/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.jdevimpl.java.explorer.FolderElement;
import oracle.jdevimpl.java.explorer.LeafElement;

public class ExpansionTracker
implements TreeExpansionListener {
    private List collapsedList = new ArrayList();
    private List expandedList = new ArrayList();
    private JTree tree;
    private boolean isTracking = false;

    public ExpansionTracker(JTree tree) {
        this.tree = tree;
    }

    public void startTracking() {
        if (!this.isTracking) {
            this.tree.addTreeExpansionListener(this);
            this.isTracking = true;
        }
    }

    public void stopTracking() {
        if (this.isTracking) {
            this.tree.removeTreeExpansionListener(this);
            this.isTracking = false;
        }
    }

    protected void handleExpansionChange(TreeExpansionEvent event, boolean expanded) {
        Element data;
        TreePath treePath = event.getPath();
        if (treePath.getPathCount() == 1) {
            return;
        }
        TNode lastNode = (TNode)treePath.getLastPathComponent();
        if (lastNode != null && (data = lastNode.getData()) instanceof FolderElement) {
            FolderElement folder = (FolderElement)data;
            boolean wantedExpansion = folder.getExpandedDefault();
            if (wantedExpansion) {
                if (expanded) {
                    this.removeRepresentationFrom(treePath, this.collapsedList);
                } else {
                    this.addRepresentationTo(treePath, this.collapsedList);
                }
            } else if (expanded) {
                this.addRepresentationTo(treePath, this.expandedList);
                this.removeRepresentationFrom(treePath, this.collapsedList);
            } else {
                this.removeRepresentationFrom(treePath, this.expandedList);
                this.addRepresentationTo(treePath, this.collapsedList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExpansionState() {
        ExpansionTracker expansionTracker = this;
        synchronized (expansionTracker) {
            this.collapsedList = new ArrayList();
            this.expandedList = new ArrayList();
        }
    }

    public Object getExpansionState() {
        return new List[]{this.collapsedList, this.expandedList};
    }

    public void restoreExpansion(Object expansionState) {
        if (expansionState instanceof List[]) {
            List[] expansionLists = (List[])expansionState;
            List toExpandList = expansionLists[1];
            List toCollapseList = expansionLists[0];
            this.restoreState(true, toExpandList);
            this.restoreState(false, toCollapseList);
        }
    }

    private void restoreState(boolean expand, List list) {
        int size = list != null ? list.size() : 0;
        int i = 0;
        while (i < size) {
            String[] ourPath = (String[])list.get(i);
            TreePath matchingPath = this.locateMatchingPath(ourPath);
            if (matchingPath != null) {
                if (expand) {
                    this.tree.expandPath(matchingPath);
                } else {
                    this.tree.collapsePath(matchingPath);
                }
            }
            ++i;
        }
    }

    private TreePath locateMatchingPath(String[] savedPath) {
        TNode currentNode = (TNode)this.tree.getModel().getRoot();
        int size = savedPath.length;
        int i = 0;
        while (i < size) {
            TNode childNode;
            block3: {
                String savedLabel = savedPath[i];
                int childCount = currentNode.getChildCount();
                int j = 0;
                while (j < childCount) {
                    childNode = (TNode)currentNode.getChildAt(j);
                    LeafElement childElement = (LeafElement)childNode.getData();
                    if (!childElement.getShortLabel().equals(savedLabel)) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return null;
            }
            currentNode = childNode;
            ++i;
        }
        return new TreePath(currentNode.getPath());
    }

    private void addRepresentationTo(TreePath treePath, List list) {
        String[] representation = this.getRepresentationFor(treePath);
        list.add(representation);
    }

    private void removeRepresentationFrom(TreePath treePath, List list) {
        String[] representation = this.getRepresentationFor(treePath);
        int length = representation.length;
        int size = list.size();
        int i = 0;
        while (i < size) {
            String[] check = (String[])list.get(i);
            if (check.length == length) {
                boolean matches = true;
                int j = 0;
                while (j < length) {
                    if (!representation[j].equals(check[j])) {
                        matches = false;
                        break;
                    }
                    ++j;
                }
                if (matches) {
                    list.remove(i);
                    break;
                }
            }
            ++i;
        }
    }

    private String[] getRepresentationFor(TreePath treePath) {
        Object[] path = treePath.getPath();
        int numObjects = path.length;
        String[] ourPath = new String[numObjects - 1];
        int i = 1;
        while (i < numObjects) {
            TNode node = (TNode)path[i];
            ourPath[i - 1] = ((LeafElement)node.getData()).getShortLabel();
            ++i;
        }
        return ourPath;
    }

    public void expandDefaultExpansion() {
        TNode rootNode = (TNode)this.tree.getModel().getRoot();
        this.expandDefaultExpansion(rootNode);
    }

    protected boolean expandDefaultExpansion(TNode treeNode) {
        boolean result = false;
        int numChildren = treeNode.getChildCount();
        int i = 0;
        while (i < numChildren) {
            TNode childNode = (TNode)treeNode.getChildAt(i);
            boolean childExpanded = this.expandDefaultExpansion(childNode);
            Element data = childNode.getData();
            if (data != null && data instanceof FolderElement) {
                FolderElement folder = (FolderElement)data;
                boolean expandedDefault = folder.getExpandedDefault();
                if (!childExpanded) {
                    if (expandedDefault) {
                        TreePath path = new TreePath(childNode.getPath());
                        this.tree.expandPath(path);
                        result = true;
                    }
                } else {
                    if (!expandedDefault) {
                        TreePath path = new TreePath(childNode.getPath());
                        this.tree.collapsePath(path);
                    }
                    result = true;
                }
            }
            ++i;
        }
        return result;
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.handleExpansionChange(event, true);
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        this.handleExpansionChange(event, false);
    }
}

