/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import oracle.javatools.util.Copyable;

public final class JavaExplorerOptions
implements Copyable {
    public static final String KEY_SETTINGS = "JavaExplorerOptions";
    public static final int SORT_NONE = 0;
    public static final int SORT_ALPHABETICAL = 1;
    public static final int SORT_TYPE = 2;
    public static final int SORT_ACCESS = 3;
    private static final int SORT_DEFAULT = 2;
    private int sortOrderOption;
    public static final int FOLDER_ERRORS = 1;
    public static final int FOLDER_IMPORTS = 2;
    public static final int FOLDER_PUBLIC_CLASS = 4;
    public static final int FOLDER_PACKAGE_CLASS = 8;
    public static final int FOLDER_INNER_CLASS = 16;
    private static final int FOLDER_ALL = 31;
    private static final int FOLDER_DEFAULT = 12;
    private int expandedFoldersOption;
    public static final int SHOW_ERRORS = 1;
    public static final int SHOW_PACKAGE = 2;
    public static final int SHOW_IMPORT = 4;
    public static final int SHOW_EXTENDS_IMPLEMENTS = 8;
    public static final int SHOW_CLASS = 16;
    public static final int SHOW_CONSTRUCTOR = 32;
    public static final int SHOW_FIELD = 64;
    public static final int SHOW_METHOD = 128;
    public static final int SHOW_INNER_CLASS = 256;
    private static final int SHOW_ALL = 511;
    private static final int SHOW_DEFAULT = 511;
    private int showFilterOption;
    public static final int HIDE_PUBLIC = 1;
    public static final int HIDE_PROTECTED = 2;
    public static final int HIDE_PRIVATE = 4;
    public static final int HIDE_PACKAGE = 8;
    public static final int HIDE_FINAL = 16;
    public static final int HIDE_INSTANCE = 32;
    public static final int HIDE_STATIC = 64;
    private static final int HIDE_ALL = 127;
    private static final int HIDE_DEFAULT = 0;
    private int hideFilterOption;
    public static final int GROUP_STATIC_INSTANCE = 1;
    public static final int GROUP_TYPE = 2;
    public static final int GROUP_ACCESS = 3;
    private static final int[] GROUP_DEFAULT = new int[0];
    private int[] groupOrderOption;
    public static final int GROUPS_STATIC = 1;
    public static final int GROUPS_INSTANCE = 2;
    public static final int GROUPS_PUBLIC = 16;
    public static final int GROUPS_PROTECTED = 32;
    public static final int GROUPS_PRIVATE = 64;
    public static final int GROUPS_PACKAGE = 128;
    public static final int GROUPS_CONSTRUCTORS = 256;
    public static final int GROUPS_METHODS = 512;
    public static final int GROUPS_FIELDS = 1024;
    public static final int GROUPS_INNER_CLASSES = 2048;
    private static final int GROUPS_ALL = 4083;
    private static final int GROUPS_DEFAULT = 1842;
    private int expandedGroupsOption;
    private boolean sync;
    private boolean showAccessIconsOption;

    public JavaExplorerOptions() {
        this.$init$();
        this.sortOrderOption = 2;
        this.expandedFoldersOption = 12;
        this.showFilterOption = 511;
        this.hideFilterOption = 0;
        this.groupOrderOption = GROUP_DEFAULT;
        this.expandedGroupsOption = 1842;
        this.showAccessIconsOption = true;
        this.sync = false;
    }

    public Object copyTo(Object target) {
        JavaExplorerOptions copy = target != null ? (JavaExplorerOptions)target : new JavaExplorerOptions();
        copy.sortOrderOption = this.sortOrderOption;
        copy.expandedFoldersOption = this.expandedFoldersOption;
        copy.showFilterOption = this.showFilterOption;
        copy.hideFilterOption = this.hideFilterOption;
        copy.groupOrderOption = this.groupOrderOption;
        copy.expandedGroupsOption = this.expandedGroupsOption;
        copy.showAccessIconsOption = this.showAccessIconsOption;
        copy.sync = this.sync;
        return copy;
    }

    public int getSortOrder() {
        return this.sortOrderOption;
    }

    public void setSortOrder(int sortOrder) {
        if (sortOrder != 0 && sortOrder != 1 && sortOrder != 2 && sortOrder != 3) {
            sortOrder = 2;
        }
        this.sortOrderOption = sortOrder;
    }

    public int getExpandedFolders() {
        return this.expandedFoldersOption;
    }

    public void setExpandedFolders(int expandedFolders) {
        this.expandedFoldersOption = expandedFolders & 0x1F;
    }

    public int getShowFilter() {
        return this.showFilterOption;
    }

    public void setShowFilter(int showFilter) {
        this.showFilterOption = showFilter & 0x1FF;
    }

    public int getHideFilter() {
        return this.hideFilterOption;
    }

    public void setHideFilter(int hideFilter) {
        this.hideFilterOption = hideFilter & 0x7F;
    }

    public int[] getGroupOrder() {
        return this.groupOrderOption;
    }

    public void setGroupOrder(int[] groupOrder) {
        this.groupOrderOption = groupOrder;
    }

    public int getExpandedGroups() {
        return this.expandedGroupsOption;
    }

    public void setExpandedGroups(int expandedGroups) {
        this.expandedGroupsOption = expandedGroups & 0xFF3;
    }

    private void $init$() {
        this.sync = false;
    }

    public boolean getSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean getShowAccessIcons() {
        return this.showAccessIconsOption;
    }

    public void setShowAccessIcons(boolean showAccessIcons) {
        this.showAccessIconsOption = showAccessIcons;
    }
}

