/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.JavaExplorer;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;

public final class JavaFilterOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_showErrors;
    private JCheckBox checkbox_showPackage;
    private JCheckBox checkbox_showImports;
    private JCheckBox checkbox_showExtendsImplements;
    private JCheckBox checkbox_showClasses;
    private JCheckBox checkbox_showConstructors;
    private JCheckBox checkbox_showMethods;
    private JCheckBox checkbox_showFields;
    private JCheckBox checkbox_showInnerClasses;
    private JCheckBox checkbox_hidePublic;
    private JCheckBox checkbox_hideProtected;
    private JCheckBox checkbox_hidePrivate;
    private JCheckBox checkbox_hidePackage;
    private JCheckBox checkbox_hideStatic;
    private JCheckBox checkbox_hideInstance;
    private JCheckBox checkbox_hideFinal;

    public JavaFilterOptionsPanel() {
        this.setHelpID("f1_idedidesetjavafilters_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        JavaExplorerOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        JavaExplorerOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private JavaExplorerOptions findOptions(TraversableContext tc) {
        JavaExplorerOptions options = (JavaExplorerOptions)tc.find("JavaExplorerOptions");
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        JavaExplorerOptions options = this.findOptions(tc);
        JavaFilterOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(JavaExplorerOptions options) {
        JavaExplorer.notifyOptionsChanged();
    }

    protected static boolean isBitSet(int value, int flag) {
        return (value & flag) == flag;
    }

    void loadSettingsFrom(JavaExplorerOptions options) {
        int showFlags = options.getShowFilter();
        int hideFlags = options.getHideFilter();
        boolean showErrors = JavaFilterOptionsPanel.isBitSet(showFlags, 1);
        boolean showPackage = JavaFilterOptionsPanel.isBitSet(showFlags, 2);
        boolean showImports = JavaFilterOptionsPanel.isBitSet(showFlags, 4);
        boolean showExtendsImplements = JavaFilterOptionsPanel.isBitSet(showFlags, 8);
        boolean showClasses = JavaFilterOptionsPanel.isBitSet(showFlags, 16);
        boolean showConstructors = JavaFilterOptionsPanel.isBitSet(showFlags, 32);
        boolean showMethods = JavaFilterOptionsPanel.isBitSet(showFlags, 128);
        boolean showFields = JavaFilterOptionsPanel.isBitSet(showFlags, 64);
        boolean showInnerClasses = JavaFilterOptionsPanel.isBitSet(showFlags, 256);
        boolean hidePublic = JavaFilterOptionsPanel.isBitSet(hideFlags, 1);
        boolean hideProtected = JavaFilterOptionsPanel.isBitSet(hideFlags, 2);
        boolean hidePrivate = JavaFilterOptionsPanel.isBitSet(hideFlags, 4);
        boolean hidePackage = JavaFilterOptionsPanel.isBitSet(hideFlags, 8);
        boolean hideStatic = JavaFilterOptionsPanel.isBitSet(hideFlags, 64);
        boolean hideInstance = JavaFilterOptionsPanel.isBitSet(hideFlags, 32);
        boolean hideFinal = JavaFilterOptionsPanel.isBitSet(hideFlags, 16);
        this.checkbox_showErrors.setSelected(showErrors);
        this.checkbox_showPackage.setSelected(showPackage);
        this.checkbox_showImports.setSelected(showImports);
        this.checkbox_showExtendsImplements.setSelected(showExtendsImplements);
        this.checkbox_showClasses.setSelected(showClasses);
        this.checkbox_showConstructors.setSelected(showConstructors);
        this.checkbox_showMethods.setSelected(showMethods);
        this.checkbox_showFields.setSelected(showFields);
        this.checkbox_showInnerClasses.setSelected(showInnerClasses);
        this.checkbox_hidePublic.setSelected(hidePublic);
        this.checkbox_hideProtected.setSelected(hideProtected);
        this.checkbox_hidePrivate.setSelected(hidePrivate);
        this.checkbox_hidePackage.setSelected(hidePackage);
        this.checkbox_hideStatic.setSelected(hideStatic);
        this.checkbox_hideInstance.setSelected(hideInstance);
        this.checkbox_hideFinal.setSelected(hideFinal);
    }

    void saveSettingsTo(JavaExplorerOptions options) throws TraversalException {
        int showFlags = 0;
        if (this.checkbox_showErrors.isSelected()) {
            showFlags |= 1;
        }
        if (this.checkbox_showPackage.isSelected()) {
            showFlags |= 2;
        }
        if (this.checkbox_showImports.isSelected()) {
            showFlags |= 4;
        }
        if (this.checkbox_showExtendsImplements.isSelected()) {
            showFlags |= 8;
        }
        if (this.checkbox_showClasses.isSelected()) {
            showFlags |= 0x10;
        }
        if (this.checkbox_showConstructors.isSelected()) {
            showFlags |= 0x20;
        }
        if (this.checkbox_showMethods.isSelected()) {
            showFlags |= 0x80;
        }
        if (this.checkbox_showFields.isSelected()) {
            showFlags |= 0x40;
        }
        if (this.checkbox_showInnerClasses.isSelected()) {
            showFlags |= 0x100;
        }
        int hideFlags = 0;
        if (this.checkbox_hidePublic.isSelected()) {
            hideFlags |= 1;
        }
        if (this.checkbox_hideProtected.isSelected()) {
            hideFlags |= 2;
        }
        if (this.checkbox_hidePrivate.isSelected()) {
            hideFlags |= 4;
        }
        if (this.checkbox_hidePackage.isSelected()) {
            hideFlags |= 8;
        }
        if (this.checkbox_hideStatic.isSelected()) {
            hideFlags |= 0x40;
        }
        if (this.checkbox_hideInstance.isSelected()) {
            hideFlags |= 0x20;
        }
        if (this.checkbox_hideFinal.isSelected()) {
            hideFlags |= 0x10;
        }
        options.setShowFilter(showFlags);
        options.setHideFilter(hideFlags);
    }

    private void initializeComponent() {
        String includeText = JavaArb.getString(124);
        JWrappedLabel label_include = new JWrappedLabel(includeText);
        String showErrorText = JavaArb.getString(28);
        this.checkbox_showErrors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showErrors, (String)showErrorText);
        String showPackageText = JavaArb.getString(226);
        this.checkbox_showPackage = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showPackage, (String)showPackageText);
        String showImportsText = JavaArb.getString(268);
        this.checkbox_showImports = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showImports, (String)showImportsText);
        String showExtendsImplementsText = JavaArb.getString(88);
        this.checkbox_showExtendsImplements = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showExtendsImplements, (String)showExtendsImplementsText);
        String showClassesText = JavaArb.getString(266);
        this.checkbox_showClasses = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showClasses, (String)showClassesText);
        String showConstructorsText = JavaArb.getString(144);
        this.checkbox_showConstructors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showConstructors, (String)showConstructorsText);
        String showMethodsText = JavaArb.getString(333);
        this.checkbox_showMethods = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showMethods, (String)showMethodsText);
        String showFieldsText = JavaArb.getString(296);
        this.checkbox_showFields = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showFields, (String)showFieldsText);
        String showInnerClassesText = JavaArb.getString(352);
        this.checkbox_showInnerClasses = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showInnerClasses, (String)showInnerClassesText);
        String excludeText = JavaArb.getString(10);
        JWrappedLabel label_exclude = new JWrappedLabel(excludeText);
        String hidePublicText = JavaArb.getString(118);
        this.checkbox_hidePublic = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_hidePublic, (String)hidePublicText);
        String hideProtectedText = JavaArb.getString(191);
        this.checkbox_hideProtected = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_hideProtected, (String)hideProtectedText);
        String hidePrivateText = JavaArb.getString(19);
        this.checkbox_hidePrivate = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_hidePrivate, (String)hidePrivateText);
        String hidePackageText = JavaArb.getString(232);
        this.checkbox_hidePackage = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_hidePackage, (String)hidePackageText);
        String hideStaticText = JavaArb.getString(271);
        this.checkbox_hideStatic = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_hideStatic, (String)hideStaticText);
        String hideInstanceText = JavaArb.getString(174);
        this.checkbox_hideInstance = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_hideInstance, (String)hideInstanceText);
        String hideFinalText = JavaArb.getString(307);
        this.checkbox_hideFinal = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_hideFinal, (String)hideFinalText);
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        Insets indentedInsets = new Insets(2, 30, 2, 5);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add((Component)label_include, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_showErrors, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.3, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_showPackage, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 0.3, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_showImports, constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 0.3, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_showExtendsImplements, constraints);
        constraints = new GridBagConstraints(0, 5, 1, 1, 0.3, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_showClasses, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 0.7, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_showConstructors, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 0.7, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_showMethods, constraints);
        constraints = new GridBagConstraints(1, 3, 1, 1, 0.7, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_showFields, constraints);
        constraints = new GridBagConstraints(1, 4, 1, 1, 0.7, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_showInnerClasses, constraints);
        constraints = new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 0, emptyInsets, 0, 0);
        this.add(Box.createVerticalStrut(10), constraints);
        constraints = new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add((Component)label_exclude, constraints);
        constraints = new GridBagConstraints(0, 7, 1, 1, 0.3, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_hidePublic, constraints);
        constraints = new GridBagConstraints(0, 8, 1, 1, 0.3, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_hideProtected, constraints);
        constraints = new GridBagConstraints(0, 9, 1, 1, 0.3, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_hidePrivate, constraints);
        constraints = new GridBagConstraints(0, 10, 1, 1, 0.3, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_hidePackage, constraints);
        constraints = new GridBagConstraints(1, 7, 1, 1, 0.7, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_hideInstance, constraints);
        constraints = new GridBagConstraints(1, 8, 1, 1, 0.7, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_hideStatic, constraints);
        constraints = new GridBagConstraints(1, 9, 1, 1, 0.7, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_hideFinal, constraints);
        constraints = new GridBagConstraints(0, 11, 2, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        this.add(Box.createGlue(), constraints);
    }
}

