/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.util.ArrayList;
import java.util.Collections;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceError;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.jdevimpl.java.explorer.ClassElement;
import oracle.jdevimpl.java.explorer.ErrorFolder;
import oracle.jdevimpl.java.explorer.FolderElement;
import oracle.jdevimpl.java.explorer.ImportFolder;
import oracle.jdevimpl.java.explorer.JavaCodeElement;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;
import oracle.jdevimpl.java.explorer.LeafElement;
import oracle.jdevimpl.java.explorer.LeafElementComparator;
import oracle.jdevimpl.java.explorer.PackageElement;

public final class JavaRootFolder
extends FolderElement {
    public JavaRootFolder(SourceFile rootSymbol, JavaExplorerOptions options) {
        super("Java Root", "Java Root", null);
        LeafElement[] childElements = this.buildChildren(rootSymbol, options);
        this.setChildren(childElements);
        this.setExpandedDefault(true);
    }

    protected LeafElement[] buildChildren(SourceFile rootSymbol, JavaExplorerOptions options) {
        if (rootSymbol == null) {
            return new LeafElement[0];
        }
        int showOptions = options.getShowFilter();
        boolean showErrors = JavaCodeElement.isBitSet(showOptions, 1);
        boolean showPackage = JavaCodeElement.isBitSet(showOptions, 2);
        boolean showImports = JavaCodeElement.isBitSet(showOptions, 4);
        boolean showClasses = JavaCodeElement.isBitSet(showOptions, 16);
        boolean sortChildren = options.getSortOrder() != 0;
        LeafElementComparator comparatorToUse = sortChildren ? new LeafElementComparator() : null;
        SourcePackage packageSymbol = rootSymbol.getSourcePackage();
        String packageName = JavaCodeElement.getName((SourceHasName)packageSymbol);
        if (packageName != null && packageName.length() == 0) {
            packageName = null;
        }
        ArrayList<FolderElement> childList = new ArrayList<FolderElement>();
        if (showClasses) {
            for (SourceClass classSymbol : rootSymbol.getSourceClasses()) {
                if (classSymbol == null) continue;
                ClassElement classElement = new ClassElement(classSymbol, options);
                classElement.setPackageName(packageName);
                childList.add(classElement);
            }
            if (comparatorToUse != null) {
                Collections.sort(childList, comparatorToUse);
            }
        }
        if (showImports) {
            int numImports;
            SourceImport[] imports = rootSymbol.getSourceImports().toArray(SourceImport.EMPTY_ARRAY);
            int n = numImports = imports != null ? imports.length : 0;
            if (numImports > 0) {
                ImportFolder importFolder = new ImportFolder(imports, options);
                childList.add(0, importFolder);
            }
        }
        if (showPackage && packageName != null) {
            PackageElement packageElement = new PackageElement(packageSymbol);
            childList.add(0, packageElement);
        }
        if (showErrors) {
            int numErrors;
            SourceError[] errors = rootSymbol.getParseErrors().toArray(SourceError.EMPTY_ARRAY);
            int n = numErrors = errors != null ? errors.length : 0;
            if (numErrors > 0) {
                ErrorFolder errorFolder = new ErrorFolder(errors, options);
                childList.add(0, errorFolder);
            }
        }
        int numChildren = childList.size();
        return childList.toArray(new LeafElement[numChildren]);
    }
}

