/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.io.PrintWriter;
import javax.swing.Icon;
import oracle.ide.util.FastStringWriter;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;
import oracle.jdevimpl.java.explorer.ModifierElement;
import oracle.jdevimpl.java.explorer.PeekProvider;

public class MethodElement
extends ModifierElement
implements PeekProvider {
    private int _methodStartOffset;
    private int _methodEndOffset;
    private static boolean _editorPeek = false;

    private void $init$() {
        this._methodStartOffset = -1;
        this._methodEndOffset = -1;
    }

    static {
        String peekProp = System.getProperty("ide.gutter.peek");
        if (peekProp != null && peekProp.equalsIgnoreCase("true")) {
            _editorPeek = true;
        }
    }

    public MethodElement(SourceMethod symbol, JavaExplorerOptions options) {
        super((SourceHasModifiers)symbol, options);
        this.$init$();
        this._methodStartOffset = symbol.getStartOffset();
        this._methodEndOffset = symbol.getEndOffset();
    }

    protected String getDisplayText(SourceElement symbol) {
        FastStringWriter buffer = MethodElement.allocFastStringBuffer();
        symbol.print((PrintWriter)buffer, 1);
        SourceTypeReference type = ((SourceMethod)symbol).getSourceReturnType();
        if (type != null) {
            buffer.print(" : ");
            MethodElement.print((SourceElement)type, (PrintWriter)buffer);
        }
        String result = buffer.toString();
        MethodElement.freeFastStringBuffer(buffer);
        return result;
    }

    protected String getTooltipText(SourceElement symbol) {
        FastStringWriter buffer = MethodElement.allocFastStringBuffer();
        symbol.print((PrintWriter)buffer, 2);
        String tooltipText = buffer.toString();
        MethodElement.freeFastStringBuffer(buffer);
        String pattern = JavaArb.getString(221);
        tooltipText = MethodElement.format(pattern, tooltipText);
        if (_editorPeek) {
            String peekHint = JavaArb.getString(170);
            tooltipText = tooltipText + peekHint;
        }
        return tooltipText;
    }

    protected Icon getIcon(SourceElement symbol) {
        return OracleIcons.getIcon((String)"method.png");
    }

    public int getMethodStartOffset() {
        return this._methodStartOffset;
    }

    public int getMethodEndOffset() {
        return this._methodEndOffset;
    }

    public int getPeekStartOffset() {
        return this._methodStartOffset;
    }

    public int getPeekEndOffset() {
        return this._methodEndOffset;
    }
}

