/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public final class OverlayedIcon
implements Icon {
    private Icon topIcon;
    private Icon bottomIcon;

    public OverlayedIcon(Icon topIcon, Icon bottomIcon) {
        this.topIcon = topIcon;
        this.bottomIcon = bottomIcon;
    }

    public void paintIcon(Component component, Graphics graphics, int x, int y) {
        int maxHeight = this.getIconHeight();
        int maxWidth = this.getIconWidth();
        if (this.bottomIcon != null) {
            int yAdjust1 = (maxHeight - this.bottomIcon.getIconHeight()) / 2;
            int xAdjust1 = (maxWidth - this.bottomIcon.getIconWidth()) / 2;
            this.bottomIcon.paintIcon(component, graphics, x + xAdjust1, y + yAdjust1);
        }
        if (this.topIcon != null) {
            int yAdjust2 = (maxHeight - this.topIcon.getIconHeight()) / 2;
            int xAdjust2 = (maxWidth - this.topIcon.getIconWidth()) / 2;
            this.topIcon.paintIcon(component, graphics, x + xAdjust2, y + yAdjust2);
        }
    }

    public int getIconWidth() {
        int width = 0;
        if (this.topIcon != null) {
            width = this.topIcon.getIconWidth();
        }
        if (this.bottomIcon != null) {
            width = Math.max(width, this.bottomIcon.getIconWidth());
        }
        return width;
    }

    public int getIconHeight() {
        int height = 0;
        if (this.topIcon != null) {
            height = this.topIcon.getIconHeight();
        }
        if (this.bottomIcon != null) {
            height = Math.max(height, this.bottomIcon.getIconHeight());
        }
        return height;
    }
}

