/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.folding;

import java.awt.Container;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.folding.JavaCodeFoldingOptions;

public final class JavaCodeFoldingOptionsPanel
extends DefaultTraversablePanel {
    private static final String PREFERENCES_HELP_TOPIC = "f1_idedidesetjavafolding_html";
    private JCheckBox checkbox_foldImports;
    private JCheckBox checkbox_foldJavadoc;
    private JCheckBox checkbox_foldInitializers;
    private JCheckBox checkbox_foldConstructors;
    private JCheckBox checkbox_foldMethods;
    private JCheckBox checkbox_foldAnonymousClasses;
    private JCheckBox checkbox_foldInnerClasses;
    private JCheckBox checkbox_foldInitialComments;

    public JavaCodeFoldingOptionsPanel() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setHelpID(PREFERENCES_HELP_TOPIC);
        this.initializeComponentLayout();
    }

    public void onEntry(TraversableContext tc) {
        JavaCodeFoldingOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        JavaCodeFoldingOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private JavaCodeFoldingOptions findOptions(TraversableContext tc) {
        JavaCodeFoldingOptions options = (JavaCodeFoldingOptions)tc.find("JavaCodeFoldingOptions");
        return options;
    }

    private void loadSettingsFrom(JavaCodeFoldingOptions options) {
        this.checkbox_foldImports.setSelected(options.getFoldImports());
        this.checkbox_foldJavadoc.setSelected(options.getFoldJavadoc());
        this.checkbox_foldInitializers.setSelected(options.getFoldInitializers());
        this.checkbox_foldConstructors.setSelected(options.getFoldConstructors());
        this.checkbox_foldMethods.setSelected(options.getFoldMethods());
        this.checkbox_foldInnerClasses.setSelected(options.getFoldInnerClasses());
        this.checkbox_foldAnonymousClasses.setSelected(options.getFoldAnonymousClasses());
        this.checkbox_foldInitialComments.setSelected(options.getFoldInitialComments());
    }

    private void saveSettingsTo(JavaCodeFoldingOptions options) {
        options.setFoldImports(this.checkbox_foldImports.isSelected());
        options.setFoldJavadoc(this.checkbox_foldJavadoc.isSelected());
        options.setFoldInitializers(this.checkbox_foldInitializers.isSelected());
        options.setFoldConstructors(this.checkbox_foldConstructors.isSelected());
        options.setFoldMethods(this.checkbox_foldMethods.isSelected());
        options.setFoldAnonymousClasses(this.checkbox_foldAnonymousClasses.isSelected());
        options.setFoldInnerClasses(this.checkbox_foldInnerClasses.isSelected());
        options.setFoldInitialComments(this.checkbox_foldInitialComments.isSelected());
    }

    private void initializeComponentLayout() {
        JLabel label_foldingTitle = new JLabel();
        this.checkbox_foldImports = new JCheckBox();
        this.checkbox_foldJavadoc = new JCheckBox();
        this.checkbox_foldInitializers = new JCheckBox();
        this.checkbox_foldConstructors = new JCheckBox();
        this.checkbox_foldMethods = new JCheckBox();
        this.checkbox_foldAnonymousClasses = new JCheckBox();
        this.checkbox_foldInnerClasses = new JCheckBox();
        this.checkbox_foldInitialComments = new JCheckBox();
        String initiallyFoldedRegionsText = JavaArb.getString(89);
        ResourceUtils.resLabel((JLabel)label_foldingTitle, null, (String)initiallyFoldedRegionsText);
        String foldImportsText = JavaArb.getString(270);
        ResourceUtils.resButton((AbstractButton)this.checkbox_foldImports, (String)foldImportsText);
        String foldJavadocText = JavaArb.getString(180);
        ResourceUtils.resButton((AbstractButton)this.checkbox_foldJavadoc, (String)foldJavadocText);
        String foldInitializersText = JavaArb.getString(224);
        ResourceUtils.resButton((AbstractButton)this.checkbox_foldInitializers, (String)foldInitializersText);
        String foldConstructorsText = JavaArb.getString(90);
        ResourceUtils.resButton((AbstractButton)this.checkbox_foldConstructors, (String)foldConstructorsText);
        String foldMethodsText = JavaArb.getString(337);
        ResourceUtils.resButton((AbstractButton)this.checkbox_foldMethods, (String)foldMethodsText);
        String foldInnerClassesText = JavaArb.getString(343);
        ResourceUtils.resButton((AbstractButton)this.checkbox_foldInnerClasses, (String)foldInnerClassesText);
        String foldAnonymousClassesText = JavaArb.getString(44);
        ResourceUtils.resButton((AbstractButton)this.checkbox_foldAnonymousClasses, (String)foldAnonymousClassesText);
        String foldInitialCommentsText = JavaArb.getString(201);
        ResourceUtils.resButton((AbstractButton)this.checkbox_foldInitialComments, (String)foldInitialCommentsText);
        Box box_verticalOptions = new Box(1);
        box_verticalOptions.setAlignmentY(0.0f);
        box_verticalOptions.add(this.checkbox_foldImports);
        box_verticalOptions.add(Box.createVerticalStrut(5));
        box_verticalOptions.add(this.checkbox_foldJavadoc);
        box_verticalOptions.add(Box.createVerticalStrut(5));
        box_verticalOptions.add(this.checkbox_foldInitializers);
        box_verticalOptions.add(Box.createVerticalStrut(5));
        box_verticalOptions.add(this.checkbox_foldConstructors);
        box_verticalOptions.add(Box.createVerticalStrut(5));
        box_verticalOptions.add(this.checkbox_foldMethods);
        box_verticalOptions.add(Box.createVerticalStrut(5));
        box_verticalOptions.add(this.checkbox_foldInnerClasses);
        box_verticalOptions.add(Box.createVerticalStrut(5));
        box_verticalOptions.add(this.checkbox_foldAnonymousClasses);
        box_verticalOptions.add(Box.createVerticalStrut(5));
        box_verticalOptions.add(this.checkbox_foldInitialComments);
        Box box_indentedOptions = new Box(0);
        box_indentedOptions.setAlignmentX(0.0f);
        box_indentedOptions.add(Box.createHorizontalStrut(24));
        box_indentedOptions.add(box_verticalOptions);
        label_foldingTitle.setAlignmentX(0.0f);
        this.add(label_foldingTitle);
        this.add(Box.createVerticalStrut(5));
        this.add(box_indentedOptions);
    }
}

