/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.folding;

import java.util.StringTokenizer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.jdevimpl.java.folding.AbstractJavaFoldingBlock;

final class JavaInitialCommentBlock
extends AbstractJavaFoldingBlock {
    protected static final String REPLACEMENT_TEXT = "/*...*/";
    protected static final String REPLACEMENT_TEXT_BEGIN = "/* ";
    protected static final String REPLACEMENT_TEXT_END = " ...*/";

    public JavaInitialCommentBlock(SourceElement element, boolean isExpanded) {
        super(element, REPLACEMENT_TEXT, isExpanded);
        String docText = element.getText();
        if (docText != null && docText.length() > 0) {
            StringTokenizer sTokenizer = new StringTokenizer(docText, "\n\r");
            while (sTokenizer.hasMoreTokens()) {
                String lineText = sTokenizer.nextToken();
                String trimLine = lineText.trim();
                if (trimLine.startsWith("*")) {
                    trimLine = trimLine.substring(1);
                } else if (trimLine.startsWith("/*")) {
                    trimLine = trimLine.substring(2);
                }
                trimLine = trimLine.trim();
                if (trimLine.length() <= 0) continue;
                lineText = REPLACEMENT_TEXT_BEGIN + trimLine + REPLACEMENT_TEXT_END;
                this.setReplacementText(lineText);
                break;
            }
        }
        this.setStartOffset(element.getStartOffset());
        this.setEndOffset(element.getEndOffset());
    }

    protected Object getId() {
        return "@InitialComment of File:" + this.getSym().getParent();
    }
}

