/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.folding;

import java.util.StringTokenizer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.jdevimpl.java.folding.AbstractJavaFoldingBlock;
import oracle.jdevimpl.java.folding.JavaMethodBlock;

final class JavadocBlock
extends AbstractJavaFoldingBlock {
    protected static final String REPLACEMENT_TEXT = "/**...*/";
    protected static final String REPLACEMENT_TEXT_BEGIN = "/** ";
    protected static final String REPLACEMENT_TEXT_END = " ...*/";
    private Object key;

    public JavadocBlock(SourceMember member, boolean isExpanded) {
        super((SourceElement)member, REPLACEMENT_TEXT, isExpanded);
        SourceDocComment docComment = member.getDocComment();
        String docText = docComment.getDocText();
        if (docText != null && docText.length() > 0) {
            StringTokenizer sTokenizer = new StringTokenizer(docText, "\n\r");
            while (sTokenizer.hasMoreTokens()) {
                String lineText = sTokenizer.nextToken();
                String trimLine = lineText.trim();
                if (trimLine.length() <= 0) continue;
                lineText = REPLACEMENT_TEXT_BEGIN + lineText + REPLACEMENT_TEXT_END;
                this.setReplacementText(lineText);
                break;
            }
        }
        this.setStartOffset(docComment.getStartOffset());
        this.setEndOffset(docComment.getEndOffset());
    }

    public void setUserObject(Object object) {
        this.key = null;
        super.setUserObject(object);
    }

    protected Object getId() {
        if (this.key == null) {
            SourceMember member = this.getMemberSym();
            this.key = member instanceof SourceMethod ? JavaMethodBlock.getMethodId((SourceMethod)member) : member.getName();
            this.key = "@" + this.key;
        }
        return this.key;
    }

    protected SourceMember getMemberSym() {
        return (SourceMember)this.getSym();
    }
}

