/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

public class ArrayedJavaLexer
extends JavaLexer {
    private LexerToken[] tokenHistory;
    private int historyCenter;

    public ArrayedJavaLexer(int history) {
        if (history <= 0) {
            throw new IllegalArgumentException("bad history: " + history);
        }
        this.historyCenter = history;
        this.tokenHistory = new LexerToken[history * 2 + 1];
    }

    public LexerToken[] getTokenHistory() {
        return this.tokenHistory;
    }

    public int getCurrentIndex() {
        return this.historyCenter;
    }

    public void setPosition(int offset) {
        super.setPosition(offset);
        this.clearTokenHistory();
    }

    protected void clearTokenHistory() {
        if (this.tokenHistory != null) {
            int numTokens = this.tokenHistory.length;
            int i = 0;
            while (i < numTokens) {
                this.tokenHistory[i] = null;
                ++i;
            }
        }
    }

    public void backup() {
        throw new IllegalStateException("backup not available");
    }

    public int lex(LexerToken lexedToken) {
        int historySize = this.tokenHistory.length;
        LexerToken oldestToken = this.tokenHistory[0];
        if (this.tokenHistory[this.historyCenter] != null) {
            System.arraycopy(this.tokenHistory, 1, this.tokenHistory, 0, historySize - 1);
            this.tokenHistory[historySize - 1] = null;
        }
        int i = this.historyCenter;
        while (i < historySize) {
            if (this.tokenHistory[i] == null) {
                LexerToken tokenToUse;
                if (oldestToken == null) {
                    tokenToUse = super.createLexerToken();
                } else {
                    tokenToUse = oldestToken;
                    oldestToken = null;
                }
                super.lex(tokenToUse);
                this.tokenHistory[i] = tokenToUse;
            }
            ++i;
        }
        if (lexedToken != null) {
            this.copyCenterToken(lexedToken);
        }
        return this.tokenHistory[this.historyCenter].getToken();
    }

    private void copyCenterToken(LexerToken lexedToken) {
        AbstractLexer.DefaultLexerToken srcToken = (AbstractLexer.DefaultLexerToken)this.tokenHistory[this.historyCenter];
        AbstractLexer.DefaultLexerToken destToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        destToken.setToken(srcToken.getToken());
        destToken.setStartOffset(srcToken.getStartOffset());
        destToken.setEndOffset(srcToken.getEndOffset());
    }
}

