/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ArraySortedSet;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicAction;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.popup.PopupWindow;
import oracle.javatools.editor.popup.PopupWindowListener;
import oracle.javatools.editor.popup.PopupWindowManager;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceError;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.javatools.parser.java.v2.util.filter.AnnotationFilter;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.audit.transform.UndoableEditCommand;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.audit.java.JavaHelper;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.JavaParserPlugin;
import oracle.jdevimpl.java.imports.ImportController;
import oracle.jdevimpl.java.imports.JavaImportOptions;
import oracle.jdevimpl.java.imports.SmartImportComparator;

public final class ImportAssistPlugin
implements ActionListener,
ActionHookInvoker,
CaretListener,
ChangeListener,
EditorPlugin,
FocusListener,
HierarchyListener,
Observer,
PopupWindowListener,
JavaParserPlugin.HelperClient {
    private static final boolean DEBUG_VERBOSE = false;
    private BasicEditorPane editor;
    private JViewport viewport;
    private Timer updateTimer;
    private Project project;
    private JavaSourceNode javaNode;
    private long cancelEndTime;
    private static final int CANCEL_PERIOD_TIMEOUT = 10000;
    private static boolean skipImportPopup = false;
    private static final int SHORT_DELAY = 1000;
    private static final int LONG_DELAY = 5000;
    private JavaManager smJavaManager;
    private int smChangeId;
    private SourceFile smFile;
    private SourceError[] smErrors;
    private static final String PLUGIN_KEY = ImportAssistPlugin.class.getName();
    private String[] importChoices;
    private SourceError importError;
    private Rectangle importRect;
    private PopupWindow importPopup;
    private AssistInsight assistInsight;
    private boolean inModify;
    private List<String> doNotAutoImportList;
    private static String nameInEditor;
    private static AsyncScheduler asScheduler;
    private AssistanceTask asTask;

    public ImportAssistPlugin() {
        this.$init$();
    }

    public void notifyCompileScheduled() {
        this.stopTimer();
        this.clearSemanticErrors();
        if (!this.inModify) {
            1 cancelRunner = new 1();
            if (SwingUtilities.isEventDispatchThread()) {
                cancelRunner.run();
            } else {
                SwingUtilities.invokeLater(cancelRunner);
            }
        }
    }

    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
    }

    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
        SourceError[] filteredErrors;
        List errors = sourceFile.getCompileErrors();
        if (errors.isEmpty()) {
            filteredErrors = SourceError.EMPTY_ARRAY;
        } else {
            ArrayList<SourceError> errorList = new ArrayList<SourceError>();
            for (SourceError error : errors) {
                short errorCode = error.getErrorCode();
                if (errorCode != 56 && errorCode != 69) continue;
                errorList.add(error);
            }
            filteredErrors = errorList.toArray(new SourceError[errorList.size()]);
        }
        this.setSemanticErrors(javaManager, sourceFile, filteredErrors, changeId);
        if (this.editor.hasFocus() && this.hasSemanticErrors()) {
            JavaImportOptions options = ImportAssistPlugin.getOptions();
            int assistDelay = options.getAssistPopupDelay();
            int remainingDelay = Math.max(50, assistDelay - elapsedDelay);
            this.restartTimer(remainingDelay);
        }
    }

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.addFocusListener((FocusListener)this);
        editor.addActionHookInvoker((ActionHookInvoker)this);
        editor.addCaretListener((CaretListener)this);
        editor.putProperty(PLUGIN_KEY, (Object)this);
        editor.addHierarchyListener((HierarchyListener)this);
        this.updateViewportTracking();
        this.updateTimer = new Timer(2000, this);
        this.updateTimer.setRepeats(false);
        Context context = CodeEditor.getContext((BasicEditorPane)editor);
        if (context == null) {
            throw new IllegalStateException("Unexpected null context");
        }
        this.updateContext(context);
        JavaParserPlugin.attachHelperClient(editor, this);
    }

    private void updateContext(Context newContext) {
        if (this.project != null) {
            this.project.detach((Observer)this);
            this.project = null;
            this.javaNode = null;
        }
        if (newContext != null) {
            this.project = newContext.getProject();
            this.javaNode = (JavaSourceNode)newContext.getNode();
            if (this.project != null) {
                this.project.attach((Observer)this);
            }
        }
    }

    public void deinstall(BasicEditorPane editor) {
        JavaParserPlugin.detachHelperClient(editor, this);
        editor.putProperty(PLUGIN_KEY, null);
        editor.removeActionHookInvoker((ActionHookInvoker)this);
        editor.removeCaretListener((CaretListener)this);
        editor.removeHierarchyListener((HierarchyListener)this);
        this.clearViewportTracking();
        this.cancelAssistance();
        this.cancelUI();
        this.cancelInsight();
        if (this.updateTimer != null) {
            this.stopTimer();
            this.updateTimer = null;
        }
        this.updateContext(null);
        Container parent = editor.getParent();
        if (parent != null && parent instanceof JViewport) {
            ((JViewport)parent).removeChangeListener(this);
        }
        editor.removeFocusListener((FocusListener)this);
        this.editor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeAction(String actionKey) {
        if (actionKey.equals("cancel")) {
            ImportAssistPlugin importAssistPlugin = this;
            synchronized (importAssistPlugin) {
                if (this.importPopup != null) {
                    this.cancelAssistance();
                    this.cancelUI();
                    this.cancelInsight();
                    this.cancelEndTime = System.currentTimeMillis() + 10000L;
                }
            }
            return false;
        }
        return false;
    }

    public void hierarchyChanged(HierarchyEvent event) {
        this.updateViewportTracking();
    }

    private void updateViewportTracking() {
        Container parent = this.editor.getParent();
        if (parent != this.viewport) {
            this.clearViewportTracking();
            if (parent instanceof JViewport) {
                this.viewport = (JViewport)parent;
                if (this.viewport != null) {
                    this.viewport.addChangeListener(this);
                }
            }
        }
    }

    private void clearViewportTracking() {
        if (this.viewport != null) {
            this.viewport.removeChangeListener(this);
            this.viewport = null;
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.cancelUI();
        this.cancelAssistance();
        this.restartTimer();
    }

    public void focusGained(FocusEvent event) {
        this.restartTimer();
    }

    public void focusLost(FocusEvent event) {
        boolean isTemporary = event.isTemporary();
        if (!isTemporary) {
            this.cancelInsight();
            this.clearSemanticErrors();
        }
        this.stopTimer();
        this.cancelUI();
        this.cancelAssistance();
    }

    public void update(Object observed, UpdateMessage change) {
        if (observed instanceof Project) {
            int messageId = change.getMessageID();
            if (messageId == UpdateMessage.OBJECT_RELOADED || messageId == UpdateMessage.PROPERTY_SET) {
                this.clearSemanticErrors();
            } else if (messageId == UpdateMessage.ATTRIBUTE_CHANGED) {
                // empty if block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("editor-ide-context")) {
            this.stopTimer();
            this.cancelInsight();
            this.cancelUI();
            this.cancelAssistance();
            this.clearSemanticErrors();
            Context newContext = CodeEditor.getContext((BasicEditorPane)this.editor);
            this.updateContext(newContext);
        }
    }

    public void caretUpdate(CaretEvent event) {
        if (!this.inModify) {
            this.cancelInsight();
            this.cancelUI();
            this.cancelAssistance();
            this.restartTimer();
        }
    }

    private void stopTimer() {
        this.updateTimer.stop();
    }

    private void restartTimer() {
        JavaImportOptions options = ImportAssistPlugin.getOptions();
        int assistDelay = options.getAssistPopupDelay();
        this.restartTimer(assistDelay);
    }

    private void restartTimer(int delay) {
        JavaImportOptions options;
        if (this.updateTimer == null) {
            return;
        }
        this.stopTimer();
        if (this.hasSemanticErrors() && (options = ImportAssistPlugin.getOptions()).getAssistEnablePopup()) {
            this.updateTimer.setInitialDelay(delay);
            this.updateTimer.restart();
        }
    }

    private static JavaImportOptions getOptions() {
        JavaImportOptions options = (JavaImportOptions)Ide.getSettings().getData("JavaImportOptions");
        if (options == null) {
            options = new JavaImportOptions();
            ClientSetting.findOrCreate((String)"oracle.jdeveloper").putData("JavaImportOptions", (Copyable)options);
        }
        return options;
    }

    public void actionPerformed(ActionEvent event) {
        long current = System.currentTimeMillis();
        int remainingTime = (int)(this.cancelEndTime - current);
        if (remainingTime <= 0) {
            this.scheduleAssistance();
        } else {
            this.restartTimer(Math.max(100, remainingTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popupClosed(PopupWindow popupWindow, int how) {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.importPopup = null;
        }
    }

    public void editorFocusGained(PopupWindow popupWindow) {
    }

    public void editorFocusLost(PopupWindow popupWindow, boolean isTemporary) {
    }

    private void $init$() {
        this.cancelEndTime = System.currentTimeMillis();
        this.inModify = false;
        this.doNotAutoImportList = new ArrayList<String>();
        this.asTask = null;
    }

    private TextBuffer getTextBuffer() {
        return this.getDocument().getTextBuffer();
    }

    private BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    private void showTemporaryFeedback(String feedbackMessage, int delay) {
        FeedbackManager feedbackManager = this.editor.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.showFeedback(this.editor, feedbackMessage, delay);
        }
    }

    private JavaManager getJavaManager() {
        return this.smJavaManager;
    }

    private SourceFile getSourceFile() {
        return this.smFile;
    }

    private boolean hasSemanticErrors() {
        SourceError[] errors = this.getSemanticErrors();
        int numErrors = errors == null ? 0 : errors.length;
        return numErrors > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceError[] getSemanticErrors() {
        SourceError[] errors;
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            errors = this.smErrors;
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getChangeId() {
        int changeId;
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            changeId = this.smChangeId;
        }
        return changeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSemanticErrors(JavaManager javaManager, SourceFile file, SourceError[] errors, int changeId) {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.smJavaManager = javaManager;
            this.smFile = file;
            this.smErrors = errors;
            this.smChangeId = changeId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSemanticErrors() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.smJavaManager = null;
            this.smErrors = null;
        }
    }

    private static ImportAssistPlugin lookupPlugin(BasicEditorPane editor) {
        return (ImportAssistPlugin)editor.getProperty(PLUGIN_KEY);
    }

    static void invokeImportAssistance(BasicEditorPane editor) {
        ImportAssistPlugin plugin = ImportAssistPlugin.lookupPlugin(editor);
        if (plugin != null) {
            skipImportPopup = true;
            plugin.respondUI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void respondUI() {
        Rectangle rect;
        SourceError error;
        String[] choices;
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.importPopup != null) {
                PopupWindowManager pwManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)this.editor);
                pwManager.dismissPopup(this.importPopup);
                this.importPopup = null;
            } else if (this.project != null) {
                String message = JavaArb.getString(325);
                this.showTemporaryFeedback(message, 1000);
                this.stopTimer();
                this.cancelEndTime = System.currentTimeMillis();
                this.scheduleAssistance();
                return;
            }
            skipImportPopup = false;
            choices = this.importChoices;
            this.importChoices = null;
            error = this.importError;
            this.importError = null;
            rect = this.importRect;
            this.importRect = null;
        }
        if (choices != null) {
            if (choices.length == 1) {
                this.insertImport(choices[0], error, null);
            } else {
                this.showInsight(choices, rect, error);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertImport(String importName, SourceError error, UndoableEdit autoEdit) {
        Rectangle visibleRect;
        int row;
        block25: {
            boolean addedImport;
            UndoableEditCommand command;
            TextBuffer textBuffer;
            block24: {
                UndoableEdit edit;
                SourceTransaction transaction;
                int replaceEnd;
                int replaceStart;
                String replaceText;
                SourceFile sourceFile;
                block22: {
                    int line = this.editor.getLineFromOffset(this.editor.getCaret().getDot());
                    row = this.editor.getRowForLine(line);
                    visibleRect = this.editor.getVisibleRect();
                    textBuffer = this.getTextBuffer();
                    sourceFile = error.getOwningSourceFile();
                    int lastImportOffset = 0;
                    List imports = sourceFile.getSourceImports();
                    for (SourceImport sourceImport : imports) {
                        lastImportOffset = Math.max(lastImportOffset, sourceImport.getEndOffset());
                    }
                    replaceText = null;
                    replaceStart = -1;
                    replaceEnd = -1;
                    try {
                        String importClassName;
                        JavaLexer lexer = new JavaLexer();
                        LexerToken lexerToken = lexer.createLexerToken();
                        lexer.setTextBuffer((ReadTextBuffer)textBuffer);
                        lexer.setPosition(error.getStartOffset());
                        lexer.setSkipComments(true);
                        lexer.setRecognizeSQLJ(true);
                        int token = lexer.lex(lexerToken);
                        if (token == 124) {
                            token = lexer.lex(lexerToken);
                        }
                        if (token != 4) break block22;
                        replaceStart = lexerToken.getStartOffset();
                        replaceEnd = lexerToken.getEndOffset();
                        String errorText = textBuffer.getString(replaceStart, replaceEnd - replaceStart);
                        int dot = importName.lastIndexOf(46);
                        String string = importClassName = dot != -1 ? importName.substring(dot + 1) : importName;
                        if (!errorText.equals(importClassName)) {
                            replaceText = importClassName;
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        // empty catch block
                    }
                }
                textBuffer.writeLock();
                this.inModify = true;
                OffsetMark replaceStartPosition = null;
                OffsetMark replaceEndPosition = null;
                if (replaceText != null) {
                    replaceStartPosition = textBuffer.addOffsetMark(replaceStart);
                    replaceEndPosition = textBuffer.addOffsetMark(replaceEnd);
                }
                command = new UndoableEditCommand(JavaArb.getString(6), CodeEditor.getContext((BasicEditorPane)this.editor));
                addedImport = false;
                try {
                    transaction = sourceFile.beginTransaction();
                }
                catch (ExpiredTextBufferException e) {
                    this.inModify = false;
                    textBuffer.writeUnlock();
                    return;
                }
                try {
                    addedImport = JavaHelper.addImport(sourceFile, importName) != null;
                }
                finally {
                    if (addedImport) {
                        edit = transaction.commit();
                        command.addEdit(edit);
                        if (autoEdit != null) {
                            command.addEdit(autoEdit);
                        }
                    } else {
                        transaction.abort();
                    }
                }
                if (replaceText == null) break block24;
                replaceStart = replaceStartPosition.getOffset();
                replaceEnd = replaceEndPosition.getOffset();
                textBuffer.removeOffsetMark(replaceStartPosition);
                textBuffer.removeOffsetMark(replaceEndPosition);
                edit = textBuffer.remove(replaceStart, replaceEnd - replaceStart);
                command.addEdit(edit);
                edit = textBuffer.insert(replaceStart, replaceText.toCharArray());
                command.addEdit(edit);
            }
            if (command.hasEdits()) {
                try {
                    CommandProcessor commandProcessor = CommandProcessor.getInstance();
                    commandProcessor.invoke((Command)command);
                    if (addedImport) {
                        String feedbackMessage = JavaArb.format(225, importName);
                        this.showTemporaryFeedback(feedbackMessage, 5000);
                    }
                    break block25;
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
            break block25;
            finally {
                this.inModify = false;
                textBuffer.writeUnlock();
            }
        }
        int newLine = this.editor.getLineFromOffset(this.editor.getCaret().getDot());
        int newRow = this.editor.getRowForLine(newLine);
        int lineHeight = this.editor.getFontMetrics(this.editor.getFont()).getHeight();
        visibleRect.translate(0, (newRow - row) * lineHeight);
        this.editor.scrollRectToVisible(visibleRect);
        this.restartTimer();
    }

    private String getKeyText() {
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions ksOptions = ideSettings.getKeyStrokeOptions();
        if (ksOptions != null) {
            int cmdId;
            Integer iCmdId;
            List assistKeyStrokes;
            KeyStrokeMap ksMap = ksOptions.getGlobalKeyMap();
            IdeAction action = IdeAction.find((int)ImportController.IMPORT_ASSISTANCE_CMD_ID);
            if (action != null && (assistKeyStrokes = ksMap.getKeyStrokesFor(iCmdId = new Integer(cmdId = action.getCommandId()))).size() > 0) {
                KeyStrokes ks = (KeyStrokes)assistKeyStrokes.get(0);
                return ks.toString();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showUI(SourceError error, Rectangle caretRect, String[] choices) {
        if (this.editor == null || !this.editor.isShowing()) {
            return;
        }
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.clearAssistance();
            String keyText = this.getKeyText();
            if (keyText == null || keyText.length() == 0) {
                String message = JavaArb.getString(52);
                this.showTemporaryFeedback(message, 5000);
                return;
            }
            this.importChoices = choices;
            this.importError = error;
            this.importRect = caretRect;
            if (this.tryAutoImport()) {
                return;
            }
            int numChoices = choices.length;
            String[] sortedChoices = new String[numChoices];
            int i = 0;
            while (i < numChoices) {
                sortedChoices[i] = ImportAssistPlugin.getClassPackageDisplayText(choices[i]);
                ++i;
            }
            String firstChoice = sortedChoices[0];
            int parenPos = firstChoice.indexOf(40);
            if (parenPos != -1) {
                String packageName = firstChoice.substring(parenPos + 1, firstChoice.length() - 1);
                String className = firstChoice.substring(0, parenPos - 1);
                firstChoice = packageName + "." + className;
            }
            int assistId = choices.length == 1 ? 241 : 63;
            String assistText = choices.length == 1 ? JavaArb.format(assistId, firstChoice, keyText) : JavaArb.format(assistId, nameInEditor, keyText);
            JLabel assistLabel = new JLabel(assistText);
            assistLabel.setOpaque(true);
            Border tooltipBorder = UIManager.getBorder("ToolTip.border");
            Border emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            CompoundBorder assistBorder = BorderFactory.createCompoundBorder(tooltipBorder, emptyBorder);
            assistLabel.setBorder(assistBorder);
            LookAndFeel.installColorsAndFont(assistLabel, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
            PopupWindowManager pwManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)this.editor);
            this.importPopup = pwManager.createPopup((Component)assistLabel, false);
            int[] locations = new int[]{4, 8};
            pwManager.positionPopup(this.importPopup, caretRect, locations);
            if (skipImportPopup) {
                this.respondUI();
            } else {
                pwManager.showPopup(this.importPopup, (PopupWindowListener)this);
            }
        }
    }

    private boolean tryAutoImport() {
        JavaImportOptions options = ImportAssistPlugin.getOptions();
        if (!options.getAutoImport()) {
            return false;
        }
        boolean foundCurrentMatch = false;
        SourceFile sourceFile = this.importError.getOwningSourceFile();
        for (SourceImport anImport : sourceFile.getSourceImports()) {
            String importClassName;
            String importName = anImport.getName();
            int dot = importName.lastIndexOf(46);
            String string = importClassName = dot != -1 ? importName.substring(dot + 1) : importName;
            if (!importClassName.startsWith(nameInEditor)) continue;
            foundCurrentMatch = true;
        }
        if (!foundCurrentMatch && this.importChoices != null && this.importChoices.length == 1 && !this.doNotAutoImportList.contains(this.importChoices[0])) {
            String choicesClassName;
            int dot = this.importChoices[0].lastIndexOf(46);
            String string = choicesClassName = dot != -1 ? this.importChoices[0].substring(dot + 1) : this.importChoices[0];
            if (choicesClassName.equals(nameInEditor)) {
                this.insertImport(this.importChoices[0], this.importError, new AutoUndoableEdit(this.importChoices[0]));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelUI() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.importPopup != null) {
                PopupWindowManager pwManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)this.editor);
                PopupWindow popup = this.importPopup;
                SwingUtilities.invokeLater(new 2(this, pwManager, popup));
                this.importPopup = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showInsight(String[] choices, Rectangle rect, SourceError error) {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            Arrays.sort(choices, new SmartImportComparator(error.getOwningSourceFile(), CodeEditor.getContext((BasicEditorPane)this.editor), nameInEditor));
            this.assistInsight = new AssistInsight(choices, rect, error, null);
            this.editor.installPlugin((EditorPlugin)this.assistInsight);
            this.assistInsight.showInsight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelInsight() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.assistInsight != null) {
                this.clearInsight();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInsight() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.assistInsight != null) {
                AssistInsight tmpInsight = this.assistInsight;
                this.assistInsight = null;
                this.editor.deinstallPlugin((EditorPlugin)tmpInsight);
            }
        }
        this.restartTimer();
    }

    private static String getClassPackageDisplayText(String fqName) {
        int dotPos = fqName.lastIndexOf(46);
        if (dotPos != -1) {
            String packageName = fqName.substring(0, dotPos);
            String className = fqName.substring(dotPos + 1);
            return className + " (" + packageName + ")";
        }
        return fqName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleAssistance() {
        if (!this.editor.isEditable() || this.project == null || !this.hasSemanticErrors()) {
            return;
        }
        boolean uiUp = false;
        AssistanceTask task = new AssistanceTask(this, null);
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.asTask != null) {
                asScheduler.cancelTask((AsyncTask)this.asTask);
            }
            this.asTask = task;
            if (this.assistInsight != null || this.importPopup != null) {
                uiUp = true;
            }
        }
        if (!uiUp) {
            asScheduler.scheduleTask((AsyncTask)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAssistance() {
        AssistanceTask pendingTask;
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            pendingTask = this.asTask;
            this.asTask = null;
        }
        if (pendingTask != null) {
            asScheduler.cancelTask((AsyncTask)pendingTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAssistance() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.asTask = null;
        }
    }

    static String getClassName(String classPackageName) {
        int dot = classPackageName.lastIndexOf(46);
        String className = dot != -1 ? classPackageName.substring(dot + 1) : classPackageName;
        return className;
    }

    static String getPackageName(String fqClassName) {
        int dot = fqClassName.lastIndexOf(46);
        String packageName = dot != -1 ? fqClassName.substring(0, dot) : "";
        return packageName;
    }

    static {
        asScheduler = new AsyncScheduler("ImportAssistance", 30000);
    }

    static String maS$getClassPackageDisplayText(String string) {
        return ImportAssistPlugin.getClassPackageDisplayText(string);
    }

    static void mav$insertImport(ImportAssistPlugin importAssistPlugin, String string, SourceError sourceError, UndoableEdit undoableEdit) {
        importAssistPlugin.insertImport(string, sourceError, undoableEdit);
    }

    static JavaManager mav$getJavaManager(ImportAssistPlugin importAssistPlugin) {
        return importAssistPlugin.getJavaManager();
    }

    static void mav$clearInsight(ImportAssistPlugin importAssistPlugin) {
        importAssistPlugin.clearInsight();
    }

    static SourceError[] mav$getSemanticErrors(ImportAssistPlugin importAssistPlugin) {
        return importAssistPlugin.getSemanticErrors();
    }

    static int mav$getChangeId(ImportAssistPlugin importAssistPlugin) {
        return importAssistPlugin.getChangeId();
    }

    static void mav$clearSemanticErrors(ImportAssistPlugin importAssistPlugin) {
        importAssistPlugin.clearSemanticErrors();
    }

    static BasicEditorPane ra$editor(ImportAssistPlugin importAssistPlugin) {
        return importAssistPlugin.editor;
    }

    static JavaImportOptions maS$getOptions() {
        return ImportAssistPlugin.getOptions();
    }

    static void wa$nameInEditor(String string) {
        nameInEditor = string;
    }

    static void mav$showTemporaryFeedback(ImportAssistPlugin importAssistPlugin, String string, int n) {
        importAssistPlugin.showTemporaryFeedback(string, n);
    }

    static SourceFile mav$getSourceFile(ImportAssistPlugin importAssistPlugin) {
        return importAssistPlugin.getSourceFile();
    }

    static String ra$nameInEditor() {
        return nameInEditor;
    }

    static JavaSourceNode ra$javaNode(ImportAssistPlugin importAssistPlugin) {
        return importAssistPlugin.javaNode;
    }

    static List ra$doNotAutoImportList(ImportAssistPlugin importAssistPlugin) {
        return importAssistPlugin.doNotAutoImportList;
    }

    static void mav$cancelInsight(ImportAssistPlugin importAssistPlugin) {
        importAssistPlugin.cancelInsight();
    }

    static void mav$cancelUI(ImportAssistPlugin importAssistPlugin) {
        importAssistPlugin.cancelUI();
    }

    static void mav$cancelAssistance(ImportAssistPlugin importAssistPlugin) {
        importAssistPlugin.cancelAssistance();
    }

    static void mav$showUI(ImportAssistPlugin importAssistPlugin, SourceError sourceError, Rectangle rectangle, String[] stringArray) {
        importAssistPlugin.showUI(sourceError, rectangle, stringArray);
    }

    final class 1
    implements Runnable {
        public void run() {
            ImportAssistPlugin.mav$cancelInsight(ImportAssistPlugin.this);
            ImportAssistPlugin.mav$cancelUI(ImportAssistPlugin.this);
            ImportAssistPlugin.mav$cancelAssistance(ImportAssistPlugin.this);
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ PopupWindowManager v$pwManager;
        private final /* synthetic */ PopupWindow v$popup;
        final /* synthetic */ ImportAssistPlugin this$0;

        public void run() {
            this.v$pwManager.dismissPopup(this.v$popup);
        }

        public 2(ImportAssistPlugin importAssistPlugin, PopupWindowManager popupWindowManager, PopupWindow popupWindow) {
            this.v$popup = popupWindow;
            this.v$pwManager = popupWindowManager;
            this.this$0 = importAssistPlugin;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AssistDataItem
    extends ListDataItem
    implements Comparable {
        private String asName;
        private Icon asIcon;
        private String displayName;

        private AssistDataItem(String name, Icon icon) {
            this.asName = name;
            this.asIcon = icon;
            this.displayName = ImportAssistPlugin.maS$getClassPackageDisplayText(this.asName);
        }

        public Icon getIcon() {
            return this.asIcon;
        }

        public String getDisplayText() {
            return this.displayName;
        }

        public String getName() {
            return this.asName;
        }

        public int compareTo(Object obj) {
            String name1 = this.getDisplayText();
            String name2 = ((AssistDataItem)obj).getDisplayText();
            return name1.compareToIgnoreCase(name2);
        }

        AssistDataItem(String string, Icon icon, 1 var3_3) {
            this(string, icon);
        }

        public final class 1 {
        }
    }

    private final class AssistData
    implements ListInsightData {
        private ListDataItem[] asData;
        private ListModel asModel;
        private SourceError asError;

        private AssistData(String[] choices, SourceError error) {
            int numChoices = choices.length;
            this.asData = new ListDataItem[numChoices];
            this.asError = error;
            Icon interfaceIcon = OracleIcons.getIcon((String)"interface.png");
            Icon classIcon = OracleIcons.getIcon((String)"class.png");
            JavaManager javaManager = ImportAssistPlugin.mav$getJavaManager(ImportAssistPlugin.this);
            CacheSupport cacheSupport = javaManager.getCacheSupport();
            cacheSupport.beginCacheUse();
            try {
                int i = 0;
                while (i < numChoices) {
                    JavaClass jc = javaManager.getClass(choices[i]);
                    Icon icon = jc != null && jc.isInterface() ? interfaceIcon : classIcon;
                    this.asData[i] = new AssistDataItem(choices[i], icon, null);
                    ++i;
                }
            }
            finally {
                cacheSupport.endCacheUse();
            }
        }

        public ListModel getListModel() {
            if (this.asModel == null) {
                this.asModel = new ReadOnlyListModel((Object[])this.asData);
            }
            return this.asModel;
        }

        public Object[] getData() {
            return this.asData;
        }

        public Object[] getMatchingData() {
            return this.asData;
        }

        public int getMatchingDataCount() {
            return this.asData.length;
        }

        public Object getDefault() {
            return this.asData[0];
        }

        public boolean complete(Object selectedObject) {
            ImportAssistPlugin.mav$insertImport(ImportAssistPlugin.this, ((ListDataItem)selectedObject).getName(), this.asError, null);
            return false;
        }

        public void partialComplete() {
        }

        AssistData(String[] stringArray, SourceError sourceError, 1 var4_4) {
            this(stringArray, sourceError);
        }

        public final class 1 {
        }
    }

    private final class AssistInsight
    extends AbstractInsight
    implements InsightProvider {
        private InsightData asData;
        private Rectangle asRect;

        private AssistInsight(String[] importChoices, Rectangle importRect, SourceError error) {
            this.asData = new AssistData(importChoices, error, null);
            this.asRect = importRect;
        }

        public void install(BasicEditorPane editor) {
            super.install(editor);
        }

        public void deinstall(BasicEditorPane editor) {
            super.deinstall(editor);
        }

        protected InsightProvider createInsightProvider() {
            return this;
        }

        public boolean isInsightTriggerChar(char typedChar) {
            return false;
        }

        public void characterTyped(BasicEditorPane editorPane, int offset, char typedChar) {
        }

        public Rectangle getShowRectangle() {
            return this.asRect;
        }

        protected void updateInsight() {
        }

        public void hideInsight() {
            super.hideInsight();
            ImportAssistPlugin.mav$clearInsight(ImportAssistPlugin.this);
        }

        protected int[] getPreferredLocations() {
            return AbstractInsight.TOOLTIP_LOCATIONS;
        }

        public InsightData getInsightData(BasicEditorPane editorPane) {
            return this.asData;
        }

        public InsightData updateInsightData(BasicEditorPane editorPane, InsightData lastData) {
            return lastData;
        }

        public InsightView getInsightView() {
            return new ListInsightView();
        }

        AssistInsight(String[] stringArray, Rectangle rectangle, SourceError sourceError, 1 var5_5) {
            this(stringArray, rectangle, sourceError);
        }

        public final class 1 {
        }
    }

    private static final class AssistanceTask
    extends AsyncTask {
        private ImportAssistPlugin asPlugin;
        private JavaSourceNode asNode;
        private boolean asCancelled;

        private AssistanceTask(ImportAssistPlugin plugin) {
            this.asPlugin = plugin;
            this.asNode = ImportAssistPlugin.ra$javaNode(plugin);
            this.asCancelled = false;
        }

        protected void requestCancelImpl() {
            this.asCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.asCancelled;
        }

        public Object runImpl() throws AsyncTask.CancelledException {
            JavaImportOptions options;
            if (!this.asNode.isOpen() || this.asNode.isReadOnly()) {
                return null;
            }
            TextBuffer textBuffer = this.asNode.acquireTextBuffer();
            if (textBuffer == null) {
                return null;
            }
            this.bailIfCancelled();
            SourceError[] currentErrors = ImportAssistPlugin.mav$getSemanticErrors(this.asPlugin);
            int currentId = ImportAssistPlugin.mav$getChangeId(this.asPlugin);
            textBuffer.readLock();
            try {
                int changeId = textBuffer.getChangeId();
                if (changeId != currentId) {
                    currentErrors = null;
                    ImportAssistPlugin.mav$clearSemanticErrors(this.asPlugin);
                    currentId = changeId;
                }
            }
            finally {
                textBuffer.readUnlock();
            }
            this.bailIfCancelled();
            if (currentErrors == null || currentErrors.length == 0) {
                return null;
            }
            BasicEditorPane editor = ImportAssistPlugin.ra$editor(this.asPlugin);
            NumberRange visibleRange = AssistanceTask.taskGetVisibleOffsets(editor, textBuffer);
            int startOffset = visibleRange.start;
            int endOffset = visibleRange.end;
            this.bailIfCancelled();
            int caretPos = editor.getCaretPosition();
            SourceError[] visibleErrors = AssistanceTask.taskGetVisibleErrors(currentErrors, startOffset, endOffset, caretPos);
            this.bailIfCancelled();
            int numVisible = visibleErrors.length;
            if (numVisible == 0) {
                return null;
            }
            String[] visibleNames = AssistanceTask.taskGetClassNames(visibleErrors, textBuffer, currentId);
            Set validatedNameSet = AssistanceTask.taskFilterClassNames(visibleNames, options = ImportAssistPlugin.maS$getOptions());
            if (validatedNameSet.size() == 0) {
                return null;
            }
            this.bailIfCancelled();
            SourceError possibleError = null;
            String[] possibleImports = null;
            ImportAssistPlugin.wa$nameInEditor(null);
            String notFoundMessage = null;
            int i = 0;
            while (i < numVisible) {
                this.bailIfCancelled();
                String name = visibleNames[i];
                if (AssistanceTask.isValidClassName(name, options)) {
                    int errorEnd;
                    int errorStart;
                    String errorText;
                    int posOffset;
                    SourceError currentError = visibleErrors[i];
                    boolean includePrefixMatches = false;
                    if (currentError.getStartOffset() <= caretPos && caretPos <= currentError.getEndOffset() && (posOffset = (errorText = textBuffer.getString(errorStart = currentError.getStartOffset(), (errorEnd = currentError.getEndOffset()) - errorStart)).indexOf(name)) != -1) {
                        int adjustedStart = errorStart + posOffset;
                        int adjustedEnd = adjustedStart + name.length();
                        if (adjustedStart <= caretPos && caretPos <= adjustedEnd) {
                            includePrefixMatches = true;
                        }
                    }
                    JavaManager javaManager = ImportAssistPlugin.mav$getJavaManager(this.asPlugin);
                    JavaClassLocator locator = javaManager.getJavaClassLocator();
                    List<String> classList = includePrefixMatches ? locator.getClassesByPrefix(name, options.getSearchClassesCaseSensitive()) : locator.getClassesByName(name, options.getSearchClassesCaseSensitive());
                    this.bailIfCancelled();
                    if (classList == null) {
                        if (notFoundMessage == null) {
                            notFoundMessage = JavaArb.format(220, name);
                            ImportAssistPlugin.mav$showTemporaryFeedback(this.asPlugin, notFoundMessage, 5000);
                        }
                    } else {
                        int numClasses;
                        ArrayList<String> notImportedClassList = new ArrayList<String>();
                        SourceFile file = currentError.getOwningSourceFile();
                        Set importNames = file.getSourceImportNames();
                        Iterator classIterator = classList.iterator();
                        while (classIterator.hasNext()) {
                            String fqClassName = classIterator.next().toString();
                            int dotIndex = fqClassName.lastIndexOf(46);
                            if (dotIndex > 0 && fqClassName.substring(0, dotIndex).equals("java.lang") || importNames.contains(fqClassName)) continue;
                            notImportedClassList.add(fqClassName);
                        }
                        classList = notImportedClassList;
                        if (options.getCheckPackageAccess()) {
                            String packageName = file.getPackageName();
                            AnnotationFilter filter = null;
                            try {
                                SourceFile sourceFile = ImportAssistPlugin.mav$getSourceFile(this.asPlugin);
                                SourceElement elementAt = sourceFile.getElementAt(caretPos);
                                if (elementAt != null) {
                                    if (elementAt != null && elementAt.getSymbolKind() == 20) {
                                        elementAt = elementAt.getParent();
                                    }
                                    if (elementAt != null && elementAt.getSymbolKind() == 1) {
                                        filter = new AnnotationFilter();
                                    }
                                }
                            }
                            catch (RuntimeException e) {
                                Assert.printStackTrace((Throwable)e);
                                filter = null;
                            }
                            CacheSupport cacheSupport = javaManager.getCacheSupport();
                            try {
                                cacheSupport.beginCacheUse();
                                classList = this.taskFilterVisibleClasses(javaManager, packageName, classList, (JavaFilter)filter);
                            }
                            finally {
                                cacheSupport.endCacheUse();
                            }
                        }
                        if ((numClasses = classList.size()) > 0) {
                            possibleImports = classList.toArray(new String[numClasses]);
                            possibleError = visibleErrors[i];
                            ImportAssistPlugin.wa$nameInEditor(name);
                            break;
                        }
                    }
                }
                ++i;
            }
            this.bailIfCancelled();
            if (possibleError != null && possibleImports != null) {
                Rectangle fixRect;
                SourceError fixError = possibleError;
                String[] fixChoices = possibleImports;
                String fixNameInEditor = ImportAssistPlugin.ra$nameInEditor();
                try {
                    fixRect = editor.modelToView(fixError.getStartOffset());
                }
                catch (BadLocationException e) {
                    Object var52_51 = null;
                    return var52_51;
                }
                1 uiInvoker = new 1(this, fixError, fixRect, fixChoices);
                SwingUtilities.invokeLater(uiInvoker);
            }
            return null;
        }

        private static boolean isErrorVisible(SourceError error, int startOffset, int endOffset) {
            int errorEnd = error.getEndOffset();
            int errorStart = error.getStartOffset();
            if (startOffset < errorEnd && errorEnd <= endOffset) {
                return true;
            }
            return startOffset <= errorStart && errorStart < endOffset;
        }

        private static String stripName(String name) {
            int otherParenPos;
            int parenPos;
            int anglePos;
            int dotPos;
            int arrayPos;
            if (name.startsWith("new ")) {
                name = name.substring(4);
            }
            if ((arrayPos = name.indexOf(91)) != -1) {
                name = name.substring(0, arrayPos);
            }
            if ((dotPos = name.indexOf(46)) != -1) {
                name = name.substring(0, dotPos);
            }
            if ((anglePos = name.indexOf(60)) != -1) {
                name = name.substring(0, anglePos);
            }
            if ((parenPos = name.indexOf(40)) != -1) {
                name = name.substring(0, parenPos);
            }
            if ((otherParenPos = name.indexOf(41)) != -1) {
                name = name.substring(0, otherParenPos);
            }
            return name.trim();
        }

        private static NumberRange taskGetVisibleOffsets(BasicEditorPane editor, TextBuffer textBuffer) {
            if (editor == null) {
                return null;
            }
            Rectangle visibleRect = editor.getVisibleRect();
            if (visibleRect == null) {
                return null;
            }
            textBuffer.readLock();
            try {
                int fontHeight = BasicAction.getFontHeight((BasicEditorPane)editor);
                int ADJUST = fontHeight * 3 / 4;
                Point startPoint = new Point(visibleRect.x, visibleRect.y + ADJUST);
                int startOffset = editor.viewToModel(startPoint);
                Point endPoint = new Point(visibleRect.x + visibleRect.width - 1, visibleRect.y + visibleRect.height - 1 - ADJUST);
                int endOffset = editor.viewToModel(endPoint);
                if (startOffset == -1 || endOffset == -1) {
                    NumberRange numberRange = null;
                    return numberRange;
                }
                int startLine = editor.getLineFromOffset(startOffset);
                int endLine = editor.getLineFromOffset(endOffset);
                startOffset = Math.min(startOffset, editor.getLineStartOffset(startLine));
                endOffset = Math.max(endOffset, editor.getLineEndOffset(endLine));
                NumberRange numberRange = new NumberRange(startOffset, endOffset);
                return numberRange;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                textBuffer.readUnlock();
            }
        }

        private static SourceError[] taskGetVisibleErrors(SourceError[] errors, int startOffset, int endOffset, int caretPos) {
            int numErrors;
            int n = numErrors = errors != null ? errors.length : 0;
            if (numErrors == 0) {
                return new SourceError[0];
            }
            ArrayList<SourceError> visibleList = new ArrayList<SourceError>();
            int i = 0;
            while (i < numErrors) {
                SourceError error = errors[i];
                if (AssistanceTask.isErrorVisible(error, startOffset, endOffset)) {
                    if (error.getStartOffset() <= caretPos && error.getEndOffset() >= caretPos) {
                        visibleList.add(0, error);
                    } else {
                        visibleList.add(error);
                    }
                }
                ++i;
            }
            int numVisible = visibleList.size();
            return visibleList.toArray(new SourceError[numVisible]);
        }

        private static String[] taskGetClassNames(SourceError[] errors, TextBuffer textBuffer, int expectedChangeId) {
            int numErrors = errors.length;
            String[] names = new String[numErrors];
            textBuffer.readLock();
            try {
                if (textBuffer.getChangeId() != expectedChangeId) {
                    String[] stringArray = null;
                    return stringArray;
                }
                int i = 0;
                while (i < numErrors) {
                    SourceError error = errors[i];
                    int start = error.getStartOffset();
                    int end = error.getEndOffset();
                    String errorName = textBuffer.getString(start, end - start);
                    names[i] = AssistanceTask.stripName(errorName);
                    ++i;
                }
            }
            finally {
                textBuffer.readUnlock();
            }
            return names;
        }

        private static boolean isValidClassName(String name, JavaImportOptions options) {
            int len;
            int n = len = name == null ? 0 : name.length();
            if (len == 0) {
                return false;
            }
            if (options.getIgnoreShortClasses() && len <= 2) {
                return false;
            }
            return !options.getIgnoreNonUppercase() || Character.isUpperCase(name.charAt(0));
        }

        private static Set taskFilterClassNames(String[] names, JavaImportOptions options) {
            ArraySortedSet nameSet = new ArraySortedSet();
            int numNames = names == null ? 0 : names.length;
            int i = 0;
            while (i < numNames) {
                String name = names[i];
                if (AssistanceTask.isValidClassName(name, options)) {
                    nameSet.add(name);
                }
                ++i;
            }
            return nameSet;
        }

        private List taskFilterVisibleClasses(JavaManager javaManager, String packageName, Collection classes, JavaFilter filter) {
            ArrayList<String> filteredList = new ArrayList<String>();
            Iterator classIterator = classes.iterator();
            while (classIterator.hasNext()) {
                int itsModifiers;
                String fqClassName = classIterator.next().toString();
                String itsPackage = ImportAssistPlugin.getPackageName(fqClassName);
                JavaClass itsClass = javaManager.getClass(fqClassName);
                if (filter != null && itsClass != null && !filter.accepts((JavaElement)itsClass)) continue;
                if (packageName.equals(itsPackage)) {
                    filteredList.add(fqClassName);
                    continue;
                }
                if (itsClass == null || !Modifier.isPublic(itsModifiers = itsClass.getModifiers())) continue;
                filteredList.add(fqClassName);
            }
            return filteredList;
        }

        AssistanceTask(ImportAssistPlugin importAssistPlugin, 1 var2_2) {
            this(importAssistPlugin);
        }

        static ImportAssistPlugin ra$asPlugin(AssistanceTask assistanceTask) {
            return assistanceTask.asPlugin;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ SourceError v$fixError;
            private final /* synthetic */ Rectangle v$fixRect;
            private final /* synthetic */ String[] v$fixChoices;
            final /* synthetic */ AssistanceTask this$0;

            public void run() {
                if (!this.this$0.isCancelledImpl()) {
                    ImportAssistPlugin.mav$showUI(AssistanceTask.ra$asPlugin(this.this$0), this.v$fixError, this.v$fixRect, this.v$fixChoices);
                }
            }

            public 1(AssistanceTask assistanceTask, SourceError sourceError, Rectangle rectangle, String[] stringArray) {
                this.v$fixChoices = stringArray;
                this.v$fixRect = rectangle;
                this.v$fixError = sourceError;
                this.this$0 = assistanceTask;
            }
        }
    }

    private class AutoUndoableEdit
    extends AbstractUndoableEdit {
        String importClass;

        public AutoUndoableEdit(String importClass) {
            this.importClass = importClass;
        }

        public void undo() {
            if (!ImportAssistPlugin.ra$doNotAutoImportList(ImportAssistPlugin.this).contains(this.importClass)) {
                ImportAssistPlugin.ra$doNotAutoImportList(ImportAssistPlugin.this).add(this.importClass);
            }
        }
    }
}

