/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.java.Context2ParserHelper;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.editing.JavaImplOverPlugin;
import oracle.jdevimpl.java.editing.NavigationEntry;
import oracle.jdevimpl.java.imports.ImportAssistPlugin;
import oracle.jdevimpl.java.imports.JavaNavigationUtilities;
import oracle.jdevimpl.java.imports.JavaSurroundWith;

public final class ImportController
implements Controller,
ContextMenuListener,
CodeMenuConstants,
DynamicMenuListener {
    private static final int COMPLETE_STATEMENT_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.CompleteStatement");
    private static final int EXPAND_SELECTION_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.ExpandSelection");
    private static final int NARROW_SELECTION_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.NarrowSelection");
    private static final int GOTO_NEXT_METHOD_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoNextMethod");
    private static final int GOTO_PREV_METHOD_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoPreviousMethod");
    private static final int GOTO_NEXT_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoNextField");
    private static final int GOTO_PREV_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoPreviousField");
    private static final int GOTO_NEXT_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoNextClass");
    private static final int GOTO_PREV_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoPreviousClass");
    private static final int GOTO_NEXT_MEMBER_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoNextMember");
    private static final int GOTO_PREV_MEMBER_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoPreviousMember");
    static final int IMPORT_ASSISTANCE_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.ImportAssistance");
    private static final int SURROUND_WITH_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.SurroundWith");
    private static final int GOTO_IMPLEMENTED_METHOD_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoImplementedMethod");
    private static final int GOTO_OVERRIDDEN_METHOD_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoOverriddenMethod");
    private JComponent[] dynamicItems;

    public ImportController() {
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu contextMenu = editorManager.getContextMenu();
        if (contextMenu != null) {
            contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        if ((contextMenu = CodeEditorGutter.getGutterContextMenu()) != null) {
            contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        this.initializeActions();
        this.initializeDynamicActions();
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
        KeyStrokeContextRegistry registry = Ide.getKeyStrokeContextRegistry();
        registry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/java/imports/accelerators.xml");
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)new CEToolbarUpdater(null));
    }

    public void shutdown() {
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu contextMenu = editorManager.getContextMenu();
        if (contextMenu != null) {
            contextMenu.removeContextMenuListener((ContextMenuListener)this);
        }
        if ((contextMenu = CodeEditorGutter.getGutterContextMenu()) != null) {
            contextMenu.removeContextMenuListener((ContextMenuListener)this);
        }
        Ide.getMainWindow().removeDynamicMenuListener((DynamicMenuListener)this);
    }

    private void initializeActions() {
        String label = JavaArb.getString(30);
        IdeAction res = IdeAction.get((int)COMPLETE_STATEMENT_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (ArrayResourceBundle)JavaArb.getInstance(), (int)210, null, (boolean)true);
        res.addController((Controller)this);
        String name = JavaArb.getString(261);
        int mnemonic = StringUtils.getMnemonicKeyCode((String)name);
        name = StringUtils.stripMnemonic((String)name);
        IdeAction res2 = IdeAction.get((int)EXPAND_SELECTION_CMD_ID, null, (String)name, (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(mnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)278, null, (boolean)true);
        res2.addController((Controller)this);
        String name2 = JavaArb.getString(20);
        int mnemonic2 = StringUtils.getMnemonicKeyCode((String)name2);
        name2 = StringUtils.stripMnemonic((String)name2);
        IdeAction res3 = IdeAction.get((int)NARROW_SELECTION_CMD_ID, null, (String)name2, (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(mnemonic2), (ArrayResourceBundle)JavaArb.getInstance(), (int)32, null, (boolean)true);
        res3.addController((Controller)this);
        String name3 = JavaArb.getString(330);
        int mnemonic3 = StringUtils.getMnemonicKeyCode((String)name3);
        name3 = StringUtils.stripMnemonic((String)name3);
        IdeAction res4 = IdeAction.get((int)GOTO_NEXT_METHOD_CMD_ID, null, (String)name3, (String)"Navigate", (Integer)new Integer(mnemonic3), (ArrayResourceBundle)JavaArb.getInstance(), (int)341, null, (boolean)true);
        res4.addController((Controller)this);
        String name4 = JavaArb.getString(320);
        int mnemonic4 = StringUtils.getMnemonicKeyCode((String)name4);
        name4 = StringUtils.stripMnemonic((String)name4);
        IdeAction res5 = IdeAction.get((int)GOTO_PREV_METHOD_CMD_ID, null, (String)name4, (String)"Navigate", (Integer)new Integer(mnemonic4), (ArrayResourceBundle)JavaArb.getInstance(), (int)38, null, (boolean)true);
        res5.addController((Controller)this);
        String name5 = JavaArb.getString(108);
        int mnemonic5 = StringUtils.getMnemonicKeyCode((String)name5);
        name5 = StringUtils.stripMnemonic((String)name5);
        IdeAction res6 = IdeAction.get((int)GOTO_NEXT_FIELD_CMD_ID, null, (String)name5, (String)"Navigate", (Integer)new Integer(mnemonic5), (ArrayResourceBundle)JavaArb.getInstance(), (int)12, null, (boolean)true);
        res6.addController((Controller)this);
        String name6 = JavaArb.getString(166);
        int mnemonic6 = StringUtils.getMnemonicKeyCode((String)name6);
        name6 = StringUtils.stripMnemonic((String)name6);
        IdeAction res7 = IdeAction.get((int)GOTO_PREV_FIELD_CMD_ID, null, (String)name6, (String)"Navigate", (Integer)new Integer(mnemonic6), (ArrayResourceBundle)JavaArb.getInstance(), (int)137, null, (boolean)true);
        res7.addController((Controller)this);
        String name7 = JavaArb.getString(234);
        int mnemonic7 = StringUtils.getMnemonicKeyCode((String)name7);
        name7 = StringUtils.stripMnemonic((String)name7);
        IdeAction res8 = IdeAction.get((int)GOTO_NEXT_CLASS_CMD_ID, null, (String)name7, (String)"Navigate", (Integer)new Integer(mnemonic7), (ArrayResourceBundle)JavaArb.getInstance(), (int)165, null, (boolean)true);
        res8.addController((Controller)this);
        String name8 = JavaArb.getString(311);
        int mnemonic8 = StringUtils.getMnemonicKeyCode((String)name8);
        name8 = StringUtils.stripMnemonic((String)name8);
        IdeAction res9 = IdeAction.get((int)GOTO_PREV_CLASS_CMD_ID, null, (String)name8, (String)"Navigate", (Integer)new Integer(mnemonic8), (ArrayResourceBundle)JavaArb.getInstance(), (int)263, null, (boolean)true);
        res9.addController((Controller)this);
        String name9 = JavaArb.getString(236);
        int mnemonic9 = StringUtils.getMnemonicKeyCode((String)name9);
        name9 = StringUtils.stripMnemonic((String)name9);
        IdeAction res10 = IdeAction.get((int)GOTO_NEXT_MEMBER_CMD_ID, null, (String)name9, (String)"Navigate", (Integer)new Integer(mnemonic9), (ArrayResourceBundle)JavaArb.getInstance(), (int)246, null, (boolean)true);
        res10.addController((Controller)this);
        IdeAction gotoNextMemberAction = res10;
        String name10 = JavaArb.getString(228);
        int mnemonic10 = StringUtils.getMnemonicKeyCode((String)name10);
        name10 = StringUtils.stripMnemonic((String)name10);
        IdeAction res11 = IdeAction.get((int)GOTO_PREV_MEMBER_CMD_ID, null, (String)name10, (String)"Navigate", (Integer)new Integer(mnemonic10), (ArrayResourceBundle)JavaArb.getInstance(), (int)334, null, (boolean)true);
        res11.addController((Controller)this);
        IdeAction gotoPreviousMemberAction = res11;
        String name11 = JavaArb.getString(187);
        int mnemonic11 = StringUtils.getMnemonicKeyCode((String)name11);
        name11 = StringUtils.stripMnemonic((String)name11);
        IdeAction res12 = IdeAction.get((int)IMPORT_ASSISTANCE_CMD_ID, null, (String)name11, (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(mnemonic11), (ArrayResourceBundle)JavaArb.getInstance(), (int)48, null, (boolean)true);
        res12.addController((Controller)this);
        String name12 = JavaArb.getString(25);
        int mnemonic12 = StringUtils.getMnemonicKeyCode((String)name12);
        name12 = StringUtils.stripMnemonic((String)name12);
        IdeAction res13 = IdeAction.get((int)SURROUND_WITH_CMD_ID, null, (String)name12, (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(mnemonic12), (Icon)OracleIcons.getIcon((String)"surround_with.png"), null, (boolean)true);
        res13.addController((Controller)this);
        String name13 = JavaArb.getString(229);
        int mnemonic13 = StringUtils.getMnemonicKeyCode((String)name13);
        name13 = StringUtils.stripMnemonic((String)name13);
        IdeAction res14 = IdeAction.get((int)GOTO_IMPLEMENTED_METHOD_CMD_ID, null, (String)name13, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(mnemonic13), (ArrayResourceBundle)JavaArb.getInstance(), (int)283, null, (boolean)true);
        res14.addController((Controller)this);
        String name14 = JavaArb.getString(33);
        int mnemonic14 = StringUtils.getMnemonicKeyCode((String)name14);
        name14 = StringUtils.stripMnemonic((String)name14);
        IdeAction res15 = IdeAction.get((int)GOTO_OVERRIDDEN_METHOD_CMD_ID, null, (String)name14, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(mnemonic14), (ArrayResourceBundle)JavaArb.getInstance(), (int)158, null, (boolean)true);
        res15.addController((Controller)this);
        Menubar ideMenuManager = Ide.getMenubar();
        JMenu navigateMenu = MenuManager.getJMenu((String)"Navigate");
        JMenuItem gotoNextMethodMenuItem = ideMenuManager.createMenuItem((ToggleAction)gotoNextMemberAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_GO_TO_NEXT_MEMBER);
        ideMenuManager.add((Component)gotoNextMethodMenuItem, navigateMenu, JDeveloperMenuConstants.SECTION_NAVIGATE_GOTO_MEMBER);
        JMenuItem gotoPreviousMethodMenuItem = ideMenuManager.createMenuItem((ToggleAction)gotoPreviousMemberAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_GO_TO_PREVIOUS_MEMBER);
        ideMenuManager.add((Component)gotoPreviousMethodMenuItem, navigateMenu, JDeveloperMenuConstants.SECTION_NAVIGATE_GOTO_MEMBER);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        Node node = context.getNode();
        CodeEditor codeEditor = null;
        CodeEditorGutter gutter = null;
        BasicEditorPane editorPane = null;
        if (node instanceof JavaSourceNode) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                codeEditor = (CodeEditor)view;
                editorPane = codeEditor.getFocusedEditorPane();
            } else if (view instanceof CodeEditorGutter.GutterView) {
                gutter = (CodeEditorGutter)view.getGUI();
                codeEditor = gutter.getCodeEditor();
                editorPane = codeEditor.getFocusedEditorPane();
            }
        }
        if (commandId == IMPORT_ASSISTANCE_CMD_ID) {
            if (editorPane != null && editorPane.isEditable()) {
                ImportAssistPlugin.invokeImportAssistance(editorPane);
            }
            return true;
        }
        if (commandId == SURROUND_WITH_CMD_ID) {
            this.whenSurroundWith(context, true);
            return true;
        }
        if (commandId == COMPLETE_STATEMENT_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.expandStatement(editorPane, context);
            }
            return true;
        }
        if (commandId == EXPAND_SELECTION_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.expandSelection(editorPane, context);
            }
            return true;
        }
        if (commandId == NARROW_SELECTION_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.narrowSelection(editorPane, context);
            }
            return true;
        }
        if (commandId == GOTO_NEXT_METHOD_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 0);
            }
            return true;
        }
        if (commandId == GOTO_PREV_METHOD_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 1);
            }
            return true;
        }
        if (commandId == GOTO_NEXT_FIELD_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 2);
            }
            return true;
        }
        if (commandId == GOTO_PREV_FIELD_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 3);
            }
            return true;
        }
        if (commandId == GOTO_NEXT_CLASS_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 4);
            }
            return true;
        }
        if (commandId == GOTO_PREV_CLASS_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 5);
            }
            return true;
        }
        if (commandId == GOTO_NEXT_MEMBER_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 6);
            }
            return true;
        }
        if (commandId == GOTO_PREV_MEMBER_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 7);
            }
            return true;
        }
        if (commandId == GOTO_IMPLEMENTED_METHOD_CMD_ID || commandId == GOTO_OVERRIDDEN_METHOD_CMD_ID) {
            boolean isImpl = commandId == GOTO_IMPLEMENTED_METHOD_CMD_ID;
            JavaImplOverPlugin.ImplOverItem item = this.getImplOverItem(isImpl, context, codeEditor, gutter, editorPane);
            if (item != null) {
                item.gotoImplOverItem();
            }
            return true;
        }
        return false;
    }

    private JavaImplOverPlugin.ImplOverItem getImplOverItem(boolean isImpl, Context context, CodeEditor codeEditor, CodeEditorGutter gutter, BasicEditorPane editor) {
        if (editor != null) {
            int line = -1;
            if (gutter != null) {
                line = CodeEditorGutter.getLineForContext((Context)context);
            } else if (codeEditor != null) {
                int caretOffset = editor.getCaretPosition();
                line = editor.getLineFromOffset(caretOffset) + 1;
            }
            if (line != -1) {
                return JavaImplOverPlugin.getImplOverItem(editor, line, isImpl);
            }
        }
        return null;
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        View view = context.getView();
        CodeEditor codeEditor = null;
        CodeEditorGutter gutter = null;
        BasicEditorPane editorPane = null;
        if (view instanceof CodeEditor) {
            codeEditor = (CodeEditor)view;
        } else if (view instanceof CodeEditorGutter.GutterView) {
            gutter = (CodeEditorGutter)view.getGUI();
            codeEditor = gutter.getCodeEditor();
        }
        if (codeEditor != null) {
            editorPane = codeEditor.getFocusedEditorPane();
        }
        if (commandId == IMPORT_ASSISTANCE_CMD_ID) {
            Node node;
            action.setEnabled(false);
            boolean enable = false;
            if (editorPane != null && (node = context.getNode()) instanceof JavaSourceNode) {
                enable = editorPane.isEditable();
            }
            action.setEnabled(enable);
            return true;
        }
        if (commandId == SURROUND_WITH_CMD_ID) {
            boolean canDo = this.whenSurroundWith(context, false);
            action.setEnabled(canDo);
            return true;
        }
        if (commandId == GOTO_NEXT_METHOD_CMD_ID || commandId == GOTO_NEXT_FIELD_CMD_ID || commandId == GOTO_PREV_FIELD_CMD_ID || commandId == GOTO_NEXT_CLASS_CMD_ID || commandId == GOTO_PREV_CLASS_CMD_ID || commandId == GOTO_NEXT_MEMBER_CMD_ID || commandId == GOTO_PREV_METHOD_CMD_ID || commandId == GOTO_NEXT_METHOD_CMD_ID) {
            if (view instanceof CodeEditor && context.getNode() instanceof JavaSourceNode) {
                action.setEnabled(true);
                return true;
            }
            action.setEnabled(false);
            return true;
        }
        if (commandId == EXPAND_SELECTION_CMD_ID || commandId == NARROW_SELECTION_CMD_ID || commandId == COMPLETE_STATEMENT_CMD_ID) {
            if (view instanceof CodeEditor && context.getNode() instanceof JavaSourceNode) {
                Context2ParserHelper helper = Context2ParserHelper.createHelper(context);
                if (helper.getSourceFile() == null) {
                    action.setEnabled(false);
                } else {
                    action.setEnabled(true);
                }
                return true;
            }
            action.setEnabled(false);
            return true;
        }
        if (commandId == GOTO_IMPLEMENTED_METHOD_CMD_ID || commandId == GOTO_OVERRIDDEN_METHOD_CMD_ID) {
            boolean enable = false;
            if (editorPane != null) {
                boolean isImpl = commandId == GOTO_IMPLEMENTED_METHOD_CMD_ID;
                JavaImplOverPlugin.ImplOverItem item = this.getImplOverItem(isImpl, context, codeEditor, gutter, editorPane);
                enable = item != null;
            }
            action.setEnabled(enable);
            return true;
        }
        return false;
    }

    private boolean whenSurroundWith(Context context, boolean doit) {
        View view;
        Node node = context.getNode();
        if (node instanceof JavaSourceNode && (view = context.getView()) instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            BasicEditorPane editorPane = codeEditor.getFocusedEditorPane();
            if (!doit) {
                int endCursorOffset;
                Element[] selectedElements = codeEditor.getSelection();
                if (selectedElements == null || selectedElements.length == 0) {
                    return false;
                }
                int startCursorOffset = codeEditor.getSelectionStart();
                if (startCursorOffset == (endCursorOffset = codeEditor.getSelectionEnd())) {
                    return false;
                }
                SourceElement endNode = (SourceElement)selectedElements[selectedElements.length - 1].getData();
                if (endNode == null) {
                    return false;
                }
                SourceElement startNode = this.getSourceElement(startCursorOffset, (SourceElement)endNode.getOwningSourceFile());
                if (startNode == null) {
                    return false;
                }
                if (!this.inSameCodeBlock(startCursorOffset, startNode, endCursorOffset, endNode)) {
                    return false;
                }
                return !this.chopsStatement(startCursorOffset, startNode) && !this.chopsStatement(endCursorOffset, endNode);
            }
            if (editorPane != null && (editorPane.isEditable() || editorPane.makeEditable())) {
                IdeMainWindow owner = Ide.getMainWindow();
                JavaSurroundWith surroundWith = new JavaSurroundWith();
                surroundWith.showSurroundWithDialog(editorPane, context, (JFrame)owner, "f1_idedsurroundwith_html");
                return true;
            }
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        View view = context.getView();
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            Node node = context.getNode();
            if (node instanceof JavaSourceNode) {
                JMenuItem surroundWithMenuItem = popup.createMenuItem((ToggleAction)IdeAction.find((int)SURROUND_WITH_CMD_ID), 500.0f);
                popup.add((Component)surroundWithMenuItem, CodeMenuConstants.SECTION_SOURCE_CTXT_MENU);
                BasicEditorPane editor = codeEditor.getFocusedEditorPane();
                surroundWithMenuItem.setEnabled(this.whenSurroundWith(context, false));
            }
        } else if (view instanceof CodeEditorGutter.GutterView) {
            CodeEditorGutter gutter = (CodeEditorGutter)view.getGUI();
            CodeEditor codeEditor = gutter.getCodeEditor();
            BasicEditorPane editorPane = codeEditor.getFocusedEditorPane();
            if (CodeEditorGutter.isMarkDroppingDown((Context)context)) {
                GutterMark mark = CodeEditorGutter.getMarkForContext((Context)context);
                String columnName = mark.getGutterColumn().getColumnName();
                if ("implements-overrides-column2".equals(columnName)) {
                    List userData = (List)mark.getUserData();
                    for (NavigationEntry navigationEntry : userData) {
                        ToggleAction gotoSourceAction = navigationEntry.createGotoSourceAction();
                        JMenuItem menuItem = popup.createMenuItem(gotoSourceAction);
                        popup.add((Component)menuItem);
                    }
                } else if ("implements-overrides-column".equals(columnName) && mark.getUserData() instanceof List) {
                    List list = (List)mark.getUserData();
                    int i = 0;
                    while (i < list.size()) {
                        JavaImplOverPlugin.ImplOverItem item = (JavaImplOverPlugin.ImplOverItem)list.get(i);
                        JMenuItem menuItem = popup.createMenuItem(item.createGotoSourceAction());
                        popup.add((Component)menuItem);
                        ++i;
                    }
                }
            } else {
                JavaImplOverPlugin.ImplOverItem overItem;
                JavaImplOverPlugin.ImplOverItem implItem = this.getImplOverItem(true, context, codeEditor, gutter, editorPane);
                if (implItem != null) {
                    JMenuItem gotoImplementedMenuItem = popup.createMenuItem((ToggleAction)IdeAction.find((int)GOTO_IMPLEMENTED_METHOD_CMD_ID));
                    popup.add((Component)gotoImplementedMenuItem, 1.0f);
                }
                if ((overItem = this.getImplOverItem(false, context, codeEditor, gutter, editorPane)) != null) {
                    JMenuItem gotoOverriddenMenuItem = popup.createMenuItem((ToggleAction)IdeAction.find((int)GOTO_OVERRIDDEN_METHOD_CMD_ID));
                    popup.add((Component)gotoOverriddenMenuItem, 1.0f);
                }
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        View view = context.getView();
        if (view instanceof CodeEditorGutter.GutterView && CodeEditorGutter.isMarkDroppingDown((Context)context)) {
            GutterMark mark = CodeEditorGutter.getMarkForContext((Context)context);
            if (mark.getUserData() instanceof List) {
                List list = (List)mark.getUserData();
                JavaImplOverPlugin.ImplOverItem item = (JavaImplOverPlugin.ImplOverItem)list.get(0);
                item.gotoImplOverItem();
            }
            return true;
        }
        return false;
    }

    private void initializeDynamicActions() {
        Menubar ideMenuManager = Ide.getMenubar();
        ArrayList<JMenuItem> dynamicList = new ArrayList<JMenuItem>();
        JMenuItem surroundsWithItem = ideMenuManager.createMenuItem((ToggleAction)IdeAction.find((int)SURROUND_WITH_CMD_ID), 500.0f);
        dynamicList.add(surroundsWithItem);
        JMenuItem completeStatementItem = ideMenuManager.createMenuItem((ToggleAction)IdeAction.find((int)COMPLETE_STATEMENT_CMD_ID), 125.0f);
        dynamicList.add(completeStatementItem);
        JMenuItem expandItem = ideMenuManager.createMenuItem((ToggleAction)IdeAction.find((int)EXPAND_SELECTION_CMD_ID), 540.0f);
        dynamicList.add(expandItem);
        JMenuItem narrowItem = ideMenuManager.createMenuItem((ToggleAction)IdeAction.find((int)NARROW_SELECTION_CMD_ID), 540.0f);
        dynamicList.add(narrowItem);
        int size = dynamicList.size();
        this.dynamicItems = dynamicList.toArray(new JMenuItem[size]);
    }

    public JComponent[] gatherDynamicActions(Context context) {
        Node node;
        View view = context.getView();
        if (view instanceof CodeEditor && (node = context.getNode()) instanceof JavaSourceNode) {
            return this.dynamicItems;
        }
        return new JComponent[0];
    }

    private SourceElement getSourceElement(int cursor, SourceElement element) {
        List children = element.getChildren();
        for (SourceElement child : children) {
            if (cursor < child.getStartOffset() || cursor >= child.getEndOffset()) continue;
            return this.getSourceElement(cursor, child);
        }
        return element;
    }

    private boolean chopsStatement(int cursor, SourceElement element) {
        if (element.getSymbolKind() == 2) {
            return false;
        }
        return cursor > element.getStartOffset() && cursor < element.getEndOffset();
    }

    private SourceElement getSourceBlock(int cursor, SourceElement element) {
        if (element.getSymbolKind() == 2 && cursor >= element.getEndOffset()) {
            element = element.getParent();
        }
        SourceElement parent = element;
        while (parent.getSymbolKind() != 11) {
            if (parent.getSymbolKind() == 2) {
                return parent;
            }
            if ((parent = parent.getParent()) != null) continue;
            return element.getOwningSourceFile();
        }
        return parent;
    }

    private boolean inSameCodeBlock(int startCursorOffset, SourceElement startNode, int endCursorOffset, SourceElement endNode) {
        return this.getSourceBlock(startCursorOffset, startNode).equals(this.getSourceBlock(endCursorOffset, endNode));
    }

    private class CEToolbarUpdater
    implements ViewSelectionListener,
    ActiveViewListener {
        public void viewSelectionChanged(ViewSelectionEvent e) {
            IdeMainWindow.updateVisibleActions();
        }

        public void activeViewChanged(ActiveViewEvent e) {
            View newView;
            View oldView = e.getOldView();
            if (oldView instanceof CodeEditor) {
                CodeEditor codeEditor = (CodeEditor)oldView;
                codeEditor.removeViewSelectionListener((ViewSelectionListener)this);
            }
            if ((newView = e.getNewView()) instanceof CodeEditor) {
                CodeEditor codeEditor = (CodeEditor)newView;
                codeEditor.addViewSelectionListener((ViewSelectionListener)this);
            }
        }

        private CEToolbarUpdater() {
        }

        CEToolbarUpdater(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

