/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceBlockStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceBreakStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceDoStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceElseClause;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceIfStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceWhileStatement;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdevimpl.java.Context2ParserHelper;

public class JavaNavigationUtilities {
    public static final int ACTION_NEXT_METHOD = 0;
    public static final int ACTION_PREV_METHOD = 1;
    public static final int ACTION_NEXT_FIELD = 2;
    public static final int ACTION_PREV_FIELD = 3;
    public static final int ACTION_NEXT_CLASS = 4;
    public static final int ACTION_PREV_CLASS = 5;
    public static final int ACTION_NEXT_MEMBER = 6;
    public static final int ACTION_PREV_MEMBER = 7;
    private static BasicEditorPane _currentEditorPane = null;
    private static ArrayList _selectionStack = new ArrayList();

    public static void navigateTo(BasicEditorPane editorPane, Context context, int actiontype) {
        SourceFile sf;
        Node node = context.getNode();
        if (node instanceof JavaSourceNode && (sf = JavaNavigationUtilities.getSourceFile(context)) != null) {
            JavaNavigationUtilities.navigate(editorPane, sf, actiontype);
        }
    }

    private static SourceFile getSourceFile(Context context) {
        Context2ParserHelper helper = Context2ParserHelper.createHelper(context);
        return helper.getSourceFile();
    }

    private static void checkExpandStack(BasicEditorPane editorPane, int spos, int epos) {
        if (_currentEditorPane == editorPane && _selectionStack.size() > 0) {
            Point lastsel = (Point)_selectionStack.get(_selectionStack.size() - 1);
            if (lastsel.x == spos && lastsel.y == epos) {
                return;
            }
        }
        _currentEditorPane = editorPane;
        _selectionStack.clear();
        _selectionStack.add(new Point(spos, epos));
    }

    public static void narrowSelection(BasicEditorPane editorPane, Context context) {
        int spos = editorPane.getSelectionStart();
        int epos = editorPane.getSelectionEnd();
        JavaNavigationUtilities.checkExpandStack(editorPane, spos, epos);
        if (_selectionStack.size() > 0) {
            _selectionStack.remove(_selectionStack.size() - 1);
        }
        if (_selectionStack.size() > 0) {
            Point p = (Point)_selectionStack.get(_selectionStack.size() - 1);
            editorPane.select(p.x, p.y);
        }
    }

    public static void expandSelection(BasicEditorPane editorPane, Context context) {
        JotProxyElementV2 lastelem;
        int spos = editorPane.getSelectionStart();
        int epos = editorPane.getSelectionEnd();
        JavaNavigationUtilities.checkExpandStack(editorPane, spos, epos);
        SourceFile sourceFile = JavaNavigationUtilities.getSourceFile(context);
        if (sourceFile == null) {
            return;
        }
        JotProxyElementV2 curelem = lastelem = new JotProxyElementV2((SourceElement)sourceFile, editorPane);
        while (curelem != null) {
            lastelem = curelem;
            JotProxyElementV2[] childs = curelem.getContainedElements();
            curelem = null;
            int i = 0;
            while (curelem == null && i < childs.length) {
                int start = childs[i].getStartOffset();
                int end = childs[i].getEndOffset();
                if (start <= spos && end >= epos && (start != spos || end != epos)) {
                    curelem = childs[i];
                }
                ++i;
            }
        }
        int docLength = editorPane.getDocument().getLength();
        Point p = new Point(lastelem.getStartOffset(), lastelem.getEndOffset());
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y > docLength || p.y < 0) {
            p.y = docLength;
        }
        if (p.x <= spos && p.y >= epos) {
            _selectionStack.add(p);
            editorPane.select(p.x, p.y);
        }
    }

    private static int[] prunePositions(SourceFile sourceFile, int action) {
        boolean wantsClasses = false;
        boolean wantsMethods = false;
        boolean wantsFields = false;
        switch (action) {
            case 0: 
            case 1: {
                wantsMethods = true;
                break;
            }
            case 2: 
            case 3: {
                wantsFields = true;
                break;
            }
            case 4: 
            case 5: {
                wantsClasses = true;
                break;
            }
            case 6: 
            case 7: {
                wantsFields = true;
                wantsClasses = true;
                wantsMethods = true;
                break;
            }
        }
        ArrayList al = new ArrayList();
        for (SourceClass srcClass : sourceFile.getClasses()) {
            JavaNavigationUtilities.recPruneClass(al, srcClass, wantsClasses, wantsMethods, wantsFields);
        }
        int[] res = new int[al.size()];
        int i = 0;
        while (i < al.size()) {
            Integer val = (Integer)al.get(i);
            res[i] = val;
            ++i;
        }
        Arrays.sort(res);
        return res;
    }

    private static void recPruneClass(ArrayList positions, SourceClass sourceClass, boolean wantsClasses, boolean wantsMethods, boolean wantsFields) {
        if (wantsClasses) {
            Integer startOffset = JavaNavigationUtilities.getOffset((SourceHasName)sourceClass);
            positions.add(startOffset);
        }
        for (SourceFieldDeclaration sf : sourceClass.getSourceFieldDeclarations()) {
            if (wantsFields) {
                Integer startOffset;
                List variables = sf.getVariables();
                if (variables != null && variables.size() > 0) {
                    SourceVariable sourceVariable = (SourceVariable)variables.get(0);
                    startOffset = JavaNavigationUtilities.getOffset((SourceHasName)sourceVariable);
                } else {
                    startOffset = new Integer(sf.getStartOffset());
                }
                positions.add(startOffset);
            }
            JavaNavigationUtilities.recPruneElement(positions, (SourceElement)sf, wantsClasses, wantsMethods, wantsFields);
        }
        Iterator itMethods = sourceClass.getSourceMethods().iterator();
        JavaNavigationUtilities.recPruneMethods(positions, itMethods, wantsClasses, wantsMethods, wantsFields);
        itMethods = sourceClass.getSourceConstructors().iterator();
        JavaNavigationUtilities.recPruneMethods(positions, itMethods, wantsClasses, wantsMethods, wantsFields);
        Iterator itIClasses = sourceClass.getDeclaredClasses().iterator();
        while (itIClasses.hasNext()) {
            JavaNavigationUtilities.recPruneClass(positions, (SourceClass)itIClasses.next(), wantsClasses, wantsMethods, wantsFields);
        }
    }

    private static Integer getOffset(SourceHasName sourceHasName) {
        SourceName nameElement = sourceHasName.getNameElement();
        int ret = nameElement != null ? nameElement.getStartOffset() : sourceHasName.getStartOffset();
        return new Integer(ret);
    }

    private static void recPruneElement(ArrayList positions, SourceElement el, boolean wantsClasses, boolean wantsMethods, boolean wantsFields) {
        switch (el.getSymbolKind()) {
            case 3: {
                JavaNavigationUtilities.recPruneClass(positions, (SourceClass)el, wantsClasses, wantsMethods, wantsFields);
                break;
            }
            default: {
                Iterator itChilds = el.getChildren().iterator();
                while (itChilds.hasNext()) {
                    JavaNavigationUtilities.recPruneElement(positions, (SourceElement)itChilds.next(), wantsClasses, wantsMethods, wantsFields);
                }
                break block0;
            }
        }
    }

    private static void recPruneMethods(ArrayList positions, Iterator itMethods, boolean wantsClasses, boolean wantsMethods, boolean wantsFields) {
        while (itMethods.hasNext()) {
            SourceBlock block;
            SourceMethod method = (SourceMethod)itMethods.next();
            if (wantsMethods) {
                Integer offset = JavaNavigationUtilities.getOffset((SourceHasName)method);
                positions.add(offset);
            }
            if ((block = method.getBlock()) == null) continue;
            JavaNavigationUtilities.recPruneElement(positions, (SourceElement)block, wantsClasses, wantsMethods, wantsFields);
        }
    }

    private static void navigate(BasicEditorPane editorPane, SourceFile sourceFile, int action) {
        int[] targetPos = JavaNavigationUtilities.prunePositions(sourceFile, action);
        int curpos = editorPane.getCaretPosition();
        int lineNumber = editorPane.getLineFromOffset(curpos);
        int newpos = curpos;
        block0 : switch (action) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                if (targetPos.length > 0) {
                    newpos = targetPos[0];
                }
                int lineEndOffset = editorPane.getLineEndOffset(lineNumber);
                int i = 0;
                while (i < targetPos.length) {
                    if (lineEndOffset < targetPos[i]) {
                        newpos = targetPos[i];
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                if (targetPos.length > 0) {
                    newpos = targetPos[targetPos.length - 1];
                }
                int lineStartOffset = editorPane.getLineStartOffset(lineNumber);
                int i = targetPos.length - 1;
                while (i >= 0) {
                    if (lineStartOffset > targetPos[i]) {
                        newpos = targetPos[i];
                        break block0;
                    }
                    --i;
                }
                break;
            }
        }
        if (newpos != curpos) {
            editorPane.select(newpos, newpos);
        }
    }

    private static SourceElement findExpandableElement(SourceElement el, int pos) {
        SourceFile sf = (SourceFile)el;
        SourceElement res = sf.getElementAt(pos);
        while (res != null) {
            switch (res.getSymbolKind()) {
                case 3: 
                case 9: 
                case 18: 
                case 19: 
                case 33: 
                case 36: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 45: {
                    return res;
                }
            }
            res = res.getParent();
        }
        return res;
    }

    public static void expandStatement(BasicEditorPane editorPane, Context context) {
        int pos = editorPane.getCaretPosition();
        SourceFile sourceFile = JavaNavigationUtilities.getSourceFile(context);
        if (sourceFile == null) {
            return;
        }
        SourceElement cel = JavaNavigationUtilities.findExpandableElement((SourceElement)sourceFile, pos);
        if (cel != null) {
            switch (cel.getSymbolKind()) {
                case 3: {
                    JavaNavigationUtilities.expandClassDeclaration(context, editorPane, sourceFile, cel);
                    break;
                }
                case 19: {
                    JavaNavigationUtilities.expandMethodDeclaration(context, editorPane, sourceFile, cel);
                    break;
                }
                case 9: {
                    JavaNavigationUtilities.expandFieldDeclaration(context, editorPane, sourceFile, cel);
                    break;
                }
                case 18: 
                case 36: 
                case 40: {
                    JavaNavigationUtilities.expandLocalsOrExpression(context, editorPane, sourceFile, cel);
                    break;
                }
                case 38: {
                    JavaNavigationUtilities.expandForStatement(context, editorPane, sourceFile, cel);
                    break;
                }
                case 41: {
                    JavaNavigationUtilities.expandSwitchStatement(context, editorPane, sourceFile, cel);
                    break;
                }
                case 45: {
                    JavaNavigationUtilities.expandWhileStatement(context, editorPane, sourceFile, cel);
                    break;
                }
                case 33: {
                    JavaNavigationUtilities.expandDoStatement(context, editorPane, sourceFile, cel);
                    break;
                }
                case 39: {
                    JavaNavigationUtilities.expandIfStatement(context, editorPane, sourceFile, cel);
                    break;
                }
            }
        }
    }

    private static void expandClassDeclaration(Context context, BasicEditorPane editorPane, SourceFile sourceFile, SourceElement cel) {
        int curOffs = editorPane.getCaretPosition();
        RefactoringCommandSupport commandSupport = new RefactoringCommandSupport();
        SourceTransaction trans = null;
        try {
            int finalpos = -1;
            trans = commandSupport.beginTransaction((SourceElement)sourceFile);
            SourceFactory sf = sourceFile.getFactory();
            SourceClass cls = (SourceClass)cel;
            SourceClassBody block = cls.getSourceBody();
            if (block == null) {
                block = sf.createClassBody();
                block.addSelf((SourceElement)cls);
            }
            trans.savepoint();
            block = cls.getSourceBody();
            if (curOffs <= block.getStartOffset()) {
                finalpos = JavaNavigationUtilities.adjustSourceBody(sf, trans, block, finalpos);
            }
            commandSupport.commit(context, "Expand Statement");
            if (finalpos != -1) {
                editorPane.select(finalpos, finalpos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            commandSupport.abort();
        }
    }

    private static void expandMethodDeclaration(Context context, BasicEditorPane editorPane, SourceFile sourceFile, SourceElement cel) {
        int curOffs = editorPane.getCaretPosition();
        RefactoringCommandSupport commandSupport = new RefactoringCommandSupport();
        SourceTransaction trans = null;
        try {
            SourceBlock block;
            int finalpos = -1;
            trans = commandSupport.beginTransaction((SourceElement)sourceFile);
            SourceFactory sf = sourceFile.getFactory();
            SourceMethod smd = (SourceMethod)cel;
            SourceFormalParameterList plist = smd.getFormalParameterList();
            boolean gotodecl = false;
            if (plist == null) {
                plist = sf.createFormalParameterList();
                plist.addSelf((SourceElement)smd);
                gotodecl = true;
            }
            if ((block = smd.getBlock()) == null) {
                block = sf.createBlock();
                block.addSelf((SourceElement)smd);
            }
            trans.savepoint();
            if (gotodecl) {
                finalpos = plist.getStartOffset() + 1;
            } else {
                block = smd.getBlock();
                if (curOffs <= block.getStartOffset()) {
                    finalpos = JavaNavigationUtilities.adjustSourceBlock(sf, trans, block, finalpos);
                }
            }
            commandSupport.commit(context, "Expand Statement");
            if (finalpos != -1) {
                editorPane.select(finalpos, finalpos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            commandSupport.abort();
        }
    }

    private static void expandFieldDeclaration(Context context, BasicEditorPane editorPane, SourceFile sourceFile, SourceElement cel) {
        String oldTxt = cel.getText();
        SourceFactory sf = sourceFile.getFactory();
        SourceMember newEl = !oldTxt.endsWith(";") ? sf.createMember(oldTxt + ';') : sf.createMember(oldTxt);
        int finalpos = -1;
        SourceTransaction trans = null;
        RefactoringCommandSupport commandSupport = new RefactoringCommandSupport();
        try {
            trans = commandSupport.beginTransaction((SourceElement)sourceFile);
            cel.replaceSelf((SourceElement)newEl);
            trans.savepoint();
            finalpos = newEl.getEndOffset();
            commandSupport.commit(context, "Expand Statement");
            if (finalpos != -1) {
                editorPane.select(finalpos, finalpos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            commandSupport.abort();
        }
    }

    private static void expandLocalsOrExpression(Context context, BasicEditorPane editorPane, SourceFile sourceFile, SourceElement cel) {
        String oldTxt = cel.getText();
        SourceFactory sf = sourceFile.getFactory();
        SourceStatement newEl = !oldTxt.endsWith(";") ? sf.createStatement('{' + oldTxt + ';' + '}') : sf.createStatement('{' + oldTxt + '}');
        int finalpos = -1;
        SourceTransaction trans = null;
        RefactoringCommandSupport commandSupport = new RefactoringCommandSupport();
        try {
            trans = commandSupport.beginTransaction((SourceElement)sourceFile);
            SourceBlockStatement sbt = (SourceBlockStatement)newEl;
            SourceElement sel = (SourceElement)sbt.getBlock().getChildren().get(0);
            sel = sel.cloneSelf(sourceFile);
            cel.replaceSelf(sel);
            trans.savepoint();
            finalpos = sel.getEndOffset();
            commandSupport.commit(context, "Expand Statement");
            if (finalpos != -1) {
                editorPane.select(finalpos, finalpos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            commandSupport.abort();
        }
    }

    private static void expandForStatement(Context context, BasicEditorPane editorPane, SourceFile sourceFile, SourceElement cel) {
        int curOffs = editorPane.getCaretPosition();
        SourceForStatement stmt = (SourceForStatement)cel;
        SourceFactory sf = sourceFile.getFactory();
        boolean adjustPrimary = false;
        SourceStatement prim = stmt.getPrimaryClause();
        if (prim == null) {
            adjustPrimary = true;
            prim = sf.createStatement("{\n}");
        } else {
            if (curOffs <= prim.getStartOffset()) {
                adjustPrimary = true;
            }
            prim = (SourceStatement)prim.cloneSelf(sourceFile);
        }
        int finalpos = -1;
        SourceTransaction trans = null;
        RefactoringCommandSupport commandSupport = new RefactoringCommandSupport();
        try {
            SourceStatement sse;
            SourceForStatement newStmt;
            SourceListExpression update;
            trans = commandSupport.beginTransaction((SourceElement)sourceFile);
            SourceListExpression initList = stmt.getForInitializationList();
            SourceLocalVariableDeclaration decls = null;
            if (initList != null) {
                initList = (SourceListExpression)initList.cloneSelf(sourceFile);
            } else {
                decls = stmt.getForVariableDeclaration();
                if (decls != null) {
                    decls = (SourceLocalVariableDeclaration)decls.cloneSelf(sourceFile);
                }
            }
            SourceExpression cond = stmt.getForConditional();
            if (cond != null) {
                cond = (SourceExpression)cond.cloneSelf(sourceFile);
            }
            if ((update = stmt.getForUpdateList()) != null) {
                update = (SourceListExpression)update.cloneSelf(sourceFile);
            }
            if (decls == null) {
                newStmt = sf.createForStatement(initList, cond, update, prim);
            } else {
                SourceExpression var;
                List lvars = decls.getVariables();
                SourceLocalVariable[] vars = new SourceLocalVariable[lvars.size()];
                vars = lvars.toArray(vars);
                int i = 0;
                while (i < vars.length) {
                    vars[i] = (SourceLocalVariable)vars[i].cloneSelf(sourceFile);
                    ++i;
                }
                newStmt = stmt.getForType() != 2 ? sf.createForVariableStatement(decls, cond, update, prim) : ((var = stmt.getForCollection()) != null ? sf.createForEnhancedStatement(vars[0], (SourceExpression)var.cloneSelf(sourceFile), prim) : (SourceForStatement)stmt.cloneSelf(sourceFile));
            }
            stmt.replaceSelf((SourceElement)newStmt);
            trans.savepoint();
            if (adjustPrimary && (sse = newStmt.getPrimaryClause()) instanceof SourceBlockStatement) {
                SourceBlockStatement sb = (SourceBlockStatement)sse;
                finalpos = JavaNavigationUtilities.adjustSourceBlock(sf, trans, sb.getBlock(), finalpos);
            }
            commandSupport.commit(context, "Expand Statement");
            if (finalpos != -1) {
                editorPane.select(finalpos, finalpos);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            commandSupport.abort();
        }
    }

    private static void expandWhileStatement(Context context, BasicEditorPane editorPane, SourceFile sourceFile, SourceElement cel) {
        int curOffs = editorPane.getCaretPosition();
        SourceWhileStatement whst = (SourceWhileStatement)cel;
        SourceFactory sf = sourceFile.getFactory();
        boolean clearcond = false;
        boolean adjustPrimary = false;
        SourceExpression ctrlexp = whst.getControlExpression();
        if (ctrlexp == null) {
            ctrlexp = sf.createExpression("true");
            clearcond = true;
        } else {
            ctrlexp = (SourceExpression)ctrlexp.cloneSelf(sourceFile);
        }
        SourceStatement prim = whst.getPrimaryClause();
        if (prim == null) {
            adjustPrimary = true;
            prim = sf.createStatement("{\n}");
        } else {
            if (curOffs <= prim.getStartOffset()) {
                adjustPrimary = true;
            }
            prim = (SourceStatement)prim.cloneSelf(sourceFile);
        }
        int finalpos = -1;
        SourceTransaction trans = null;
        RefactoringCommandSupport commandSupport = new RefactoringCommandSupport();
        try {
            SourceStatement sse;
            trans = commandSupport.beginTransaction((SourceElement)sourceFile);
            SourceWhileStatement newWhile = sf.createWhileStatement(ctrlexp, prim);
            whst.replaceSelf((SourceElement)newWhile);
            trans.savepoint();
            if (clearcond) {
                ctrlexp = newWhile.getControlExpression();
                SourceExpression eel = ctrlexp.getFirstOperand();
                finalpos = eel.getStartOffset();
                eel.removeSelf();
            }
            if (adjustPrimary && (sse = newWhile.getPrimaryClause()) instanceof SourceBlockStatement) {
                SourceBlockStatement sb = (SourceBlockStatement)sse;
                finalpos = JavaNavigationUtilities.adjustSourceBlock(sf, trans, sb.getBlock(), finalpos);
            }
            commandSupport.commit(context, "Expand Statement");
            if (finalpos != -1) {
                editorPane.select(finalpos, finalpos);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            commandSupport.abort();
        }
    }

    private static void expandDoStatement(Context context, BasicEditorPane editorPane, SourceFile sourceFile, SourceElement cel) {
        int curOffs = editorPane.getCaretPosition();
        SourceDoStatement stmt = (SourceDoStatement)cel;
        SourceFactory sf = sourceFile.getFactory();
        boolean clearcond = false;
        boolean adjustPrimary = false;
        SourceExpression ctrlexp = stmt.getControlExpression();
        if (ctrlexp == null || ctrlexp.getFirstOperand() == null || ctrlexp.getFirstOperand().getStartOffset() == -1) {
            ctrlexp = sf.createExpression("true");
            clearcond = true;
        } else {
            ctrlexp = (SourceExpression)ctrlexp.cloneSelf(sourceFile);
        }
        SourceStatement prim = stmt.getPrimaryClause();
        if (prim == null) {
            adjustPrimary = true;
            prim = sf.createStatement("{\n}");
        } else {
            if (curOffs <= prim.getStartOffset()) {
                adjustPrimary = true;
            }
            prim = (SourceStatement)prim.cloneSelf(sourceFile);
        }
        int finalpos = -1;
        SourceTransaction trans = null;
        RefactoringCommandSupport commandSupport = new RefactoringCommandSupport();
        try {
            SourceStatement sse;
            trans = commandSupport.beginTransaction((SourceElement)sourceFile);
            SourceDoStatement newWhile = sf.createDoStatement(ctrlexp, prim);
            stmt.replaceSelf((SourceElement)newWhile);
            trans.savepoint();
            if (adjustPrimary && (sse = newWhile.getPrimaryClause()) instanceof SourceBlockStatement) {
                SourceBlockStatement sb = (SourceBlockStatement)sse;
                finalpos = JavaNavigationUtilities.adjustSourceBlock(sf, trans, sb.getBlock(), finalpos);
            }
            if (clearcond) {
                ctrlexp = newWhile.getControlExpression();
                SourceExpression eel = ctrlexp.getFirstOperand();
                if (finalpos == -1) {
                    finalpos = eel.getStartOffset();
                }
                eel.removeSelf();
            }
            commandSupport.commit(context, "Expand Statement");
            if (finalpos != -1) {
                editorPane.select(finalpos, finalpos);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            commandSupport.abort();
        }
    }

    private static void expandIfStatement(Context context, BasicEditorPane editorPane, SourceFile sourceFile, SourceElement cel) {
        int curOffs = editorPane.getCaretPosition();
        SourceIfStatement sip = (SourceIfStatement)cel;
        boolean clearcond = false;
        boolean adjustPrimary = false;
        SourceExpression ctrlexp = sip.getControlExpression();
        SourceFactory sf = sourceFile.getFactory();
        if (ctrlexp == null) {
            ctrlexp = sf.createExpression("true");
            clearcond = true;
        } else {
            ctrlexp = (SourceExpression)ctrlexp.cloneSelf(sourceFile);
        }
        SourceStatement prim = sip.getPrimaryClause();
        if (prim == null) {
            adjustPrimary = true;
            prim = sf.createStatement("{\n}");
        } else {
            if (curOffs <= prim.getStartOffset()) {
                adjustPrimary = true;
            }
            prim = (SourceStatement)prim.cloneSelf(sourceFile);
        }
        SourceElseClause sec = sip.getElseClause();
        if (sec != null) {
            sec = sec.getPrimaryClause() != null ? (SourceElseClause)sec.cloneSelf(sourceFile) : sf.createElseClause(sf.createStatement("{\n}"));
        }
        int finalpos = -1;
        SourceTransaction trans = null;
        RefactoringCommandSupport commandSupport = new RefactoringCommandSupport();
        try {
            SourceStatement sse;
            trans = commandSupport.beginTransaction((SourceElement)sourceFile);
            SourceIfStatement newIf = sf.createIfStatement(ctrlexp, prim, sec);
            sip.replaceSelf((SourceElement)newIf);
            trans.savepoint();
            if (clearcond) {
                ctrlexp = newIf.getControlExpression();
                SourceExpression eel = ctrlexp.getFirstOperand();
                finalpos = eel.getStartOffset();
                eel.removeSelf();
            }
            if (adjustPrimary) {
                SourceStatement sse2 = newIf.getPrimaryClause();
                if (sse2 instanceof SourceBlockStatement) {
                    SourceBlockStatement sb = (SourceBlockStatement)sse2;
                    finalpos = JavaNavigationUtilities.adjustSourceBlock(sf, trans, sb.getBlock(), finalpos);
                }
            } else if (sec != null && (sse = sec.getPrimaryClause()) instanceof SourceBlockStatement) {
                SourceBlockStatement sb = (SourceBlockStatement)sse;
                finalpos = JavaNavigationUtilities.adjustSourceBlock(sf, trans, sb.getBlock(), finalpos);
            }
            commandSupport.commit(context, "Expand Statement");
            if (finalpos != -1) {
                editorPane.select(finalpos, finalpos);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            commandSupport.abort();
        }
    }

    private static void expandSwitchStatement(Context context, BasicEditorPane editorPane, SourceFile sourceFile, SourceElement cel) {
        int curOffs = editorPane.getCaretPosition();
        SourceSwitchStatement stmt = (SourceSwitchStatement)cel;
        SourceFactory sf = sourceFile.getFactory();
        boolean clearcond = false;
        boolean adjustPrimary = false;
        SourceExpression ctrlexp = stmt.getControlExpression();
        if (ctrlexp == null) {
            ctrlexp = sf.createExpression("true");
            clearcond = true;
        } else {
            ctrlexp = (SourceExpression)ctrlexp.cloneSelf(sourceFile);
        }
        SourceBlockStatement prim = (SourceBlockStatement)stmt.getPrimaryClause();
        if (prim == null) {
            adjustPrimary = true;
            prim = sf.createBlockStatement(sf.createBlock("{\n}"));
        } else {
            if (curOffs <= prim.getStartOffset()) {
                adjustPrimary = true;
            }
            prim = (SourceBlockStatement)prim.cloneSelf(sourceFile);
        }
        int finalpos = -1;
        SourceTransaction trans = null;
        RefactoringCommandSupport commandSupport = new RefactoringCommandSupport();
        try {
            SourceStatement sse;
            trans = commandSupport.beginTransaction((SourceElement)sourceFile);
            SourceSwitchStatement newStmt = sf.createSwitchStatement(ctrlexp, prim);
            stmt.replaceSelf((SourceElement)newStmt);
            trans.savepoint();
            if (clearcond) {
                ctrlexp = newStmt.getControlExpression();
                SourceExpression eel = ctrlexp.getFirstOperand();
                finalpos = eel.getStartOffset();
                eel.removeSelf();
            }
            if (adjustPrimary && (sse = newStmt.getPrimaryClause()) instanceof SourceBlockStatement) {
                SourceBlockStatement sb = (SourceBlockStatement)sse;
                finalpos = JavaNavigationUtilities.adjustSourceBlock(sf, trans, sb.getBlock(), finalpos);
            }
            commandSupport.commit(context, "Expand Statement");
            if (finalpos != -1) {
                editorPane.select(finalpos, finalpos);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            commandSupport.abort();
        }
    }

    private static int adjustSourceBlock(SourceFactory factory, SourceTransaction transaction, SourceBlock blk, int finalpos) {
        SourceBreakStatement toer = factory.createBreakStatement(null);
        blk.getChildren().add(0, toer);
        transaction.savepoint();
        if (finalpos == -1) {
            finalpos = toer.getStartOffset();
        }
        String curb = blk.getText();
        String newVal = curb.substring(0, toer.getStartOffset() - blk.getStartOffset()) + curb.substring(toer.getEndOffset() - blk.getStartOffset());
        blk.replaceSelf((SourceElement)factory.createBlock(newVal));
        return finalpos;
    }

    private static int adjustSourceBody(SourceFactory factory, SourceTransaction transaction, SourceClassBody blk, int finalpos) {
        SourceFieldDeclaration toer = factory.createFieldDeclaration(factory.createType("int"), "xxxx");
        blk.getChildren().add(0, toer);
        transaction.savepoint();
        if (finalpos == -1) {
            finalpos = toer.getStartOffset();
        }
        SourceClass ccls = (SourceClass)blk.getParent();
        String curb = ccls.getText();
        String newVal = curb.substring(0, toer.getStartOffset() - ccls.getStartOffset()) + curb.substring(toer.getEndOffset() - ccls.getStartOffset());
        ccls.replaceSelf((SourceElement)factory.createClass(newVal));
        return finalpos;
    }

    static class JotProxyElementV2 {
        private static final JotProxyElementV2[] NULL_TOKLIST = new JotProxyElementV2[0];
        private SourceElement _jElem;
        private int _oStart;
        private int _oEnd;
        private JotProxyElementV2[] _childs;
        BasicEditorPane _editorPane;

        public JotProxyElementV2(SourceElement el, BasicEditorPane editorPane) {
            this._jElem = el;
            this._oStart = el.getStartOffset();
            this._oEnd = el.getEndOffset();
            this._editorPane = editorPane;
        }

        public JotProxyElementV2(int start, int end, JotProxyElementV2[] childs, BasicEditorPane editorPane) {
            this._oStart = start;
            this._oEnd = end;
            this._childs = childs;
            this._editorPane = editorPane;
        }

        public int getStartOffset() {
            return this._oStart;
        }

        public int getEndOffset() {
            return this._oEnd;
        }

        private String getStringFromEditor() {
            String res = "";
            try {
                res = this._editorPane.getText(this._oStart, this._oEnd - this._oStart);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return res;
        }

        private void adjustChildsToLines() {
            int min = this._oStart;
            int i = 0;
            while (i < this._childs.length) {
                JotProxyElementV2 cel = this._childs[i];
                int olstart = this._editorPane.getLineStartOffset(this._editorPane.getLineFromOffset(cel.getStartOffset()));
                int olend = this._editorPane.getLineEndOffset(this._editorPane.getLineFromOffset(cel.getEndOffset()));
                cel._oStart = Math.max(min, olstart);
                cel._oEnd = i < this._childs.length - 1 ? Math.min(olend, this._childs[i + 1]._oStart) : Math.min(olend, this._oEnd);
                min = cel._oEnd;
                ++i;
            }
        }

        private JotProxyElementV2[] extractTokens(int offset, String s) {
            ArrayList<JotProxyElementV2> al = new ArrayList<JotProxyElementV2>();
            boolean inToken = false;
            int i = 0;
            int tokStart = 0;
            int len = s.length();
            while (i <= len) {
                if (i < len && Character.isJavaIdentifierPart(s.charAt(i))) {
                    if (!inToken) {
                        tokStart = i;
                        inToken = true;
                    }
                } else if (inToken) {
                    al.add(new JotProxyElementV2(offset + tokStart, offset + i, NULL_TOKLIST, this._editorPane));
                    inToken = false;
                }
                ++i;
            }
            return al.toArray(new JotProxyElementV2[al.size()]);
        }

        private void fillChilds() {
            int elemID = this._jElem.getSymbolKind();
            switch (elemID) {
                case 52: {
                    String txt = this.getStringFromEditor();
                    this._childs = this.extractTokens(this._oStart, txt);
                    return;
                }
                case 12: 
                case 51: {
                    SourceElement[] types = this._jElem.getContainedElements();
                    ArrayList<JotProxyElementV2> lParams = new ArrayList<JotProxyElementV2>();
                    int ostart = -1;
                    int oend = -1;
                    int i = 0;
                    while (i < types.length) {
                        SourceElement el = types[i];
                        if (ostart == -1) {
                            ostart = el.getStartOffset();
                        }
                        lParams.add(new JotProxyElementV2(el, this._editorPane));
                        oend = el.getEndOffset();
                        ++i;
                    }
                    JotProxyElementV2 params = null;
                    if (ostart != -1) {
                        JotProxyElementV2[] allparams = new JotProxyElementV2[lParams.size()];
                        allparams = lParams.toArray(allparams);
                        params = new JotProxyElementV2(ostart, oend, allparams, this._editorPane);
                        this._childs = new JotProxyElementV2[1];
                        this._childs[0] = params;
                        return;
                    }
                }
                case 2: {
                    SourceElement[] els = this._jElem.getContainedElements();
                    ArrayList<JotProxyElementV2> cchilds = new ArrayList<JotProxyElementV2>();
                    ArrayList<JotProxyElementV2> cgroup = null;
                    int curgrpline = -10;
                    int grpsoff = 0;
                    int grpeofs = 0;
                    int i = 0;
                    while (i < els.length) {
                        SourceElement cel = els[i];
                        int lstart = this._editorPane.getLineFromOffset(cel.getStartOffset());
                        int lend = this._editorPane.getLineFromOffset(cel.getEndOffset());
                        if (lstart - curgrpline > 0) {
                            if (cgroup != null) {
                                JotProxyElementV2[] gelems = new JotProxyElementV2[cgroup.size()];
                                gelems = cgroup.toArray(gelems);
                                cchilds.add(new JotProxyElementV2(grpsoff, grpeofs, gelems, this._editorPane));
                            }
                            cgroup = new ArrayList<JotProxyElementV2>();
                            grpsoff = Math.max(this._oStart, this._editorPane.getLineStartOffset(lstart));
                            grpeofs = Math.min(this._oEnd, this._editorPane.getLineStartOffset(lend + 1));
                            cgroup.add(new JotProxyElementV2(cel, this._editorPane));
                            curgrpline = lend;
                        } else {
                            grpeofs = Math.min(this._oEnd, this._editorPane.getLineStartOffset(lend + 1));
                            cgroup.add(new JotProxyElementV2(cel, this._editorPane));
                            curgrpline = lend;
                        }
                        ++i;
                    }
                    if (cgroup != null) {
                        JotProxyElementV2[] gelems = new JotProxyElementV2[cgroup.size()];
                        gelems = cgroup.toArray(gelems);
                        cchilds.add(new JotProxyElementV2(grpsoff, grpeofs, gelems, this._editorPane));
                    }
                    JotProxyElementV2[] jotProxyElements = new JotProxyElementV2[cchilds.size()];
                    jotProxyElements = cchilds.toArray(jotProxyElements);
                    cchilds = new ArrayList();
                    cgroup = null;
                    curgrpline = -10;
                    grpsoff = 0;
                    grpeofs = 0;
                    int i2 = 0;
                    while (i2 < jotProxyElements.length) {
                        JotProxyElementV2 cel = jotProxyElements[i2];
                        int lstart = this._editorPane.getLineFromOffset(cel.getStartOffset());
                        int lend = this._editorPane.getLineFromOffset(cel.getEndOffset());
                        if (lstart - curgrpline > 0) {
                            if (cgroup != null) {
                                JotProxyElementV2[] gelems = new JotProxyElementV2[cgroup.size()];
                                gelems = cgroup.toArray(gelems);
                                cchilds.add(new JotProxyElementV2(grpsoff, grpeofs, gelems, this._editorPane));
                            }
                            cgroup = new ArrayList();
                            grpsoff = cel.getStartOffset();
                            grpeofs = cel.getEndOffset();
                            cgroup.add(cel);
                            curgrpline = lend;
                        } else {
                            grpeofs = cel.getEndOffset();
                            cgroup.add(cel);
                            curgrpline = lend;
                        }
                        ++i2;
                    }
                    if (cgroup != null) {
                        JotProxyElementV2[] gelems = new JotProxyElementV2[cgroup.size()];
                        gelems = cgroup.toArray(gelems);
                        cchilds.add(new JotProxyElementV2(grpsoff, grpeofs, gelems, this._editorPane));
                    }
                    jotProxyElements = new JotProxyElementV2[cchilds.size()];
                    if ((jotProxyElements = cchilds.toArray(jotProxyElements)).length != 0) {
                        this._childs = new JotProxyElementV2[1];
                        this._childs[0] = new JotProxyElementV2(jotProxyElements[0].getStartOffset(), jotProxyElements[jotProxyElements.length - 1].getEndOffset(), jotProxyElements, this._editorPane);
                    } else {
                        this._childs = NULL_TOKLIST;
                    }
                    return;
                }
            }
            SourceElement[] jchilds = this._jElem.getContainedElements();
            this._childs = new JotProxyElementV2[jchilds.length];
            int i = 0;
            while (i < jchilds.length) {
                this._childs[i] = new JotProxyElementV2(jchilds[i], this._editorPane);
                ++i;
            }
            if (elemID == 4) {
                this.adjustChildsToLines();
            }
        }

        public JotProxyElementV2[] getContainedElements() {
            if (this._childs == null) {
                this.fillChilds();
            }
            return this._childs;
        }
    }
}

