/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceThrowStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.imports.AbstractTryCatchFinallySurrounder;
import oracle.jdevimpl.java.imports.ImportUtilities2;

public final class JavaTryCatchFinallySurrounder
extends AbstractTryCatchFinallySurrounder {
    private String[] _exceptions;
    private String[] _importsToAdd;
    private SourceFile _sourceFile;

    public JavaTryCatchFinallySurrounder(int type) {
        super(type);
    }

    protected void doSurroundImpl(BasicEditorPane editorPane, Context context) throws BadLocationException {
        try {
            this._init(editorPane, context);
            super.doSurroundImpl(editorPane, context);
            if (this._importsToAdd != null) {
                BasicDocument document = (BasicDocument)editorPane.getDocument();
                TextBuffer textBuffer = document.getTextBuffer();
                ImportUtilities2.insertImports(this._importsToAdd, this._sourceFile, textBuffer);
            }
        }
        finally {
            this._clear();
        }
    }

    protected String[] getExceptions() {
        return this._exceptions;
    }

    private void _init(BasicEditorPane editorPane, Context context) {
        Ide.getWaitCursor().show();
        try {
            try {
                this._sourceFile = ImportUtilities2.getCompiledParseTree(context);
            }
            catch (RuntimeException e) {
                this._sourceFile = null;
            }
        }
        finally {
            Ide.getWaitCursor().hide();
        }
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        LineMap lineMap = document.getLineMap();
        TextBuffer textBuffer = document.getTextBuffer();
        int selectStart = this.startPos;
        int startLine = lineMap.getLineFromOffset(selectStart);
        int blockStart = lineMap.getLineStartOffset(startLine);
        int selectEnd = this.endPos;
        int endLine = lineMap.getLineFromOffset(selectEnd - 1);
        endLine = Math.max(endLine, startLine);
        int blockEnd = lineMap.getLineEndOffset(endLine);
        String[] exceptions = this.getCatchExceptions(this._sourceFile, blockStart, blockEnd);
        String[][] processResult = this.processImports(this._sourceFile, textBuffer, exceptions);
        this._exceptions = processResult[0];
        this._importsToAdd = processResult[1];
    }

    private void _clear() {
        this._exceptions = null;
        this._importsToAdd = null;
        this._sourceFile = null;
    }

    private static List getImportNameList(ImportUtilities2.ImportLine[] imports) {
        ArrayList<String> importList = new ArrayList<String>();
        int count = imports.length;
        int i = 0;
        while (i < count) {
            ImportUtilities2.ImportLine importLine = imports[i];
            if (!ImportUtilities2.isStatic(importLine)) {
                importList.add(importLine._fqName);
            }
            ++i;
        }
        return importList;
    }

    private String[][] processImports(SourceFile sourceFile, TextBuffer textBuffer, String[] classesToImport) {
        if (sourceFile == null) {
            String[][] result = new String[][]{classesToImport, new String[0]};
            return result;
        }
        String packageName = ImportUtilities2.getPackageName(sourceFile);
        ImportUtilities2.ImportLine[] imports = ImportUtilities2.getImports(sourceFile, textBuffer);
        List narrowList = JavaTryCatchFinallySurrounder.getImportNameList(ImportUtilities2.getNarrowImports(imports));
        List wideList = JavaTryCatchFinallySurrounder.getImportNameList(ImportUtilities2.getWideImports(imports));
        ImportUtilities2.disposeImports(imports, textBuffer);
        int count = classesToImport != null ? classesToImport.length : 0;
        ArrayList<String> exceptionList = new ArrayList<String>();
        ArrayList<String> importsToAddList = new ArrayList<String>();
        int i = 0;
        while (i < count) {
            String currentFQName = classesToImport[i];
            String currentPackage = ImportUtilities2.getPackageFor(currentFQName);
            String currentName = ImportUtilities2.getClassFor(currentFQName);
            String wideImport = currentPackage + ".*";
            String narrowImport = currentFQName;
            if (narrowList.contains(narrowImport) || wideList.contains(wideImport) || packageName.equals(currentPackage) || currentPackage.equals("java.lang")) {
                exceptionList.add(currentName);
            } else {
                int narrowCount = narrowList.size();
                String suffix = "." + currentName;
                boolean conflicts = false;
                int n = 0;
                while (n < narrowCount) {
                    String existingImport = narrowList.get(n).toString();
                    if (existingImport.endsWith(suffix)) {
                        conflicts = true;
                        break;
                    }
                    ++n;
                }
                if (conflicts) {
                    exceptionList.add(currentFQName);
                } else {
                    exceptionList.add(currentName);
                    importsToAddList.add(currentFQName);
                }
            }
            ++i;
        }
        int exceptionCount = exceptionList.size();
        String[] exceptionArray = exceptionList.toArray(new String[exceptionCount]);
        int importCount = importsToAddList.size();
        Object[] importArray = importsToAddList.toArray(new String[importCount]);
        Arrays.sort(importArray);
        String[][] result = new String[][]{exceptionArray, importArray};
        return result;
    }

    private void findThrowedException(Set throwed, SourceElement el, int start, int end) {
        int elEnd = el.getEndOffset();
        int elStart = el.getStartOffset();
        if (start >= elEnd || end <= elStart) {
            return;
        }
        if (start <= elStart && end >= elEnd) {
            switch (el.getSymbolKind()) {
                case 53: {
                    SourceMethodCallExpression mcall = (SourceMethodCallExpression)el;
                    JavaMethod jMethod = mcall.getResolvedMethod();
                    if (jMethod == null) break;
                    for (JavaType tp : jMethod.getExceptions()) {
                        if (!this.notCatched((SourceElement)mcall, tp, start, end)) continue;
                        throwed.add(tp.getQualifiedName());
                    }
                    break;
                }
                case 43: {
                    SourceThrowStatement thr = (SourceThrowStatement)el;
                    JavaType tp = thr.getExpression().getResolvedType();
                    if (!this.notCatched((SourceElement)thr, tp, start, end)) break;
                    throwed.add(tp.getQualifiedName());
                    break;
                }
            }
        }
        Iterator childIter = el.getChildren().iterator();
        while (childIter.hasNext()) {
            this.findThrowedException(throwed, (SourceElement)childIter.next(), start, end);
        }
    }

    private boolean notCatched(SourceElement element, JavaType tp, int start, int end) {
        boolean notCatched = true;
        SourceElement parent = element.getParent();
        boolean notDone = true;
        while (notDone) {
            if (parent.getStartOffset() >= start && parent.getEndOffset() <= end) {
                switch (parent.getSymbolKind()) {
                    case 44: {
                        SourceTryStatement tstmt = (SourceTryStatement)parent;
                        for (SourceCatchClause ctch : tstmt.getCatchClauses()) {
                            JavaType cType = ctch.getCatchVariable().getResolvedType();
                            if (!cType.isAssignableFrom(tp)) continue;
                            notCatched = false;
                            notDone = false;
                        }
                        break;
                    }
                }
                parent = parent.getParent();
                continue;
            }
            notDone = false;
        }
        return notCatched;
    }

    private String[] getCatchExceptions(SourceFile sourceFile, int start, int end) {
        block12: {
            if (sourceFile != null) {
                List errorList = sourceFile.getCompileErrors();
                HashSet fqNameSet = new HashSet();
                this.findThrowedException(fqNameSet, (SourceElement)sourceFile, start, end);
                ArrayList<String> orderedList = new ArrayList<String>();
                JavaManager javaManager = (JavaManager)sourceFile.getProvider();
                CacheSupport support = javaManager.getCacheSupport();
                support.beginCacheUse();
                try {
                    Iterator nameIterator = fqNameSet.iterator();
                    block4: while (nameIterator.hasNext()) {
                        String fqName = nameIterator.next().toString();
                        JavaClass javaClass = javaManager.getClass(fqName);
                        if (javaClass == null || javaClass.isInterface()) {
                            orderedList.add(fqName);
                            continue;
                        }
                        JavaClass currentClass = javaClass;
                        while (true) {
                            JavaType baseType = currentClass.getSuperclass();
                            JavaClass baseClass = null;
                            if (baseType != null) {
                                baseClass = baseType.getTypeErasure();
                            }
                            if (baseClass == null) {
                                orderedList.add(fqName);
                                continue block4;
                            }
                            String fqBaseName = baseClass.getQualifiedName();
                            if (fqBaseName.equals("java.lang.Object")) {
                                orderedList.add(fqName);
                                continue block4;
                            }
                            int index = orderedList.indexOf(fqBaseName);
                            if (index != -1) {
                                orderedList.add(index, fqName);
                                continue block4;
                            }
                            currentClass = baseClass;
                        }
                    }
                    int count = orderedList.size();
                    if (count <= 0) break block12;
                    String[] stringArray = orderedList.toArray(new String[count]);
                    return stringArray;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    support.endCacheUse();
                }
            }
        }
        return new String[]{"java.lang.Exception"};
    }
}

