/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.util.ArraySortedSet;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.util.Formatting;
import oracle.javatools.parser.java.v2.write.SourceComparator;
import oracle.jdeveloper.controller.JavaSourceNodeActionDelegate;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;

public class OrganizeImportsActionDelegate
extends JavaSourceNodeActionDelegate {
    public static final String THRESHOLD = "organize-imports-threshold";

    protected int[] doAction(SourceFile file, Context context, Element[] elements, int[] text, IdeAction action) {
        int threshold = -1;
        Integer property = (Integer)action.getValue(THRESHOLD);
        if (property != null) {
            threshold = property;
        }
        OrganizeImportsActionDelegate.organizeImports(context, file, threshold);
        return null;
    }

    public static List organizeImports(Context context, SourceFile file, int threshold) {
        JavaProvider provider = file.getProvider();
        SourceFactory factory = file.getFactory();
        if (threshold < 0) {
            CodingStyleOptions options = CodingStyleManager.getCodingStyleManager().getCodingStyleOptions(context);
            threshold = Integer.MAX_VALUE;
            if (options.getUseWideImports()) {
                threshold = options.getWideImportThreshold();
            }
        }
        file.getTransaction().savepoint();
        file.compile();
        LinkedHashMap typeImports = new LinkedHashMap();
        LinkedHashMap<String, ArraySortedSet> memberImports = new LinkedHashMap<String, ArraySortedSet>();
        List importDeclarations = file.getSourceImports();
        for (SourceImport impor : importDeclarations) {
            int count;
            String qualifiedName = impor.getName();
            if (!impor.isUsed() || (count = impor.getImportedElementCount()) == 0) continue;
            int dot = qualifiedName.lastIndexOf(46);
            String qualifierName = dot > 0 ? qualifiedName.substring(0, dot) : "";
            LinkedHashMap<String, Object> importMap = impor.isStatic() ? memberImports : typeImports;
            Set unqualifiedNames = (Set)importMap.get(qualifierName);
            if (unqualifiedNames == null) {
                unqualifiedNames = new ArraySortedSet();
                importMap.put(qualifierName, (ArraySortedSet)unqualifiedNames);
            }
            int j = 0;
            while (j < count) {
                JavaMember member = (JavaMember)impor.getImportedElementAt(j);
                unqualifiedNames.add(member.getName());
                ++j;
            }
        }
        SourceImport dummy = factory.createImportDeclaration("dummy" + System.currentTimeMillis());
        importDeclarations.add(dummy);
        importDeclarations.retainAll(Arrays.asList(dummy));
        HashMap<String, ArraySortedSet> unqualifiedDemandImportTypeNames = new HashMap<String, ArraySortedSet>();
        for (Map.Entry entry : typeImports.entrySet()) {
            String qualifierName = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            if (set.size() < threshold) continue;
            JavaPackage packag = provider.getPackage(qualifierName);
            for (JavaClass type : packag.getDeclaredClasses()) {
                String unqualifiedName = type.getName();
                Set names = (Set)unqualifiedDemandImportTypeNames.get(unqualifiedName);
                if (names == null) {
                    names = new ArraySortedSet();
                    unqualifiedDemandImportTypeNames.put(unqualifiedName, (ArraySortedSet)names);
                }
                names.add(qualifierName);
            }
        }
        for (Map.Entry entry : typeImports.entrySet()) {
            String qualifierName = (String)entry.getKey();
            String thisPackage = file.getPackageName();
            if (thisPackage != null && thisPackage.equals(qualifierName)) continue;
            Set set = (Set)entry.getValue();
            if (set.size() >= threshold) {
                Iterator j = set.iterator();
                while (j.hasNext()) {
                    String memberName = (String)j.next();
                    String qualifiedName = qualifierName + '.' + memberName;
                    Set conflicts = (Set)unqualifiedDemandImportTypeNames.get(memberName);
                    if (conflicts == null || conflicts.size() <= 1) continue;
                    SourceImport impor = factory.createImportDeclaration(qualifiedName);
                    importDeclarations.add(impor);
                    j.remove();
                }
                if (set.isEmpty()) continue;
                if (set.size() >= threshold) {
                    SourceImport impor = factory.createImportDeclaration(qualifierName + ".*");
                    importDeclarations.add(impor);
                    continue;
                }
                for (String memberName : set) {
                    String qualifiedName = qualifierName + '.' + memberName;
                    SourceImport impor = factory.createImportDeclaration(qualifiedName);
                    importDeclarations.add(impor);
                }
                continue;
            }
            for (String memberName : set) {
                String qualifiedName = qualifierName + '.' + memberName;
                SourceImport impor = factory.createImportDeclaration(qualifiedName);
                importDeclarations.add(impor);
            }
        }
        HashMap<String, ArraySortedSet> unqualifiedDemandImportMemberNames = new HashMap<String, ArraySortedSet>();
        for (Map.Entry entry : memberImports.entrySet()) {
            String qualifierName = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            if (set.size() < threshold) continue;
            JavaClass type = provider.getClass(qualifierName);
            for (JavaMember member : type.getDeclaredFields()) {
                String unqualifiedName = member.getName();
                Set names = (Set)unqualifiedDemandImportMemberNames.get(unqualifiedName);
                if (names == null) {
                    names = new ArraySortedSet();
                    unqualifiedDemandImportMemberNames.put(unqualifiedName, (ArraySortedSet)names);
                }
                names.add(qualifierName);
            }
        }
        for (Map.Entry entry : memberImports.entrySet()) {
            String qualifierName = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            if (set.size() >= threshold) {
                Iterator j = set.iterator();
                while (j.hasNext()) {
                    String memberName = (String)j.next();
                    String qualifiedName = qualifierName + '.' + memberName;
                    Set conflicts = (Set)unqualifiedDemandImportMemberNames.get(memberName);
                    if (conflicts == null || conflicts.size() <= 1) continue;
                    SourceImport impor = factory.createImportDeclaration(8, qualifiedName);
                    importDeclarations.add(impor);
                    j.remove();
                }
                if (set.isEmpty()) continue;
                if (set.size() >= threshold) {
                    SourceImport impor = factory.createImportDeclaration(8, qualifierName + ".*");
                    importDeclarations.add(impor);
                    continue;
                }
                for (String memberName : set) {
                    String qualifiedName = qualifierName + '.' + memberName;
                    SourceImport impor = factory.createImportDeclaration(8, qualifiedName);
                    importDeclarations.add(impor);
                }
                continue;
            }
            for (String memberName : set) {
                String qualifiedName = qualifierName + '.' + memberName;
                SourceImport impor = factory.createImportDeclaration(8, qualifiedName);
                importDeclarations.add(impor);
            }
        }
        importDeclarations.remove(dummy);
        if (!importDeclarations.isEmpty()) {
            Collections.sort(importDeclarations, SourceComparator.hasNameComparator());
            file.getTransaction().savepoint();
            SourceElement first = (SourceElement)importDeclarations.get(0);
            SourceElement last = (SourceElement)importDeclarations.get(importDeclarations.size() - 1);
            Formatting.reformatRegion((SourceFile)file, (int)first.getStartOffset(), (int)last.getEndOffset());
        }
        return importDeclarations;
    }
}

