/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import oracle.javatools.parser.LexerToken;

public final class TokenPattern {
    public static final int EQUAL = 1;
    public static final int CENTER = 0;
    public static final int NOT_EQUAL = -1;
    private int[] pattern;
    private int patternCenter;
    private int patternLength;

    public TokenPattern(int[] pattern) {
        int length = pattern.length;
        if (length == 0 || length % 2 == 1) {
            throw new IllegalArgumentException("bad pattern");
        }
        this.pattern = pattern;
        this.patternLength = length / 2;
        this.patternCenter = -1;
        int i = 0;
        while (i < this.patternLength) {
            int index = i * 2 + 1;
            if (pattern[index] == 0) {
                this.patternCenter = i;
            }
            ++i;
        }
        if (this.patternCenter == -1) {
            throw new IllegalStateException("center not declared");
        }
    }

    public boolean matchesPattern(LexerToken[] tokensToCheck, int tokenCenter) {
        if (tokensToCheck == null || tokensToCheck.length < this.patternLength) {
            return false;
        }
        int firstIndex = tokenCenter - this.patternCenter;
        if (firstIndex < 0) {
            return false;
        }
        int lastIndex = tokenCenter + (this.patternLength - this.patternCenter - 1);
        if (lastIndex >= tokensToCheck.length) {
            return false;
        }
        int i = 0;
        while (i < this.patternLength) {
            int patternIndex = i * 2;
            int patternToken = this.pattern[patternIndex];
            int matchBehavior = this.pattern[patternIndex + 1];
            int checkToken = tokensToCheck[i + firstIndex].getToken();
            switch (matchBehavior) {
                case 0: 
                case 1: {
                    if (patternToken == checkToken) break;
                    return false;
                }
                case -1: {
                    if (patternToken != checkToken) break;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

