/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.ide.model.Project;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.InsightInputFilter;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.editor.insight.SortedInsightInputFilter;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.compiler.CompilerOptionManager;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightDataItem;
import oracle.jdevimpl.java.insight.JavaInsightOptions;
import oracle.jdevimpl.java.util.ExpressionFinder;
import oracle.jdevimpl.java.util.FoundSymbol;

abstract class AbstractCompletionInsightData
implements ListInsightData,
JavaConstants,
CallerContext.Constants {
    private static final int verboseValue = 0;
    static final int VERBOSE_MEMBER = 256;
    static final int VERBOSE_CLASS = 128;
    static final int VERBOSE_IMPORT = 64;
    static final int VERBOSE_PACKAGE = 32;
    static final int VERBOSE_LABEL = 16;
    static final int VERBOSE_ABSTRACT = 2;
    static final int VERBOSE_DETECT = 1;
    private InsightDataItem[] _insightDataItems;
    protected static final int OPTION_HIDE_DEPRECATED = 1;
    protected static final int OPTION_STRIKE_THRU_DEPRECATED = 2;
    protected static final int OPTION_SHOW_ACCESS_ICONS = 4;
    protected static final int OPTION_HIDE_OBJECT_DOT_STATIC = 8;
    protected static final int OPTION_HIDE_HIDDEN = 16;
    private static boolean suppressHidden = Boolean.getBoolean("insight.suppresshidden");
    private String _insertSuffix;
    final InsightContext helper;
    JavaProvider provider;
    CallerContext callerContext;
    ReadOnlyListModel listModel;
    InsightDataItem[] dataList;
    InsightDataItem[] filterDataList;
    String currentPrefix;
    Object[] matchingDataList;
    int analysisStartOffset;
    int optionsMask;
    private JavaFilter resultFilter;
    static final InsightDataItem[] kEmptyDataList = new InsightDataItem[0];

    static boolean verboseOutput(int filter) {
        return (0 & filter) == filter;
    }

    static boolean getSuppressHidden() {
        return suppressHidden;
    }

    static void setSuppressHidden(boolean newValue) {
        suppressHidden = newValue;
    }

    void setInsertSuffix(String insertSuffix) {
        this._insertSuffix = insertSuffix;
    }

    void verbosePrintln(String msg) {
        if (AbstractCompletionInsightData.verboseOutput(2)) {
            System.out.print("AbstractInsight (");
            System.out.print(this.identifySelf());
            System.out.print("): ");
            System.out.println(msg);
        }
    }

    abstract EditDescriptor getEditDescriptor();

    abstract String identifySelf();

    abstract void fillInitialDataImpl();

    abstract void updateDataImpl();

    int getNameStartOffset(ReadTextBuffer textBuffer, int caretOffset) {
        return AbstractCompletionInsightData.getIdentifierStart(textBuffer, caretOffset);
    }

    int getNameEndOffset(ReadTextBuffer textBuffer, int caretOffset) {
        return AbstractCompletionInsightData.getIdentifierEnd(textBuffer, caretOffset);
    }

    int getAnalysisStartOffset(ReadTextBuffer textBuffer, int caretOffset) {
        ExpressionFinder finder = this.helper.getFinder();
        FoundSymbol foundSymbol = finder.determinePrimaryPrefix(caretOffset, this.getPrimaryPrefixFilter());
        if (foundSymbol == null) {
            return AbstractCompletionInsightData.getIdentifierStart(textBuffer, caretOffset);
        }
        return foundSymbol.startOffset;
    }

    int getPrimaryPrefixFilter() {
        return 0;
    }

    protected CodingStyleOptions getCodingStyleOptions() {
        CodingStyleManager csm = CodingStyleManager.getCodingStyleManager();
        if (csm != null) {
            return csm.getCodingStyleOptions();
        }
        return null;
    }

    protected void retrieveOptions(JavaInsightOptions options) {
        Project project;
        if (!options.getShowDeprecated()) {
            this.optionsMask |= 1;
        } else if (options.getStrikethruDeprecated()) {
            this.optionsMask |= 2;
        }
        if (options.getShowAccessIcons()) {
            this.optionsMask |= 4;
        }
        if (suppressHidden) {
            this.optionsMask |= 0x10;
        }
        if ((project = this.helper.getProject()) != null) {
            try {
                CompilerOptionManager optionManager = CompilerOptionManager.getInstance((PropertyStorage)project);
                if (optionManager.isShowObjectDotStaticWarnings()) {
                    this.optionsMask |= 8;
                }
            }
            catch (AssertionError e) {
                ((Throwable)((Object)e)).printStackTrace();
            }
        }
    }

    AbstractCompletionInsightData(InsightContext helper) {
        this.$init$();
        this.helper = helper;
        JavaInsightOptions options = helper.getJavaInsightOptions();
        this.retrieveOptions(options);
        this.provider = helper.getProvider();
        this.callerContext = helper.getCallerContext();
    }

    public ListModel getListModel() {
        return this.buildListModel();
    }

    protected InsightInputFilter getInputFilter() {
        return SortedInsightInputFilter.INSTANCE;
    }

    private ReadOnlyListModel buildListModel() {
        this._insightDataItems = (InsightDataItem[])this.getData();
        this.listModel = new ReadOnlyListModel((Object[])this._insightDataItems);
        return this.listModel;
    }

    public Object[] getData() {
        JavaFilter filter = this.getResultFilter();
        if (filter == null) {
            return this.dataList;
        }
        if (this.filterDataList == null) {
            int dataSize = this.dataList.length;
            ArrayList<InsightDataItem> filteredList = new ArrayList<InsightDataItem>(dataSize);
            int i = 0;
            while (i < dataSize) {
                JavaElement result = this.dataList[i].getUnderlyingItem();
                if (filter.accepts(result)) {
                    filteredList.add(this.dataList[i]);
                }
                ++i;
            }
            int filterCount = filteredList.size();
            this.filterDataList = filteredList.toArray(new InsightDataItem[filterCount]);
        }
        return this.filterDataList;
    }

    public Object[] getMatchingData() {
        if (this.matchingDataList == null) {
            String prefix = this.getCurrentPrefix();
            this.buildListModel();
            InsightInputFilter inputFilter = this.getInputFilter();
            this.matchingDataList = inputFilter.getMatchingData((ListDataItem[])this._insightDataItems, prefix);
        }
        return this.matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] matchingData = this.getMatchingData();
        return matchingData == null ? 0 : matchingData.length;
    }

    public Object getDefault() {
        String prefix = this.getCurrentPrefix();
        this.buildListModel();
        InsightInputFilter inputFilter = this.getInputFilter();
        ListDataItem ret = inputFilter.findClosestDataItem((ListDataItem[])this._insightDataItems, prefix);
        return ret;
    }

    protected String getCurrentPrefix() {
        if (this.currentPrefix == null) {
            TextBuffer textBuffer = this.helper.getTextBuffer();
            int caretOffset = this.helper.getCaretPosition();
            int prefixStart = this.getNameStartOffset((ReadTextBuffer)textBuffer, caretOffset);
            int prefixLength = caretOffset - prefixStart;
            this.currentPrefix = textBuffer.getString(prefixStart, prefixLength);
        }
        return this.currentPrefix;
    }

    public boolean complete(Object selectedObject) {
        InsightDataItem item = (InsightDataItem)((Object)selectedObject);
        String itemName = item.getName();
        String insertedText = this._insertSuffix == null ? itemName : itemName + this._insertSuffix;
        BasicDocument document = this.helper.getDocument();
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int caretOffset = this.helper.getCaretPosition();
        int offsetAdjustment = this.helper.getCaretPositionAdjustment();
        int startOffset = this.getNameStartOffset((ReadTextBuffer)textBuffer, caretOffset);
        int endOffset = this.getNameEndOffset((ReadTextBuffer)textBuffer, caretOffset);
        BasicEditorPane editor = this.helper.getEditorPane();
        editor.beginEdit(this.getEditDescriptor());
        try {
            try {
                document.remove(startOffset + offsetAdjustment, endOffset - startOffset);
                document.insertString(startOffset + offsetAdjustment, insertedText, null);
            }
            catch (BadLocationException e) {
                System.err.println("Exception occurred in completion: " + e);
                e.printStackTrace();
            }
        }
        finally {
            editor.endEdit();
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public void partialComplete() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK], 9[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean prefixNotSuitable(String commonPrefix) {
        int quoteCount = 0;
        int singleCount = 0;
        int curlyCount = 0;
        int bracketCount = 0;
        int parenCount = 0;
        int index = 0;
        while (index < commonPrefix.length()) {
            char c = commonPrefix.charAt(index);
            switch (c) {
                case '\\': {
                    ++index;
                    break;
                }
                case '{': {
                    if (quoteCount != 0 || singleCount != 0) break;
                    ++curlyCount;
                    break;
                }
                case '}': {
                    if (quoteCount != 0 || singleCount != 0) break;
                    --curlyCount;
                    break;
                }
                case '\"': {
                    if (quoteCount == 0) {
                        ++quoteCount;
                        break;
                    }
                    --quoteCount;
                    break;
                }
                case '\'': {
                    if (singleCount == 0) {
                        ++singleCount;
                        break;
                    }
                    --singleCount;
                    break;
                }
                case '[': {
                    if (quoteCount != 0 || singleCount != 0) break;
                    ++bracketCount;
                    break;
                }
                case ']': {
                    if (quoteCount != 0 || singleCount != 0) break;
                    --bracketCount;
                    break;
                }
                case '(': {
                    if (quoteCount != 0 || singleCount != 0) break;
                    ++parenCount;
                    break;
                }
                case ')': {
                    if (quoteCount != 0 || singleCount != 0) break;
                    --parenCount;
                    break;
                }
            }
            ++index;
        }
        return curlyCount != 0 || quoteCount != 0 || singleCount != 0 || bracketCount != 0 || parenCount != 0;
    }

    private void $init$() {
        this.optionsMask = 0;
    }

    void clearData() {
        this.dataList = kEmptyDataList;
        this.matchingDataList = null;
        this.listModel = null;
        this.filterDataList = null;
        this.currentPrefix = null;
    }

    private void clearFilterData() {
        this.listModel = null;
        this.matchingDataList = null;
        this.filterDataList = null;
    }

    private void updateDataListForAccessIcons() {
        if (this.option(4)) {
            int numItems = this.dataList.length;
            int i = 0;
            while (i < numItems) {
                this.dataList[i].setShowAccessIcon();
                ++i;
            }
        }
    }

    final void fillInitialData() {
        this.verbosePrintln("fillInitialData");
        this.clearData();
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int caretOffset = this.helper.getCaretPosition();
        this.analysisStartOffset = this.getAnalysisStartOffset((ReadTextBuffer)textBuffer, caretOffset);
        this.fillInitialDataImpl();
        this.updateDataListForAccessIcons();
    }

    final void updateData() {
        this.verbosePrintln("updateData");
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int caretOffset = this.helper.getCaretPosition();
        int newAnalysisStartOffset = this.getAnalysisStartOffset((ReadTextBuffer)textBuffer, caretOffset);
        if (newAnalysisStartOffset != this.analysisStartOffset) {
            this.clearData();
            return;
        }
        this.verbosePrintln("updateDataImpl");
        this.updateDataImpl();
        this.currentPrefix = null;
        this.matchingDataList = null;
        this.updateDataListForAccessIcons();
    }

    void fillDataListHelper(CallerContext.InputOptions options) {
        this.fillDataListHelper(0, 0, false, options);
    }

    void fillDataListHelper(int startOffset, int endOffset, boolean expression, CallerContext.InputOptions options) {
        this.clearData();
        this.dataList = this.fillDataListHelperImpl(startOffset, endOffset, expression, options);
        if (this.dataList == null || this.dataList.length == 0) {
            this.dataList = kEmptyDataList;
            this.errorEmpty(null);
        }
    }

    protected InsightDataItem[] fillDataListHelperImpl(int startOffset, int endOffset, boolean expression, CallerContext.InputOptions options) {
        CallerContext.Output output;
        InsightDataItem[] insightDataItemArray;
        JavaPackage packagePrimary = null;
        JavaHasType primary = null;
        if (startOffset != endOffset) {
            SourceFactory factory;
            SourceExpression e;
            TextBuffer textBuffer = this.helper.getTextBuffer();
            String inputText = textBuffer.getString(startOffset, endOffset - startOffset);
            SourceElement scope = this.callerContext.getSourceScope();
            SourceFile file = scope.getOwningSourceFile();
            if (file == null) {
                CommonUtilities.panic((String)"No SourceFile instance");
            }
            if ((e = (factory = file.getFactory()).createExpression(inputText)) != null) {
                e.setContext(this.callerContext);
                primary = e.getResolvedObject();
                if (primary == null) {
                    if (CommonUtilities.isValidQualifiedName((String)inputText)) {
                        packagePrimary = this.provider.getPackage(inputText);
                    } else {
                        this.errorSemantic("Could not determine lhs context.");
                        return null;
                    }
                }
            }
        }
        if ((insightDataItemArray = this.createInsightDataItems(output = packagePrimary != null ? this.callerContext.listNames(packagePrimary, options) : this.callerContext.listNames(primary, options), packagePrimary, primary)) == null || insightDataItemArray.length == 0) {
            return null;
        }
        return insightDataItemArray;
    }

    protected InsightDataItem[] createInsightDataItems(CallerContext.Output output, JavaPackage packagePrimary, JavaHasType hasTypePrimary) {
        ArrayList list = output.all;
        int count = list.size();
        InsightDataItem[] outArray = new InsightDataItem[count];
        int i = 0;
        for (JavaElement javaElement : list) {
            outArray[i++] = new InsightDataItem(javaElement);
        }
        return outArray;
    }

    void errorParsing() {
    }

    void errorSemantic(String message) {
    }

    void errorEmpty(String target) {
    }

    /*
     * Unable to fully structure code
     */
    protected String findCurrentPrefix() {
        textBuffer = this.helper.getTextBuffer();
        caretOffset = this.helper.getCaretPosition();
        prefixStart = this.analysisStartOffset;
        prefixEnd = AbstractCompletionInsightData.getIdentifierStart((ReadTextBuffer)textBuffer, caretOffset);
        if (prefixEnd != prefixStart) ** GOTO lbl8
        return "";
lbl-1000:
        // 1 sources

        {
            --prefixEnd;
lbl8:
            // 2 sources

            ** while (Character.isWhitespace((char)textBuffer.getChar((int)(prefixEnd - 1))))
        }
lbl9:
        // 1 sources

        prefixLength = prefixEnd - prefixStart;
        return textBuffer.getString(prefixStart, prefixLength);
    }

    protected static int getIdentifierStart(ReadTextBuffer textBuffer, int offset) {
        int checkPos = offset - 1;
        while (checkPos >= 0) {
            char c = textBuffer.getChar(checkPos);
            if (!Character.isJavaIdentifierPart(c)) break;
            --checkPos;
        }
        return checkPos + 1;
    }

    protected static int getIdentifierEnd(ReadTextBuffer textBuffer, int offset) {
        int checkPos = offset;
        int bufferLength = textBuffer.getLength();
        while (checkPos < bufferLength) {
            char c = textBuffer.getChar(checkPos);
            if (!Character.isJavaIdentifierPart(c)) break;
            ++checkPos;
        }
        return checkPos;
    }

    protected static String removeInitialNew(String src) {
        if (!src.startsWith("new")) {
            return src;
        }
        if (!Character.isWhitespace(src.charAt(3))) {
            return src;
        }
        int srcLength = src.length();
        int checkPos = 4;
        while (checkPos < srcLength) {
            if (!Character.isWhitespace(src.charAt(checkPos))) break;
            ++checkPos;
        }
        return src.substring(checkPos);
    }

    JavaFilter getResultFilter() {
        return this.resultFilter;
    }

    void setResultFilter(JavaFilter filter) {
        if (this.resultFilter != null) {
            this.clearFilterData();
        }
        this.resultFilter = filter;
    }

    protected final boolean option(int option) {
        return (this.optionsMask & option) != 0;
    }
}

