/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.javatools.editor.insight.TooltipDataItem;
import oracle.javatools.parser.java.v2.classfile.Name;
import oracle.javatools.parser.java.v2.common.AbstractField;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.EnumConstantSym;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdevimpl.java.JavaArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnnotationDataItem
extends TooltipDataItem
implements Comparable {
    private JavaMethod method;
    private String displayText;
    private Object defaultValue;
    private Object value;
    private boolean printBold;

    AnnotationDataItem() {
        this.method = null;
        this.displayText = JavaArb.getString(35);
        this.value = null;
        this.defaultValue = null;
        this.printBold = false;
    }

    AnnotationDataItem(JavaMethod javaMethod, Object value, Object defaultValue, boolean printBold) {
        this.method = javaMethod;
        this.displayText = null;
        this.value = value;
        this.defaultValue = defaultValue;
        this.printBold = printBold;
    }

    public String getDisplayText() {
        if (this.displayText == null && this.method != null) {
            JavaType returnType = this.method.getReturnType();
            String typeString = returnType != null ? CommonUtilities.getInstantiatedTypeToString((JavaType)returnType) : JavaArb.getString(111);
            String methodName = this.method.getName();
            StringBuffer buf = new StringBuffer();
            buf.append(typeString);
            buf.append("  ");
            buf.append(methodName);
            String currentValue = null;
            StringBuffer valueBuf = new StringBuffer();
            StringBuffer defaultValueBuf = new StringBuffer();
            this.getValueText(this.value, valueBuf);
            this.getValueText(this.defaultValue, defaultValueBuf);
            if (valueBuf.length() > 0 && !valueBuf.toString().equals(defaultValueBuf.toString())) {
                buf.append("  =  ");
                currentValue = valueBuf.toString();
            } else if (defaultValueBuf.length() > 0) {
                buf.append("  default  ");
                currentValue = defaultValueBuf.toString();
            }
            if (currentValue != null) {
                buf.append(currentValue);
            }
            this.displayText = buf.toString();
        }
        return this.displayText;
    }

    private void getValueText(Object value, StringBuffer buf) {
        if (value == null) {
            return;
        }
        if (value instanceof Object[]) {
            buf.append('{');
            Object[] values = (Object[])value;
            int x = 0;
            while (x < values.length) {
                this.getValueText(values[x], buf);
                if (x < values.length - 1) {
                    buf.append(", ");
                }
                ++x;
            }
            buf.append('}');
        } else if (value instanceof AbstractField) {
            AbstractField field = (AbstractField)value;
            JavaClass parent = field.getOwningClass();
            if (parent != null) {
                buf.append(parent.getName());
                buf.append('.');
            }
            buf.append(field.getName());
        } else if (value instanceof EnumConstantSym) {
            EnumConstantSym sym = (EnumConstantSym)value;
            JavaClass parent = sym.getOwningClass();
            if (parent != null) {
                buf.append(parent.getName());
                buf.append('.');
            }
            buf.append(sym.getName());
        } else if (value instanceof JavaAnnotation) {
            JavaAnnotation javaAnnotation = (JavaAnnotation)value;
            JavaType annotationType = javaAnnotation.getAnnotationType();
            if (annotationType != null) {
                buf.append('@');
                buf.append(annotationType.getName());
                buf.append('(');
                Map components = javaAnnotation.getComponents();
                Collection methods = annotationType.getMethods();
                Set keys = components.keySet();
                Iterator keyIter = keys.iterator();
                boolean needComma = false;
                block1: while (keyIter.hasNext()) {
                    Object key = keyIter.next();
                    String methodName = key.toString();
                    StringBuffer valueBuf = new StringBuffer();
                    this.getValueText(components.get(key), valueBuf);
                    for (JavaMethod method : methods) {
                        if (!method.getName().equals(methodName)) continue;
                        StringBuffer defaultValueBuf = new StringBuffer();
                        this.getValueText(method.getDefaultValue(), defaultValueBuf);
                        if (defaultValueBuf.toString().equals(valueBuf.toString())) continue block1;
                    }
                    if (needComma) {
                        buf.append(',');
                    } else {
                        needComma = true;
                    }
                    if (!"value".equals(methodName) || keys.size() != 1) {
                        buf.append(methodName);
                        buf.append('=');
                    }
                    buf.append(valueBuf.toString());
                }
                buf.append(')');
            }
        } else if (value instanceof JavaClass) {
            JavaClass clazz = (JavaClass)value;
            buf.append(clazz.getName());
            buf.append(".class");
        } else {
            boolean insertQuotes;
            boolean bl = insertQuotes = value instanceof String || value instanceof Name;
            if (insertQuotes) {
                buf.append('\"');
            }
            buf.append(value.toString());
            if (insertQuotes) {
                buf.append('\"');
            }
        }
    }

    final boolean hasValue() {
        return this.value != null || this.defaultValue != null;
    }

    final boolean printBold() {
        return this.printBold;
    }

    public boolean isDeprecated() {
        return this.method.isDeprecated();
    }

    public String toString() {
        return this.getDisplayText();
    }

    private String getCompareKey() {
        if (this.method != null) {
            return this.method.getName();
        }
        return "";
    }

    public int compareTo(Object object) {
        if (object instanceof AnnotationDataItem) {
            return this.getCompareKey().compareTo(((AnnotationDataItem)object).getCompareKey());
        }
        return 0;
    }
}

