/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.Project;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.common.QuickComponent;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.jdeveloper.java.insight.AnnotationElementValueContext;
import oracle.jdeveloper.java.insight.AnnotationElementValueInsightDataItem;
import oracle.jdeveloper.java.insight.AnnotationElementValueProvider;
import oracle.jdeveloper.java.insight.InsightProviders;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightDataItem;
import oracle.jdevimpl.java.insight.MemberInsightData;
import oracle.jdevimpl.java.insight.WrappedInsightDataItem;
import oracle.jdevimpl.java.util.ExpressionFinder;

class AnnotationInsightData
extends MemberInsightData {
    private boolean SHOW_ANNOTATION_ELEMENT_NAMES;
    private boolean SHOW_ANNOTATION_VALUES;
    private int SHOW_PROVIDER_ANNOTATION_UNKNOWN;
    private int SHOW_PROVIDER_ANNOTATION_OFF;
    private int SHOW_PROVIDER_ANNOTATION_ON;
    private int SHOW_PROVIDER_ANNOTATION_SETTING;
    private boolean SHOW_NOTHING;
    private boolean SHOW_POSSIBLE_COMPACT_FORM;
    private String currentAnnotationElementName;
    private String currentValuePrefix;
    private SourceAnnotation currentAnnotation;
    private JavaType currentAnnotationType;
    private JavaFilter currentSmartFilter;

    private void $init$() {
        this.SHOW_ANNOTATION_ELEMENT_NAMES = false;
        this.SHOW_ANNOTATION_VALUES = false;
        this.SHOW_PROVIDER_ANNOTATION_UNKNOWN = 0;
        this.SHOW_PROVIDER_ANNOTATION_OFF = 1;
        this.SHOW_PROVIDER_ANNOTATION_ON = 2;
        this.SHOW_PROVIDER_ANNOTATION_SETTING = this.SHOW_PROVIDER_ANNOTATION_UNKNOWN;
        this.SHOW_NOTHING = false;
        this.SHOW_POSSIBLE_COMPACT_FORM = false;
    }

    AnnotationInsightData(InsightContext insight, int tokenStart) {
        super(insight);
        this.$init$();
        ExpressionFinder finder = insight.getFinder();
        int caretPosition = insight.getCaretPosition();
        SourceElement scope = this.callerContext.getSourceScope();
        while (scope != null && !(scope instanceof SourceAnnotation)) {
            scope = scope.getParent();
        }
        this.currentAnnotation = (SourceAnnotation)scope;
        if (this.currentAnnotation != null) {
            this.currentAnnotationType = this.currentAnnotation.getAnnotationType();
            if (this.currentAnnotationType != null) {
                Collection methods = this.currentAnnotationType.getDeclaredMethods();
                Iterator methodIter = methods.iterator();
                int nonDefaultMethodCount = methods.size();
                boolean hasValueMethod = false;
                while (methodIter.hasNext()) {
                    JavaMethod method = (JavaMethod)methodIter.next();
                    if (method.getDefaultValue() != null) {
                        --nonDefaultMethodCount;
                    } else {
                        this.currentAnnotationElementName = method.getName();
                    }
                    if (!method.getName().equals("value")) continue;
                    hasValueMethod = true;
                }
                if (nonDefaultMethodCount == 1 && this.currentAnnotationElementName != null && this.currentAnnotationElementName.equals("value")) {
                    this.SHOW_POSSIBLE_COMPACT_FORM = true;
                } else if (hasValueMethod && nonDefaultMethodCount == 0) {
                    this.currentAnnotationElementName = "value";
                    this.SHOW_POSSIBLE_COMPACT_FORM = true;
                } else {
                    this.currentAnnotationElementName = null;
                }
            }
        }
        this.SHOW_ANNOTATION_ELEMENT_NAMES = finder.isCursorAtAnnotationElementName(tokenStart, caretPosition);
        if (!this.SHOW_ANNOTATION_ELEMENT_NAMES) {
            this.SHOW_POSSIBLE_COMPACT_FORM = false;
        }
        if (this.SHOW_POSSIBLE_COMPACT_FORM || !this.SHOW_ANNOTATION_ELEMENT_NAMES) {
            LexerToken lastLexerToken = finder.isCursorAtAnnotationElementValue(tokenStart, caretPosition, false);
            if (lastLexerToken == null && this.SHOW_POSSIBLE_COMPACT_FORM) {
                lastLexerToken = finder.isCursorAtAnnotationElementValue(tokenStart, caretPosition, this.SHOW_POSSIBLE_COMPACT_FORM);
            }
            if (lastLexerToken != null) {
                int lastTokenValue = lastLexerToken.getToken();
                if (lastTokenValue == 11 || lastTokenValue == 10 || lastTokenValue == 8 || lastTokenValue == 9 || lastTokenValue == 13) {
                    this.SHOW_NOTHING = true;
                } else if (lastTokenValue == 14 && caretPosition >= lastLexerToken.getEndOffset()) {
                    this.SHOW_NOTHING = true;
                } else {
                    if (!this.SHOW_POSSIBLE_COMPACT_FORM) {
                        this.currentAnnotationElementName = finder.getAnnotationElementNameAtCursor(tokenStart, caretPosition);
                    }
                    this.currentValuePrefix = finder.getAnnotationElementValuePrefix(tokenStart, caretPosition, this.SHOW_POSSIBLE_COMPACT_FORM);
                    if (this.currentAnnotation != null && this.currentAnnotationElementName != null) {
                        this.SHOW_ANNOTATION_VALUES = true;
                    }
                }
            }
        }
        this.currentSmartFilter = null;
    }

    void setResultFilter(JavaFilter filter) {
        this.currentSmartFilter = null;
        if (this.SHOW_POSSIBLE_COMPACT_FORM) {
            if (filter == null) {
                this.SHOW_ANNOTATION_VALUES = false;
            } else {
                this.SHOW_ANNOTATION_ELEMENT_NAMES = false;
                this.SHOW_ANNOTATION_VALUES = true;
            }
        }
        JavaFilter smartFilter = filter;
        if (this.SHOW_ANNOTATION_ELEMENT_NAMES) {
            smartFilter = new 1();
        }
        if (this.SHOW_ANNOTATION_VALUES && smartFilter != null) {
            if (this.SHOW_PROVIDER_ANNOTATION_SETTING == this.SHOW_PROVIDER_ANNOTATION_OFF) {
                this.forceUpdateData = true;
            }
            this.SHOW_PROVIDER_ANNOTATION_SETTING = this.SHOW_PROVIDER_ANNOTATION_ON;
            this.currentSmartFilter = smartFilter;
            smartFilter = null;
        } else {
            if (this.SHOW_PROVIDER_ANNOTATION_SETTING == this.SHOW_PROVIDER_ANNOTATION_ON) {
                this.forceUpdateData = true;
            }
            this.SHOW_PROVIDER_ANNOTATION_SETTING = this.SHOW_PROVIDER_ANNOTATION_OFF;
        }
        super.setResultFilter(smartFilter);
    }

    String identifySelf() {
        return "Annotation";
    }

    protected InsightDataItem[] fillDataListHelperImpl(int startOffset, int endOffset, boolean expression, CallerContext.InputOptions options) {
        if (this.SHOW_NOTHING) {
            return new InsightDataItem[0];
        }
        if (this.SHOW_ANNOTATION_ELEMENT_NAMES) {
            options.input = (byte)(options.input | 0x20);
        }
        if (this.SHOW_PROVIDER_ANNOTATION_SETTING == this.SHOW_PROVIDER_ANNOTATION_ON) {
            List<AnnotationElementValueProvider> valueProviders = InsightProviders.getAnnotationElementValueProviders();
            ArrayList<AnnotationElementValueInsightDataItem> allResults = new ArrayList<AnnotationElementValueInsightDataItem>();
            2 annotationContext = new 2();
            for (AnnotationElementValueProvider provider : valueProviders) {
                List<AnnotationElementValueInsightDataItem> result = provider.getAnnotationElementValues(annotationContext);
                if (result == null) continue;
                allResults.addAll(result);
            }
            if (allResults.size() > 0) {
                if (this.currentValuePrefix != null && this.currentValuePrefix.startsWith("\"")) {
                    for (AnnotationElementValueInsightDataItem item : allResults) {
                        String name = item.getName().trim();
                        boolean startsWith = name.startsWith("\"");
                        boolean endsWith = name.endsWith("\"");
                        if (startsWith || endsWith) {
                            if (startsWith) {
                                name = name.substring(1);
                            }
                            if (endsWith) {
                                name = name.substring(0, name.length() - 1);
                            }
                            item.setCompletionText(name);
                        }
                        ((InsightDataItem)item).setInsertExactName();
                    }
                }
                return allResults.toArray(new AnnotationElementValueInsightDataItem[allResults.size()]);
            }
            super.setResultFilter(this.currentSmartFilter);
        }
        if (this.currentValuePrefix != null && this.currentValuePrefix.startsWith("\"")) {
            return new InsightDataItem[0];
        }
        InsightDataItem[] dataItems = super.fillDataListHelperImpl(startOffset, endOffset, expression, options);
        if (this.SHOW_ANNOTATION_ELEMENT_NAMES && dataItems != null && dataItems.length > 0) {
            String equalPostFix = null;
            int x = 0;
            while (x < dataItems.length) {
                if (dataItems[x].getUnderlyingItem() instanceof QuickComponent) {
                    if (equalPostFix == null) {
                        equalPostFix = this.getEqualPostFix();
                    }
                    WrappedInsightDataItem wrapped = new WrappedInsightDataItem(dataItems[x].getUnderlyingItem());
                    wrapped.setCompletionText(wrapped.getName() + equalPostFix);
                    dataItems[x] = wrapped;
                }
                ++x;
            }
        }
        return dataItems;
    }

    int getNameStartOffset(ReadTextBuffer textBuffer, int caretOffset) {
        if (this.currentValuePrefix != null && this.currentValuePrefix.startsWith("\"")) {
            int checkPos = caretOffset - 1;
            while (checkPos >= 0) {
                int prev;
                char c = textBuffer.getChar(checkPos);
                int n = prev = checkPos > 0 ? (int)textBuffer.getChar(checkPos - 1) : 32;
                if (c == '\"' && prev != 92) {
                    return checkPos + 1;
                }
                --checkPos;
            }
        }
        return super.getNameStartOffset(textBuffer, caretOffset);
    }

    int getNameEndOffset(ReadTextBuffer textBuffer, int caretOffset) {
        if (this.currentValuePrefix != null && this.currentValuePrefix.startsWith("\"")) {
            int checkPos = caretOffset;
            int bufferLength = textBuffer.getLength();
            while (checkPos < bufferLength) {
                char c = textBuffer.getChar(checkPos);
                if (c == '\\') {
                    checkPos += 2;
                    continue;
                }
                if (c == '\"') break;
                ++checkPos;
            }
            return checkPos < bufferLength ? checkPos : bufferLength;
        }
        return super.getNameEndOffset(textBuffer, caretOffset);
    }

    int getAnalysisStartOffset(ReadTextBuffer textBuffer, int caretOffset) {
        if (this.currentValuePrefix != null && this.currentValuePrefix.startsWith("\"")) {
            return this.getNameStartOffset(textBuffer, caretOffset);
        }
        return super.getAnalysisStartOffset(textBuffer, caretOffset);
    }

    private String getEqualPostFix() {
        String equalPostFix = null;
        CodingStyleOptions styleOptions = this.getCodingStyleOptions();
        if (styleOptions != null) {
            equalPostFix = styleOptions.getSpaceAroundAssignment() ? " = " : "=";
        }
        if (equalPostFix == null) {
            equalPostFix = "=";
        }
        return equalPostFix;
    }

    static String ra$currentValuePrefix(AnnotationInsightData annotationInsightData) {
        return annotationInsightData.currentValuePrefix;
    }

    static String ra$currentAnnotationElementName(AnnotationInsightData annotationInsightData) {
        return annotationInsightData.currentAnnotationElementName;
    }

    static SourceAnnotation ra$currentAnnotation(AnnotationInsightData annotationInsightData) {
        return annotationInsightData.currentAnnotation;
    }

    final class 1
    implements JavaFilter {
        public boolean accepts(JavaElement element) {
            return element instanceof QuickComponent;
        }
    }

    final class 2
    implements AnnotationElementValueContext {
        public Project getProject() {
            return AnnotationInsightData.this.helper.getProject();
        }

        public SourceAnnotation getAnnotation() {
            return AnnotationInsightData.ra$currentAnnotation(AnnotationInsightData.this);
        }

        public String getAnnotationElementName() {
            return AnnotationInsightData.ra$currentAnnotationElementName(AnnotationInsightData.this);
        }

        public String getValuePrefix() {
            return AnnotationInsightData.ra$currentValuePrefix(AnnotationInsightData.this);
        }

        public SourceElement getSourceCope() {
            return AnnotationInsightData.this.callerContext.getSourceScope();
        }
    }
}

