/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.CamelCaseInsightInputFilter;
import oracle.javatools.editor.insight.InsightInputFilter;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.util.SimplifyTypeHelper;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.audit.transform.UndoableEditCommand;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.audit.java.JavaHelper;
import oracle.jdevimpl.java.Context2ParserHelper;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.AbstractCompletionInsightData;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.JavaInsightOptions;

abstract class AutoImportInsightData
extends AbstractCompletionInsightData {
    private static final int OPTION_ADD_AUTOMATIC_IMPORT = 16;
    private static final int OPTION_USE_EXPLICIT_IMPORT = 32;
    static final EditDescriptor dropPackageDescriptor;

    protected void retrieveOptions(JavaInsightOptions options) {
        CodingStyleOptions styleOptions;
        super.retrieveOptions(options);
        if (options.getAutoImport()) {
            this.optionsMask |= 0x10;
        }
        if ((styleOptions = this.getCodingStyleOptions()) != null && !styleOptions.getUseWideImports()) {
            this.optionsMask |= 0x20;
        }
    }

    AutoImportInsightData(InsightContext insight) {
        super(insight);
    }

    protected InsightInputFilter getInputFilter() {
        return CamelCaseInsightInputFilter.INSTANCE;
    }

    static {
        String editName = JavaArb.getString(120);
        dropPackageDescriptor = new EditDescriptor(editName);
    }

    void autoImport(String fqClassName) {
        String addImportName;
        boolean doAutoImport = this.option(16);
        if (!doAutoImport) {
            return;
        }
        SourceElement scope = this.callerContext.getSourceScope();
        SimplifyTypeHelper helper = SimplifyTypeHelper.simplifyTypeName((SourceElement)scope, (String)fqClassName);
        if (helper == null) {
            return;
        }
        int nameStartOffset = -1;
        String simplifiedName = helper.getSimplifiedName();
        if (simplifiedName != null) {
            int fqLength = fqClassName.length();
            int simpleLength = simplifiedName.length();
            nameStartOffset = this.analysisStartOffset + fqLength - simpleLength;
        }
        if ((addImportName = helper.getImportName()) != null) {
            if (simplifiedName == null) {
                CommonUtilities.panic((String)"Add-import implies drop-prefix.");
            }
            this.doImport(nameStartOffset, addImportName, true);
        } else if (simplifiedName != null) {
            this.doDropPrefix(nameStartOffset);
        }
    }

    void addImport(String fqClassName) {
        this.doImport(0, fqClassName, false);
    }

    private void doDropPrefix(int nameStartOffset) {
        int packageStart = this.analysisStartOffset;
        int packageLength = nameStartOffset - packageStart;
        BasicEditorPane editor = this.helper.getEditorPane();
        BasicDocument document = this.helper.getDocument();
        editor.beginEdit(dropPackageDescriptor);
        try {
            try {
                document.remove(packageStart, packageLength);
            }
            catch (BadLocationException e) {
                System.err.println("Exception occurred in completion: " + e);
                e.printStackTrace();
            }
        }
        finally {
            editor.endEdit();
        }
    }

    private void doImport(int nameStartOffset, String importString, boolean dropPrefix) {
        TextBuffer textBuffer = this.helper.getTextBuffer();
        textBuffer.writeLock();
        try {
            UndoableEdit edit;
            Context context = CodeEditor.getContext((BasicEditorPane)this.helper.getEditorPane());
            JavaManager manager = Context2ParserHelper.createHelper(context).getJavaManager();
            SourceFile file = manager.getSourceFile(textBuffer);
            OffsetMark packageStartPosition = null;
            OffsetMark packageEndPosition = null;
            if (dropPrefix) {
                packageStartPosition = textBuffer.addOffsetMark(this.analysisStartOffset);
                packageEndPosition = textBuffer.addOffsetMark(nameStartOffset);
            }
            UndoableEditCommand command = new UndoableEditCommand(JavaArb.getString(96), context);
            boolean addedImport = false;
            SourceTransaction transaction = file.beginTransaction();
            try {
                addedImport = JavaHelper.addImport(file, importString) != null;
            }
            finally {
                if (addedImport) {
                    edit = transaction.commit();
                    command.addEdit(edit);
                } else {
                    transaction.abort();
                }
            }
            if (dropPrefix) {
                int packageStart = packageStartPosition.getOffset();
                int packageEnd = packageEndPosition.getOffset();
                textBuffer.removeOffsetMark(packageStartPosition);
                textBuffer.removeOffsetMark(packageEndPosition);
                edit = textBuffer.remove(packageStart, packageEnd - packageStart);
                command.addEdit(edit);
            }
            try {
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                commandProcessor.invoke((Command)command);
                if (addedImport) {
                    String feedbackMessage = JavaArb.format(225, importString);
                    this.helper.showFeedback(feedbackMessage);
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        finally {
            textBuffer.writeUnlock();
        }
    }
}

