/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.PrototypeCellProvider;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.util.SwingUtils;
import oracle.jdevimpl.java.insight.InsightDataItem;

final class CompletionCellRenderer
extends JLabel
implements ListCellRenderer,
PrototypeCellProvider {
    private boolean boldDeclaredMembersOption;
    private boolean italicLocalVariablesOption;
    private boolean strikethruDeprecatedOption;
    private boolean showDefiningClassOption;
    private static final int HORIZONTAL_PADDING = 6;
    private static final int VERTICAL_PADDING = 2;
    private static final int INSIDE_PADDING = 8;
    private int cellTypeWidth;
    private int cellNameWidth;
    private int cellIconWidth;
    private int cellHeight;
    private Dimension cellSize;
    private InsightDataItem currentItem;

    public CompletionCellRenderer() {
        this.$init$();
        this.setOpaque(false);
        this.updateCellSize(0, 0, 0, 0);
    }

    protected void setBoldDeclaredMembers(boolean boldDeclaredMembers) {
        this.boldDeclaredMembersOption = boldDeclaredMembers;
    }

    protected void setItalicLocalVariables(boolean italicLocalVariables) {
        this.italicLocalVariablesOption = italicLocalVariables;
    }

    protected void setStrikethruDeprecated(boolean strikethruDeprecated) {
        this.strikethruDeprecatedOption = strikethruDeprecated;
    }

    protected void setShowDefiningClass(boolean showDefiningClass) {
        this.showDefiningClassOption = showDefiningClass;
    }

    private void $init$() {
        this.boldDeclaredMembersOption = false;
        this.italicLocalVariablesOption = false;
        this.strikethruDeprecatedOption = false;
        this.showDefiningClassOption = false;
        this.cellTypeWidth = 0;
        this.cellNameWidth = 0;
        this.cellIconWidth = 0;
        this.cellHeight = 0;
        this.cellSize = new Dimension();
        this.currentItem = null;
    }

    private void updateCellSize(int typeWidth, int nameWidth, int iconWidth, int height) {
        this.cellTypeWidth = Math.max(typeWidth, 50);
        this.cellNameWidth = Math.max(nameWidth, 80);
        this.cellIconWidth = iconWidth;
        this.cellHeight = height;
        this.cellSize.width = 6 + this.cellIconWidth + 8 + this.cellTypeWidth + 8 + this.cellNameWidth + 6;
        this.cellSize.height = 2 + this.cellHeight + 2;
        EditorProperties properties = EditorProperties.getProperties();
        int widthCap = properties.getIntegerProperty("insight-max-popup-width");
        Dimension screenSize = this.getToolkit().getScreenSize();
        if (this.cellSize.width > (widthCap = Math.min(screenSize.width / 2 - 20, widthCap))) {
            this.cellSize.width = widthCap;
            int spaceRemaining = widthCap - 12 - this.cellIconWidth - 16;
            this.cellTypeWidth = Math.min(spaceRemaining / 3, this.cellTypeWidth);
            this.cellNameWidth = spaceRemaining - this.cellTypeWidth;
        }
        this.setMinimumSize(this.cellSize);
        this.setPreferredSize(this.cellSize);
        this.setMaximumSize(this.cellSize);
    }

    public void paint(Graphics graphics) {
        Font plainFont;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.cellSize.width, this.cellSize.height);
        if (this.currentItem != null && (plainFont = this.getFont()) != null) {
            String declaringClass;
            Font fontToUse;
            FontMetrics plainMetrics = this.getFontMetrics(plainFont);
            int plainAscent = plainMetrics.getAscent();
            int plainHeight = plainMetrics.getHeight();
            Font boldFont = this.boldDeclaredMembersOption ? plainFont.deriveFont(1) : plainFont;
            FontMetrics boldMetrics = this.getFontMetrics(boldFont);
            Font italicFont = this.italicLocalVariablesOption ? plainFont.deriveFont(2) : plainFont;
            FontMetrics italicMetrics = this.getFontMetrics(italicFont);
            boolean isLocal = this.currentItem.belongsToClass();
            boolean isVariable = this.currentItem.getUnderlyingItem() instanceof JavaVariable;
            Font font = isLocal ? boldFont : (fontToUse = isVariable ? italicFont : plainFont);
            FontMetrics metricsToUse = isLocal ? boldMetrics : (isVariable ? italicMetrics : plainMetrics);
            Icon icon = this.currentItem.getIcon();
            if (icon != null) {
                int iconXPos = 6;
                int iconYPos = 2;
                int iconHeight = icon.getIconHeight();
                int yAdjust = (this.cellHeight - iconHeight) / 2;
                icon.paintIcon(this, graphics, 6, 2 + yAdjust);
            }
            graphics.setColor(this.getForeground());
            graphics.setFont(fontToUse);
            int textYAdjust = (this.cellHeight - plainHeight) / 2;
            int textYPos = 2 + plainAscent + textYAdjust;
            String itemName = this.currentItem.getDisplayCellName();
            int nameWidth = metricsToUse.stringWidth(itemName);
            if (nameWidth > this.cellNameWidth) {
                itemName = this.truncateString(itemName, nameWidth, this.cellNameWidth, metricsToUse);
                nameWidth = metricsToUse.stringWidth(itemName);
            }
            int nameXPos = 6 + this.cellIconWidth + 8;
            SwingUtils.drawString((Graphics)graphics, (String)itemName, (int)nameXPos, (int)textYPos);
            String itemType = this.currentItem.getDisplayCellType();
            int typeWidth = metricsToUse.stringWidth(itemType);
            if (this.showDefiningClassOption && (declaringClass = this.currentItem.declaringClass()) != null && declaringClass.length() > 0) {
                itemType = itemType + " - " + declaringClass;
                typeWidth += metricsToUse.stringWidth(" - ") + metricsToUse.stringWidth(declaringClass);
            }
            if (typeWidth > this.cellTypeWidth) {
                itemType = this.truncateString(itemType, typeWidth, this.cellTypeWidth, metricsToUse);
                typeWidth = metricsToUse.stringWidth(itemType);
            }
            int typeXPos = this.cellSize.width - 6 - typeWidth;
            SwingUtils.drawString((Graphics)graphics, (String)itemType, (int)typeXPos, (int)textYPos);
            if (this.strikethruDeprecatedOption && this.currentItem.isDeprecated()) {
                int strikeYPos = textYAdjust + 2 + plainAscent * 2 / 3;
                if (nameWidth > 0) {
                    graphics.drawLine(nameXPos, strikeYPos, nameXPos + nameWidth, strikeYPos);
                }
                if (typeWidth > 0) {
                    graphics.drawLine(typeXPos, strikeYPos, typeXPos + typeWidth, strikeYPos);
                }
            }
        }
    }

    protected String truncateString(String displayText, int width, int maxWidth, FontMetrics metrics) {
        if (width < maxWidth) {
            return displayText;
        }
        String ellipsis = "...";
        int allowedWidth = maxWidth - metrics.stringWidth("...");
        int currentWidth = width;
        int lastIndex = displayText.length() - 1;
        while (currentWidth > allowedWidth && lastIndex > 0) {
            char c = displayText.charAt(lastIndex--);
            int charWidth = metrics.charWidth(c);
            currentWidth -= charWidth;
        }
        String truncatedText = displayText.substring(0, lastIndex + 1) + "...";
        return truncatedText;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setFont(list.getFont());
        if (value instanceof InsightDataItem) {
            this.currentItem = (InsightDataItem)((Object)value);
            AccessibleContext ac = this.getAccessibleContext();
            if (ac != null) {
                ac.setAccessibleName(this.currentItem.getAccessibleText());
            }
        }
        return this;
    }

    public Object getPrototypeCell(JList list, ListModel listModel) {
        Font plainFont = list.getFont();
        FontMetrics plainMetrics = this.getFontMetrics(plainFont);
        Font boldFont = this.boldDeclaredMembersOption ? plainFont.deriveFont(1) : plainFont;
        FontMetrics boldMetrics = this.getFontMetrics(boldFont);
        Font italicFont = this.italicLocalVariablesOption ? plainFont.deriveFont(2) : plainFont;
        FontMetrics italicMetrics = this.getFontMetrics(italicFont);
        int maxTypeWidth = 0;
        int maxNameWidth = 0;
        int maxIconWidth = 0;
        String extraDefining = this.showDefiningClassOption ? " - " : null;
        int maxHeight = plainMetrics.getHeight();
        int numElements = listModel.getSize();
        int i = 0;
        while (i < numElements) {
            String declaringClass;
            InsightDataItem item = (InsightDataItem)((Object)listModel.getElementAt(i));
            Icon icon = item.getIcon();
            boolean isLocal = item.belongsToClass();
            boolean isVariable = item.getUnderlyingItem() instanceof JavaVariable;
            FontMetrics metricsToUse = isLocal ? boldMetrics : (isVariable ? italicMetrics : plainMetrics);
            int extraTypeWidth = 0;
            if (extraDefining != null && (declaringClass = item.declaringClass()) != null && declaringClass.length() > 0) {
                extraTypeWidth = metricsToUse.stringWidth(extraDefining) + metricsToUse.stringWidth(declaringClass);
            }
            String itemType = item.getDisplayCellType();
            int typeWidth = metricsToUse.stringWidth(itemType) + extraTypeWidth;
            maxTypeWidth = Math.max(maxTypeWidth, typeWidth);
            String itemName = item.getDisplayCellName();
            int nameWidth = metricsToUse.stringWidth(itemName);
            maxNameWidth = Math.max(maxNameWidth, nameWidth);
            if (icon != null) {
                int iconWidth = icon.getIconWidth();
                maxIconWidth = Math.max(maxIconWidth, iconWidth);
                int iconHeight = icon.getIconHeight();
                maxHeight = Math.max(maxHeight, iconHeight);
            }
            ++i;
        }
        this.updateCellSize(maxTypeWidth, maxNameWidth, maxIconWidth, maxHeight);
        return new int[0];
    }
}

