/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.htmlpopup.ContentProvider;
import oracle.ide.ceditor.htmlpopup.HtmlPopup;
import oracle.ide.ceditor.htmlpopup.HtmlPopupView;
import oracle.ide.ceditor.htmlpopup.PopupEventListener;
import oracle.ide.ceditor.htmlpopup.StaticContentProvider;
import oracle.ide.ceditor.insight.ListDataItem;
import oracle.ide.config.ClientSetting;
import oracle.javatools.editor.ActionPreInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.java.insight.CompletionCellRenderer;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightContextImpl;
import oracle.jdevimpl.java.insight.InsightDataItem;
import oracle.jdevimpl.java.insight.JavaInsightOptions;
import oracle.jdevimpl.java.insight.RegularInsightProvider;
import oracle.jdevimpl.java.insight.SmartInsightProvider;

public class CompletionInsight
extends AbstractInsight
implements JavaConstants {
    private ListInsightView _listInsightView;
    private HtmlPopupView _htmlPopupView;
    private Listeners _listeners;
    private JavaFilter _smartFilter;
    protected static final String COMPLETION_INSTANCE = "java-completion";
    protected static final String PARAMETER_INSTANCE = "java-parameter";
    public static final int FEEDBACK_MESSAGE_DELAY = 5000;
    protected static final boolean DEBUG_DUMP_TEXT_BUFFER = false;
    protected static final String DEBUG_DUMP_FILE_NAME = "insight_buffer_dump.java";

    private void $init$() {
        this._listeners = new Listeners(null);
        this._smartFilter = null;
    }

    public CompletionInsight() {
        this.$init$();
    }

    public CompletionInsight(Context context) {
        this();
    }

    protected Context getContext() {
        Context context = CodeEditor.getContext((BasicEditorPane)this.getEditorPane());
        return context;
    }

    public int getInsightType() {
        return 1;
    }

    protected InsightProvider createInsightProvider() {
        return new RegularProvider(false);
    }

    protected InsightProvider createSmartInsightProvider() {
        return new RegularProvider(true);
    }

    protected InsightContext createInsightContext(BasicEditorPane pane) {
        return new InsightContextImpl(this, pane);
    }

    public boolean isInsightTriggerChar(char typedChar) {
        return typedChar == '.' || typedChar == '@';
    }

    private static boolean isMethodWithParameters(InsightDataItem item) {
        if (item.getItemType() != 8) {
            return false;
        }
        JavaMethod method = (JavaMethod)item.getUnderlyingItem();
        return method.getParameters().isEmpty() ^ true;
    }

    protected boolean isExactMatch(InsightData data) {
        Object[] matches = data.getMatchingData();
        if (matches == null) {
            return false;
        }
        int length = matches.length;
        if (length <= 1) {
            return length == 1;
        }
        InsightDataItem firstItem = (InsightDataItem)((Object)matches[0]);
        if (!CompletionInsight.isMethodWithParameters(firstItem)) {
            return false;
        }
        JavaMethod firstMethod = (JavaMethod)firstItem.getUnderlyingItem();
        String name = firstMethod.getName();
        JavaType firstType = firstMethod.getReturnType();
        if (firstType == null) {
            return false;
        }
        boolean firstIsVoid = "V".equals(firstType.getDescriptor());
        int i = 1;
        while (i < length) {
            boolean isVoid;
            InsightDataItem item = (InsightDataItem)((Object)matches[i]);
            if (!CompletionInsight.isMethodWithParameters(item)) {
                return false;
            }
            JavaMethod method = (JavaMethod)item.getUnderlyingItem();
            if (!name.equals(method.getName())) {
                return false;
            }
            JavaType type = method.getReturnType();
            boolean bl = isVoid = type != null && "V".equals(type.getDescriptor());
            if (firstIsVoid != isVoid) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String getTypeString(int type) {
        switch (type) {
            case 1: {
                return COMPLETION_INSTANCE;
            }
            case 2: {
                return PARAMETER_INSTANCE;
            }
        }
        throw new IllegalStateException("unknown type: " + type);
    }

    public AbstractInsight getInsight(int type) {
        String typeString = this.getTypeString(type);
        BasicEditorPane editor = this.getEditorPane();
        return (AbstractInsight)editor.getProperty(typeString);
    }

    public void install(BasicEditorPane editor) {
        super.install(editor);
        int type = this.getInsightType();
        String typeString = this.getTypeString(type);
        editor.putProperty(typeString, (Object)this);
    }

    public void deinstall(BasicEditorPane editor) {
        super.deinstall(editor);
        int type = this.getInsightType();
        String typeString = this.getTypeString(type);
        editor.putProperty(typeString, null);
    }

    public void showInsight(boolean wasAutoInvoked) {
        boolean wasActive = this.isActive();
        super.showInsight(wasAutoInvoked);
        if (!wasActive && this.isActive()) {
            BasicEditorPane editorPane1 = this.getEditorPane();
            editorPane1.addPreActionInvoker((ActionPreInvoker)this._listeners, 2.0);
        }
    }

    public void hideInsight() {
        if (this.isActive()) {
            BasicEditorPane editorPane = this.getEditorPane();
            editorPane.removePreActionInvoker((ActionPreInvoker)this._listeners, 2.0);
            if (this._htmlPopupView != null) {
                this.hideHtmlDoc();
            }
        }
        super.hideInsight();
    }

    private void toggleHtmlDoc() {
        if (this._htmlPopupView == null) {
            this.showHtmlDoc();
        } else {
            this.hideHtmlDoc();
        }
    }

    private void showHtmlDoc() {
        ContentProvider contentProvider = this.getSelectedContentProvider();
        if (contentProvider != null) {
            BasicEditorPane editorPane = this.getEditorPane();
            this._htmlPopupView = HtmlPopup.invokePopup((BasicEditorPane)editorPane, (ContentProvider)contentProvider);
            if (this._htmlPopupView != null) {
                this._htmlPopupView.addPopupEventListener((PopupEventListener)this._listeners);
                this._listInsightView.addListSelectionListener((ListSelectionListener)this._listeners);
            }
        }
    }

    protected void updateInsight() {
        boolean hasHtmlPopup;
        boolean bl = hasHtmlPopup = this._htmlPopupView != null;
        if (hasHtmlPopup) {
            this.hideHtmlDoc();
        }
        super.updateInsight();
        if (hasHtmlPopup) {
            this.showHtmlDoc();
        }
    }

    private void hideHtmlDoc() {
        BasicEditorPane editorPane = this.getEditorPane();
        HtmlPopup.cancelPopup((BasicEditorPane)editorPane);
    }

    private ContentProvider getSelectedContentProvider() {
        ContentProvider ret = null;
        Object selectedValue = this._listInsightView.getSelectedValue();
        if (selectedValue instanceof ListDataItem) {
            ListDataItem listDataItem = (ListDataItem)selectedValue;
            Context context = this.getContext();
            ret = listDataItem.getContentProvider(context);
        }
        return ret;
    }

    public InsightView getInsightView() {
        JavaInsightOptions options = this.getJavaInsightOptions();
        CompletionCellRenderer renderer = new CompletionCellRenderer();
        renderer.setBoldDeclaredMembers(options.getBoldDeclaredMembers());
        renderer.setItalicLocalVariables(options.getItalicLocalVariables());
        renderer.setStrikethruDeprecated(options.getStrikethruDeprecated());
        renderer.setShowDefiningClass(options.getShowDefiningClass());
        this._listInsightView = new ListInsightView((ListCellRenderer)renderer);
        return this._listInsightView;
    }

    public JavaInsightOptions getJavaInsightOptions() {
        JavaInsightOptions insightOptions = (JavaInsightOptions)Ide.getSettings().getData("JavaInsightOptions");
        if (insightOptions == null) {
            insightOptions = new JavaInsightOptions();
            ClientSetting.findOrCreate((String)"oracle.jdeveloper").putData("JavaInsightOptions", (Copyable)insightOptions);
        }
        return insightOptions;
    }

    protected void showFeedback(String feedbackMessage) {
        BasicEditorPane editorPane = this.getEditorPane();
        FeedbackManager feedbackManager = editorPane.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.showFeedback(editorPane, feedbackMessage);
        }
    }

    protected void showFeedback(String feedbackMessage, int hideDelay) {
        BasicEditorPane editorPane = this.getEditorPane();
        FeedbackManager feedbackManager = editorPane.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.showFeedback(editorPane, feedbackMessage, hideDelay);
        }
    }

    protected void hideFeedback() {
        BasicEditorPane editorPane = this.getEditorPane();
        FeedbackManager feedbackManager = editorPane.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.hideFeedback(editorPane);
        }
    }

    public int getCaretPositionAdjustment() {
        return 0;
    }

    static void wa$_smartFilter(CompletionInsight completionInsight, JavaFilter javaFilter) {
        completionInsight._smartFilter = javaFilter;
    }

    static JavaFilter ra$_smartFilter(CompletionInsight completionInsight) {
        return completionInsight._smartFilter;
    }

    static ContentProvider mav$getSelectedContentProvider(CompletionInsight completionInsight) {
        return completionInsight.getSelectedContentProvider();
    }

    static HtmlPopupView ra$_htmlPopupView(CompletionInsight completionInsight) {
        return completionInsight._htmlPopupView;
    }

    static ListInsightView ra$_listInsightView(CompletionInsight completionInsight) {
        return completionInsight._listInsightView;
    }

    static void wa$_htmlPopupView(CompletionInsight completionInsight, HtmlPopupView htmlPopupView) {
        completionInsight._htmlPopupView = htmlPopupView;
    }

    static void mav$toggleHtmlDoc(CompletionInsight completionInsight) {
        completionInsight.toggleHtmlDoc();
    }

    static void mav$hideHtmlDoc(CompletionInsight completionInsight) {
        completionInsight.hideHtmlDoc();
    }

    protected class RegularProvider
    implements InsightProvider {
        final boolean _useSmartFilter;

        protected RegularProvider() {
            this(false);
        }

        protected RegularProvider(boolean useSmartFilter) {
            this._useSmartFilter = useSmartFilter;
        }

        protected void setSmartFilter(BasicEditorPane editorPane) {
            if (CompletionInsight.ra$_smartFilter(CompletionInsight.this) == null && this._useSmartFilter) {
                InsightContext context = CompletionInsight.this.createInsightContext(editorPane);
                SmartInsightProvider smartProvider = new SmartInsightProvider(context);
                CompletionInsight.wa$_smartFilter(CompletionInsight.this, smartProvider.filterInsightData());
            }
        }

        public InsightData getInsightData(BasicEditorPane editorPane) {
            CompletionInsight.wa$_smartFilter(CompletionInsight.this, null);
            this.setSmartFilter(editorPane);
            InsightContext context = CompletionInsight.this.createInsightContext(editorPane);
            RegularInsightProvider provider = new RegularInsightProvider(context, CompletionInsight.ra$_smartFilter(CompletionInsight.this));
            return provider.getInsightData();
        }

        public InsightData updateInsightData(BasicEditorPane editorPane, InsightData lastData) {
            if (!this._useSmartFilter) {
                CompletionInsight.wa$_smartFilter(CompletionInsight.this, null);
            }
            this.setSmartFilter(editorPane);
            InsightContext context = CompletionInsight.this.createInsightContext(editorPane);
            RegularInsightProvider provider = new RegularInsightProvider(context, CompletionInsight.ra$_smartFilter(CompletionInsight.this));
            return provider.updateInsightData(lastData);
        }

        public InsightView getInsightView() {
            return CompletionInsight.this.getInsightView();
        }
    }

    private class Listeners
    implements ActionPreInvoker,
    PopupEventListener,
    ListSelectionListener,
    ActionListener {
        private Timer _timer;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean invokeAction(String actionKey) {
            if (actionKey.equals("show-javadoc-popup")) {
                CompletionInsight.mav$toggleHtmlDoc(CompletionInsight.this);
                return true;
            } else {
                if (CompletionInsight.ra$_htmlPopupView(CompletionInsight.this) == null) return false;
                if (actionKey.equals("scroll-line-up")) {
                    CompletionInsight.ra$_htmlPopupView(CompletionInsight.this).up();
                    return true;
                } else if (actionKey.equals("scroll-line-down")) {
                    CompletionInsight.ra$_htmlPopupView(CompletionInsight.this).down();
                    return true;
                } else {
                    if (!actionKey.equals("cancel")) return false;
                    CompletionInsight.mav$hideHtmlDoc(CompletionInsight.this);
                }
            }
            return true;
        }

        public void popupCanceled() {
        }

        public void popupClosed() {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
            }
            CompletionInsight.ra$_listInsightView(CompletionInsight.this).removeListSelectionListener((ListSelectionListener)this);
            CompletionInsight.ra$_htmlPopupView(CompletionInsight.this).removePopupEventListener((PopupEventListener)this);
            CompletionInsight.wa$_htmlPopupView(CompletionInsight.this, null);
        }

        public void contentsChanged() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (this._timer != null) {
                this._timer.stop();
            } else {
                this._timer = new Timer(500, this);
                this._timer.setRepeats(false);
            }
            this._timer.start();
        }

        public void actionPerformed(ActionEvent e) {
            ContentProvider contentProvider = CompletionInsight.mav$getSelectedContentProvider(CompletionInsight.this);
            if (contentProvider == null) {
                contentProvider = new StaticContentProvider("No information available", true);
            }
            CompletionInsight.ra$_htmlPopupView(CompletionInsight.this).push(contentProvider);
        }

        private Listeners() {
        }

        Listeners(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

