/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.parser.java.v2.common.QuickHasName;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.doc.SourceDocElement;
import oracle.jdeveloper.javadoc.TagDescriptor;
import oracle.jdeveloper.javadoc.TagManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.AbstractCompletionInsightData;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightDataItem;

public class DocTagInsightData
extends AbstractCompletionInsightData {
    private static final EditDescriptor editDescriptor;
    private String tagPrefix;
    private int type;

    private void $init$() {
        this.type = 0;
    }

    DocTagInsightData(InsightContext insight) {
        super(insight);
        SourceDocElement de;
        SourceMember m;
        this.$init$();
        int caretOffset = insight.getCaretPosition();
        SourceFile file = insight.getSourceFile();
        SourceElement e = file.getElementAt(caretOffset);
        if (e instanceof SourceDocElement && (m = (de = (SourceDocElement)e).getOwningMember()) != null) {
            this.type = m.getElementKind();
        }
        if (this.type == 0) {
            // empty if block
        }
        this.fillInitialData();
    }

    static {
        String editName = JavaArb.getString(312);
        editDescriptor = new EditDescriptor(editName);
    }

    String identifySelf() {
        return "DocTag";
    }

    EditDescriptor getEditDescriptor() {
        return editDescriptor;
    }

    void fillInitialDataImpl() {
        this.tagPrefix = this.findCurrentPrefix();
        this.refreshDataList();
    }

    void updateDataImpl() {
        String newPrefix = this.findCurrentPrefix();
        if (!newPrefix.startsWith(this.tagPrefix)) {
            this.clearData();
        }
        if (!this.tagPrefix.equals(newPrefix)) {
            this.tagPrefix = newPrefix;
            this.clearData();
            this.refreshDataList();
        }
    }

    public boolean complete(Object selectedObject) {
        InsightDataItem item = (InsightDataItem)((Object)selectedObject);
        String name = item.getName();
        BasicDocument document = this.helper.getDocument();
        document.writeLock();
        try {
            BasicEditorPane editor;
            block10: {
                TextBuffer textBuffer = this.helper.getTextBuffer();
                int caretOffset = this.helper.getCaretPosition();
                int offsetAdjustment = this.helper.getCaretPositionAdjustment();
                int startOffset = this.getStartOfTag((ReadTextBuffer)textBuffer, caretOffset);
                int endOffset = this.getEndOfTag((ReadTextBuffer)textBuffer, caretOffset);
                int caretToStartOffset = caretOffset - startOffset;
                editor = this.helper.getEditorPane();
                editor.beginEdit(this.getEditDescriptor());
                try {
                    try {
                        String currentText = textBuffer.getString(startOffset, endOffset - startOffset);
                        if (name.startsWith(currentText)) {
                            int insertionPoint = editor.getCaretPosition() - caretToStartOffset;
                            document.insertString(startOffset + offsetAdjustment + currentText.length(), name.substring(currentText.length()), null);
                            editor.setCaretPosition(insertionPoint + name.length());
                            break block10;
                        }
                        document.remove(startOffset + offsetAdjustment, endOffset - startOffset);
                        document.insertString(startOffset + offsetAdjustment, name, null);
                    }
                    catch (BadLocationException e) {
                        System.err.println("Exception occurred in doc tag completion: " + e);
                        e.printStackTrace();
                    }
                }
                finally {
                    editor.endEdit();
                }
            }
            if (name.endsWith("}")) {
                editor.setCaretPosition(editor.getCaretPosition() - 1);
            }
        }
        finally {
            document.writeUnlock();
        }
        return false;
    }

    protected String findCurrentPrefix() {
        int beginPrefix;
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int endPrefix = this.helper.getCaretPosition();
        if (endPrefix == (beginPrefix = this.getStartOfTag((ReadTextBuffer)textBuffer, endPrefix))) {
            return "";
        }
        int prefixLength = endPrefix - beginPrefix;
        return textBuffer.getString(beginPrefix, prefixLength);
    }

    int getNameStartOffset(ReadTextBuffer textBuffer, int caretOffset) {
        return this.getStartOfTag(textBuffer, caretOffset);
    }

    int getNameEndOffset(ReadTextBuffer textBuffer, int caretOffset) {
        return this.getEndOfTag(textBuffer, caretOffset);
    }

    int getAnalysisStartOffset(ReadTextBuffer textBuffer, int caretOffset) {
        return this.getStartOfTag(textBuffer, caretOffset);
    }

    private void refreshDataList() {
        int tagType;
        String lowerCaseTagPrefix = this.tagPrefix.toLowerCase();
        TagManager tagManager = TagManager.getInstance();
        switch (this.type) {
            case 3: {
                tagType = 1;
                break;
            }
            case 5: {
                tagType = 2;
                break;
            }
            case 8: {
                tagType = 4;
                break;
            }
            default: {
                tagType = 0;
                break;
            }
        }
        ArrayList standardTags = tagManager.getTags(tagType);
        ArrayList inlineTags = tagManager.getInlineTags(tagType);
        int length = standardTags.size() + inlineTags.size();
        ArrayList<InsightDataItem> dataItems = new ArrayList<InsightDataItem>(length);
        for (TagDescriptor tag : standardTags) {
            String tagText = tag.toString();
            if (lowerCaseTagPrefix.length() != 0 && !tagText.toLowerCase().startsWith(lowerCaseTagPrefix)) continue;
            String template = tag.isAllowsTemplate() ? tag.getTemplate() : "";
            String hasNameText = template.length() > 0 ? tagText + ' ' + template : tagText;
            QuickHasName qhn = QuickHasName.createHasName((String)hasNameText);
            dataItems.add(new InsightDataItem((JavaElement)qhn));
        }
        for (TagDescriptor tag : inlineTags) {
            String tagText = tag.toString();
            if (lowerCaseTagPrefix.length() != 0 && !tagText.toLowerCase().startsWith(lowerCaseTagPrefix)) continue;
            QuickHasName qhn = QuickHasName.createHasName((String)tagText);
            dataItems.add(new InsightDataItem((JavaElement)qhn));
        }
        int itemCount = dataItems.size();
        this.dataList = dataItems.toArray(new InsightDataItem[itemCount]);
    }

    private int getStartOfTag(ReadTextBuffer textBuffer, int offset) {
        int marker = offset - 1;
        while (marker >= 0) {
            char c = textBuffer.getChar(marker);
            if (Character.isWhitespace(c) || c == '{' || c == '*' || c == '@') {
                if (c == '@') break;
                ++marker;
                break;
            }
            --marker;
        }
        return marker;
    }

    private int getEndOfTag(ReadTextBuffer textBuffer, int offset) {
        int checkPos = offset;
        int bufferLength = textBuffer.getLength();
        while (checkPos < bufferLength) {
            char c = textBuffer.getChar(checkPos);
            if (Character.isWhitespace(c)) break;
            ++checkPos;
        }
        return checkPos;
    }
}

