/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.List;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Project;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.java.SourceFileReducer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceSuperclassClause;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCompoundStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSimpleStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.VariableNaming;
import oracle.jdeveloper.model.JavaSourceNode;

public class InsightContextProvider {
    private Object _data;

    public Object getData() {
        return this._data;
    }

    private static boolean isCompleteElement(TextBuffer buffer, SourceElement sourceElement) {
        List children;
        boolean ret = true;
        if (sourceElement instanceof SourceSimpleStatement || sourceElement instanceof SourcePackage || sourceElement instanceof SourceImport) {
            int endOffset = sourceElement.getEndOffset();
            char lastChar = buffer.getChar(endOffset - 1);
            if (lastChar != ';') {
                ret = false;
            }
        } else if (sourceElement instanceof SourceCompoundStatement) {
            SourceCompoundStatement sourceCompoundStatement = (SourceCompoundStatement)sourceElement;
            SourceStatement primaryClause = sourceCompoundStatement.getPrimaryClause();
            if (primaryClause == null) {
                ret = false;
            }
        } else if (sourceElement instanceof SourceVariableDeclaration) {
            SourceElement parent;
            int endOffset = sourceElement.getEndOffset();
            char lastChar = buffer.getChar(endOffset - 1);
            if (lastChar != ';' && !((parent = sourceElement.getParent()) instanceof SourceForStatement)) {
                ret = false;
            }
        } else if (sourceElement instanceof SourceSuperclassClause || sourceElement instanceof SourceInterfacesClause || sourceElement instanceof SourceThrowsClause) {
            List children2 = sourceElement.getChildren();
            if (children2.isEmpty()) {
                ret = false;
            }
        } else if (sourceElement instanceof SourceFormalParameter && (children = sourceElement.getChildren()).size() < 2) {
            ret = false;
        }
        return ret;
    }

    private static LexerToken getKeyword(TextBuffer textBuffer, SourceElement sourceElement, int keyword) {
        int token;
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer((ReadTextBuffer)textBuffer);
        int startOffset = sourceElement.getStartOffset();
        javaLexer.setPosition(startOffset);
        LexerToken lexerToken = javaLexer.createLexerToken();
        do {
            if ((token = javaLexer.lex(lexerToken)) != 0) continue;
            return null;
        } while (token != keyword);
        return lexerToken;
    }

    InsightType getType(Context context) {
        InsightType ret = null;
        Project project = context.getProject();
        if (project != null) {
            JavaSourceNode node = (JavaSourceNode)context.getNode();
            CodeEditor codeEditor = (CodeEditor)context.getView();
            int offset = codeEditor.getCaretPosition();
            TextBuffer textBuffer = node.acquireTextBuffer();
            try {
                SourceFileReducer sourceFileReducer = new SourceFileReducer();
                textBuffer = sourceFileReducer.reduce(textBuffer, new Integer[]{offset});
                List adjustedOffsets = sourceFileReducer.getAdjustedOffsets();
                offset = (Integer)adjustedOffsets.get(0);
                JavaManager javaManager = JavaManager.getInstance((Project)project);
                SourceFile sourceFile = javaManager.getSourceFile(textBuffer);
                ret = this.getType(textBuffer, (SourceElement)sourceFile, offset);
            }
            finally {
                node.releaseTextBuffer();
            }
        }
        return ret;
    }

    InsightType getType(TextBuffer textBuffer, SourceElement sourceElement, int offset) {
        InsightType ret;
        InsightType ret2;
        List children = sourceElement.getChildren();
        int size = children.size();
        SourceElement child = null;
        int childPos = size - 1;
        while (childPos >= 0) {
            child = (SourceElement)children.get(childPos);
            int startOffset = child.getStartOffset();
            if (offset > startOffset) break;
            --childPos;
        }
        if (childPos >= 0 && (ret2 = this.getType(textBuffer, child, offset)) != null) {
            return ret2;
        }
        boolean isInside = false;
        int endOffset = sourceElement.getEndOffset();
        if (offset <= endOffset) {
            isInside = true;
        } else if (!InsightContextProvider.isCompleteElement(textBuffer, sourceElement)) {
            isInside = true;
        }
        if (isInside && (ret = this.getTypeAt(textBuffer, sourceElement, offset)) != null) {
            return ret;
        }
        return null;
    }

    private InsightType getTypeAt(TextBuffer textBuffer, SourceElement sourceElement, int offset) {
        this._data = null;
        int symbolKind = sourceElement.getSymbolKind();
        block0 : switch (symbolKind) {
            case 52: {
                return InsightType.UNKNOWN;
            }
            case 2: {
                return InsightType.CODE_USAGE;
            }
            case 30: {
                LexerToken keyword = InsightContextProvider.getKeyword(textBuffer, sourceElement, 98);
                int endOffset = keyword.getEndOffset();
                if (offset <= endOffset) break;
                return InsightType.LABEL;
            }
            case 21: {
                LexerToken keyword = InsightContextProvider.getKeyword(textBuffer, sourceElement, 125);
                int endOffset = keyword.getEndOffset();
                if (offset <= endOffset) break;
                return InsightType.PACKAGE;
            }
            case 14: {
                LexerToken keyword = InsightContextProvider.getKeyword(textBuffer, sourceElement, 118);
                int endOffset = keyword.getEndOffset();
                if (offset <= endOffset) break;
                return InsightType.IMPORT;
            }
            case 1: {
                SourceAnnotation sourceAnnotation = (SourceAnnotation)sourceElement;
                SourceListExpression argumentList = sourceAnnotation.getArgumentList();
                if (argumentList != null) {
                    int startOffset = argumentList.getStartOffset();
                    if (startOffset < 0) {
                        startOffset = sourceAnnotation.getStartOffset();
                        if (offset <= startOffset) break;
                        return InsightType.ANNOTATION;
                    }
                    if (offset <= startOffset) break;
                    this._data = sourceAnnotation;
                    return InsightType.ANNOTATION_PARM;
                }
                int startOffset = sourceAnnotation.getStartOffset();
                if (offset <= startOffset) break;
                return InsightType.ANNOTATION;
            }
            case 22: {
                return InsightType.EXTENDS;
            }
            case 15: {
                return InsightType.IMPLEMENTS;
            }
            case 24: {
                return InsightType.THROWS;
            }
            case 43: {
                return InsightType.THROW;
            }
            case 55: {
                return InsightType.NEW;
            }
            case 67: {
                return InsightType.DOC_TAG;
            }
            case 68: {
                SourceDocTextFragment sourceDocTextFragment = (SourceDocTextFragment)sourceElement;
                String text = sourceDocTextFragment.getDocText();
                if (text.startsWith("@")) {
                    return InsightType.DOC_TAG;
                }
                return InsightType.DOC_TEXT;
            }
            case 65: {
                return InsightType.INLINE_DOC_TAG;
            }
            case 3: {
                SourceClass sourceClass = (SourceClass)sourceElement;
                this._data = sourceClass;
                return InsightType.CLASS_CLAUSE;
            }
            case 4: {
                return InsightType.CLASS_BODY;
            }
            case 17: {
                int endOffset;
                int startOffset;
                SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)sourceElement;
                SourceName nameElement = sourceLocalVariable.getNameElement();
                if (nameElement == null || offset < (startOffset = nameElement.getStartOffset()) || offset > (endOffset = nameElement.getEndOffset())) break;
                SourceTypeReference sourceType = sourceLocalVariable.getSourceType();
                if (sourceType != null) {
                    String name = sourceType.getName();
                    this._data = VariableNaming.suggestNamesFromCamelWord(name, VariableNaming.VARIABLE_FORMATER);
                }
                return InsightType.VARIABLE_NAME;
            }
            case 36: {
                List statementChildren;
                SourceElement parent = sourceElement.getParent();
                if (parent.getSymbolKind() != 2 || (statementChildren = sourceElement.getChildren()).size() != 1) break;
                SourceElement statementFirstChild = (SourceElement)statementChildren.get(0);
                switch (statementFirstChild.getSymbolKind()) {
                    case 57: {
                        int childEndOffset = statementFirstChild.getEndOffset();
                        if (offset <= childEndOffset) break block0;
                        SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)statementFirstChild;
                        String name = sourceSimpleNameExpression.getName();
                        this._data = VariableNaming.suggestNamesFromCamelWord(name, VariableNaming.VARIABLE_FORMATER);
                        return InsightType.VARIABLE_NAME;
                    }
                }
                break;
            }
            case 13: {
                int endOffset;
                SourceElement firstChild;
                List children = sourceElement.getChildren();
                if (children.size() <= 0 || !((firstChild = (SourceElement)children.get(0)) instanceof SourceTypeReference) || (endOffset = firstChild.getEndOffset()) >= offset) break;
                SourceTypeReference typeReference = (SourceTypeReference)firstChild;
                String name = typeReference.getName();
                this._data = VariableNaming.suggestNamesFromCamelWord(name, VariableNaming.PARAMETER_FORMATER);
                return InsightType.VARIABLE_NAME;
            }
            case 10: {
                int endOffset;
                SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)sourceElement;
                SourceName nameElement = sourceFieldVariable.getNameElement();
                if (nameElement == null || (endOffset = nameElement.getEndOffset()) >= offset) break;
                String name = nameElement.getName();
                this._data = VariableNaming.suggestNamesFromCamelWord(name, VariableNaming.FIELD_FORMATER);
                break;
            }
            case 9: {
                int endOffset;
                SourceFieldDeclaration sourceFieldDeclaration = (SourceFieldDeclaration)sourceElement;
                SourceTypeReference sourceTypeReference = sourceFieldDeclaration.getSourceType();
                if (sourceTypeReference == null || (endOffset = sourceTypeReference.getEndOffset()) >= offset || !this.isInVariableName(textBuffer, endOffset, offset)) break;
                String name = sourceTypeReference.getName();
                this._data = VariableNaming.suggestNamesFromCamelWord(name, VariableNaming.FIELD_FORMATER);
                return InsightType.VARIABLE_NAME;
            }
        }
        return null;
    }

    private boolean isInVariableName(TextBuffer textBuffer, int from, int to) {
        boolean ret = true;
        int braceDepth = 0;
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer((ReadTextBuffer)textBuffer);
        lexer.setPosition(from);
        LexerToken lexerToken = lexer.createLexerToken();
        block7: while (true) {
            int token = lexer.lex(lexerToken);
            if (lexerToken.getStartOffset() > to) break;
            switch (token) {
                case 0: {
                    continue block7;
                }
                case 39: {
                    if (braceDepth != 0) continue block7;
                    ret = true;
                    continue block7;
                }
                case 33: {
                    if (braceDepth != 0) continue block7;
                    ret = false;
                    continue block7;
                }
                case 49: {
                    ++braceDepth;
                    continue block7;
                }
                case 70: {
                    --braceDepth;
                    continue block7;
                }
            }
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class InsightType
    extends Enum<InsightType> {
        private static final /* synthetic */ InsightType[] $v;
        public static final /* enum */ InsightType LABEL;
        public static final /* enum */ InsightType PACKAGE;
        public static final /* enum */ InsightType IMPORT;
        public static final /* enum */ InsightType ANNOTATION;
        public static final /* enum */ InsightType ANNOTATION_PARM;
        public static final /* enum */ InsightType EXTENDS;
        public static final /* enum */ InsightType IMPLEMENTS;
        public static final /* enum */ InsightType THROWS;
        public static final /* enum */ InsightType THROW;
        public static final /* enum */ InsightType NEW;
        public static final /* enum */ InsightType DOC_TAG;
        public static final /* enum */ InsightType INLINE_DOC_TAG;
        public static final /* enum */ InsightType DOC_TEXT;
        public static final /* enum */ InsightType CLASS_CLAUSE;
        public static final /* enum */ InsightType CLASS_BODY;
        public static final /* enum */ InsightType CODE_USAGE;
        public static final /* enum */ InsightType VARIABLE_NAME;
        public static final /* enum */ InsightType UNKNOWN;

        public static InsightType valueOf(String string) {
            return Enum.valueOf(InsightType.class, string);
        }

        public static final InsightType[] values() {
            return (InsightType[])$v.clone();
        }

        static {
            InsightType[] insightTypeArray = new InsightType[18];
            insightTypeArray[17] = UNKNOWN = new InsightType("UNKNOWN", 17);
            insightTypeArray[16] = VARIABLE_NAME = new InsightType("VARIABLE_NAME", 16);
            insightTypeArray[15] = CODE_USAGE = new InsightType("CODE_USAGE", 15);
            insightTypeArray[14] = CLASS_BODY = new InsightType("CLASS_BODY", 14);
            insightTypeArray[13] = CLASS_CLAUSE = new InsightType("CLASS_CLAUSE", 13);
            insightTypeArray[12] = DOC_TEXT = new InsightType("DOC_TEXT", 12);
            insightTypeArray[11] = INLINE_DOC_TAG = new InsightType("INLINE_DOC_TAG", 11);
            insightTypeArray[10] = DOC_TAG = new InsightType("DOC_TAG", 10);
            insightTypeArray[9] = NEW = new InsightType("NEW", 9);
            insightTypeArray[8] = THROW = new InsightType("THROW", 8);
            insightTypeArray[7] = THROWS = new InsightType("THROWS", 7);
            insightTypeArray[6] = IMPLEMENTS = new InsightType("IMPLEMENTS", 6);
            insightTypeArray[5] = EXTENDS = new InsightType("EXTENDS", 5);
            insightTypeArray[4] = ANNOTATION_PARM = new InsightType("ANNOTATION_PARM", 4);
            insightTypeArray[3] = ANNOTATION = new InsightType("ANNOTATION", 3);
            insightTypeArray[2] = IMPORT = new InsightType("IMPORT", 2);
            insightTypeArray[1] = PACKAGE = new InsightType("PACKAGE", 1);
            insightTypeArray[0] = LABEL = new InsightType("LABEL", 0);
            $v = insightTypeArray;
        }

        private InsightType(String string2, int n2) {
        }
    }
}

