/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.ceditor.htmlpopup.ContentProvider;
import oracle.ide.ceditor.insight.ListDataItem;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.OverlayedIcon;
import oracle.jdevimpl.java.explorer.SideBySideIcon;
import oracle.jdevimpl.javadoc.popup.SourceMemberProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsightDataItem
extends ListDataItem
implements JavaConstants {
    private JavaElement item;
    private String displayText;
    private Icon itemIcon;
    private byte flags;
    private static final byte FULL_SIGNATURE = 1;
    private static final byte SHOW_ACCESS_ICONS = 2;
    private static final byte BELONGS_TO_CLASS = 4;
    private static final byte INSERT_EXACT_NAME = 8;
    private static final String PACKAGE_TYPE = JavaArb.getString(247);
    private static final String CLASS_TYPE = JavaArb.getString(290);
    private static final String LABEL_TYPE;
    private static final String INTERFACE_TYPE;
    private static final String ANNOTATION_TYPE;

    void setFullSignature() {
        this.flags = (byte)(this.flags | 1);
    }

    private boolean useFullSignature() {
        return (this.flags & 1) != 0;
    }

    void setShowAccessIcon() {
        this.flags = (byte)(this.flags | 2);
    }

    private boolean showAccessIcons() {
        return (this.flags & 2) != 0;
    }

    void setInsertExactName() {
        this.flags = (byte)(this.flags | 8);
    }

    boolean insertExactName() {
        return (this.flags & 8) != 0;
    }

    public InsightDataItem(JavaElement result) {
        this.$init$();
        this.item = result;
    }

    private void $init$() {
        this.flags = 0;
    }

    public String toString() {
        return this.getDisplayText();
    }

    public String getName() {
        if (this.item instanceof JavaHasName) {
            String name = ((JavaHasName)this.item).getName();
            if (this.item.getElementKind() != 9) {
                return name;
            }
            int lastDot = name.lastIndexOf(46);
            if (lastDot != -1) {
                return name.substring(lastDot + 1);
            }
            return name;
        }
        return "";
    }

    protected String getDisplayCellType() {
        int itemType = this.item.getElementKind();
        switch (itemType) {
            case 15: {
                return LABEL_TYPE;
            }
            case 1: {
                if (!"*".equals(this.getName())) {
                    return "";
                }
            }
            case 9: {
                return PACKAGE_TYPE;
            }
            case 3: 
            case 10: {
                JavaType c = (JavaType)this.item;
                if (c.isAnnotation()) {
                    return ANNOTATION_TYPE;
                }
                if (c.isInterface()) {
                    return INTERFACE_TYPE;
                }
                return CLASS_TYPE;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 14: 
            case 16: {
                JavaHasType ht = (JavaHasType)this.item;
                JavaType result = ht.getResolvedType();
                if (result != null) {
                    return result.getUnqualifiedName();
                }
                return "";
            }
        }
        throw new RuntimeException("Not an item type " + itemType);
    }

    protected String getDisplayCellName() {
        int itemType = this.item.getElementKind();
        switch (itemType) {
            case 1: {
                if (!(this.item instanceof JavaHasName)) {
                    return "";
                }
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                return this.getName();
            }
            case 4: {
                return ((JavaMethod)this.item).getName();
            }
            case 8: {
                JavaMethod m = (JavaMethod)this.item;
                if (this.useFullSignature()) {
                    return InsightDataItem.getShortSignature(m);
                }
                return InsightDataItem.getVeryShortSignature(m);
            }
        }
        throw new RuntimeException("Not an item type" + itemType);
    }

    protected String getDisplayTextImpl() {
        int itemType = this.item.getElementKind();
        switch (itemType) {
            case 1: {
                if (!(this.item instanceof JavaHasName)) {
                    return "";
                }
            }
            case 3: 
            case 9: 
            case 15: {
                return this.getName();
            }
            case 5: 
            case 7: 
            case 14: 
            case 16: {
                JavaVariable v = (JavaVariable)this.item;
                String variableName = v.getName();
                JavaType variableType = v.getResolvedType();
                if (variableType != null) {
                    return variableType.getName() + ' ' + variableName;
                }
                return variableName;
            }
            case 4: 
            case 8: {
                JavaMethod m = (JavaMethod)this.item;
                String signature = itemType == 4 ? m.getName() : (this.useFullSignature() ? InsightDataItem.getShortSignature(m) : InsightDataItem.getVeryShortSignature(m));
                JavaType returnType = m.getReturnType();
                if (returnType != null) {
                    return returnType.getUnqualifiedName() + ' ' + signature;
                }
                return signature;
            }
        }
        throw new RuntimeException("Not an item type" + itemType);
    }

    public Icon getIcon() {
        if (this.itemIcon != null) {
            return this.itemIcon;
        }
        int type = this.item.getElementKind();
        switch (type) {
            case 3: 
            case 10: {
                JavaType t = (JavaType)this.item;
                if (t.isInterface()) {
                    this.itemIcon = OracleIcons.getIcon((String)"interface.png");
                    break;
                }
                this.itemIcon = OracleIcons.getIcon((String)"class.png");
                break;
            }
            case 4: 
            case 8: {
                this.itemIcon = OracleIcons.getIcon((String)"method.png");
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 16: {
                this.itemIcon = OracleIcons.getIcon((String)"field.png");
                break;
            }
            case 1: {
                if (!"*".equals(this.getName())) {
                    return null;
                }
            }
            case 9: {
                this.itemIcon = OracleIcons.getIcon((String)"package.png");
                break;
            }
            case 15: {
                return null;
            }
            default: {
                throw new RuntimeException("Not an item type" + type);
            }
        }
        if (this.showAccessIcons() && (type == 3 || type == 4 || type == 8 || type == 5)) {
            int modifiers = this.item.getModifiers();
            Icon accessIcon = Modifier.isPublic(modifiers) ? JavaArb.getIcon(336) : (Modifier.isProtected(modifiers) ? JavaArb.getIcon(102) : (Modifier.isPrivate(modifiers) ? JavaArb.getIcon(244) : JavaArb.getIcon(121)));
            if (Modifier.isStatic(modifiers)) {
                Icon staticIcon = JavaArb.getIcon(142);
                accessIcon = new OverlayedIcon(staticIcon, accessIcon);
            }
            if (Modifier.isFinal(modifiers)) {
                Icon finalIcon = JavaArb.getIcon(71);
                accessIcon = new OverlayedIcon(finalIcon, accessIcon);
            } else if (Modifier.isAbstract(modifiers)) {
                Icon abstractIcon = JavaArb.getIcon(84);
                accessIcon = new OverlayedIcon(abstractIcon, accessIcon);
            }
            this.itemIcon = new SideBySideIcon(this.itemIcon, accessIcon, 1);
        }
        return this.itemIcon;
    }

    public String getDisplayText() {
        if (this.displayText == null) {
            this.displayText = this.getDisplayTextImpl();
        }
        return this.displayText;
    }

    public boolean belongsToClass() {
        return (this.flags & 4) != 0;
    }

    public void setBelongsToClass(boolean belongsToClass) {
        this.flags = belongsToClass ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    public String declaringClass() {
        int type = this.item.getElementKind();
        switch (type) {
            case 4: 
            case 5: 
            case 8: {
                JavaMember member = (JavaMember)this.item;
                return member.getOwningClass().getName();
            }
        }
        return "";
    }

    public boolean isDeprecated() {
        return this.item.isDeprecated();
    }

    public int getItemType() {
        return this.item.getElementKind();
    }

    public JavaElement getUnderlyingItem() {
        return this.item;
    }

    public ContentProvider getContentProvider(Context context) {
        SourceMemberProvider ret = null;
        JavaElement javaElement = this.getUnderlyingItem();
        SourceElement sourceElement = javaElement.getSourceElement();
        if (sourceElement instanceof SourceMember) {
            SourceMember sourceMember = (SourceMember)sourceElement;
            ret = new SourceMemberProvider(context, sourceMember);
        }
        return ret;
    }

    public static String getShortSignature(JavaMethod method) {
        String methodName = method.getName();
        Collection parameters = method.getParameters();
        if (parameters.isEmpty()) {
            return methodName + "()";
        }
        StringBuffer buffer = new StringBuffer(methodName);
        buffer.append('(');
        Iterator iterator = parameters.iterator();
        boolean needComma = false;
        while (iterator.hasNext()) {
            JavaLocalVariable v;
            JavaType type;
            if (needComma) {
                buffer.append(',');
            }
            if ((type = (v = (JavaLocalVariable)iterator.next()).getResolvedType()) != null) {
                buffer.append(type.getUnqualifiedName());
            } else {
                buffer.append("<unknown>");
            }
            needComma = true;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public static String getVeryShortSignature(JavaMethod method) {
        String methodName = method.getName();
        if (method.getParameters().isEmpty()) {
            return methodName + "()";
        }
        return methodName + "(...)";
    }

    static {
        INTERFACE_TYPE = JavaArb.getString(294);
        LABEL_TYPE = JavaArb.getString(329);
        ANNOTATION_TYPE = JavaArb.getString(327);
    }
}

