/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;

class IntConstantFilter
implements JavaFilter,
JavaConstants {
    public final boolean accepts(JavaElement element) {
        switch (element.getElementKind()) {
            case 5: {
                JavaField field = (JavaField)element;
                if (!field.isStatic()) {
                    return false;
                }
            }
            case 7: {
                if (element.isFinal()) break;
                return false;
            }
            default: {
                return false;
            }
        }
        JavaVariable v = (JavaVariable)element;
        JavaType type = v.getResolvedType();
        if (type != null) {
            String descriptor = type.getDescriptor();
            char ch = descriptor.charAt(0);
            switch (ch) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': {
                    return true;
                }
            }
            return false;
        }
        Object value = v.getConstantValue();
        if (value == null) {
            return false;
        }
        return value instanceof Integer || value instanceof Character || value instanceof Byte || value instanceof Short;
    }
}

