/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.JavaInsightOptions;

public final class JavaInsightOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_boldDeclaredMembers;
    private JCheckBox checkbox_italicLocalVariables;
    private JCheckBox checkbox_showTopLevelPackages;
    private JCheckBox checkbox_showImportedClasses;
    private JCheckBox checkbox_showObjectMethods;
    private JCheckBox checkbox_showOverloadedMethods;
    private JCheckBox checkbox_showDeprecated;
    private JCheckBox checkbox_strikethruDeprecated;
    private JCheckBox checkbox_autoImport;
    private JCheckBox checkbox_showDefiningClass;
    private JCheckBox checkbox_showAccessIcons;

    public JavaInsightOptionsPanel() {
        this.setHelpID("f1_idedidesetjavainsight_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        JavaInsightOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        JavaInsightOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private JavaInsightOptions findOptions(TraversableContext tc) {
        JavaInsightOptions options = (JavaInsightOptions)tc.find("JavaInsightOptions");
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        JavaInsightOptions options = this.findOptions(tc);
        JavaInsightOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(JavaInsightOptions options) {
    }

    void loadSettingsFrom(JavaInsightOptions options) {
        boolean boldDeclaredMembers = options.getBoldDeclaredMembers();
        boolean italicLocalVariables = options.getItalicLocalVariables();
        boolean showTopLevelPackages = options.getShowTopLevelPackages();
        boolean showImportedClasses = options.getShowImportedClasses();
        boolean showObjectMethods = options.getShowObjectMethods();
        boolean showOverloadedMethods = options.getShowOverloadedMethods();
        boolean showDeprecated = options.getShowDeprecated();
        boolean strikethruDeprecated = options.getStrikethruDeprecated();
        boolean autoImport = options.getAutoImport();
        boolean showDefiningClass = options.getShowDefiningClass();
        boolean showAccessIcons = options.getShowAccessIcons();
        this.checkbox_boldDeclaredMembers.setSelected(boldDeclaredMembers);
        this.checkbox_italicLocalVariables.setSelected(italicLocalVariables);
        this.checkbox_showTopLevelPackages.setSelected(showTopLevelPackages);
        this.checkbox_showImportedClasses.setSelected(showImportedClasses);
        this.checkbox_showObjectMethods.setSelected(showObjectMethods);
        this.checkbox_showOverloadedMethods.setSelected(showOverloadedMethods);
        this.checkbox_showDeprecated.setSelected(showDeprecated);
        this.checkbox_strikethruDeprecated.setSelected(strikethruDeprecated);
        this.checkbox_autoImport.setSelected(autoImport);
        this.checkbox_showDefiningClass.setSelected(showDefiningClass);
        this.checkbox_showAccessIcons.setSelected(showAccessIcons);
    }

    void saveSettingsTo(JavaInsightOptions options) throws TraversalException {
        boolean boldDeclaredMembers = this.checkbox_boldDeclaredMembers.isSelected();
        boolean italicLocalVariables = this.checkbox_italicLocalVariables.isSelected();
        boolean showTopLevelPackages = this.checkbox_showTopLevelPackages.isSelected();
        boolean showImportedClasses = this.checkbox_showImportedClasses.isSelected();
        boolean showObjectMethods = this.checkbox_showObjectMethods.isSelected();
        boolean showOverloadedMethods = this.checkbox_showOverloadedMethods.isSelected();
        boolean showDeprecated = this.checkbox_showDeprecated.isSelected();
        boolean strikethruDeprecated = this.checkbox_strikethruDeprecated.isSelected();
        boolean autoImport = this.checkbox_autoImport.isSelected();
        boolean showDefiningClass = this.checkbox_showDefiningClass.isSelected();
        boolean showAccessIcons = this.checkbox_showAccessIcons.isSelected();
        options.setBoldDeclaredMembers(boldDeclaredMembers);
        options.setItalicLocalVariables(italicLocalVariables);
        options.setShowTopLevelPackages(showTopLevelPackages);
        options.setShowImportedClasses(showImportedClasses);
        options.setShowObjectMethods(showObjectMethods);
        options.setShowOverloadedMethods(showOverloadedMethods);
        options.setShowDeprecated(showDeprecated);
        options.setStrikethruDeprecated(strikethruDeprecated);
        options.setAutoImport(autoImport);
        options.setShowDefiningClass(showDefiningClass);
        options.setShowAccessIcons(showAccessIcons);
    }

    private void initializeComponent() {
        String boldDeclaredMembersText = JavaArb.getString(56);
        this.checkbox_boldDeclaredMembers = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_boldDeclaredMembers, (String)boldDeclaredMembersText);
        String italicLocalVariablesText = JavaArb.getString(188);
        this.checkbox_italicLocalVariables = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_italicLocalVariables, (String)italicLocalVariablesText);
        String showTopLevelPackagesText = JavaArb.getString(304);
        this.checkbox_showTopLevelPackages = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showTopLevelPackages, (String)showTopLevelPackagesText);
        String showImportedClassesText = JavaArb.getString(55);
        this.checkbox_showImportedClasses = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showImportedClasses, (String)showImportedClassesText);
        String showObjectMethodsText = JavaArb.getString(125);
        this.checkbox_showObjectMethods = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showObjectMethods, (String)showObjectMethodsText);
        String showOverloadedMethodsText = JavaArb.getString(309);
        this.checkbox_showOverloadedMethods = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showOverloadedMethods, (String)showOverloadedMethodsText);
        String showDefiningClassText = JavaArb.getString(363);
        this.checkbox_showDefiningClass = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showDefiningClass, (String)showDefiningClassText);
        String showDeprecatedText = JavaArb.getString(362);
        this.checkbox_showDeprecated = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showDeprecated, (String)showDeprecatedText);
        String strikethruDeprecatedText = JavaArb.getString(153);
        this.checkbox_strikethruDeprecated = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_strikethruDeprecated, (String)strikethruDeprecatedText);
        String autoImportText = JavaArb.getString(64);
        this.checkbox_autoImport = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoImport, (String)autoImportText);
        Component[] dependents = new Component[]{this.checkbox_strikethruDeprecated};
        ItemSelectableTracker tracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_showDeprecated, dependents);
        String showAccessIconsText = JavaArb.getString(212);
        this.checkbox_showAccessIcons = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showAccessIcons, (String)showAccessIconsText);
        Insets indentedInsets = new Insets(0, 30, 2, 5);
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        JPanel panel_member = new JPanel(new GridBagLayout());
        String memberBorderText = JavaArb.getString(273);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(memberBorderText);
        panel_member.setBorder(titledBorder);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_member.add((Component)this.checkbox_boldDeclaredMembers, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_member.add((Component)this.checkbox_italicLocalVariables, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_member.add((Component)this.checkbox_showTopLevelPackages, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_member.add((Component)this.checkbox_showImportedClasses, constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_member.add((Component)this.checkbox_showObjectMethods, constraints);
        constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_member.add((Component)this.checkbox_showOverloadedMethods, constraints);
        constraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_member.add((Component)this.checkbox_showDefiningClass, constraints);
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(panel_member, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(Box.createVerticalStrut(5), constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(this.checkbox_showDeprecated, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 1, indentedInsets, 0, 0);
        this.add(this.checkbox_strikethruDeprecated, constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(Box.createVerticalStrut(5), constraints);
        constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(this.checkbox_autoImport, constraints);
        constraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(Box.createVerticalStrut(5), constraints);
        constraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(this.checkbox_showAccessIcons, constraints);
        constraints = new GridBagConstraints(0, 8, 1, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        this.add(Box.createGlue(), constraints);
    }
}

