/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.EnumConstantSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldDeclSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalsSym;
import oracle.javatools.parser.java.v2.internal.symbol.InitializerSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.SwitchLabelSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.SimpleNameExpr;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.AutoImportInsightData;
import oracle.jdevimpl.java.insight.EnumInsightDataItem;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightDataItem;
import oracle.jdevimpl.java.insight.JavaInsightOptions;
import oracle.jdevimpl.java.insight.WrappedInsightDataItem;
import oracle.jdevimpl.java.util.ExpressionFinder;
import oracle.jdevimpl.java.util.FoundSymbol;

class MemberInsightData
extends AutoImportInsightData
implements CallerContext.Constants {
    private static final int OPTION_HIDE_ROOT_PACKAGES = 256;
    private static final int OPTION_HIDE_IMPORTED_CLASSES = 512;
    private static final int OPTION_HIDE_OBJECT_MEMBERS = 1024;
    private static final int OPTION_SHOW_OVERLOADED_METHODS = 2048;
    protected boolean forceUpdateData;
    private static final EditDescriptor editDescriptor;
    private String primaryPrefix;

    private void $init$() {
        this.forceUpdateData = false;
    }

    EditDescriptor getEditDescriptor() {
        return editDescriptor;
    }

    String identifySelf() {
        return "Member";
    }

    int getPrimaryPrefixFilter() {
        return 0;
    }

    MemberInsightData(InsightContext insight) {
        super(insight);
        this.$init$();
    }

    static {
        String editName = JavaArb.getString(346);
        editDescriptor = new EditDescriptor(editName);
    }

    public boolean complete(Object selectedObject) {
        SourceElement scope;
        SourceFile file;
        InsightDataItem item = (InsightDataItem)((Object)selectedObject);
        String name = item.getName();
        String trailer = "";
        boolean retriggerInsight = false;
        boolean zeroParameters = false;
        int itemType = item.getItemType();
        if (!item.insertExactName()) {
            if (itemType == 9) {
                trailer = ".";
                retriggerInsight = true;
            } else if (itemType == 8) {
                trailer = "()";
                JavaMethod javaMethod = (JavaMethod)item.getUnderlyingItem();
                zeroParameters = javaMethod.getParameters().size() == 0;
                JavaType returnType = javaMethod.getReturnType();
                if (returnType != null && "V".equals(returnType.getDescriptor())) {
                    trailer = "();";
                }
            }
        }
        BasicDocument document = this.helper.getDocument();
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int caretOffset = this.helper.getCaretPosition();
        boolean moveAfterParen = false;
        if (!item.insertExactName() && itemType == 3 && this.getResultFilter() != null && (file = (scope = this.callerContext.getSourceScope()).getOwningSourceFile()) != null) {
            SourceElement cel = file.getElementAt(caretOffset);
            while (cel != null) {
                switch (cel.getSymbolKind()) {
                    case 61: {
                        moveAfterParen = true;
                    }
                    case 3: {
                        cel = null;
                        break;
                    }
                    default: {
                        cel = cel.getParent();
                        break;
                    }
                }
            }
        }
        int offsetAdjustment = this.helper.getCaretPositionAdjustment();
        String importString = null;
        if (!item.insertExactName() && itemType != 9) {
            importString = this.determinePossibleImportString(name);
        }
        document.writeLock();
        try {
            int startOffset = this.getNameStartOffset((ReadTextBuffer)textBuffer, caretOffset);
            int endOffset = this.getNameEndOffset((ReadTextBuffer)textBuffer, caretOffset);
            int caretToStartOffset = caretOffset - startOffset;
            if (textBuffer.getLength() > endOffset) {
                if (trailer.startsWith("()") && !zeroParameters) {
                    String checkTrailer = textBuffer.getString(endOffset, 1);
                    if (trailer.startsWith(checkTrailer)) {
                        trailer = "(";
                        ++endOffset;
                    }
                } else {
                    int trailerLength = trailer.length();
                    int bufferLengthRemaining = Math.min(textBuffer.getLength() - endOffset, trailerLength);
                    String checkTrailer = textBuffer.getString(endOffset, bufferLengthRemaining);
                    if (checkTrailer.equals(trailer)) {
                        endOffset += trailerLength;
                    } else if (trailer.equals("();") && checkTrailer.startsWith("()")) {
                        endOffset += 2;
                    }
                }
            }
            BasicEditorPane editor = this.helper.getEditorPane();
            editor.beginEdit(this.getEditDescriptor());
            try {
                try {
                    String currentText = textBuffer.getString(startOffset, endOffset - startOffset);
                    String replacementText = name + trailer;
                    if (replacementText.startsWith(currentText)) {
                        int insertionPoint = editor.getCaretPosition() - caretToStartOffset;
                        document.insertString(startOffset + offsetAdjustment + currentText.length(), replacementText.substring(currentText.length()), null);
                        editor.setCaretPosition(insertionPoint + replacementText.length());
                    } else {
                        document.remove(startOffset + offsetAdjustment, endOffset - startOffset);
                        document.insertString(startOffset + offsetAdjustment, replacementText, null);
                    }
                    if (trailer.startsWith("(") && !zeroParameters) {
                        AbstractInsight insight;
                        int parenAdjustment = trailer.length() - 1;
                        if (parenAdjustment != 0) {
                            editor.setCaretPosition(editor.getCaretPosition() - parenAdjustment);
                        }
                        if ((insight = this.helper.getInsight(2)) != null) {
                            insight.restartPopupTimer();
                        }
                    }
                    if (moveAfterParen) {
                        int curpos = editor.getCaretPosition();
                        int tLen = textBuffer.getLength();
                        while (curpos < tLen && textBuffer.getChar(curpos) != ')') {
                            ++curpos;
                        }
                        if (++curpos < tLen) {
                            editor.setCaretPosition(curpos);
                        }
                    }
                }
                catch (BadLocationException e) {
                    System.err.println("Exception occurred in completion: " + e);
                    e.printStackTrace();
                }
            }
            finally {
                editor.endEdit();
            }
            if (!item.insertExactName() && itemType != 9) {
                JavaType javaType;
                if (importString != null) {
                    this.autoImport(importString);
                } else if (itemType == 3 && this.primaryPrefix.length() == 0 && !(javaType = (JavaType)item.getUnderlyingItem()).isMemberClass()) {
                    this.addImport(javaType.getQualifiedName());
                }
            }
        }
        finally {
            document.writeUnlock();
        }
        return retriggerInsight;
    }

    private JavaHasType resolveExpression(String text) {
        SourceFactory factory;
        SourceExpression e;
        SourceElement scope = this.callerContext.getSourceScope();
        SourceFile file = scope.getOwningSourceFile();
        if (file == null) {
            CommonUtilities.panic((String)"No SourceFile instance");
        }
        if ((e = (factory = file.getFactory()).createExpression(text)) == null) {
            return null;
        }
        e.setContext(this.callerContext);
        return e.getResolvedObject();
    }

    private String determinePossibleImportString(String completionName) {
        String namedPrefix;
        int firstDot;
        String primary = this.primaryPrefix + completionName;
        int primaryLength = primary.length();
        int currentOffset = 0;
        while (currentOffset < primaryLength) {
            char c = primary.charAt(currentOffset);
            if (c != '.' && !Character.isJavaIdentifierPart(c)) break;
            ++currentOffset;
        }
        if ((firstDot = (namedPrefix = primary.substring(0, currentOffset)).indexOf(46)) == -1) {
            return null;
        }
        String firstName = namedPrefix.substring(0, firstDot);
        JavaHasType result = this.resolveExpression(firstName);
        if (result != null) {
            return null;
        }
        String source = namedPrefix;
        int length = source.length();
        int nextDot = source.indexOf(46, firstDot + 1);
        String found = null;
        while (true) {
            String target;
            JavaType jc;
            if (nextDot == -1) {
                nextDot = length;
            }
            if ((jc = this.callerContext.resolveTypeName(target = source.substring(0, nextDot))) != null) {
                found = target;
            } else {
                result = this.resolveExpression(target);
                if (result != null) {
                    return found;
                }
            }
            if (nextDot == length) break;
            nextDot = source.indexOf(46, nextDot + 1);
        }
        return found;
    }

    protected void retrieveOptions(JavaInsightOptions options) {
        super.retrieveOptions(options);
        if (!options.getShowTopLevelPackages()) {
            this.optionsMask |= 0x100;
        }
        if (!options.getShowImportedClasses()) {
            this.optionsMask |= 0x200;
        }
        if (!options.getShowObjectMethods()) {
            this.optionsMask |= 0x400;
        }
        if (options.getShowOverloadedMethods()) {
            this.optionsMask |= 0x800;
        }
    }

    protected void fillInitialDataImpl() {
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int caretOffset = this.helper.getCaretPosition();
        ExpressionFinder finder = this.helper.getFinder();
        FoundSymbol foundSymbol = finder.determinePrimaryPrefix(caretOffset, this.getPrimaryPrefixFilter());
        this.primaryPrefix = "";
        if (foundSymbol != null) {
            int start = foundSymbol.startOffset;
            int end = foundSymbol.endOffset;
            this.primaryPrefix = textBuffer.getString(start, end - start);
        }
        this.clearData();
        this.fillDataList();
    }

    protected void updateDataImpl() {
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int caretOffset = this.helper.getCaretPosition();
        ExpressionFinder finder = this.helper.getFinder();
        FoundSymbol foundSymbol = finder.determinePrimaryPrefix(caretOffset, this.getPrimaryPrefixFilter());
        String newPrefix = "";
        if (foundSymbol != null) {
            int start = foundSymbol.startOffset;
            int end = foundSymbol.endOffset;
            newPrefix = textBuffer.getString(start, end - start);
        }
        if (!this.primaryPrefix.equals(newPrefix)) {
            this.primaryPrefix = newPrefix;
            this.forceUpdateData = true;
        }
        if (this.forceUpdateData) {
            this.clearData();
            this.fillDataList();
            this.forceUpdateData = false;
        }
    }

    protected InsightDataItem[] createInsightDataItems(CallerContext.Output output, JavaPackage packagePrimary, JavaHasType hasTypePrimary) {
        ArrayList<InsightDataItem> dataItemList;
        block35: {
            SourceElement se;
            block36: {
                ArrayList list = output.all;
                int count = list.size();
                dataItemList = new ArrayList<InsightDataItem>(count + 3);
                SourceElement sourceElement = this.callerContext.getSourceScope();
                boolean displayEnumsQualified = true;
                se = sourceElement;
                if (se instanceof NameSym) {
                    se = se.getParent();
                }
                if (se instanceof SimpleNameExpr) {
                    se = se.getParent();
                }
                if (se instanceof SwitchLabelSym) {
                    displayEnumsQualified = false;
                }
                JavaType primaryClass = null;
                if (packagePrimary == null && hasTypePrimary != null) {
                    primaryClass = hasTypePrimary.getResolvedType();
                }
                for (JavaElement javaElement : list) {
                    if (javaElement instanceof EnumConstantSym || javaElement instanceof JavaField && ((JavaField)javaElement).isEnumConstant()) {
                        boolean finalDisplayEnumsQualified = displayEnumsQualified;
                        JavaType enumOwnerType = null;
                        if (javaElement instanceof EnumConstantSym) {
                            enumOwnerType = ((EnumConstantSym)javaElement).getOwningClass().getResolvedType();
                        } else if (javaElement instanceof JavaField) {
                            enumOwnerType = ((JavaField)javaElement).getOwningClass().getResolvedType();
                        }
                        if (primaryClass != null && enumOwnerType != null && primaryClass.equals((Object)enumOwnerType)) {
                            finalDisplayEnumsQualified = false;
                        }
                        if (finalDisplayEnumsQualified) {
                            JavaElement enumElement = javaElement;
                            block1: while (enumElement != null) {
                                if (enumElement instanceof ClassSym) {
                                    SourceElement curScope = sourceElement;
                                    while (curScope != null) {
                                        if (curScope.equals(enumElement)) {
                                            finalDisplayEnumsQualified = false;
                                            break block1;
                                        }
                                        curScope = curScope.getParent();
                                    }
                                    break;
                                }
                                enumElement = enumElement.getOwner();
                            }
                        }
                        EnumInsightDataItem dataItem = new EnumInsightDataItem(javaElement, finalDisplayEnumsQualified);
                        dataItem.setBelongsToClass(finalDisplayEnumsQualified ^ true);
                        dataItemList.add(dataItem);
                        continue;
                    }
                    InsightDataItem dataItem = new InsightDataItem(javaElement);
                    boolean belongsToClass = false;
                    if (primaryClass != null) {
                        JavaElement owner = javaElement.getOwner();
                        while (owner != null) {
                            if (owner instanceof JavaClass) {
                                if (!((JavaClass)owner).getQualifiedName().equals(primaryClass.getQualifiedName())) break;
                                belongsToClass = true;
                                break;
                            }
                            owner = owner.getOwner();
                        }
                    }
                    dataItem.setBelongsToClass(belongsToClass);
                    dataItemList.add(dataItem);
                }
                if (packagePrimary != null || hasTypePrimary == null) break block36;
                if (hasTypePrimary.getElementKind() != 3) break block35;
                JavaType primaryJavaType = (JavaType)hasTypePrimary;
                boolean addedClass = false;
                se = this.callerContext.getSourceScope();
                while (se != null) {
                    if (se instanceof FormalsSym) break block35;
                    if ((se instanceof FieldDeclSym || se instanceof MethodSym || se instanceof InitializerSym) && !addedClass) {
                        addedClass = true;
                        dataItemList.add(new WrappedInsightDataItem("class", "Class", "class"));
                    }
                    if (se instanceof ClassSym && ((ClassSym)se).getVMName().equals(primaryJavaType.getVMName())) {
                        dataItemList.add(new WrappedInsightDataItem("this", primaryJavaType.getName(), "this"));
                        JavaType superClass = primaryJavaType.getSuperclass();
                        if (superClass == null) break block35;
                        dataItemList.add(new WrappedInsightDataItem("super", superClass.getName(), "super"));
                        break block35;
                    }
                    se = se.getParent();
                }
                break block35;
            }
            if (packagePrimary == null && hasTypePrimary == null) {
                boolean isExpression = false;
                se = this.callerContext.getSourceScope();
                while (se != null) {
                    if (se instanceof FormalsSym) break;
                    if (se instanceof Expr) {
                        isExpression = true;
                    }
                    boolean addThisSuper = false;
                    if (se instanceof FieldDeclSym && !((FieldDeclSym)se).isStatic()) {
                        if (isExpression) {
                            addThisSuper = true;
                        }
                    } else if (se instanceof MethodSym && !((MethodSym)se).isStatic()) {
                        addThisSuper = true;
                    } else if (se instanceof InitializerSym && !((InitializerSym)se).isStatic()) {
                        addThisSuper = true;
                    } else if (se instanceof ClassSym) break;
                    if (addThisSuper) {
                        String classTypeName = null;
                        String superTypeName = null;
                        while (se != null) {
                            if (se instanceof ClassSym) {
                                classTypeName = ((ClassSym)se).getName();
                                JavaType classType = ((ClassSym)se).getResolvedType();
                                if (classType == null || classType.getSuperclass() == null) break;
                                superTypeName = classType.getSuperclass().getName();
                                break;
                            }
                            se = se.getParent();
                        }
                        if (classTypeName != null) {
                            dataItemList.add(new WrappedInsightDataItem("this", classTypeName, "this"));
                        }
                        if (superTypeName == null) break;
                        dataItemList.add(new WrappedInsightDataItem("super", superTypeName, "super"));
                        break;
                    }
                    se = se.getParent();
                }
            }
        }
        return dataItemList.toArray(new InsightDataItem[dataItemList.size()]);
    }

    private void fillDataList() {
        int startOffset;
        int endOffset = startOffset = this.analysisStartOffset;
        if (this.primaryPrefix.length() > 0) {
            endOffset += this.primaryPrefix.length() - 1;
        }
        CallerContext.InputOptions options = new CallerContext.InputOptions();
        options.input = (byte)79;
        if (this.option(256)) {
            options.squash = (byte)(options.squash | 2);
        }
        if (this.option(512)) {
            options.squash = (byte)(options.squash | 1);
        }
        if (this.option(1)) {
            options.squash = (byte)(options.squash | 0x10);
        }
        if (this.option(16)) {
            options.squash = (byte)(options.squash | 0x20);
        }
        if (this.option(1024)) {
            options.squash = (byte)(options.squash | 8);
        }
        if (this.option(8)) {
            options.squash = (byte)(options.squash | 4);
        }
        this.fillDataListHelper(startOffset, endOffset, true, options);
        if (this.option(2048)) {
            int finalCount = this.dataList.length;
            int i = 0;
            while (i < finalCount) {
                this.dataList[i].setFullSignature();
                ++i;
            }
        } else {
            ArrayList<InsightDataItem> items = new ArrayList<InsightDataItem>();
            ArrayList<String> keys = new ArrayList<String>();
            int firstCount = this.dataList.length;
            int i = 0;
            while (i < firstCount) {
                InsightDataItem item = this.dataList[i];
                if (item.getItemType() != 8) {
                    items.add(item);
                } else {
                    String displayText = item.getDisplayText();
                    if (item.isDeprecated()) {
                        displayText = displayText + 'd';
                    }
                    if (!keys.contains(displayText)) {
                        keys.add(displayText);
                        items.add(item);
                    }
                }
                ++i;
            }
            int finalCount = items.size();
            this.dataList = items.toArray(new InsightDataItem[finalCount]);
        }
    }
}

