/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.parser.java.v2.common.QuickHasName;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.jdevimpl.java.insight.AbstractCompletionInsightData;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightDataItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameInsightData
extends AbstractCompletionInsightData {
    public static final EditDescriptor GENERIC_DESCRIPTOR = new EditDescriptor("Completion");
    public static final EditDescriptor VARIABLENAME_DESCRIPTOR = new EditDescriptor("Variable Name Completion");
    private final EditDescriptor _editDescriptor;
    private JavaHasName[] _javaHasNames;

    public NameInsightData(EditDescriptor editDescriptor, InsightContext helper, List<String> names) {
        super(helper);
        this._editDescriptor = editDescriptor;
        this._javaHasNames = new JavaHasName[names.size()];
        int i = 0;
        while (i < names.size()) {
            String variableName = names.get(i);
            QuickHasName quickHasName = QuickHasName.createHasName((String)variableName);
            this._javaHasNames[i] = quickHasName;
            ++i;
        }
        this.fillInitialData();
    }

    @Override
    EditDescriptor getEditDescriptor() {
        return this._editDescriptor;
    }

    @Override
    String identifySelf() {
        return "NameInsightData";
    }

    @Override
    void fillInitialDataImpl() {
        this.dataList = new InsightDataItem[this._javaHasNames.length];
        int i = 0;
        while (i < this._javaHasNames.length) {
            this.dataList[i] = new InsightDataItem((JavaElement)this._javaHasNames[i]);
            ++i;
        }
    }

    @Override
    void updateDataImpl() {
        String newPrefix = this.findCurrentPrefix();
        ArrayList<InsightDataItem> ret = new ArrayList<InsightDataItem>();
        int i = 0;
        while (i < this._javaHasNames.length) {
            JavaHasName javaHasName = this._javaHasNames[i];
            String name = javaHasName.getName();
            if (name.startsWith(newPrefix)) {
                InsightDataItem insightDataItem = new InsightDataItem((JavaElement)this._javaHasNames[i]);
                ret.add(insightDataItem);
            }
            ++i;
        }
        this.dataList = ret.toArray(new InsightDataItem[ret.size()]);
    }
}

