/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.PrototypeCellProvider;
import oracle.javatools.editor.insight.TooltipDataItem;
import oracle.javatools.util.SwingUtils;
import oracle.jdevimpl.java.insight.AnnotationDataItem;
import oracle.jdevimpl.java.insight.ParameterDataItem;

final class ParameterCellRenderer
extends JComponent
implements ListCellRenderer,
PrototypeCellProvider {
    private boolean strikethruDeprecatedOption;
    private static final int PADDING = 2;
    private Dimension cellSize;
    private boolean cellTooWide;
    private TooltipDataItem currentItem;
    private static final String SEPARATOR = ", ";

    public ParameterCellRenderer() {
        this.$init$();
        this.setOpaque(false);
        this.cellSize = new Dimension(0, 0);
        this.currentItem = null;
        this.updateCellSize();
    }

    protected void setStrikethruDeprecated(boolean strikethruDeprecated) {
        this.strikethruDeprecatedOption = strikethruDeprecated;
    }

    private void $init$() {
        this.strikethruDeprecatedOption = false;
    }

    private void updateCellSize() {
        this.calculateCellSize(this.getFont(), this.currentItem, this.cellSize);
        EditorProperties properties = EditorProperties.getProperties();
        int widthCap = properties.getIntegerProperty("insight-max-popup-width");
        Dimension screenSize = this.getToolkit().getScreenSize();
        widthCap = Math.min(screenSize.width / 2 - 5, widthCap);
        if (this.cellSize.width > widthCap) {
            this.cellTooWide = true;
            this.cellSize.width = widthCap;
        } else {
            this.cellTooWide = false;
        }
        this.setMinimumSize(this.cellSize);
        this.setPreferredSize(this.cellSize);
        this.setMaximumSize(this.cellSize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calculateCellSize(Font plainFont, TooltipDataItem item, Dimension size) {
        if (item != null) {
            if (item instanceof ParameterDataItem) {
                this.calculateCellSize(plainFont, (ParameterDataItem)item, size);
                return;
            } else {
                if (!(item instanceof AnnotationDataItem)) throw new IllegalArgumentException(item.getClass().getName());
                this.calculateCellSize(plainFont, (AnnotationDataItem)item, size);
            }
            return;
        } else {
            size.height = 4;
            size.width = 4;
        }
    }

    public void paint(Graphics graphics) {
        Font plainFont;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.cellSize.width, this.cellSize.height);
        if (this.currentItem != null && (plainFont = this.getFont()) != null) {
            if (this.currentItem instanceof ParameterDataItem) {
                this.paint(graphics, plainFont, (ParameterDataItem)this.currentItem);
            } else if (this.currentItem instanceof AnnotationDataItem) {
                this.paint(graphics, plainFont, (AnnotationDataItem)this.currentItem);
            } else {
                throw new IllegalArgumentException(this.currentItem.getClass().getName());
            }
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setBackground(list.getBackground());
        this.setForeground(list.getForeground());
        this.setFont(list.getFont());
        this.currentItem = (TooltipDataItem)value;
        this.updateCellSize();
        return this;
    }

    public Object getPrototypeCell(JList list, ListModel listModel) {
        Font plainFont = list.getFont();
        Dimension size = new Dimension(0, 0);
        int maxWidth = 0;
        TooltipDataItem largestItem = null;
        int numElements = listModel.getSize();
        int i = 0;
        while (i < numElements) {
            TooltipDataItem item = (TooltipDataItem)listModel.getElementAt(i);
            this.calculateCellSize(plainFont, item, size);
            if (size.width > maxWidth) {
                maxWidth = size.width;
                largestItem = item;
            }
            ++i;
        }
        return largestItem;
    }

    private void calculateCellSize(Font plainFont, ParameterDataItem dataItem, Dimension size) {
        int width = 0;
        int height = 0;
        if (plainFont != null) {
            FontMetrics plainMetrics = this.getFontMetrics(plainFont);
            Font boldFont = plainFont.deriveFont(1);
            FontMetrics boldMetrics = this.getFontMetrics(boldFont);
            height = plainMetrics.getHeight();
            int argumentIndex = dataItem.getArgumentIndex();
            int numParameters = dataItem.getParameterCount();
            if (numParameters == 0) {
                String displayText = dataItem.getDisplayText();
                width = plainMetrics.stringWidth(displayText);
            } else {
                String separator = "";
                int i = 0;
                while (i < numParameters) {
                    if (separator.length() > 0) {
                        width += plainMetrics.stringWidth(separator);
                    }
                    separator = SEPARATOR;
                    FontMetrics metricsToUse = i == argumentIndex ? boldMetrics : plainMetrics;
                    String parameterText = dataItem.getParameter(i);
                    width += metricsToUse.stringWidth(parameterText);
                    ++i;
                }
            }
        }
        size.width = width + 4;
        size.height = height + 4;
    }

    private void paint(Graphics graphics, Font plainFont, ParameterDataItem item) {
        int numParameters;
        FontMetrics plainMetrics = this.getFontMetrics(plainFont);
        Font boldFont = plainFont.deriveFont(1);
        FontMetrics boldMetrics = this.getFontMetrics(boldFont);
        int plainAscent = plainMetrics.getAscent();
        int boldAscent = boldMetrics.getAscent();
        int xPos = 2;
        int yPos = 2;
        int argumentIndex = item.getArgumentIndex();
        if (argumentIndex >= (numParameters = item.getParameterCount())) {
            graphics.setColor(Color.gray);
        } else {
            graphics.setColor(this.getForeground());
        }
        int strikethruXPos = xPos;
        int strikethruXWidth = 0;
        if (numParameters == 0) {
            String displayText = item.getDisplayText();
            graphics.setFont(plainFont);
            SwingUtils.drawString((Graphics)graphics, (String)displayText, (int)xPos, (int)(yPos + plainAscent));
            strikethruXWidth = plainMetrics.stringWidth(displayText);
        } else {
            int preSkip = 0;
            int postSkip = 0;
            int truncateChars = 0;
            String ellipsis = "...";
            if (this.cellTooWide) {
                int ellipsisPlainWidth = plainMetrics.stringWidth("...");
                Dimension currentSize = new Dimension();
                this.calculateCellSize(plainFont, item, currentSize);
                int allowedWidth = this.cellSize.width;
                int currentWidth = currentSize.width;
                while (currentWidth > allowedWidth) {
                    int firstUnskipped;
                    if (argumentIndex - (firstUnskipped = preSkip++) >= 2) {
                        String parameterText = item.getParameter(firstUnskipped);
                        currentWidth -= plainMetrics.stringWidth(parameterText);
                        currentWidth += ellipsisPlainWidth;
                        continue;
                    }
                    int lastUnskipped = numParameters - postSkip - 1;
                    if (lastUnskipped - argumentIndex >= 2) {
                        String parameterText = item.getParameter(lastUnskipped);
                        ++postSkip;
                        currentWidth -= plainMetrics.stringWidth(parameterText);
                        currentWidth += ellipsisPlainWidth;
                        continue;
                    }
                    if (argumentIndex - firstUnskipped >= 1) {
                        String parameterText = item.getParameter(firstUnskipped);
                        ++preSkip;
                        currentWidth -= plainMetrics.stringWidth(parameterText);
                        currentWidth += ellipsisPlainWidth;
                        continue;
                    }
                    if (lastUnskipped - argumentIndex >= 1) {
                        String parameterText = item.getParameter(lastUnskipped);
                        ++postSkip;
                        currentWidth -= plainMetrics.stringWidth(parameterText);
                        currentWidth += ellipsisPlainWidth;
                        continue;
                    }
                    String parameterText = item.getParameter(argumentIndex);
                    truncateChars = this.truncateString(parameterText, currentWidth, allowedWidth, boldMetrics);
                    break;
                }
            }
            int firstUnskippedIndex = preSkip;
            int lastUnskippedIndex = numParameters - postSkip - 1;
            String separator = "";
            Font fontToUse = null;
            FontMetrics metricsToUse = null;
            int ascentToUse = 0;
            int i = 0;
            while (i < numParameters) {
                if (separator.length() > 0) {
                    SwingUtils.drawString((Graphics)graphics, (String)separator, (int)xPos, (int)ascentToUse);
                    int separatorWidth = metricsToUse.stringWidth(separator);
                    xPos += separatorWidth;
                    strikethruXWidth += separatorWidth;
                }
                separator = SEPARATOR;
                if (i == argumentIndex) {
                    fontToUse = boldFont;
                    metricsToUse = boldMetrics;
                    ascentToUse = boldAscent;
                } else {
                    fontToUse = plainFont;
                    metricsToUse = plainMetrics;
                    ascentToUse = plainAscent;
                }
                String parameterText = item.getParameter(i);
                graphics.setFont(fontToUse);
                if (i < firstUnskippedIndex || i > lastUnskippedIndex) {
                    parameterText = "...";
                } else if (i == argumentIndex && truncateChars > 0) {
                    int length = parameterText.length();
                    parameterText = parameterText.substring(0, length - truncateChars) + "...";
                }
                SwingUtils.drawString((Graphics)graphics, (String)parameterText, (int)xPos, (int)ascentToUse);
                int parameterWidth = metricsToUse.stringWidth(parameterText);
                xPos += parameterWidth;
                strikethruXWidth += parameterWidth;
                ++i;
            }
        }
        if (this.strikethruDeprecatedOption && item.isDeprecated()) {
            int strikeYPos = yPos + plainAscent / 2;
            if (strikethruXWidth > 0) {
                graphics.drawLine(strikethruXPos, strikeYPos, strikethruXPos + strikethruXWidth, strikeYPos);
            }
        }
    }

    protected int truncateString(String displayText, int width, int maxWidth, FontMetrics metrics) {
        if (width < maxWidth) {
            return 0;
        }
        String ellipsis = "...";
        int allowedWidth = maxWidth - metrics.stringWidth("...");
        int currentWidth = width;
        int lastIndex = displayText.length() - 1;
        while (currentWidth > allowedWidth && lastIndex > 0) {
            char c = displayText.charAt(lastIndex--);
            int charWidth = metrics.charWidth(c);
            currentWidth -= charWidth;
        }
        return displayText.length() - (lastIndex + 1);
    }

    private void calculateCellSize(Font plainFont, AnnotationDataItem item, Dimension size) {
        int width = 0;
        int height = 0;
        if (plainFont != null) {
            String displayText = item.getDisplayText();
            Font font = item.printBold() ? plainFont.deriveFont(1) : plainFont;
            FontMetrics fontMetrics = this.getFontMetrics(font);
            height = fontMetrics.getHeight();
            width = fontMetrics.stringWidth(displayText);
        }
        size.width = width + 4;
        size.height = height + 4;
    }

    public void paint(Graphics graphics, Font plainFont, AnnotationDataItem item) {
        Font font = item.printBold() ? plainFont.deriveFont(1) : plainFont;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int initialX = 2;
        int xPos = 2;
        int yPos = 2;
        graphics.setColor(this.getForeground());
        String displayText = item.getDisplayText();
        graphics.setFont(font);
        SwingUtils.drawString((Graphics)graphics, (String)displayText, (int)xPos, (int)(yPos + fontMetrics.getAscent()));
        xPos += fontMetrics.stringWidth(displayText);
    }
}

