/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.TooltipDataItem;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.jdevimpl.java.JavaArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParameterDataItem
extends TooltipDataItem
implements Comparable {
    private JavaMethod method;
    private String[] parameters;
    private String parameterSignature;
    private String displayText;
    private int argumentIndex;

    ParameterDataItem(JavaMethod javaMethod, int inArgumentIndex) {
        this.method = javaMethod;
        this.displayText = null;
        this.argumentIndex = inArgumentIndex;
        this.buildParametersAndSignature(javaMethod);
    }

    int getParameterCount() {
        JavaClass enclosing = this.method.getOwningClass();
        int count = this.parameters.length;
        if (!this.method.isConstructor()) {
            return count;
        }
        boolean ignoreFirstParameter = !enclosing.isStatic() && enclosing.getOwningClass() != null;
        return ignoreFirstParameter ? count - 1 : count;
    }

    String getParameter(int index) {
        JavaClass enclosing = this.method.getOwningClass();
        if (!this.method.isConstructor()) {
            return this.parameters[index];
        }
        boolean ignoreFirstParameter = !enclosing.isStatic() && enclosing.getOwningClass() != null;
        return this.parameters[ignoreFirstParameter ? index + 1 : index];
    }

    int getArgumentIndex() {
        return this.argumentIndex;
    }

    String getParameterSignature() {
        return this.parameterSignature;
    }

    private void buildParametersAndSignature(JavaMethod methodItem) {
        Collection methodParameters = methodItem.getParameters();
        int numParameters = methodParameters.size();
        this.parameters = new String[numParameters];
        StringBuilder signatureBuf = new StringBuilder();
        StringBuffer buffer = new StringBuffer();
        Iterator things = methodParameters.iterator();
        int i = 0;
        while (i < numParameters) {
            buffer.setLength(0);
            JavaVariable item = (JavaVariable)things.next();
            String itemName = item.getName();
            JavaType type = item.getResolvedType();
            String itemType = type != null ? type.getUnqualifiedName() : "<unknown>";
            buffer.append(itemType);
            if (i > 0) {
                signatureBuf.append(", ");
            }
            signatureBuf.append(itemType);
            if (itemName != null && itemName.length() > 0) {
                buffer.append(" ");
                buffer.append(itemName);
            }
            this.parameters[i] = buffer.toString();
            ++i;
        }
        this.parameterSignature = signatureBuf.toString();
    }

    public String getDisplayText() {
        if (this.displayText == null) {
            int numParameters = this.getParameterCount();
            if (numParameters == 0) {
                this.displayText = JavaArb.getString(35);
            } else {
                StringBuffer buffer = new StringBuffer();
                String comma = "";
                int i = 0;
                while (i < numParameters) {
                    buffer.append(comma);
                    comma = ", ";
                    buffer.append(this.getParameter(i));
                    ++i;
                }
                this.displayText = buffer.toString();
            }
        }
        return this.displayText;
    }

    public boolean isDeprecated() {
        return this.method.isDeprecated();
    }

    public String toString() {
        return this.getDisplayText();
    }

    public int compareTo(Object object) {
        ParameterDataItem item2 = (ParameterDataItem)object;
        String name1 = this.getDisplayText();
        String name2 = item2.getDisplayText();
        return ListDataItem.compareInsensitive((String)name1, (String)name2);
    }
}

