/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ListModel;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.insight.TooltipDataItem;
import oracle.javatools.editor.insight.TooltipDataItemListModel;
import oracle.javatools.editor.insight.TooltipInsightData;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdevimpl.java.insight.AbstractCompletionInsightData;
import oracle.jdevimpl.java.insight.AnnotationDataItem;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.ParameterDataItem;
import oracle.jdevimpl.java.util.ExpressionFinder;
import oracle.jdevimpl.java.util.FoundSymbol;

final class ParameterInsightData
extends TooltipInsightData
implements JavaConstants,
CallerContext.Constants {
    private CallerContext callerContext;
    private InsightContext helper;
    private TooltipDataItemListModel tooltipListModel;
    protected TooltipDataItem[] tooltipDataList;
    protected FoundSymbol methodInvocation;
    protected int argumentIndex;
    private boolean isAnnotationInsight;
    static final TooltipDataItem[] kEmptyTooltipList = new TooltipDataItem[0];

    ParameterInsightData(InsightContext insight) {
        this.$init$();
        this.helper = insight;
        this.callerContext = insight.getCallerContext();
        this.fillInitialData();
    }

    public ListModel getListModel() {
        return this.buildListModel();
    }

    private TooltipDataItemListModel buildListModel() {
        if (this.tooltipListModel == null) {
            Arrays.sort(this.tooltipDataList);
            this.tooltipListModel = new TooltipDataItemListModel(this.tooltipDataList);
        }
        return this.tooltipListModel;
    }

    public Object[] getData() {
        return this.tooltipDataList;
    }

    private void $init$() {
        this.argumentIndex = -1;
    }

    private void clearData() {
        this.tooltipDataList = kEmptyTooltipList;
        this.tooltipListModel = null;
    }

    protected void fillInitialData() {
        this.updateData();
    }

    protected void updateData() {
        this.clearData();
        int[] returnIndex = new int[1];
        ExpressionFinder finder = this.helper.getFinder();
        int caretOffset = this.helper.getCaretPosition();
        this.methodInvocation = finder.determineArgumentInvocation(caretOffset, returnIndex);
        this.argumentIndex = returnIndex[0];
        if (this.methodInvocation == null) {
            return;
        }
        if (finder.isMethodDeclaration(this.methodInvocation)) {
            return;
        }
        if (finder.isAnnotation(this.methodInvocation)) {
            this.fillAnnotationData();
            this.isAnnotationInsight = true;
        } else {
            this.fillParameterData();
            this.isAnnotationInsight = false;
        }
    }

    private void fillAnnotationData() {
        SourceFile file = this.helper.getSourceFile();
        SourceAnnotation sa = null;
        SourceElement element = file.getElementAt(this.methodInvocation.startOffset);
        while (sa == null && element != null) {
            if (element instanceof SourceAnnotation) {
                sa = (SourceAnnotation)element;
            }
            element = element.getParent();
        }
        if (sa == null) {
            return;
        }
        int caretOffset = this.helper.getCaretPosition();
        String currentElementName = this.helper.getFinder().getAnnotationElementNameAtCursor(sa.getStartOffset(), caretOffset);
        JavaAnnotation a = (JavaAnnotation)sa.getCompiledObject();
        if (a == null) {
            return;
        }
        JavaType type = a.getAnnotationType();
        Map components = a.getComponents();
        if (type == null || type.getMethods() == null || components == null) {
            return;
        }
        ArrayList<AnnotationDataItem> annotationDataItemList = new ArrayList<AnnotationDataItem>();
        ArrayList<String> printBoldList = new ArrayList<String>();
        if (currentElementName != null) {
            String firstName = null;
            int nonDefaultElementCount = 0;
            for (JavaMethod m : type.getMethods()) {
                String key = m.getName();
                if (!components.containsKey(key)) continue;
                if (m.getDefaultValue() == null) {
                    ++nonDefaultElementCount;
                }
                if (firstName == null) {
                    firstName = key;
                }
                if (key.equals(currentElementName)) {
                    printBoldList.clear();
                    printBoldList.add(key);
                    break;
                }
                if (!key.toLowerCase().startsWith(currentElementName.toLowerCase())) continue;
                printBoldList.add(key);
            }
            if (firstName != null && printBoldList.isEmpty() && nonDefaultElementCount == 1) {
                printBoldList.add(firstName);
            }
        }
        for (JavaMethod m : type.getMethods()) {
            String key = m.getName();
            if (!components.containsKey(key)) continue;
            Object value = components.get(key);
            boolean printBold = printBoldList.contains(key);
            AnnotationDataItem item = new AnnotationDataItem(m, value, m.getDefaultValue(), printBold);
            annotationDataItemList.add(item);
        }
        int count = annotationDataItemList.size();
        if (count == 0) {
            AnnotationDataItem empty = new AnnotationDataItem();
            this.tooltipDataList = new TooltipDataItem[]{empty};
        } else {
            this.tooltipDataList = annotationDataItemList.toArray(new TooltipDataItem[count]);
        }
    }

    private void fillParameterData() {
        String invokeString = this.methodInvocation.string;
        int newIndex = -1;
        int index = 0;
        while (index < invokeString.length()) {
            newIndex = invokeString.indexOf("new", index);
            if (newIndex < 0 || newIndex + 3 < invokeString.length() && Character.isWhitespace(invokeString.charAt(newIndex + 3))) break;
            index = newIndex + 1;
        }
        int lastDot = newIndex < 0 ? invokeString.lastIndexOf(46) : invokeString.lastIndexOf(46, newIndex);
        JavaHasType lhs = null;
        if (lastDot != -1) {
            SourceFactory factory;
            SourceExpression e;
            TextBuffer textBuffer = this.helper.getTextBuffer();
            int startOffset = this.methodInvocation.startOffset;
            int endOffset = startOffset + lastDot;
            String inputText = textBuffer.getString(startOffset, endOffset - startOffset);
            SourceElement scope = this.callerContext.getSourceScope();
            SourceFile file = scope.getOwningSourceFile();
            if (file == null) {
                CommonUtilities.panic((String)"No SourceFile instance");
            }
            if ((e = (factory = file.getFactory()).createExpression(inputText)) == null) {
                return;
            }
            e.setContext(this.callerContext);
            lhs = e.getResolvedObject();
            if (lhs == null) {
                return;
            }
        }
        int firstIdentifier = lastDot + 1;
        while (!Character.isJavaIdentifierPart(invokeString.charAt(firstIdentifier))) {
            ++firstIdentifier;
        }
        CallerContext.InputOptions options = new CallerContext.InputOptions();
        if (!this.helper.getJavaInsightOptions().getShowDeprecated()) {
            options.squash = (byte)(options.squash | 0x10);
        }
        CallerContext.Output output = null;
        int length = invokeString.length();
        if (firstIdentifier == newIndex) {
            firstIdentifier += 4;
            while (!Character.isJavaIdentifierPart(invokeString.charAt(firstIdentifier))) {
                ++firstIdentifier;
            }
            String lastName = invokeString.substring(firstIdentifier);
            JavaType type = lhs == null ? this.callerContext.resolveTypeName(lastName) : this.callerContext.resolveTypeName(lhs, lastName);
            if (type != null) {
                output = this.callerContext.listMethods((JavaHasType)type, "<init>", null, options);
            }
        } else {
            String lastName = invokeString.substring(firstIdentifier);
            output = this.callerContext.listMethods(lhs, lastName, null, options);
        }
        if (output == null) {
            return;
        }
        ArrayList methods = output.all;
        if (methods.size() == 0) {
            return;
        }
        this.tooltipDataList = this.makeItems(methods);
    }

    private TooltipDataItem[] makeItems(ArrayList methods) {
        int length = methods.size();
        LinkedHashMap<String, ParameterDataItem> itemMap = new LinkedHashMap<String, ParameterDataItem>();
        int i = length - 1;
        while (i >= 0) {
            JavaMethod method = (JavaMethod)methods.get(i);
            ParameterDataItem item = new ParameterDataItem(method, this.argumentIndex);
            itemMap.put(item.getParameterSignature(), item);
            --i;
        }
        TooltipDataItem[] items = new ParameterDataItem[itemMap.size()];
        int count = items.length - 1;
        Iterator iter = itemMap.values().iterator();
        while (iter.hasNext()) {
            items[count--] = (ParameterDataItem)iter.next();
        }
        return items;
    }

    private static String removeInitialNew(String src) {
        return AbstractCompletionInsightData.removeInitialNew(src);
    }

    boolean isAnnotationInsight() {
        return this.isAnnotationInsight;
    }
}

