/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchStatement;
import oracle.javatools.parser.java.v2.util.filter.AssignableFilter;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.javatools.parser.java.v2.util.filter.OrFilter;
import oracle.jdevimpl.java.insight.AnnotationSymFilter;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.IntConstantFilter;

final class SmartInsightProvider
implements JavaConstants {
    private final InsightContext context;

    SmartInsightProvider(InsightContext context) {
        this.context = context;
    }

    private static SourceElement getLeftElem(SourceElement sourceElement, int offset) {
        int lStart = sourceElement.getStartOffset();
        if (offset <= lStart) {
            return null;
        }
        SourceElement ret = sourceElement;
        List children = sourceElement.getChildren();
        for (SourceElement child : children) {
            SourceElement candidate = SmartInsightProvider.getLeftElem(child, offset);
            if (candidate == null) continue;
            ret = candidate;
        }
        return ret;
    }

    private static String getAdjustedText(SourceElement el, int offs) {
        String res = el.getText();
        if (offs > el.getStartOffset() && offs < el.getEndOffset()) {
            res = res.substring(0, offs - el.getStartOffset());
        }
        return res;
    }

    private JavaFilter checkAssign(JavaHasType tp, String cmm) {
        if ((cmm = cmm.trim()).endsWith(";")) {
            return null;
        }
        if (cmm.endsWith(",")) {
            return null;
        }
        int equalsIndex = cmm.indexOf(61);
        if (equalsIndex != -1) {
            JavaType javaType;
            if (cmm.substring(equalsIndex + 1).trim().startsWith("new")) {
                boolean makeFilter;
                block11: {
                    boolean bl = makeFilter = (cmm = cmm.substring(equalsIndex + 1).trim().substring(3).trim()).length() == 0;
                    if (!makeFilter && Character.isJavaIdentifierStart(cmm.charAt(0))) {
                        int x = 1;
                        while (x < cmm.length()) {
                            char c = cmm.charAt(x);
                            if (c == '.' || Character.isJavaIdentifierPart(c)) {
                                ++x;
                                continue;
                            }
                            break block11;
                        }
                        makeFilter = true;
                    }
                }
                if (makeFilter) {
                    JavaType javaType2 = tp.getResolvedType();
                    return javaType2 == null ? null : new AssignableFilter(javaType2, 2);
                }
            } else {
                if (cmm.endsWith("[")) {
                    JavaClass intType = this.context.getProvider().getClass("int");
                    return new AssignableFilter((JavaType)intType, 1);
                }
                if (cmm.endsWith("(")) {
                    JavaType javaType3 = tp.getResolvedType();
                    return javaType3 == null ? null : new AssignableFilter(javaType3, 3);
                }
            }
            return (javaType = tp.getResolvedType()) == null ? null : new AssignableFilter(javaType, 1);
        }
        return null;
    }

    private JavaFilter lookForCaseLabel(SourceElement el) {
        SourceElement sel = el;
        JavaType switchType = null;
        while (sel != null) {
            if (sel.getSymbolKind() == 41) {
                SourceSwitchStatement sss = (SourceSwitchStatement)sel;
                switchType = sss.getControlExpression().getResolvedType();
                break;
            }
            sel = sel.getParent();
        }
        sel = el;
        while (sel != null) {
            SourceSwitchLabel lbl;
            if (sel.getSymbolKind() == 23 && (lbl = (SourceSwitchLabel)sel).getText().startsWith("case")) {
                if (switchType != null && switchType.isEnum()) {
                    return new AssignableFilter(switchType);
                }
                return new IntConstantFilter();
            }
            sel = sel.getParent();
        }
        return null;
    }

    private JavaFilter lookForDeclaration(SourceElement el, int offset) {
        SourceElement sel = el;
        SourceLocalVariable slv = null;
        while (sel != null) {
            if (sel.getSymbolKind() == 17) {
                slv = (SourceLocalVariable)sel;
            } else if (sel.getSymbolKind() == 18) {
                if (slv == null) {
                    return null;
                }
                SourceLocalVariableDeclaration sld = (SourceLocalVariableDeclaration)sel;
                SourceElement parent = sld.getParent();
                String dString = parent.getSymbolKind() == 38 ? SmartInsightProvider.getAdjustedText(parent, offset) : SmartInsightProvider.getAdjustedText((SourceElement)sld, offset);
                return this.checkAssign((JavaHasType)slv, dString);
            }
            sel = sel.getParent();
        }
        return null;
    }

    private JavaFilter lookForInfixExpression(SourceElement el, int offset) {
        SourceElement sel = el;
        while (sel != null) {
            if (sel.getSymbolKind() == 50) {
                SourceInfixExpression sif = (SourceInfixExpression)sel;
                switch (sif.getOperatorCode()) {
                    case 20: 
                    case 21: 
                    case 22: 
                    case 25: 
                    case 30: 
                    case 42: {
                        SourceExpression fop;
                        if (offset < sif.getEndOffset() || (fop = sif.getFirstOperand()) == null) break;
                        JavaType ttp = fop.getResolvedType();
                        return new AssignableFilter(ttp, 1);
                    }
                }
            }
            sel = sel.getParent();
        }
        return null;
    }

    private int getArgumentPosition(SourceListExpression slist, int offset) {
        int res = 0;
        int cur = 0;
        for (SourceElement el : slist.getOperands()) {
            if (el.getEndOffset() < offset) {
                res = cur;
            }
            ++cur;
        }
        String adjt = SmartInsightProvider.getAdjustedText((SourceElement)slist, offset).trim();
        if (adjt.endsWith(",")) {
            ++res;
        }
        return res;
    }

    private JavaFilter findPossibleParameterTypes(SourceListExpression sourceListExpression, JavaClass javaClass, String name, int parameterIndex, boolean isCast) {
        HashSet<JavaType> validTypes = new HashSet<JavaType>();
        while (javaClass != null) {
            Iterator it = name != null ? javaClass.getMethods(name).iterator() : javaClass.getDeclaredConstructors().iterator();
            while (it.hasNext()) {
                JavaMethod meth = (JavaMethod)it.next();
                JavaType[] parameterTypes = meth.getParameterTypes();
                if (parameterIndex >= parameterTypes.length) continue;
                boolean isok = true;
                int i = 0;
                while (i < parameterIndex) {
                    SourceExpression sourceExpression = sourceListExpression.getOperandAt(i);
                    JavaType resolvedType = sourceExpression.getResolvedType();
                    JavaType javaType = parameterTypes[i];
                    isok &= javaType.isAssignableFrom(resolvedType);
                    ++i;
                }
                if (!isok) continue;
                JavaType javaType = parameterTypes[parameterIndex];
                validTypes.add(javaType);
            }
            JavaType javaType = javaClass.getSuperclass();
            javaClass = name != null && javaType != null ? javaType.getTypeErasure() : null;
        }
        if (validTypes.isEmpty()) {
            return null;
        }
        JavaFilter[] filters = new JavaFilter[validTypes.size()];
        int require = isCast ? 2 : 1;
        int i = 0;
        for (JavaType javaType : validTypes) {
            filters[i++] = new AssignableFilter(javaType, require);
        }
        return new OrFilter(filters);
    }

    private JavaFilter lookForMethodParameter(SourceElement el, int offset) {
        SourceElement sel = el;
        SourceListExpression slist = null;
        while (sel != null) {
            if (sel.getSymbolKind() == 51) {
                if (offset <= sel.getEndOffset()) {
                    slist = (SourceListExpression)sel;
                }
            } else if ((sel.getSymbolKind() == 53 || sel.getSymbolKind() == 55) && offset < sel.getEndOffset()) {
                JavaClass cls;
                if (slist == null) {
                    return null;
                }
                int paramindex = this.getArgumentPosition(slist, offset);
                SourceExpression sex = slist.getOperandAt(paramindex);
                boolean inCast = false;
                if (sex != null && (sex.getSymbolKind() == 61 || sex.getSymbolKind() == 59) && offset < sex.getEndOffset()) {
                    inCast = true;
                }
                SourceInvokeExpression mcall = (SourceInvokeExpression)sel;
                String mname = null;
                if (mcall instanceof SourceMethodCallExpression) {
                    SourceMethodCallExpression smc = (SourceMethodCallExpression)mcall;
                    mname = smc.getName();
                    JavaHasType lhs = mcall.getResolvedLhs();
                    if (lhs != null) {
                        cls = lhs.getResolvedType().getTypeErasure();
                    } else {
                        SourceElement lel = sel;
                        while (lel != null && lel.getSymbolKind() != 3) {
                            lel = lel.getParent();
                        }
                        cls = (JavaClass)lel;
                    }
                } else {
                    SourceNewClassExpression scce = (SourceNewClassExpression)mcall;
                    cls = scce.getSourceType().getResolvedType().getTypeErasure();
                }
                return this.findPossibleParameterTypes(slist, cls, mname, paramindex, inCast);
            }
            sel = sel.getParent();
        }
        return null;
    }

    private JavaFilter lookForAssignment(SourceElement el, int offset) {
        SourceElement sel = el;
        JavaType assignmentType = null;
        boolean makeCheckAssign = false;
        while (sel != null) {
            if (sel.getSymbolKind() == 48) {
                assignmentType = ((SourceAssignmentExpression)sel).getResolvedType();
            } else if (sel.getSymbolKind() == 36 || sel.getSymbolKind() == 51) {
                if (assignmentType == null) {
                    return null;
                }
                makeCheckAssign = true;
            } else if ((sel.getSymbolKind() == 9 || sel.getSymbolKind() == 18) && (assignmentType = ((SourceVariableDeclaration)sel).getSourceType().getResolvedType()) != null) {
                makeCheckAssign = true;
            }
            if (makeCheckAssign) {
                String dString = SmartInsightProvider.getAdjustedText(sel, offset);
                return this.checkAssign((JavaHasType)assignmentType, dString);
            }
            sel = sel.getParent();
        }
        return null;
    }

    private JavaFilter lookForCast(SourceElement el, int offset) {
        SourceElement sel = el;
        while (sel != null) {
            if (sel.getSymbolKind() == 59) {
                if (offset >= sel.getEndOffset()) {
                    return null;
                }
                int off = sel.getStartOffset() + 1;
                if (off == offset) {
                    return null;
                }
                return this.filterInsightData(off);
            }
            sel = sel.getParent();
        }
        return null;
    }

    private JavaFilter lookForWrapper(SourceElement el, int offset) {
        SourceElement sel = el;
        while (sel != null) {
            if (sel.getSymbolKind() == 61) {
                int off;
                if (offset >= sel.getEndOffset()) {
                    return null;
                }
                SourceElement parent = sel.getParent();
                if (parent != null) {
                    if (parent.getSymbolKind() == 39 || parent.getSymbolKind() == 45) {
                        JavaClass booleanType = this.context.getProvider().getClass("boolean");
                        return new AssignableFilter((JavaType)booleanType, 1);
                    }
                    if (parent.getSymbolKind() == 41) {
                        JavaClass intType = this.context.getProvider().getClass("int");
                        return new AssignableFilter((JavaType)intType, 1);
                    }
                }
                if ((off = sel.getStartOffset() + 1) == offset) {
                    return null;
                }
                return this.filterInsightData(off);
            }
            sel = sel.getParent();
        }
        return null;
    }

    private JavaFilter lookForAnnotationSym(SourceElement el) {
        if (el.getSymbolKind() == 1 || el.getSymbolKind() == 20 && el.getParent() != null && el.getParent().getSymbolKind() == 1) {
            return new AnnotationSymFilter();
        }
        return null;
    }

    public JavaFilter filterInsightData() {
        return this.filterInsightData(this.context.getCaretPosition());
    }

    private JavaFilter filterInsightData(int curoffset) {
        SourceFile sf = this.context.getSourceFile();
        SourceElement el = SmartInsightProvider.getLeftElem((SourceElement)sf, curoffset);
        JavaFilter res = this.lookForInfixExpression(el, curoffset);
        if (res != null) {
            return res;
        }
        res = this.lookForMethodParameter(el, curoffset);
        if (res != null) {
            return res;
        }
        res = this.lookForCast(el, curoffset);
        if (res != null) {
            return res;
        }
        res = this.lookForWrapper(el, curoffset);
        if (res != null) {
            return res;
        }
        res = this.lookForDeclaration(el, curoffset);
        if (res != null) {
            return res;
        }
        res = this.lookForAssignment(el, curoffset);
        if (res != null) {
            return res;
        }
        res = this.lookForCaseLabel(el);
        if (res != null) {
            return res;
        }
        res = this.lookForAnnotationSym(el);
        if (res != null) {
            return res;
        }
        res = new 1();
        return res;
    }

    final class 1
    implements JavaFilter {
        public boolean accepts(JavaElement element) {
            return true;
        }
    }
}

