/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import javax.swing.Icon;
import oracle.javatools.parser.java.v2.common.QuickHasName;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.jdevimpl.java.insight.InsightDataItem;

public class WrappedInsightDataItem
extends InsightDataItem {
    protected String displayName;
    protected String displayType;
    protected String completionText;
    protected boolean deprecated;
    protected String declaringClass;
    protected Icon icon;
    private boolean isJavaElementProxy;

    public WrappedInsightDataItem(String displayName, String displayType, String completionText) {
        super((JavaElement)QuickHasName.createHasName((String)displayName));
        this.displayName = displayName;
        this.displayType = displayType;
        this.completionText = completionText;
        this.deprecated = false;
        this.declaringClass = null;
        this.isJavaElementProxy = false;
    }

    public WrappedInsightDataItem(JavaElement javaElement) {
        super(javaElement);
        this.isJavaElementProxy = true;
        this.completionText = null;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public void setDeclaringClass(String declaringClass) {
        this.declaringClass = declaringClass;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setCompletionText(String completionText) {
        this.completionText = completionText;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getName() {
        if (this.isJavaElementProxy && this.completionText == null) {
            return super.getName();
        }
        return this.completionText;
    }

    protected String getDisplayCellType() {
        if (this.isJavaElementProxy) {
            return super.getDisplayCellType();
        }
        return this.displayType;
    }

    protected String getDisplayCellName() {
        if (this.isJavaElementProxy && this.displayName == null) {
            return super.getDisplayCellName();
        }
        return this.displayName;
    }

    protected String getDisplayTextImpl() {
        if (this.isJavaElementProxy) {
            return super.getDisplayTextImpl();
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.displayType);
        buf.append(' ');
        buf.append(this.displayName);
        return buf.toString();
    }

    public Icon getIcon() {
        if (this.isJavaElementProxy) {
            return super.getIcon();
        }
        return this.icon;
    }

    public String declaringClass() {
        if (this.isJavaElementProxy) {
            return super.declaringClass();
        }
        return this.declaringClass;
    }

    public boolean isDeprecated() {
        if (this.isJavaElementProxy) {
            return super.isDeprecated();
        }
        return this.deprecated;
    }
}

