/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.usage;

import java.net.URL;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceBlockElement;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.util.Usages;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdeveloper.usage.event.UsageListener;
import oracle.jdevimpl.java.usage.ClassUsageQuery;
import oracle.jdevimpl.java.usage.ConstructorUsageQuery;
import oracle.jdevimpl.java.usage.FieldUsageQuery;
import oracle.jdevimpl.java.usage.MethodUsageQuery;

public abstract class BaseUsageQuery
extends Usages {
    private UsageEvent lastEvent;
    private final URL url;
    private final UsageListener listener;
    private final int[] startLocations;
    private final int[] endLocations;
    private int locationIndex;

    public static void findClassUsages(SourceFile file, UsageListener listener, int[] startLocations, int[] endLocations, String fqClassName) {
        URL url = file.getURL();
        ClassUsageQuery query = new ClassUsageQuery(url, listener, startLocations, endLocations, fqClassName);
        Usages.processUsages((SourceFile)file, (Usages)query);
    }

    public static void findConstructorUsages(SourceFile file, UsageListener listener, int[] startLocations, int[] endLocations, String fqClassName, String[] fqParameterTypes) {
        URL url = file.getURL();
        ConstructorUsageQuery query = new ConstructorUsageQuery(url, listener, startLocations, endLocations, fqClassName, fqParameterTypes);
        Usages.processUsages((SourceFile)file, (Usages)query);
    }

    public static void findFieldUsages(SourceFile file, UsageListener listener, int[] startLocations, int[] endLocations, String fqClassName, String fieldName) {
        URL url = file.getURL();
        FieldUsageQuery query = new FieldUsageQuery(url, listener, startLocations, endLocations, fqClassName, fieldName);
        Usages.processUsages((SourceFile)file, (Usages)query);
    }

    public static void findMethodUsages(SourceFile file, UsageListener listener, int[] startLocations, int[] endLocations, String fqClassName, String methodName, String[] fqParameterTypes) {
        URL url = file.getURL();
        MethodUsageQuery query = new MethodUsageQuery(url, listener, startLocations, endLocations, fqClassName, methodName, fqParameterTypes);
        Usages.processUsages((SourceFile)file, (Usages)query);
    }

    private void $init$() {
        this.lastEvent = null;
        this.locationIndex = 0;
    }

    BaseUsageQuery(URL url, UsageListener listener, int[] startLocations, int[] endLocations) {
        this.$init$();
        this.url = url;
        this.listener = listener;
        this.startLocations = startLocations;
        this.endLocations = endLocations;
    }

    final URL getURL() {
        return this.url;
    }

    final UsageListener getListener() {
        return this.listener;
    }

    final UsageEvent getLastEvent() {
        return this.lastEvent;
    }

    final void setLastEvent(UsageEvent event) {
        this.lastEvent = event;
    }

    abstract boolean match(JavaElement var1);

    abstract UsageEvent generateUsageEvent(int var1, int var2, int var3);

    public final boolean shouldTraverse(SourceElement element) {
        if (element instanceof SourceMember || element instanceof SourceBlockElement) {
            this.offsetAdvance(element);
        }
        return this.offsetFound(element);
    }

    final void processCandidate(SourceElement symbol, JavaElement subject, int category) {
        int[] startEnd = this.findLocation(symbol);
        if (startEnd == null) {
            return;
        }
        if (!this.match(subject)) {
            return;
        }
        int startOffset = startEnd[0];
        int endOffset = startEnd[1];
        UsageEvent event = this.generateUsageEvent(category, startOffset, endOffset);
        if (event != null) {
            this.setLastEvent(event);
        }
    }

    private int[] findLocation(SourceElement symbol) {
        if (this.startLocations == null || this.endLocations == null) {
            return null;
        }
        int symbolStart = symbol.getStartOffset();
        int symbolEnd = symbol.getEndOffset();
        int count = this.startLocations.length;
        int i = 0;
        while (i < count) {
            int start = this.startLocations[i];
            int end = this.endLocations[i];
            if (symbolStart <= start && end <= symbolEnd) {
                return new int[]{start, end};
            }
            ++i;
        }
        return null;
    }

    private final void offsetAdvance(SourceElement symbol) {
        int locationCount = this.startLocations.length;
        while (this.locationIndex < locationCount) {
            int offset = this.startLocations[this.locationIndex];
            if (symbol.getEndOffset() < offset) {
                return;
            }
            if (symbol.getStartOffset() <= offset) {
                return;
            }
            ++this.locationIndex;
        }
    }

    private final boolean offsetFound(SourceElement symbol) {
        int locationCount = this.startLocations.length;
        int index = this.locationIndex;
        while (index < locationCount) {
            int offset = this.startLocations[index];
            if (symbol.getEndOffset() < offset) {
                return false;
            }
            if (symbol.getStartOffset() <= offset) {
                return true;
            }
            ++index;
        }
        return false;
    }
}

