/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.usage;

import java.lang.reflect.Modifier;
import java.net.URL;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.usage.event.FieldUsageEvent;
import oracle.jdeveloper.usage.event.FieldUsageListener;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdeveloper.usage.event.UsageListener;
import oracle.jdevimpl.java.usage.BaseUsageQuery;

class FieldUsageQuery
extends BaseUsageQuery {
    protected final String targetClassName;
    protected final String targetFieldName;

    FieldUsageQuery(URL url, UsageListener listener, int[] startLocations, int[] endLocations, String fqClassName, String fieldName) {
        super(url, listener, startLocations, endLocations);
        this.targetClassName = fqClassName;
        this.targetFieldName = fieldName;
    }

    protected boolean match(JavaElement element) {
        JavaField field = (JavaField)element;
        String fieldName = field.getName();
        if (!fieldName.equals(this.targetFieldName)) {
            return false;
        }
        JavaClass owningClass = field.getOwningClass();
        if (owningClass == null) {
            return false;
        }
        int modifiers = field.getModifiers();
        boolean isStatic = Modifier.isStatic(modifiers);
        String owningClassName = owningClass.getRawName();
        if (this.targetClassName.equals(owningClassName)) {
            return true;
        }
        if (isStatic) {
            return false;
        }
        for (JavaType type : owningClass.getHierarchy()) {
            String name = type.getRawName();
            if (!this.targetClassName.equals(name)) continue;
            return true;
        }
        return false;
    }

    protected UsageEvent generateUsageEvent(int category, int startOffset, int endOffset) {
        FieldUsageEvent event = new FieldUsageEvent(null, category, this.getURL(), startOffset, endOffset);
        boolean swallowEvent = false;
        if (swallowEvent) {
            return null;
        }
        FieldUsageListener listener = (FieldUsageListener)this.getListener();
        listener.notifyFieldUsage(event);
        return event;
    }

    public void declareField(SourceFieldVariable s) {
        this.processCandidate((SourceElement)s, (JavaElement)s, 201);
    }

    public void useFieldInDocComment(SourceDocReference s, JavaField field) {
    }

    public void useFieldInExpression(SourceExpression s, JavaField field) {
        this.processCandidate((SourceElement)s, (JavaElement)field, 202);
    }
}

