/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.util;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JComponent;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.peek.CodePeek;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;

public class JavaCodePeek {
    public static CodePeek createCodePeek(JComponent comp, String fileName, String text, String labelText, Rectangle rect) {
        CodePeek peek = null;
        peek = new CodePeek(comp, fileName);
        rect.grow(1, 0);
        rect.translate(-1, -1);
        rect.x = Math.max(rect.x, 0);
        rect.y = Math.max(rect.y, 0);
        peek.setRectangle(rect);
        peek.setText(text);
        peek.setLabelText(labelText);
        return peek;
    }

    public static CodePeek createCodePeek(JComponent comp, SourceElement se, Rectangle rect) {
        String fileName = se.getOwningSourceFile().getFile().getURL().toExternalForm();
        String text = JavaCodePeek.getPeekText(se);
        String labelText = se.getOwningSourceFile().getSourcePrimaryClass().getQualifiedName();
        CodePeek peek = JavaCodePeek.createCodePeek(comp, fileName, text, labelText, rect);
        return peek;
    }

    public static void showPeek(CodePeek peek) {
        peek.showPeek(Ide.getMainWindow().getLayeredPane());
    }

    public static String getPeekText(Project project, URL url, int line, int padLines) {
        JavaManager jm;
        SourceFile sf;
        String text = null;
        if (project != null && (sf = (jm = JavaManager.getInstance((Project)project)).getSourceFile(url)) != null) {
            TextBuffer tb = sf.getTextBuffer();
            tb.readLock();
            try {
                int sOff = tb.getLineMap().getLineStartOffset(Math.max(0, line - padLines));
                int eOff = tb.getLineMap().getLineEndOffset(Math.min(line + padLines, tb.getLineMap().getLineCount() - 1));
                text = sf.getTextBuffer().getString(sOff, eOff - sOff - 1);
            }
            finally {
                tb.readUnlock();
            }
        }
        if (text == null) {
            JavaCodePeek.getPeekText(url, line, padLines);
        }
        return text;
    }

    public static CodePeek createCodePeek(Project project, URL url, int line, String labelText, JComponent comp, Rectangle rect, String styleName) {
        int pad = 4;
        String text = JavaCodePeek.getPeekText(project, url, --line, pad);
        CodePeek peek = JavaCodePeek.createCodePeek(comp, url.getFile(), text, labelText, rect);
        HighlightLayer hl = peek.getEditor().createHighlightLayer();
        int hiLine = line < pad ? line : pad;
        EditorProperties properties = EditorProperties.getProperties();
        HighlightStyle style = properties.getHighlightRegistry().lookupStyle(styleName);
        hl.addLineHighlight(style, hiLine);
        return peek;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPeekText(URL url, int line, int padLines) {
        if (url == null) {
            return null;
        }
        for (Object e : EditorManager.getEditorManager().getAllEditors()) {
            Node node;
            CodeEditor editor;
            Context context;
            if (!(e instanceof CodeEditor) || (context = (editor = (CodeEditor)e).getContext()) == null || (node = context.getNode()) == null || !node.getURL().equals(url)) continue;
            Project project = context.getProject();
            return JavaCodePeek.getPeekText(project, url, line, padLines);
        }
        Reader r = null;
        String text = null;
        try {
            try {
                r = new FileReader(new File(url.toURI()));
                r = new BufferedReader(r);
                int firstLine = Math.max(0, line - padLines);
                int lastLine = line + padLines;
                int curLine = 0;
                String aLine = ((BufferedReader)r).readLine();
                while (aLine != null) {
                    if (curLine > lastLine) {
                        return text;
                    }
                    if (curLine >= firstLine && curLine <= lastLine) {
                        text = text + aLine;
                    }
                    ++curLine;
                    aLine = ((BufferedReader)r).readLine();
                }
                return text;
            }
            catch (FileNotFoundException e) {
                return text;
            }
            catch (URISyntaxException e) {
                return text;
            }
            catch (IOException e) {
                return text;
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static String getPeekText(SourceElement se) {
        switch (se.getSymbolKind()) {
            case 10: 
            case 17: {
                se = se.getParent();
                break;
            }
        }
        return se.getText();
    }
}

