/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.javadoc.JProjectJavadoc;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.javadoc.JavadocArb;

public class JavadocConfigPanel
extends ProjectSettingsTraversablePanel {
    private GridBagLayout gbLayout;
    private JButton btnDir;
    private JCheckBox chkAuthor;
    private JCheckBox chkDeprecated;
    private JCheckBox chkIndex;
    private JCheckBox chkNavBar;
    private JCheckBox chkSince;
    private JCheckBox chkTree;
    private JCheckBox chkVersion;
    private JComboBox cmbScope;
    private JLabel lblDir;
    private JLabel lblMisc;
    private JLabel lblMiscExplanation;
    private JLabel lblScope;
    private JPanel pnlGenerate;
    private JPanel pnlTags;
    private JTextField fldMisc;
    private URLTextField fldDir;
    private static final String[] PROPERTY_KEYS = new String[]{"outputDirectory", "scope", "generateVersion", "generateAuthor", "generateSince", "generateDeprecated", "generateIndex", "generateTree", "generateNavbar", "miscOptions"};
    private static final String PUBLIC_OPTION = JavadocArb.getString(47);
    private static final String PROTECTED_OPTION = JavadocArb.getString(70);
    private static final String PACKAGE_OPTION = JavadocArb.getString(68);
    private static final String PRIVATE_OPTION = JavadocArb.getString(36);

    private void $init$() {
        this.gbLayout = new GridBagLayout();
        this.btnDir = new JButton();
        this.chkAuthor = new JCheckBox();
        this.chkDeprecated = new JCheckBox();
        this.chkIndex = new JCheckBox();
        this.chkNavBar = new JCheckBox();
        this.chkSince = new JCheckBox();
        this.chkTree = new JCheckBox();
        this.chkVersion = new JCheckBox();
        this.cmbScope = new JComboBox();
        this.lblDir = new JLabel();
        this.lblMisc = new JLabel();
        this.lblMiscExplanation = new JLabel();
        this.lblScope = new JLabel();
        this.pnlGenerate = new JPanel();
        this.pnlTags = new JPanel();
        this.fldMisc = new JTextField();
        this.fldDir = new URLTextField(null, true);
    }

    public JavadocConfigPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.lblDir, (Component)this.fldDir, (String)JavadocArb.getString(92));
        ResourceUtils.resButton((AbstractButton)this.btnDir, (String)JavadocArb.getString(86));
        ResourceUtils.resLabel((JLabel)this.lblScope, (Component)this.cmbScope, (String)JavadocArb.getString(11));
        ResourceUtils.resButton((AbstractButton)this.chkVersion, (String)"@v&ersion");
        ResourceUtils.resButton((AbstractButton)this.chkAuthor, (String)"@auth&or");
        ResourceUtils.resButton((AbstractButton)this.chkSince, (String)"@&since");
        ResourceUtils.resButton((AbstractButton)this.chkDeprecated, (String)"@dep&recated");
        ResourceUtils.resButton((AbstractButton)this.chkIndex, (String)JavadocArb.getString(31));
        ResourceUtils.resButton((AbstractButton)this.chkTree, (String)JavadocArb.getString(29));
        ResourceUtils.resButton((AbstractButton)this.chkNavBar, (String)JavadocArb.getString(77));
        ResourceUtils.resLabel((JLabel)this.lblMisc, (Component)this.fldMisc, (String)JavadocArb.getString(26));
        this.lblMiscExplanation.setText(JavadocArb.getString(46));
        this.btnDir.addActionListener((ActionListener)this.fldDir);
        this.pnlTags.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(JavadocArb.getString(35)), BorderFactory.createEmptyBorder(0, 8, 8, 8)));
        this.pnlTags.setLayout(this.gbLayout);
        Insets empty = new Insets(0, 0, 0, 0);
        this.pnlTags.add((Component)this.chkVersion, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, empty, 0, 0));
        this.pnlTags.add((Component)this.chkAuthor, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, empty, 0, 0));
        this.pnlTags.add((Component)this.chkSince, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, empty, 0, 0));
        this.pnlTags.add((Component)this.chkDeprecated, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, empty, 10, 0));
        this.pnlGenerate.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(JavadocArb.getString(20)), BorderFactory.createEmptyBorder(0, 8, 8, 8)));
        this.pnlGenerate.setLayout(this.gbLayout);
        this.pnlGenerate.add((Component)this.chkIndex, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, empty, 0, 0));
        this.pnlGenerate.add((Component)this.chkTree, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, empty, 0, 0));
        this.pnlGenerate.add((Component)this.chkNavBar, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, empty, 0, 0));
        this.setLayout(this.gbLayout);
        Insets leftCol = new Insets(0, 0, 0, 8);
        Insets rightCol = new Insets(0, 0, 0, 0);
        this.add(this.lblDir, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, leftCol, 0, 0));
        this.add((Component)this.fldDir, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, leftCol, 0, 0));
        this.add(this.btnDir, new GridBagConstraints(3, -1, 1, 1, 0.0, 0.0, 17, 0, rightCol, 0, 0));
        leftCol.top = 5;
        rightCol.top = 5;
        this.add(this.lblScope, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, leftCol, 0, 0));
        this.add(this.cmbScope, new GridBagConstraints(1, -1, 3, 1, 0.0, 0.0, 17, 0, rightCol, 10, 0));
        leftCol.top = 10;
        rightCol.top = 10;
        this.add(this.pnlTags, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 1, leftCol, 0, 0));
        this.add(this.pnlGenerate, new GridBagConstraints(2, -1, 2, 1, 1.0, 0.0, 17, 1, rightCol, 0, 0));
        leftCol.bottom = 2;
        this.add(this.lblMisc, new GridBagConstraints(0, -1, 4, 1, 0.0, 0.0, 17, 0, leftCol, 0, 0));
        leftCol.top = 0;
        this.add(this.fldMisc, new GridBagConstraints(0, -1, 4, 1, 0.0, 0.0, 18, 2, leftCol, 0, 0));
        this.add(this.lblMiscExplanation, new GridBagConstraints(0, -1, 4, 1, 0.0, 1.0, 18, 2, empty, 0, 0));
    }

    public String getDataKey() {
        return JProjectJavadoc.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        Project proj = (Project)tc.find("Project");
        JProjectJavadoc javadocSettings = JavadocConfigPanel.getJProjectJavadoc(tc, proj);
        boolean isDefaultProject = JavadocConfigPanel.isDefaultProject((Namespace)tc);
        boolean isUserProperties = JavadocConfigPanel.editingUserProperties((Namespace)tc);
        this.setHelpID(isDefaultProject ? "f1_run_ppdefault_javadoc_html" : "f1_run_ppcustom_javadoc_html");
        this.loadFrom(javadocSettings, proj, isDefaultProject, isUserProperties);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        boolean isDefaultProject = JavadocConfigPanel.isDefaultProject((Namespace)tc);
        boolean isUserProperties = JavadocConfigPanel.editingUserProperties((Namespace)tc);
        Project proj = (Project)tc.find("Project");
        JProjectJavadoc doc = JavadocConfigPanel.getJProjectJavadoc(tc, proj);
        this.commitTo(doc, isDefaultProject, isUserProperties);
    }

    private static JProjectJavadoc getJProjectJavadoc(TraversableContext tc, Project proj) {
        PropertyStorage propertyData = JavadocConfigPanel.getPropertyData((Namespace)tc);
        return JProjectJavadoc.getInstance(propertyData, proj.getURL());
    }

    private void loadFrom(JProjectJavadoc doc, Project proj, boolean isDefaultProject, boolean editingUserData) {
        URL outDir = doc.getOutputDirectory();
        if (outDir == null && !editingUserData) {
            URL dir = URLFileSystem.getParent((URL)proj.getURL());
            outDir = URLFactory.newDirURL((URL)dir, (String)"javadoc");
        }
        if (isDefaultProject) {
            URL defaultProjectDir = URLFileSystem.getParent((URL)Ide.getDefaultProject().getURL());
            this.fldDir.setBaseURL(defaultProjectDir);
        } else {
            this.fldDir.setBaseURL(null);
        }
        this.fldDir.setURL(outDir);
        this.btnDir.setVisible(isDefaultProject ^ true);
        NonNullableComboBoxModel model = new NonNullableComboBoxModel();
        model.addElement((Object)PUBLIC_OPTION);
        model.addElement((Object)PROTECTED_OPTION);
        model.addElement((Object)PACKAGE_OPTION);
        model.addElement((Object)PRIVATE_OPTION);
        this.cmbScope.setModel(model);
        String scope = doc.getScope();
        if ("-public".equals(scope)) {
            this.cmbScope.setSelectedItem(PUBLIC_OPTION);
        } else if ("-package".equals(scope)) {
            this.cmbScope.setSelectedItem(PACKAGE_OPTION);
        } else if ("-private".equals(scope)) {
            this.cmbScope.setSelectedItem(PRIVATE_OPTION);
        } else {
            this.cmbScope.setSelectedItem(PROTECTED_OPTION);
        }
        this.chkAuthor.setSelected(doc.isGenerateAuthor());
        this.chkVersion.setSelected(doc.isGenerateVersion());
        this.chkSince.setSelected(doc.isGenerateSince());
        this.chkDeprecated.setSelected(doc.isGenerateDeprecated());
        this.chkIndex.setSelected(doc.isGenerateIndex());
        this.chkTree.setSelected(doc.isGenerateTree());
        this.chkNavBar.setSelected(doc.isGenerateNavbar());
        this.fldMisc.setText(doc.getMiscOptions());
    }

    private void commitTo(JProjectJavadoc doc, boolean isDefaultProject, boolean userData) throws TraversalException {
        URL dirURL = this.fldDir.getURL();
        if (isDefaultProject) {
            URL defaultProjectDir = URLFileSystem.getParent((URL)Ide.getDefaultProject().getURL());
            if (dirURL == null || URLFileSystem.toRelativeSpec((URL)dirURL, (URL)defaultProjectDir, (boolean)true) == null) {
                throw new TraversalException(JProjectArb.format((int)149, (Object)JProjectArb.getString((int)139), (Object)this.fldDir.getText().trim()));
            }
        } else if (dirURL == null) {
            String txt = this.fldDir.getText().trim();
            if (ModelUtil.hasLength((String)txt)) {
                String msg = JProjectArb.format((int)16, (Object)txt);
                throw new TraversalException(msg, JavadocArb.getString(44));
            }
            if (!userData) {
                String msg = JavadocArb.getString(23);
                throw new TraversalException(msg, JavadocArb.getString(44));
            }
        } else if (!URLFileSystem.canCreate((URL)dirURL)) {
            String msg = JProjectArb.format((int)16, (Object)this.fldDir.getText().trim());
            throw new TraversalException(msg, JavadocArb.getString(44));
        }
        if (ModelUtil.areDifferent((Object)doc.getOutputDirectory(), (Object)dirURL)) {
            doc.setOutputDirectory(URLFileSystem.canonicalize((URL)dirURL));
        }
        Object sel = this.cmbScope.getSelectedItem();
        if (!doc.getScope().equals(sel)) {
            String scope;
            if (PUBLIC_OPTION.equals(sel)) {
                scope = "-public";
            } else if (PROTECTED_OPTION.equals(sel)) {
                scope = "-protected";
            } else if (PACKAGE_OPTION.equals(sel)) {
                scope = "-package";
            } else if (PRIVATE_OPTION.equals(sel)) {
                scope = "-private";
            } else {
                throw new TraversalException(JavadocArb.format(52, sel));
            }
            doc.setScope(scope);
        }
        doc.setGenerateAuthor(this.chkAuthor.isSelected());
        doc.setGenerateSince(this.chkSince.isSelected());
        doc.setGenerateVersion(this.chkVersion.isSelected());
        doc.setGenerateDeprecated(this.chkDeprecated.isSelected());
        doc.setGenerateIndex(this.chkIndex.isSelected());
        doc.setGenerateTree(this.chkTree.isSelected());
        doc.setGenerateNavbar(this.chkNavBar.isSelected());
        doc.setMiscOptions(this.fldMisc.getText());
    }
}

