/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.javadoc.JavadocSettings;
import oracle.jdeveloper.javadoc.TagDescriptor;
import oracle.jdevimpl.javadoc.JavadocArb;

public class JavadocOptionsPanel
extends DefaultTraversablePanel {
    private JButton _addButton;
    private JButton _downButton;
    private JButton _removeButton;
    private JButton _upButton;
    private JCheckBox _hasFieldScope;
    private JCheckBox _hasMethodScope;
    private JCheckBox _hasClassScope;
    private JCheckBox _isRequired;
    private JLabel _templateLabel;
    private JLabel _listLabel;
    private JWrappedLabel _previewLabel;
    private JLabel _previewItemLabel;
    private JLabel _usageLabel;
    private JLabel _tagNameLabel;
    private JLabel _tagPropertiesLabel;
    private JList _tagList;
    private JScrollPane _scroller;
    private JTextField _templateText;
    private JTextField _tagNameText;
    private JLabel _feedbackLabel;
    private TagDescriptor _selectedTD;
    private TagListModel _listModel;
    private boolean _listIsUpdating;
    private boolean _modelIsUpdating;

    public JavadocOptionsPanel() {
        this.setHelpID("f1_jed_javadoc_prefs_html");
        this.initializeComponent();
        this.addListeners();
    }

    public void onEntry(TraversableContext tc) {
        JavadocSettings options = this.findOptions(tc);
        this.loadSettingsFrom(options);
        this._tagList.setSelectedIndex(0);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        JavadocSettings options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private JavadocSettings findOptions(TraversableContext tc) {
        JavadocSettings options = (JavadocSettings)tc.find("JavadocSettings");
        return options;
    }

    void loadSettingsFrom(JavadocSettings options) {
        ArrayList tags = (ArrayList)options.getTagList();
        this._listModel = new TagListModel(tags);
        this._tagList.setModel(this._listModel);
    }

    void saveSettingsTo(JavadocSettings options) throws TraversalException {
        ListModel model = this._tagList.getModel();
        int size = model.getSize();
        ArrayList<TagDescriptor> tags = new ArrayList<TagDescriptor>(size);
        int i = 0;
        while (i < size) {
            TagDescriptor tagDescriptor = (TagDescriptor)model.getElementAt(i);
            if (tagDescriptor.getName().length() > 1) {
                tags.add(tagDescriptor);
            }
            ++i;
        }
        options.setTagList(tags);
    }

    private void addListeners() {
        InteractionListener _interactionListener = new InteractionListener(null);
        this._tagList.addListSelectionListener(_interactionListener);
        this._tagNameText.getDocument().addDocumentListener(_interactionListener);
        this._templateText.getDocument().addDocumentListener(_interactionListener);
        this._hasMethodScope.addItemListener(_interactionListener);
        this._hasFieldScope.addItemListener(_interactionListener);
        this._hasClassScope.addItemListener(_interactionListener);
        this._isRequired.addItemListener(_interactionListener);
        this._addButton.addActionListener(_interactionListener);
        this._removeButton.addActionListener(_interactionListener);
        this._upButton.addActionListener(_interactionListener);
        this._downButton.addActionListener(_interactionListener);
    }

    private void initializeComponent() {
        this._listLabel = new JLabel();
        this._tagList = new JList();
        this._tagList.setSelectionMode(0);
        ResourceUtils.resLabel((JLabel)this._listLabel, (Component)this._tagList, (String)JavadocArb.getString(34));
        this._scroller = new JScrollPane();
        this._scroller.getViewport().add(this._tagList);
        this._tagPropertiesLabel = new JLabel(JavadocArb.getString(1));
        this._tagNameLabel = new JLabel();
        this._tagNameText = new JTextField();
        ResourceUtils.resLabel((JLabel)this._tagNameLabel, (Component)this._tagNameText, (String)JavadocArb.getString(16));
        this._feedbackLabel = new JLabel();
        this._feedbackLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this._templateText = new JTextField();
        this._templateLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._templateLabel, (Component)this._templateText, (String)JavadocArb.getString(107));
        this._previewLabel = new JWrappedLabel();
        this._previewItemLabel = new JLabel(JavadocArb.getString(33));
        this._isRequired = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._isRequired, (String)JavadocArb.getString(51));
        this._usageLabel = new JLabel(JavadocArb.getString(2));
        this._hasMethodScope = new JCheckBox();
        this._hasFieldScope = new JCheckBox();
        this._hasClassScope = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._hasMethodScope, (String)JavadocArb.getString(110));
        ResourceUtils.resButton((AbstractButton)this._hasFieldScope, (String)JavadocArb.getString(105));
        ResourceUtils.resButton((AbstractButton)this._hasClassScope, (String)JavadocArb.getString(101));
        this._addButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._addButton, (String)JavadocArb.getString(89));
        this._removeButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._removeButton, (String)JavadocArb.getString(27));
        JavadocOptionsPanel.ensureSameWidth(new JButton[]{this._addButton, this._removeButton});
        this._upButton = JavadocOptionsPanel.createIconicButton(OracleIcons.getIcon((String)"up.png"), JavadocArb.getString(22));
        this._downButton = JavadocOptionsPanel.createIconicButton(OracleIcons.getIcon((String)"down.png"), JavadocArb.getString(54));
        JPanel tagListPanel = new JPanel(new GridBagLayout());
        tagListPanel.add((Component)this._listLabel, new GridBagConstraints(0, -1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        tagListPanel.add((Component)this._scroller, new GridBagConstraints(0, -1, 2, 2, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        tagListPanel.add((Component)this._addButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        tagListPanel.add((Component)this._removeButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 0, 0), 0, 0));
        tagListPanel.add((Component)this._upButton, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 0), 0, 0));
        tagListPanel.add((Component)this._downButton, new GridBagConstraints(2, -1, 1, 1, 0.0, 1.0, 11, 2, new Insets(0, 5, 5, 0), 0, 0));
        JPanel tagPropertiesPanel = new JPanel(new GridBagLayout());
        tagPropertiesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        tagPropertiesPanel.add((Component)this._tagNameLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._tagNameText, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._feedbackLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 5, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._usageLabel, new GridBagConstraints(1, 2, 1, 4, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._hasFieldScope, new GridBagConstraints(2, 2, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._hasMethodScope, new GridBagConstraints(2, 3, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._hasClassScope, new GridBagConstraints(2, 4, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._isRequired, new GridBagConstraints(2, 5, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._templateLabel, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._templateText, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._previewItemLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._previewLabel, new GridBagConstraints(1, 8, 2, 1, 1.0, 1.0, 18, 1, new Insets(2, 0, 0, 0), 0, 0));
        JPanel propPanel = new JPanel(new BorderLayout(0, 2));
        propPanel.add((Component)this._tagPropertiesLabel, "North");
        propPanel.add((Component)tagPropertiesPanel, "Center");
        this.setLayout(new BorderLayout(5, 5));
        this.add(tagListPanel, "West");
        this.add(propPanel, "Center");
    }

    protected void updateNameAndTemplate() {
        String name = this._tagNameText.getText().trim();
        if (!name.startsWith("@")) {
            name = "@" + name;
        }
        if (this._selectedTD.isCustom()) {
            boolean tagIsDuplicate = false;
            if ("@exception".equals(name)) {
                this._feedbackLabel.setText(JavadocArb.format(64, name));
                tagIsDuplicate = true;
            } else {
                int i = 0;
                while (i < (this._listModel != null ? this._listModel.getSize() : 0)) {
                    TagDescriptor descriptor = (TagDescriptor)this._listModel.getElementAt(i);
                    if (descriptor != this._selectedTD && descriptor.getName().equals(name)) {
                        this._feedbackLabel.setText(JavadocArb.format(48, name));
                        tagIsDuplicate = true;
                        break;
                    }
                    ++i;
                }
            }
            if (tagIsDuplicate) {
                this._feedbackLabel.setVisible(true);
                this._tagNameText.setText(this._selectedTD.getName());
                return;
            }
        }
        this._feedbackLabel.setVisible(false);
        this._selectedTD.setName(name);
        String template = this._templateText.getText();
        this._selectedTD.setTemplate(template);
        this._previewLabel.setText(name + " " + template);
    }

    private static void ensureSameWidth(JButton[] buttons) {
        if (buttons.length < 2) {
            return;
        }
        Dimension d = buttons[0].getPreferredSize();
        int width = d.width;
        int i = 1;
        while (i < buttons.length) {
            width = Math.max(width, buttons[i].getPreferredSize().width);
            ++i;
        }
        int i2 = 0;
        while (i2 < buttons.length) {
            buttons[i2].setPreferredSize(new Dimension(width, d.height));
            ++i2;
        }
    }

    private static JButton createIconicButton(Icon icon, String accessibleLabel) {
        JButton button = new JButton();
        button.setIcon(icon);
        button.getAccessibleContext().setAccessibleName(accessibleLabel);
        button.setEnabled(false);
        button.setMargin(new Insets(2, 0, 2, 0));
        return button;
    }

    static boolean ra$_modelIsUpdating(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._modelIsUpdating;
    }

    static void wa$_listIsUpdating(JavadocOptionsPanel javadocOptionsPanel, boolean bl) {
        javadocOptionsPanel._listIsUpdating = bl;
    }

    static JList ra$_tagList(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._tagList;
    }

    static void wa$_selectedTD(JavadocOptionsPanel javadocOptionsPanel, TagDescriptor tagDescriptor) {
        javadocOptionsPanel._selectedTD = tagDescriptor;
    }

    static TagDescriptor ra$_selectedTD(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._selectedTD;
    }

    static JTextField ra$_tagNameText(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._tagNameText;
    }

    static JTextField ra$_templateText(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._templateText;
    }

    static JCheckBox ra$_hasFieldScope(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._hasFieldScope;
    }

    static JCheckBox ra$_hasMethodScope(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._hasMethodScope;
    }

    static JCheckBox ra$_hasClassScope(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._hasClassScope;
    }

    static JCheckBox ra$_isRequired(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._isRequired;
    }

    static JButton ra$_removeButton(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._removeButton;
    }

    static JLabel ra$_templateLabel(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._templateLabel;
    }

    static JButton ra$_upButton(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._upButton;
    }

    static TagListModel ra$_listModel(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._listModel;
    }

    static JButton ra$_downButton(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._downButton;
    }

    static boolean ra$_listIsUpdating(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._listIsUpdating;
    }

    static JButton ra$_addButton(JavadocOptionsPanel javadocOptionsPanel) {
        return javadocOptionsPanel._addButton;
    }

    static void wa$_modelIsUpdating(JavadocOptionsPanel javadocOptionsPanel, boolean bl) {
        javadocOptionsPanel._modelIsUpdating = bl;
    }

    private final class InteractionListener
    implements ActionListener,
    DocumentListener,
    ItemListener,
    ListSelectionListener {
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == JavadocOptionsPanel.ra$_addButton(JavadocOptionsPanel.this)) {
                String newTag = JavadocArb.getString(37);
                TagDescriptor td = new TagDescriptor(newTag, 15, 1);
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, true);
                JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).addElement(td);
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, false);
                JavadocOptionsPanel.ra$_tagList(JavadocOptionsPanel.this).setSelectedValue(td, true);
                JavadocOptionsPanel.ra$_tagNameText(JavadocOptionsPanel.this).requestFocus();
            } else if (o == JavadocOptionsPanel.ra$_removeButton(JavadocOptionsPanel.this)) {
                int index = JavadocOptionsPanel.ra$_tagList(JavadocOptionsPanel.this).getSelectedIndex();
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, true);
                JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).removeElement(JavadocOptionsPanel.ra$_tagList(JavadocOptionsPanel.this).getSelectedValue());
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, false);
                int elementCount = JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).getSize();
                if (index == 0 || index < elementCount) {
                    JavadocOptionsPanel.ra$_tagList(JavadocOptionsPanel.this).setSelectedIndex(index);
                } else if (index >= elementCount) {
                    JavadocOptionsPanel.ra$_tagList(JavadocOptionsPanel.this).setSelectedIndex(elementCount - 1);
                }
            } else if (o == JavadocOptionsPanel.ra$_upButton(JavadocOptionsPanel.this)) {
                TagDescriptor td = (TagDescriptor)JavadocOptionsPanel.ra$_tagList(JavadocOptionsPanel.this).getSelectedValue();
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, true);
                JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).moveUp(td);
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, false);
                JavadocOptionsPanel.ra$_tagList(JavadocOptionsPanel.this).setSelectedIndex(JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).indexOf(td));
            } else if (o == JavadocOptionsPanel.ra$_downButton(JavadocOptionsPanel.this)) {
                TagDescriptor td = (TagDescriptor)JavadocOptionsPanel.ra$_tagList(JavadocOptionsPanel.this).getSelectedValue();
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, true);
                JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).moveDown(td);
                JavadocOptionsPanel.wa$_modelIsUpdating(JavadocOptionsPanel.this, false);
                JavadocOptionsPanel.ra$_tagList(JavadocOptionsPanel.this).setSelectedIndex(JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).indexOf(td));
            }
        }

        public void changedUpdate(DocumentEvent e) {
            this.upateName(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.upateName(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.upateName(e);
        }

        private void upateName(DocumentEvent de) {
            if (!JavadocOptionsPanel.ra$_listIsUpdating(JavadocOptionsPanel.this)) {
                DocumentEvent.ElementChange elementChange = de.getChange(de.getDocument().getDefaultRootElement());
                System.out.println(elementChange);
                JavadocOptionsPanel.this.updateNameAndTemplate();
                JavadocOptionsPanel.ra$_tagList(JavadocOptionsPanel.this).setSelectedValue(JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this), true);
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (JavadocOptionsPanel.ra$_listIsUpdating(JavadocOptionsPanel.this)) {
                return;
            }
            JCheckBox cb = (JCheckBox)e.getSource();
            boolean selected = cb.isSelected();
            if (cb == JavadocOptionsPanel.ra$_hasFieldScope(JavadocOptionsPanel.this)) {
                if (selected) {
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).setScope(2);
                } else {
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).unsetScope(2);
                }
            } else if (cb == JavadocOptionsPanel.ra$_hasMethodScope(JavadocOptionsPanel.this)) {
                if (selected) {
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).setScope(4);
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).setScope(8);
                } else {
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).unsetScope(4);
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).unsetScope(8);
                }
            } else if (cb == JavadocOptionsPanel.ra$_hasClassScope(JavadocOptionsPanel.this)) {
                if (selected) {
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).setScope(1);
                } else {
                    JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).unsetScope(1);
                }
            } else if (cb == JavadocOptionsPanel.ra$_isRequired(JavadocOptionsPanel.this)) {
                JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).setRequired(selected);
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || JavadocOptionsPanel.ra$_modelIsUpdating(JavadocOptionsPanel.this)) {
                return;
            }
            JavadocOptionsPanel.wa$_listIsUpdating(JavadocOptionsPanel.this, true);
            JavadocOptionsPanel.wa$_selectedTD(JavadocOptionsPanel.this, (TagDescriptor)JavadocOptionsPanel.ra$_tagList(JavadocOptionsPanel.this).getSelectedValue());
            if (JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this) != null) {
                String name = JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).getName();
                if (name.startsWith("@")) {
                    name = name.substring(1);
                }
                JavadocOptionsPanel.ra$_tagNameText(JavadocOptionsPanel.this).setText(name);
                JavadocOptionsPanel.ra$_templateText(JavadocOptionsPanel.this).setText(JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).getTemplate());
                JavadocOptionsPanel.this.updateNameAndTemplate();
                JavadocOptionsPanel.ra$_hasFieldScope(JavadocOptionsPanel.this).setSelected((JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).getScope() & 2) > 0);
                JavadocOptionsPanel.ra$_hasMethodScope(JavadocOptionsPanel.this).setSelected((JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).getScope() & 4) > 0);
                JavadocOptionsPanel.ra$_hasClassScope(JavadocOptionsPanel.this).setSelected((JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).getScope() & 1) > 0);
                JavadocOptionsPanel.ra$_isRequired(JavadocOptionsPanel.this).setSelected(JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).isRequired());
                boolean enable = JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).isCustom();
                JavadocOptionsPanel.ra$_tagNameText(JavadocOptionsPanel.this).setEnabled(enable);
                JavadocOptionsPanel.ra$_hasFieldScope(JavadocOptionsPanel.this).setEnabled(enable);
                JavadocOptionsPanel.ra$_hasMethodScope(JavadocOptionsPanel.this).setEnabled(enable);
                JavadocOptionsPanel.ra$_hasMethodScope(JavadocOptionsPanel.this).setEnabled(enable);
                JavadocOptionsPanel.ra$_hasClassScope(JavadocOptionsPanel.this).setEnabled(enable);
                JavadocOptionsPanel.ra$_removeButton(JavadocOptionsPanel.this).setEnabled(enable);
                enable = JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).isCustom() || JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this).isAllowsTemplate();
                JavadocOptionsPanel.ra$_templateText(JavadocOptionsPanel.this).setEnabled(enable);
                JavadocOptionsPanel.ra$_templateLabel(JavadocOptionsPanel.this).setEnabled(enable);
            }
            JavadocOptionsPanel.ra$_upButton(JavadocOptionsPanel.this).setEnabled(JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).indexOf(JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this)) > 0);
            JavadocOptionsPanel.ra$_downButton(JavadocOptionsPanel.this).setEnabled(JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).indexOf(JavadocOptionsPanel.ra$_selectedTD(JavadocOptionsPanel.this)) < JavadocOptionsPanel.ra$_listModel(JavadocOptionsPanel.this).getSize() - 1);
            JavadocOptionsPanel.wa$_listIsUpdating(JavadocOptionsPanel.this, false);
        }

        private InteractionListener() {
        }

        InteractionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class TagListModel
    extends DefaultListModel {
        private ArrayList _dataList;

        TagListModel(List data) {
            this._dataList = (ArrayList)data;
        }

        public void add(int index, Object element) {
            this._dataList.add(index, element);
            this.fireIntervalAdded(this, index, index);
        }

        public void addElement(Object element) {
            int index = this._dataList.size();
            this.add(index, element);
        }

        public int indexOf(Object elem) {
            return this._dataList.indexOf(elem);
        }

        public void moveUp(Object obj) {
            int i = this._dataList.indexOf(obj);
            TagDescriptor td = (TagDescriptor)obj;
            this.removeElement(td);
            this.add(--i, td);
        }

        public void moveDown(Object obj) {
            int i = this._dataList.indexOf(obj);
            TagDescriptor td = (TagDescriptor)obj;
            if (this.removeElement(td)) {
                this.add(++i, td);
            }
        }

        public boolean removeElement(Object obj) {
            int i = this._dataList.indexOf(obj);
            if (i >= 0) {
                this.removeElementAt(i);
                return true;
            }
            return false;
        }

        public void removeElementAt(int index) {
            int elementCount = this._dataList.size();
            if (index >= 0 && index <= elementCount) {
                this._dataList.remove(index);
                this.fireIntervalRemoved(this, index, index);
            }
        }

        public Object getElementAt(int index) {
            return this._dataList.get(index);
        }

        public int getSize() {
            return this._dataList.size();
        }
    }
}

