/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc.audit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.doc.SourceDocBlockTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocElement;
import oracle.javatools.parser.java.v2.model.doc.SourceDocInlineTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.analyzer.ViolationReport;
import oracle.jdeveloper.audit.java.Visibility;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.javadoc.TagDescriptor;
import oracle.jdeveloper.javadoc.TagManager;
import oracle.jdevimpl.javadoc.JavadocArb;
import oracle.jdevimpl.javadoc.audit.DocAnalyzerBundle;
import oracle.jdevimpl.javadoc.audit.DocAnalyzerUtils;
import oracle.jdevimpl.javadoc.audit.DocCategory;
import oracle.jdevimpl.javadoc.audit.DocRule;
import oracle.jdevimpl.javadoc.audit.transform.AddCommentFix;
import oracle.jdevimpl.javadoc.audit.transform.AddTagFix;
import oracle.jdevimpl.javadoc.audit.transform.AddTerminatorFix;
import oracle.jdevimpl.javadoc.audit.transform.RemoveTagFix;
import oracle.jdevimpl.javadoc.audit.transform.SortTagsFix;
import oracle.jdevimpl.javadoc.audit.transform.TagSpellingFix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocAnalyzer
extends Analyzer {
    private List<TagDescriptor> constructorTags;
    private List<TagDescriptor> methodTags;
    private List<TagDescriptor> classTags;
    private List<TagDescriptor> fieldTags;
    private List<TagDescriptor> inlineConstructorTags;
    private List<TagDescriptor> inlineMethodTags;
    private List<TagDescriptor> inlineClassTags;
    private List<TagDescriptor> inlineFieldTags;
    public static final int CLASS_SCOPE = 1;
    public static final int METHOD_SCOPE = 2;
    public static final int FIELD_SCOPE = 4;
    public static final int ALL_SCOPE = 7;
    private int autoGenScope;
    private static final SourceDocTag[] NO_DOC_TAGS = new SourceDocTag[0];
    private final Localizer LOCALIZER;
    private final DocCategory docCategory;
    private static final String COMMENT_MISSING = "missing-comment";
    private static final String DESCRIPTION_MISSING = "description-is-empty";
    private static final String TAG_MISSPELLED = "tag-misspelled";
    private static final String TAG_MISSING = "tag-is-missing";
    private static final String TAG_MISPLACED = "tag-is-misplaced";
    private static final String TAG_DUPLICATE = "tag-is-duplicate";
    private static final String TAG_DESCRIPTION_MISSING = "tag-description-missing";
    private static final String TAGS_UNSORTED = "tags-incorrectly-sorted";
    private static final String COMMENT_MISSING_PERIOD = "comment-period-missing";
    private static final String COMMENT_HTML_INVALID = "comment-html-is-unterminated";
    private DocRule JD_COMMENT_MISSING;
    private DocRule JD_DESCRIPTION_MISSING;
    private DocRule JD_TAG_MISSPELLED;
    private DocRule JD_TAG_MISSING;
    private DocRule JD_TAG_MISPLACED;
    private DocRule JD_TAG_DUPLICATE;
    private DocRule JD_TAG_DESCRIPTION_MISSING;
    private DocRule JD_TAGS_UNSORTED;
    private DocRule JD_COMMENT_MISSING_PERIOD;
    private DocRule JD_COMMENT_HTML_INVALID;
    private static final String MESSAGE_SUBJECT = "subject";
    private static final String MESSAGE_DETAIL = "detail";
    private static final String[] TAGS_CAN_BE_UNTERMINATED = new String[]{"p", "br", "li", "dt", "dd", "hr", "img", "th"};

    private void $init$() {
        this.autoGenScope = 7;
        this.LOCALIZER = Localizer.instance(DocAnalyzerBundle.class);
        this.docCategory = new DocCategory(this.LOCALIZER);
        this.JD_COMMENT_MISSING = new DocRule(COMMENT_MISSING, this.docCategory, Severity.ADVISORY, this.LOCALIZER, new AddCommentFix(this.LOCALIZER));
        this.JD_DESCRIPTION_MISSING = new DocRule(DESCRIPTION_MISSING, this.docCategory, Severity.ADVISORY, this.LOCALIZER);
        this.JD_TAG_MISSPELLED = new DocRule(TAG_MISSPELLED, this.docCategory, Severity.WARNING, this.LOCALIZER, new TagSpellingFix(this.LOCALIZER));
        this.JD_TAG_MISSING = new DocRule(TAG_MISSING, new String[]{COMMENT_MISSING}, this.docCategory, Severity.WARNING, this.LOCALIZER, null, new AddTagFix(this.LOCALIZER));
        this.JD_TAG_MISPLACED = new DocRule(TAG_MISPLACED, this.docCategory, Severity.WARNING, this.LOCALIZER, new Transform[]{new RemoveTagFix(this.LOCALIZER)}, null);
        this.JD_TAG_DUPLICATE = new DocRule(TAG_DUPLICATE, this.docCategory, Severity.WARNING, this.LOCALIZER, new RemoveTagFix(this.LOCALIZER));
        this.JD_TAG_DESCRIPTION_MISSING = new DocRule(TAG_DESCRIPTION_MISSING, this.docCategory, Severity.ADVISORY, this.LOCALIZER);
        this.JD_TAGS_UNSORTED = new DocRule(TAGS_UNSORTED, this.docCategory, Severity.ADVISORY, this.LOCALIZER, new SortTagsFix(this.LOCALIZER));
        this.JD_COMMENT_MISSING_PERIOD = new DocRule(COMMENT_MISSING_PERIOD, this.docCategory, Severity.WARNING, this.LOCALIZER, new AddTerminatorFix(this.LOCALIZER));
        this.JD_COMMENT_HTML_INVALID = new DocRule(COMMENT_HTML_INVALID, this.docCategory, Severity.WARNING, this.LOCALIZER);
    }

    public Rule[] getRules() {
        return new Rule[]{this.JD_COMMENT_MISSING, this.JD_DESCRIPTION_MISSING, this.JD_TAG_DESCRIPTION_MISSING, this.JD_TAG_MISSPELLED, this.JD_TAG_MISSING, this.JD_TAG_MISPLACED, this.JD_TAG_DUPLICATE, this.JD_TAGS_UNSORTED, this.JD_COMMENT_MISSING_PERIOD, this.JD_COMMENT_HTML_INVALID};
    }

    public Rule[] getRules(SourceElement element) {
        if (element == null) {
            return this.getRulesNullElement();
        }
        return this.getRulesNonNullElement();
    }

    protected Rule[] getRulesNonNullElement() {
        return new Rule[]{this.JD_COMMENT_MISSING, this.JD_TAG_MISSING, this.JD_TAG_MISSPELLED, this.JD_TAGS_UNSORTED};
    }

    protected Rule[] getRulesNullElement() {
        return new Rule[]{this.JD_TAG_MISSING, this.JD_TAG_MISSPELLED, this.JD_TAGS_UNSORTED};
    }

    public void setAutoGenScope(int scope) {
        this.autoGenScope |= scope;
    }

    public void unsetAutoGenScope(int scope) {
        this.autoGenScope &= ~scope;
    }

    private void verify(AuditContext context, Visibility visibility, SourceDocComment comment, TagDescriptor[] tds, TagDescriptor[] inlineTds) {
        this.verifyComment(context, visibility, comment, tds, inlineTds);
    }

    private void verifyComment(AuditContext context, Visibility visibility, SourceDocComment comment, TagDescriptor[] tds, TagDescriptor[] inlineTds) {
        if (comment == null) {
            HashMap<SourceDocTag, String> spellMap = new HashMap<SourceDocTag, String>();
            boolean missingTagsReported = this.checkRequired(context, visibility, comment, tds, NO_DOC_TAGS, spellMap);
            if (!missingTagsReported && this.shouldVerify(this.JD_COMMENT_MISSING, visibility)) {
                context.report((Rule)this.JD_COMMENT_MISSING);
            }
        } else {
            this.verifyDescription(visibility, comment, context);
            this.verifyTags(context, visibility, comment, tds);
            this.verifyInlineTags(context, visibility, comment, inlineTds);
        }
    }

    private void verifyDescription(Visibility visibility, SourceDocComment comment, AuditContext context) {
        this.verifyDescription(context, visibility, comment, null);
    }

    private void verifyDescription(AuditContext context, Visibility visibility, SourceDocComment comment, String template) {
        boolean descriptionIsBlank;
        if (comment == null) {
            return;
        }
        SourceDocDescription description = comment.getDescription();
        boolean bl = descriptionIsBlank = description == null || description.isBlank();
        if (this.shouldVerify(this.JD_DESCRIPTION_MISSING, visibility) && descriptionIsBlank) {
            if (template == null || template.trim().length() == 0) {
                ViolationReport report = context.report((Rule)this.JD_DESCRIPTION_MISSING, (Object)comment);
            } else {
                ViolationReport report = context.report((Rule)this.JD_DESCRIPTION_MISSING);
            }
        }
        if (!descriptionIsBlank) {
            String docText;
            if (this.shouldVerify(this.JD_COMMENT_MISSING_PERIOD, visibility) && !DocAnalyzerUtils.hasEndSentenceChar(docText = description.getDocText()) && !docText.trim().startsWith("@inheritDoc")) {
                context.report((Rule)this.JD_COMMENT_MISSING_PERIOD, (Object)description);
            }
            this.checkHTML(context, visibility, description);
        }
    }

    private void verifyTags(AuditContext context, Visibility visibility, SourceDocComment comment, TagDescriptor[] tds) {
        SourceDocTag[] existingTags;
        HashMap<SourceDocTag, String> misspelledTags = new HashMap<SourceDocTag, String>();
        ArrayList<TagDescriptor> dups = new ArrayList<TagDescriptor>();
        if (comment != null) {
            List blockTags = comment.getBlockTags();
            existingTags = blockTags.toArray(new SourceDocTag[blockTags.size()]);
        } else {
            existingTags = NO_DOC_TAGS;
        }
        this.checkRequired(context, visibility, comment, tds, existingTags, misspelledTags);
        int i = 0;
        while (i < existingTags.length) {
            SourceDocTag currentTag = existingTags[i];
            TagDescriptor td = this.findTag(currentTag, tds);
            if (td == null) {
                this.checkMisplaced(context, visibility, currentTag, misspelledTags);
            } else {
                if (!this.checkDuplicates(context, visibility, currentTag, td, dups)) {
                    this.checkTagDescription(context, visibility, currentTag);
                }
                if (!td.isAllowDuplicates() && !dups.contains(td)) {
                    dups.add(td);
                }
                this.checkHTML(context, visibility, currentTag.getDescription());
            }
            ++i;
        }
        this.checkSortOrder(context, visibility, tds, existingTags);
    }

    private void verifyInlineTags(AuditContext context, Visibility visibility, SourceDocComment comment, TagDescriptor[] inlineTds) {
        if (comment != null && this.shouldVerify(this.JD_TAG_MISPLACED, visibility)) {
            Collection tags = comment.getInlineTags();
            for (SourceDocInlineTag tag : tags) {
                boolean match = false;
                TagDescriptor[] tagDescriptorArray = inlineTds;
                int n = 0;
                while (n < tagDescriptorArray.length) {
                    TagDescriptor inlineTag = tagDescriptorArray[n];
                    if (tag.getName().equals(inlineTag.getName())) {
                        match = true;
                        break;
                    }
                    ++n;
                }
                if (match) continue;
                ViolationReport report = context.report((Rule)this.JD_TAG_MISPLACED, (Object)tag);
                report.addParameter("tagName", (Object)tag.getName());
            }
        }
    }

    private void checkHTML(AuditContext context, Visibility visibility, SourceDocDescription srcDocDescription) {
        if (srcDocDescription == null) {
            return;
        }
        if (!this.shouldVerify(this.JD_COMMENT_HTML_INVALID, visibility)) {
            return;
        }
        HashMap<String, List<SourceElement>> openTags = new HashMap<String, List<SourceElement>>();
        HashMap<String, List<SourceElement>> closeTags = new HashMap<String, List<SourceElement>>();
        for (SourceDocElement docElement : srcDocDescription.getChildren()) {
            String descriptionText;
            SourceDocElement srcElement;
            if (docElement instanceof SourceDocInlineTag) {
                SourceDocInlineTag inlineTag = (SourceDocInlineTag)docElement;
                String tagName = inlineTag.getName();
                srcElement = inlineTag.getDescription();
                descriptionText = "@literal".equals(tagName) || "@code".equals(tagName) ? "" : (srcElement != null ? srcElement.getText() : "");
            } else {
                srcElement = docElement;
                descriptionText = docElement.getText();
            }
            this.checkUnterminatedTags(descriptionText, (SourceElement)srcElement, openTags, closeTags);
        }
        if (openTags.keySet().size() > 0) {
            ArrayList openingTags = new ArrayList(openTags.keySet());
            int i = openingTags.size() - 1;
            while (i > 0) {
                String two;
                String one = (String)openingTags.get(i);
                if (one.equalsIgnoreCase(two = (String)openingTags.get(i - 1))) {
                    openingTags.remove(i);
                    --i;
                }
                --i;
            }
        }
        this.reportHtmlErrors(context, openTags, JavadocArb.getString(88));
        this.reportHtmlErrors(context, closeTags, JavadocArb.getString(65));
    }

    private void checkUnterminatedTags(String descriptionText, SourceElement srcElement, Map<String, List<SourceElement>> openTags, Map<String, List<SourceElement>> closeTags) {
        if (descriptionText == null || descriptionText.trim().length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(descriptionText, " \t\n\r\f<>", true);
        while (st.hasMoreTokens()) {
            String endTokenName;
            boolean closeTagIsBogus;
            String token = st.nextToken();
            if (!token.equals("<")) continue;
            try {
                token = st.nextToken();
            }
            catch (Exception e) {
                break;
            }
            if (token.charAt(0) >= 'A' && token.charAt(0) <= 'Z' || token.charAt(0) >= 'a' && token.charAt(0) <= 'z') {
                if (!this.tagMustBeTerminated(token)) continue;
                this.addToTagMap(token, srcElement, openTags);
                continue;
            }
            if (token.charAt(0) != '/' || !(closeTagIsBogus = this.tagMustBeTerminated(endTokenName = token.substring(1)))) continue;
            Iterator<String> nextKey = openTags.keySet().iterator();
            while (nextKey.hasNext()) {
                String openTagName = nextKey.next();
                if (!endTokenName.equalsIgnoreCase(openTagName)) continue;
                List<SourceElement> valueList = openTags.get(openTagName);
                int size = valueList.size();
                if (size == 1) {
                    closeTagIsBogus = false;
                    nextKey.remove();
                    break;
                }
                if (size <= 0) break;
                closeTagIsBogus = false;
                valueList.remove(size - 1);
                break;
            }
            if (!closeTagIsBogus) continue;
            this.addToTagMap(token, srcElement, closeTags);
        }
    }

    private boolean tagMustBeTerminated(String token) {
        boolean needsCloseTag = true;
        String[] stringArray = TAGS_CAN_BE_UNTERMINATED;
        int n = 0;
        while (n < stringArray.length) {
            String nextTag = stringArray[n];
            if (token.equalsIgnoreCase(nextTag) || token.equalsIgnoreCase(nextTag + '/')) {
                needsCloseTag = false;
                break;
            }
            ++n;
        }
        return needsCloseTag;
    }

    private void addToTagMap(String key, SourceElement value, Map<String, List<SourceElement>> map) {
        List<Object> locations;
        if (map.containsKey(key)) {
            locations = map.get(key);
        } else {
            locations = new ArrayList();
            map.put(key, locations);
        }
        if (!locations.contains(value)) {
            locations.add(value);
        }
    }

    private void reportHtmlErrors(AuditContext context, Map<String, List<SourceElement>> map, String violationDescription) {
        for (String tag : map.keySet()) {
            for (SourceElement errorLocation : map.get(tag)) {
                ViolationReport report = context.report((Rule)this.JD_COMMENT_HTML_INVALID, (Object)errorLocation);
                report.addParameter(MESSAGE_SUBJECT, (Object)tag);
                report.addParameter(MESSAGE_DETAIL, (Object)violationDescription);
            }
        }
    }

    private boolean checkRequired(AuditContext context, Visibility visibility, SourceDocComment comment, TagDescriptor[] tagsToCheck, SourceDocTag[] existing, Map<SourceDocTag, String> spellMap) {
        if (!this.shouldVerify(this.JD_TAG_MISSING, visibility) && !this.shouldVerify(this.JD_TAG_MISSPELLED, visibility)) {
            return false;
        }
        StringBuffer buf = new StringBuffer(100);
        ArrayList<TagDescriptor> required = new ArrayList<TagDescriptor>(tagsToCheck.length);
        TagDescriptor[] tagDescriptorArray = tagsToCheck;
        int n = 0;
        while (n < tagDescriptorArray.length) {
            TagDescriptor td = tagDescriptorArray[n];
            SourceDocTag[] found = td.findDocTags(existing);
            if (td.isRequired()) {
                required.add(td);
                if (found.length == 0 && !this.checkSpelling(td, existing, spellMap)) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(td.getName());
                    if (td.getReference().length() > 0) {
                        buf.append(" ");
                        buf.append(td.getReference());
                    }
                }
            }
            ++n;
        }
        if (buf.length() > 0) {
            TagDescriptor[] requiredTags = new TagDescriptor[required.size()];
            required.toArray(requiredTags);
            ViolationReport report = context.report((Rule)this.JD_TAG_MISSING);
            if (comment == null) {
                report.setVariation(COMMENT_MISSING);
            } else {
                report.setFocusLocation((Object)comment);
            }
            report.addParameter("missing-tag-names", (Object)buf.toString());
            report.addParameter("missing-tags", (Object)requiredTags);
            report.addParameter("sort-order", (Object)tagsToCheck);
            return true;
        }
        return false;
    }

    private void checkMisplaced(AuditContext context, Visibility visibility, SourceDocTag currentTag, Map<SourceDocTag, String> misspelledTags) {
        String fixText = misspelledTags.get(currentTag);
        if (fixText != null) {
            if (this.shouldVerify(this.JD_TAG_MISSPELLED, visibility)) {
                ViolationReport report = context.report((Rule)this.JD_TAG_MISSPELLED, (Object)currentTag);
                report.addParameter("tagName", (Object)currentTag.getName());
                report.addParameter("Correction", (Object)fixText);
                report.addParameter("tagText", (Object)DocAnalyzerUtils.getReference(currentTag));
            }
        } else if (this.shouldVerify(this.JD_TAG_MISPLACED, visibility) && !"@beaninfo".equals(currentTag.getName()) && !"@hidden".equals(currentTag.getName()) && !currentTag.isException()) {
            ViolationReport report = context.report((Rule)this.JD_TAG_MISPLACED, (Object)currentTag);
            report.addParameter("fullTagName", (Object)this.getFullTagName(currentTag));
            report.addParameter("tagName", (Object)currentTag.getName());
            report.addParameter("tagText", (Object)DocAnalyzerUtils.getReference(currentTag));
        }
    }

    private void checkSortOrder(AuditContext context, Visibility visibility, TagDescriptor[] sortedTDs, SourceDocTag[] existing) {
        Object[] sortedTags;
        if (this.shouldVerify(this.JD_TAGS_UNSORTED, visibility) && !Arrays.equals(existing, sortedTags = DocAnalyzerUtils.sortTags(existing, sortedTDs))) {
            SourceDocComment comment = (SourceDocComment)existing[0].getParent();
            ViolationReport report = context.report((Rule)this.JD_TAGS_UNSORTED, (Object)comment);
            report.addParameter("sort-order", (Object)sortedTDs);
        }
    }

    private boolean checkDuplicates(AuditContext context, Visibility visibility, SourceDocTag currentTag, TagDescriptor td, List<TagDescriptor> duplicateTags) {
        if (this.shouldVerify(this.JD_TAG_DUPLICATE, visibility) && !td.isAllowDuplicates() && duplicateTags.contains(td)) {
            ViolationReport report = context.report((Rule)this.JD_TAG_DUPLICATE, (Object)currentTag);
            report.addParameter("fullTagName", (Object)this.getFullTagName(currentTag));
            report.addParameter("tagName", (Object)currentTag.getName());
            report.addParameter("tagText", (Object)DocAnalyzerUtils.getReference(currentTag));
            return true;
        }
        return false;
    }

    private void checkTagDescription(AuditContext context, Visibility visibility, SourceDocTag currentTag) {
        boolean blank;
        SourceDocDescription description = currentTag.getDescription();
        boolean bl = blank = description == null || description.isBlank();
        if (this.shouldVerify(this.JD_TAG_DESCRIPTION_MISSING, visibility) && blank && !currentTag.isException() && !currentTag.isReference()) {
            ViolationReport report = context.report((Rule)this.JD_TAG_DESCRIPTION_MISSING, (Object)currentTag);
            report.addParameter("full-tag-name", (Object)this.getFullTagName(currentTag));
        }
    }

    private boolean checkSpelling(TagDescriptor td, SourceDocTag[] existing, Map<SourceDocTag, String> map) {
        String[] reCheck;
        boolean error = false;
        String[] stringArray = reCheck = this.getMisspellings(td.getName());
        int n = 0;
        while (n < stringArray.length) {
            SourceDocTag[] found;
            String tagName = stringArray[n];
            TagDescriptor tdCopy = new TagDescriptor();
            td.copyTo(tdCopy);
            tdCopy.setName(tagName);
            SourceDocTag[] sourceDocTagArray = found = tdCopy.findDocTags(existing);
            int n2 = 0;
            while (n2 < sourceDocTagArray.length) {
                SourceDocTag errorTag = sourceDocTagArray[n2];
                if (!map.containsKey(errorTag)) {
                    map.put(errorTag, td.getName());
                }
                if (!error) {
                    error = found.length > 0;
                }
                ++n2;
            }
            ++n;
        }
        return error;
    }

    private String[] getMisspellings(String tagName) {
        if ("@param".equals(tagName)) {
            return new String[]{"@parm"};
        }
        if ("@return".equals(tagName)) {
            return new String[]{"@returns"};
        }
        return new String[0];
    }

    private boolean shouldVerify(DocRule rule, Visibility vis) {
        return rule.isEnabled();
    }

    private boolean checkVisibility(Visibility elemVisibility) {
        boolean match = false;
        Rule[] rules = this.getRules();
        int i = 0;
        while (i < rules.length) {
            if (rules[i].isEnabled() && !match) {
                DocRule rule = (DocRule)rules[i];
                Visibility minimumVisibility = rule.getVisibility();
                match = minimumVisibility.compareTo(elemVisibility) <= 0;
            }
            ++i;
        }
        return match;
    }

    private TagDescriptor findTag(SourceDocTag tag, TagDescriptor[] tds) {
        TagDescriptor[] tagDescriptorArray = tds;
        int n = 0;
        while (n < tagDescriptorArray.length) {
            TagDescriptor td = tagDescriptorArray[n];
            if (td.nameAndReferenceEquals(tag)) {
                return td;
            }
            ++n;
        }
        return null;
    }

    private String getFullTagName(SourceDocTag tag) {
        String name = tag.getName();
        String append = "";
        SourceDocReference reference = tag.getReference();
        if (reference != null) {
            String ref = reference.getNormalizedText();
            int index = ref.indexOf(" ");
            append = index > 0 ? ref.substring(0, index) : ref;
        }
        return append != null && append.length() > 0 ? name + " " + append.trim() : name;
    }

    public void exit(AuditContext context, SourceFieldDeclaration fieldConstruct) {
        if ((this.autoGenScope & 4) == 0) {
            return;
        }
        SourceClass cls = fieldConstruct.getEnclosingClass();
        if (cls == null || cls.isAnonymous()) {
            return;
        }
        int modifiers = fieldConstruct.getModifiers();
        Visibility visibility = Visibility.valueOf(modifiers);
        if (!this.checkVisibility(visibility)) {
            return;
        }
        ArrayList<TagDescriptor> tagList = new ArrayList<TagDescriptor>(this.getTagsForType(2));
        TagDescriptor[] tagArray = new TagDescriptor[tagList.size()];
        tagList.toArray(tagArray);
        tagList = new ArrayList<TagDescriptor>(this.getInlineTagsForType(2));
        TagDescriptor[] inlineTagArray = new TagDescriptor[tagList.size()];
        tagList.toArray(inlineTagArray);
        StringBuffer name = new StringBuffer(50);
        for (SourceVariable v : fieldConstruct.getVariables()) {
            if (name.length() > 0) {
                name.append(", ");
            }
            name.append(v.getName());
        }
        SourceDocComment comment = fieldConstruct.getDocComment();
        this.verify(context, visibility, comment, tagArray, inlineTagArray);
    }

    public void exit(AuditContext context, SourceClass classConstruct) {
        if ((this.autoGenScope & 1) == 0) {
            return;
        }
        if (!classConstruct.isExported()) {
            return;
        }
        int modifiers = classConstruct.getModifiers();
        Visibility visibility = Visibility.valueOf(modifiers);
        if (!this.checkVisibility(visibility)) {
            return;
        }
        ArrayList<TagDescriptor> tagList = new ArrayList<TagDescriptor>(this.getTagsForType(1));
        TagDescriptor[] tagArray = new TagDescriptor[tagList.size()];
        tagList.toArray(tagArray);
        tagList = new ArrayList<TagDescriptor>(this.getInlineTagsForType(1));
        TagDescriptor[] inlineTagArray = new TagDescriptor[tagList.size()];
        tagList.toArray(inlineTagArray);
        SourceDocComment comment = classConstruct.getDocComment();
        this.verify(context, visibility, comment, tagArray, inlineTagArray);
    }

    public void exit(AuditContext context, SourceMethod methodConstruct) {
        if ((this.autoGenScope & 2) == 0) {
            return;
        }
        SourceClass cls = methodConstruct.getEnclosingClass();
        if (cls.isAnonymous()) {
            return;
        }
        int modifiers = methodConstruct.getModifiers();
        Visibility visibility = Visibility.valueOf(modifiers);
        if (!this.checkVisibility(visibility)) {
            return;
        }
        boolean isConstructor = methodConstruct.isConstructor();
        int TAG = isConstructor ? 8 : 4;
        ArrayList<TagDescriptor> tagList = new ArrayList<TagDescriptor>(this.getTagsForType(TAG));
        this.addParamTags(methodConstruct, tagList);
        this.addReturnTag(methodConstruct, tagList);
        this.addThrowsTag(methodConstruct, tagList);
        TagDescriptor[] tagArray = new TagDescriptor[tagList.size()];
        tagList.toArray(tagArray);
        tagList = new ArrayList<TagDescriptor>(this.getInlineTagsForType(TAG));
        TagDescriptor[] inlineTagArray = new TagDescriptor[tagList.size()];
        tagList.toArray(inlineTagArray);
        SourceDocComment comment = methodConstruct.getDocComment();
        this.verify(context, visibility, comment, tagArray, inlineTagArray);
    }

    private void addParamTags(SourceMethod srcMethod, List<TagDescriptor> tdList) {
        List params = srcMethod.getSourceParameters();
        if (params.size() == 0) {
            this.removeTagPlaceholder("@param", tdList);
            return;
        }
        TagDescriptor paramTag = this.findByName("@param", tdList);
        try {
            int pos = -1;
            for (SourceVariable p : params) {
                String paramName = p.getName();
                TagDescriptor td = new TagDescriptor(paramTag.getName(), paramTag.getScope(), paramTag.getParams());
                td.setReference(paramName);
                td.setCustom(paramTag.isCustom());
                td.setAllowDuplicates(paramTag.isAllowDuplicates());
                td.setRequired(paramTag.isRequired());
                td.setAllowsTemplate(paramTag.isAllowsTemplate());
                pos = pos == -1 ? this.removeTagPlaceholder("@param", tdList) : pos;
                tdList.add(pos++, td);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addReturnTag(SourceMethod srcMethod, List<TagDescriptor> tdList) {
        SourceTypeReference type = srcMethod.getSourceReturnType();
        if (type == null || "void".equals(type.getName())) {
            this.removeTagPlaceholder("@return", tdList);
            return;
        }
        TagDescriptor returnTag = this.findByName("@return", tdList);
        try {
            TagDescriptor td = new TagDescriptor(returnTag.getName(), returnTag.getScope(), returnTag.getParams());
            td.setCustom(returnTag.isCustom());
            td.setAllowDuplicates(returnTag.isAllowDuplicates());
            td.setRequired(returnTag.isRequired());
            td.setAllowsTemplate(returnTag.isAllowsTemplate());
            int pos = this.removeTagPlaceholder("@return", tdList);
            tdList.add(pos++, td);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addThrowsTag(SourceMethod srcMethod, List<TagDescriptor> tdList) {
        List checkedExceptions;
        ArrayList<String> exceptionTags = new ArrayList<String>();
        SourceDocComment comment = srcMethod.getDocComment();
        if (comment != null) {
            Collection c = comment.findExceptionTags();
            Iterator exTagIterator = c.iterator();
            while (exTagIterator.hasNext()) {
                try {
                    SourceDocBlockTag exTag = (SourceDocBlockTag)exTagIterator.next();
                    SourceDocReference ref = exTag.getReference();
                    if (ref == null) continue;
                    JavaHasType hasType = ref.getResolvedObject();
                    if (hasType != null) {
                        JavaType javaType = hasType.getResolvedType();
                        exceptionTags.add(javaType.getName());
                        continue;
                    }
                    exceptionTags.add(exTag.getReferenceText());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if ((checkedExceptions = srcMethod.getSourceExceptions()).size() + exceptionTags.size() == 0) {
            this.removeTagPlaceholder("@throws", tdList);
            return;
        }
        for (SourceTypeReference t : checkedExceptions) {
            String name = t.getName();
            if (exceptionTags.contains(name)) continue;
            exceptionTags.add(name);
        }
        TagDescriptor throwsTag = this.findByName("@throws", tdList);
        try {
            int pos = -1;
            for (String name : exceptionTags) {
                TagDescriptor td = new TagDescriptor(throwsTag.getName(), throwsTag.getScope(), throwsTag.getParams());
                td.setReference(name);
                td.setCustom(throwsTag.isCustom());
                td.setAllowDuplicates(throwsTag.isAllowDuplicates());
                td.setRequired(throwsTag.isRequired());
                td.setAllowsTemplate(throwsTag.isAllowDuplicates());
                pos = pos == -1 ? this.removeTagPlaceholder("@throws", tdList) : pos;
                tdList.add(pos++, td);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int removeTagPlaceholder(String tag, List<TagDescriptor> tdList) {
        TagDescriptor found = this.findByName(tag, tdList);
        if (found == null) {
            return -1;
        }
        int location = tdList.indexOf(found);
        tdList.remove(location);
        return location;
    }

    private TagDescriptor findByName(String name, List<TagDescriptor> list) {
        for (TagDescriptor td : list) {
            if (!td.getName().equals(name)) continue;
            return td;
        }
        return null;
    }

    private List<TagDescriptor> getTagsForType(int tagId) {
        switch (tagId) {
            case 2: {
                if (this.fieldTags == null) {
                    this.fieldTags = TagManager.getInstance().getTags(tagId);
                }
                return this.fieldTags;
            }
            case 1: {
                if (this.classTags == null) {
                    this.classTags = TagManager.getInstance().getTags(tagId);
                }
                return this.classTags;
            }
            case 4: {
                if (this.methodTags == null) {
                    this.methodTags = TagManager.getInstance().getTags(tagId);
                }
                return this.methodTags;
            }
            case 8: {
                if (this.constructorTags == null) {
                    this.constructorTags = TagManager.getInstance().getTags(tagId);
                }
                return this.constructorTags;
            }
        }
        return Collections.EMPTY_LIST;
    }

    private List<TagDescriptor> getInlineTagsForType(int tagId) {
        switch (tagId) {
            case 2: {
                if (this.inlineFieldTags == null) {
                    this.inlineFieldTags = TagManager.getInstance().getInlineTags(tagId);
                }
                return this.inlineFieldTags;
            }
            case 1: {
                if (this.inlineClassTags == null) {
                    this.inlineClassTags = TagManager.getInstance().getInlineTags(tagId);
                }
                return this.inlineClassTags;
            }
            case 4: {
                if (this.inlineMethodTags == null) {
                    this.inlineMethodTags = TagManager.getInstance().getInlineTags(tagId);
                }
                return this.inlineMethodTags;
            }
            case 8: {
                if (this.inlineConstructorTags == null) {
                    this.inlineConstructorTags = TagManager.getInstance().getInlineTags(tagId);
                }
                return this.inlineConstructorTags;
            }
        }
        return Collections.emptyList();
    }

    private Location getLocationOfCommentStart(AuditContext context, SourceDocComment comment) {
        Location location;
        try {
            int start = comment.getStartOffset();
            ModelAdapter modelAdapter = context.getModelAdapter();
            location = modelAdapter.getLocation(start, 3);
        }
        catch (Exception e) {
            location = context.getLocation((Object)comment);
        }
        return location;
    }

    public DocAnalyzer() {
        this.$init$();
    }
}

