/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc.popup;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.doc.SourceDocBlockTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocElement;
import oracle.javatools.parser.java.v2.model.doc.SourceDocHasDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocInlineTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.util.BindingContext;
import oracle.jdeveloper.javadoc.TagDescriptor;
import oracle.jdeveloper.javadoc.TagManager;
import oracle.jdevimpl.javadoc.JavadocArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavadocFormater {
    static final String VAR_ARGS = "...";
    static final String ARRAY = "[] ";
    static final String SPACE = " ";
    static final String COMMA = ",";
    static final String OPEN_PAREN = "(";
    static final String CLOSE_PAREN = ")";
    static final String PARENS = "()";
    static final String DASH = " - ";
    static final String POUND = "#";
    static final String NB_SPACE = "&nbsp;";
    static final String THROWS = "throws ";
    static final String EXTENDS = "extends ";
    static final String IMPLEMENTS = "implements ";
    static final String START_HREF = "<a href=\"";
    static final String SPLIT_HREF = "\">";
    static final String END_HREF = "</a>";
    static final String HTTP = "http:";
    static final String EMPTY_STRING = "";
    static final String JOT_HREF = "jot_href://";
    private static final String[][] LITERAL_CONVERSION_MAP = new String[][]{{"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}, {"\"", "&quot;"}};
    private TagDescriptor[] _sortedTags = TagManager.getInstance().getAllTags();
    protected static final String GOTO_JAVADOC_LINK = "goto_javadoc://";
    private static JavadocFormater INSTANCE;

    private JavadocFormater() {
    }

    public static JavadocFormater getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JavadocFormater();
        }
        return INSTANCE;
    }

    public String getJavadoc(SourceMember member) {
        Collection allOverridden;
        JavaMethod[] methodArray;
        String tagDesc;
        SourceDocComment sourceDocComment;
        boolean isMethod = false;
        boolean isClass = false;
        boolean isField = false;
        String copyWarning = null;
        StringBuffer data = new StringBuffer(5000);
        int KIND = member.getElementKind();
        switch (KIND) {
            case 8: {
                isMethod = true;
                SourceMethod sourceMethod = (SourceMethod)member;
                this.addSignature(data, sourceMethod);
                SourceMethod methodWithComments = this.getMethodWithComments(sourceMethod);
                if (methodWithComments == null) {
                    sourceDocComment = null;
                    break;
                }
                sourceDocComment = methodWithComments.getDocComment();
                JavaClass owningClass = methodWithComments.getOwningClass();
                String qualifiedName = owningClass.getQualifiedName();
                if (sourceMethod.equals((Object)methodWithComments)) break;
                String link = this.createJotLink(qualifiedName, qualifiedName);
                copyWarning = JavadocArb.format(67, link);
                break;
            }
            case 5: {
                if (member instanceof SourceMemberVariable) {
                    isClass = true;
                    this.addSignature(data, (SourceMemberVariable)member);
                } else {
                    isField = true;
                    this.addSignature(data, (SourceFieldVariable)member);
                }
                sourceDocComment = member.getDocComment();
                break;
            }
            case 3: {
                isClass = true;
                this.addSignature(data, (SourceClass)member);
                sourceDocComment = member.getDocComment();
                break;
            }
            default: {
                sourceDocComment = null;
                break;
            }
        }
        if (sourceDocComment != null && (tagDesc = this.getTagDescriptionText((SourceDocHasDescription)sourceDocComment)).length() > 0) {
            if (copyWarning != null) {
                data.append(this.b(copyWarning));
                data.append(this.p());
            }
            data.append(tagDesc);
        }
        if (isMethod && (methodArray = (allOverridden = ((SourceMethod)member).getOverriddenMethods()).toArray(new JavaMethod[allOverridden.size()])).length > 0) {
            JavaMethod overridden = methodArray[0];
            JavaClass owningClass = overridden.getOwningClass();
            boolean isInterface = owningClass.isInterface();
            String heading = isInterface ? JavadocArb.getString(5) : JavadocArb.getString(76);
            this.startDefintionList(data, heading);
            String name = overridden.getName();
            String cName = owningClass.getQualifiedName();
            String link = this.createJotLink(cName + POUND + name, name);
            String classLink = this.createJotLink(cName, owningClass.getName());
            String inText = isInterface ? JavadocArb.getString(3) : JavadocArb.getString(93);
            this.addToDefinitionList(data, this.code(link + SPACE + inText + SPACE + classLink));
            this.endDefinitionList(data);
        }
        if (sourceDocComment != null) {
            List blockTags = sourceDocComment.getBlockTags();
            Map<String, List<SourceDocTag>> separatedTags = this.groupTagsByType(blockTags);
            TagDescriptor[] tagDescriptorArray = this._sortedTags;
            int n = 0;
            while (n < tagDescriptorArray.length) {
                List<SourceDocTag> tagList;
                int length;
                TagDescriptor thisTag = tagDescriptorArray[n];
                String name = thisTag.getName();
                if (separatedTags.containsKey(name) && (length = (tagList = separatedTags.get(name)).size()) != 0) {
                    int scope = thisTag.getScope();
                    if (isField && (scope & 2) > 0 || isMethod && (scope & 4) > 0 || isClass && (scope & 1) > 0) {
                        SourceDocTag[] tagArray = tagList.toArray(new SourceDocTag[length]);
                        if ("@throws".equals(name) || "@exception".equals(name)) {
                            this.addThrowsComments(member, data, tagArray);
                        } else if ("@deprecated".equals(name)) {
                            this.addDeprecatedComments(data, tagArray);
                        } else if ("@param".equals(name)) {
                            this.addParamComments(data, tagArray);
                        } else if ("@return".equals(name)) {
                            this.addReturnComments(data, tagArray);
                        } else if ("@see".equals(name)) {
                            this.addSeeComments(data, tagArray);
                        } else if ("@since".equals(name)) {
                            this.addOtherComments(data, tagArray);
                        }
                    }
                }
                ++n;
            }
        }
        String message = data.toString();
        return message;
    }

    private SourceMethod getMethodWithComments(SourceMethod sourceMethod) {
        SourceDocComment docComment = sourceMethod.getDocComment();
        if (docComment != null) {
            return sourceMethod;
        }
        Collection overriddenMethods = sourceMethod.getOverriddenMethods();
        for (JavaMethod javaMethod : overriddenMethods) {
            SourceMethod superMethod;
            SourceElement sourceElement = javaMethod.getSourceElement();
            if (!(sourceElement instanceof SourceMethod) || (superMethod = (SourceMethod)sourceElement).getDocComment() == null) continue;
            return superMethod;
        }
        return null;
    }

    private void addSignature(StringBuffer buffer, SourceMethod method) {
        JavaClass returnType;
        SourceClass owningClass = this.getOwningClass((SourceMember)method);
        String owningClassName = owningClass.getQualifiedName();
        String parentLink = this.createJotLink(owningClassName, owningClassName);
        this.h3(buffer, this.code(parentLink));
        BindingContext bindingContext = new BindingContext(owningClass.getOwningSourceFile().getProvider(), (JavaIsGeneric)method, (JavaType)owningClass);
        buffer.append(this.pre());
        int modifiers = method.getModifiers();
        modifiers &= 0xFFFFFF7F;
        if (owningClass.isInterface()) {
            modifiers &= 0xFFFFFBFF;
        }
        String mods = Modifier.toString(modifiers) + SPACE;
        buffer.append(mods);
        int colOffset = mods.length();
        Object object = returnType = method.isConstructor() ? method.getOwningClass() : method.getReturnType();
        if (returnType != null) {
            String typeText = this.createTypeLink((JavaType)returnType, bindingContext);
            buffer.append(typeText).append(SPACE);
            colOffset += returnType.getName().length() + 1;
        }
        int throwsOffset = colOffset;
        if (!method.isConstructor()) {
            String methName = method.getName();
            buffer.append(this.b(methName));
            colOffset += methName.length() + 1;
        }
        buffer.append(OPEN_PAREN);
        Collection params = method.getParameters();
        int size = params.size();
        int counter = 1;
        for (JavaVariable var : params) {
            String link;
            String pname = var.getName();
            JavaType varType = var.getResolvedType();
            if (var.isVarargs()) {
                String varTypeName = varType.getName();
                varTypeName = varTypeName.substring(0, varTypeName.length() - 2) + VAR_ARGS;
                JavaType type = varType.getComponentType();
                link = type.isPrimitive() ? varTypeName : this.createJotLink(type.getQualifiedName(), varTypeName);
            } else {
                link = varType != null ? this.createTypeLink(varType, bindingContext) : var.getUnresolvedType().getSimplifiedName();
            }
            buffer.append(link);
            buffer.append(SPACE);
            buffer.append(pname);
            if (counter < size) {
                buffer.append(COMMA);
                buffer.append(this.br());
                buffer.append(this.filler(colOffset));
            }
            ++counter;
        }
        buffer.append(CLOSE_PAREN);
        Collection thrown = method.getExceptions();
        counter = 1;
        int len = thrown.size();
        if (len > 0) {
            buffer.append(this.br());
            buffer.append(this.filler(throwsOffset));
            buffer.append(THROWS);
        }
        for (JavaType thrownType : thrown) {
            String thrownTypeName = thrownType.getQualifiedName();
            String link = this.createJotLink(thrownTypeName, thrownTypeName);
            buffer.append(counter < len ? link + this.br() + this.filler(throwsOffset + 7) : link);
            ++counter;
        }
        buffer.append(this.preClose());
    }

    private void addSignature(StringBuffer buffer, SourceMemberVariable enumConstant) {
        String pkg = enumConstant.getOwningClass().getPackageName();
        if (pkg != null && pkg.length() > 0) {
            this.h3(buffer, pkg);
        }
        int modifiers = enumConstant.getModifiers();
        String mods = Modifier.toString(modifiers);
        JavaType enumType = enumConstant.getResolvedType();
        String type = enumType.getQualifiedName();
        if (pkg != null && pkg.length() > 0 && type.startsWith(pkg)) {
            type = type.substring(pkg.length() + 1);
        }
        this.pre(buffer, mods + SPACE + this.b(type));
        JavaType superType = enumType.getSuperclass();
        if (superType != null) {
            String linkText = this.createJotLink(superType.getQualifiedName(), superType.getName());
            buffer.append(this.dl());
            buffer.append(this.dt());
            buffer.append(this.code(EXTENDS + linkText));
        }
        buffer.append(this.dlClose());
    }

    private void addSignature(StringBuffer buffer, SourceFieldVariable field) {
        SourceClass owningClass = this.getOwningClass((SourceMember)field);
        String qualifiedName = owningClass.getQualifiedName();
        String parentLink = this.createJotLink(qualifiedName, qualifiedName);
        this.h3(buffer, this.code(parentLink));
        buffer.append(this.pre());
        String mods = Modifier.toString(field.getModifiers()) + SPACE;
        JavaType fieldType = field.getSourceType().getResolvedType();
        String lnk = this.createTypeLink(fieldType, new BindingContext(owningClass.getOwningSourceFile().getProvider(), (JavaIsGeneric)owningClass, (JavaType)owningClass));
        buffer.append(mods);
        buffer.append(lnk);
        buffer.append(SPACE);
        StringBuffer fields = new StringBuffer(50);
        List vars = field.getOwningDeclaration().getVariables();
        Iterator variableIterator = vars.iterator();
        while (variableIterator.hasNext()) {
            if (fields.length() > 0) {
                fields.append(", ");
            }
            SourceVariable v = (SourceVariable)variableIterator.next();
            fields.append(v.getName());
        }
        buffer.append(this.b(fields.toString()));
        buffer.append(this.preClose());
    }

    private void addSignature(StringBuffer buffer, SourceClass sourceClass) {
        String pkg = sourceClass.getPackageName();
        if (pkg != null && pkg.length() > 0) {
            this.h3(buffer, pkg);
        }
        int modifiers = sourceClass.getModifiers();
        if (sourceClass.isInterface()) {
            modifiers &= 0xFFFFFBFF;
        }
        String mods = Modifier.toString(modifiers);
        String type = sourceClass.getResolvedType().getQualifiedName();
        if (pkg != null && pkg.length() > 0 && type.startsWith(pkg)) {
            type = type.substring(pkg.length() + 1);
        }
        this.pre(buffer, mods + SPACE + this.b(type));
        JavaType superType = sourceClass.getSuperclass();
        if (superType != null) {
            String linkText = this.createJotLink(superType.getQualifiedName(), superType.getName());
            buffer.append(this.dl());
            buffer.append(this.dt());
            buffer.append(this.code(EXTENDS + linkText));
        }
        Collection ifaces = sourceClass.getInterfaces();
        int len = ifaces.size();
        int counter = 1;
        if (len > 0) {
            if (superType == null) {
                buffer.append(this.dl());
            }
            buffer.append(this.dt());
            buffer.append(this.code());
            buffer.append(IMPLEMENTS);
            for (JavaType ifaceType : ifaces) {
                String ifaceName = ifaceType.getQualifiedName();
                String linkText = this.createJotLink(ifaceName, ifaceName);
                buffer.append(counter < len ? linkText + COMMA + SPACE : linkText);
                ++counter;
            }
            buffer.append(this.codeClose());
        }
        buffer.append(this.dlClose());
    }

    private String getTagDescriptionText(SourceDocHasDescription docElement) {
        SourceDocDescription description = docElement.getDescription();
        if (description == null) {
            return EMPTY_STRING;
        }
        StringBuffer buffer = new StringBuffer();
        String delim = EMPTY_STRING;
        for (Object child : description.getChildren()) {
            buffer.append(delim);
            delim = SPACE;
            if (child instanceof SourceDocInlineTag) {
                SourceDocInlineTag inlineTag = (SourceDocInlineTag)child;
                String tagName = inlineTag.getName();
                if (inlineTag.isReference()) {
                    String ref = "@value".equals(tagName) ? this.unwrapValueReference((SourceDocTag)inlineTag) : this.unwrapReference((SourceDocTag)inlineTag);
                    buffer.append(SPACE);
                    buffer.append(ref);
                    continue;
                }
                if ("@inheritDoc".equals(tagName)) {
                    String inheritedText = this.getInheritedComment((SourceDocElement)docElement);
                    if (inheritedText.length() <= 0) continue;
                    buffer.append(inheritedText);
                    continue;
                }
                if ("@code".equals(tagName) || "@literal".equals(tagName)) {
                    String descriptionText = this.getLiteralDescription((SourceDocInlineTag)child);
                    if (descriptionText.length() <= 0) continue;
                    buffer.append("@code".equals(tagName) ? this.code(descriptionText) : descriptionText);
                    continue;
                }
                String descriptionText = this.getTagDescriptionText((SourceDocHasDescription)inlineTag);
                if (descriptionText.length() == 0) {
                    descriptionText = inlineTag.getArgumentText();
                }
                buffer.append(descriptionText);
                continue;
            }
            SourceDocTextFragment textFragment = (SourceDocTextFragment)child;
            String desc = textFragment.getDocText();
            if (desc.length() <= 0) continue;
            buffer.append(desc.replaceAll("/>", ">"));
        }
        String text = buffer.toString().trim();
        return text.length() == 0 ? text : SPACE + text + SPACE;
    }

    private void addParamComments(StringBuffer buffer, SourceDocTag[] tags) {
        if (tags.length == 0) {
            return;
        }
        boolean hasComment = false;
        SourceDocTag[] sourceDocTagArray = tags;
        int n = 0;
        while (n < sourceDocTagArray.length) {
            SourceDocTag tag = sourceDocTagArray[n];
            if (tag.getDescription() != null) {
                hasComment = true;
                break;
            }
            ++n;
        }
        if (hasComment) {
            String heading = JavadocArb.getString(7);
            this.startDefintionList(buffer, heading);
            SourceDocTag[] sourceDocTagArray2 = tags;
            int n2 = 0;
            while (n2 < sourceDocTagArray2.length) {
                SourceDocTag tag = sourceDocTagArray2[n2];
                if (tag.isParameter()) {
                    String tagDefinition = this.code(tag.getReferenceText());
                    String tagDescription = this.getTagDescriptionText((SourceDocHasDescription)tag);
                    tagDefinition = tagDefinition + (tagDescription.length() > 0 ? DASH + tagDescription : EMPTY_STRING);
                    this.addToDefinitionList(buffer, tagDefinition);
                } else {
                    String tagText = tag.getArgumentText();
                    this.addToDefinitionList(buffer, tagText);
                }
                ++n2;
            }
            this.endDefinitionList(buffer);
        }
    }

    private void addReturnComments(StringBuffer buffer, SourceDocTag[] tags) {
        SourceDocTag tag = tags[0];
        String tagComment = this.getTagDescriptionText((SourceDocHasDescription)tag);
        if (tagComment.length() > 0) {
            String heading = JavadocArb.getString(21);
            this.startDefintionList(buffer, heading);
            this.addToDefinitionList(buffer, tagComment);
            this.endDefinitionList(buffer);
        }
    }

    private void addThrowsComments(SourceMember member, StringBuffer buffer, SourceDocTag[] tags) {
        if (tags.length == 0) {
            return;
        }
        if (!(member instanceof SourceMethod)) {
            return;
        }
        Collection thrown = ((SourceMethod)member).getExceptions();
        int size = thrown.size();
        ArrayList<String> ignore = new ArrayList<String>(size);
        boolean addedHeader = false;
        if (size > 0) {
            String heading = JavadocArb.getString(39);
            this.startDefintionList(buffer, heading);
            addedHeader = true;
            for (JavaType thrownType : thrown) {
                String qualifiedName = thrownType.getQualifiedName();
                String displayName = thrownType.getName();
                boolean match = false;
                SourceDocTag[] sourceDocTagArray = tags;
                int n = 0;
                while (n < sourceDocTagArray.length) {
                    SourceDocTag exTag = sourceDocTagArray[n];
                    String throwsName = exTag.getReferenceText().trim();
                    boolean bl = match = displayName.equals(throwsName) || displayName.endsWith(throwsName);
                    if (match) {
                        String tagText;
                        ignore.add(throwsName);
                        String link = this.createJotLink(qualifiedName, displayName);
                        String tagDefinition = this.code(link);
                        String comment = tagText = this.getTagDescriptionText((SourceDocHasDescription)exTag);
                        if (comment.length() > 0) {
                            tagDefinition = tagDefinition + DASH + comment;
                        }
                        this.addToDefinitionList(buffer, tagDefinition);
                        break;
                    }
                    ++n;
                }
                if (match) continue;
                String link = this.createJotLink(qualifiedName, displayName);
                this.addToDefinitionList(buffer, this.code(link));
            }
        }
        if (tags.length > ignore.size()) {
            SourceDocTag[] sourceDocTagArray = tags;
            int n = 0;
            while (n < sourceDocTagArray.length) {
                SourceDocTag tag = sourceDocTagArray[n];
                if (tag.isException()) {
                    String exName;
                    if (!addedHeader) {
                        String heading = JavadocArb.getString(39);
                        this.startDefintionList(buffer, heading);
                        addedHeader = true;
                    }
                    if ((exName = tag.getReferenceText()) != null && !ignore.contains(exName)) {
                        String link = this.unwrapReference(tag);
                        String tagDefinition = this.code(link);
                        String desc = this.getTagDescriptionText((SourceDocHasDescription)tag);
                        if (desc.length() > 0) {
                            StringBuffer b = new StringBuffer(tagDefinition);
                            b.append(DASH).append(desc);
                            this.addToDefinitionList(buffer, b.toString());
                        } else {
                            this.addToDefinitionList(buffer, tagDefinition);
                        }
                    }
                }
                ++n;
            }
        }
        this.endDefinitionList(buffer);
    }

    private void addSeeComments(StringBuffer buffer, SourceDocTag[] tags) {
        String heading = JavadocArb.getString(75);
        this.startDefintionList(buffer, heading);
        StringBuffer seeText = new StringBuffer(50);
        seeText.append(this.dd());
        int len = tags.length;
        int i = 0;
        while (i < len) {
            String seeLink = this.createSeeLink(tags[i]);
            if (i < len - 1) {
                seeText.append(seeLink);
                seeText.append(", ");
            } else {
                seeText.append(seeLink);
            }
            ++i;
        }
        buffer.append(seeText);
        this.endDefinitionList(buffer);
    }

    private void addOtherComments(StringBuffer buffer, SourceDocTag[] tags) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < tags.length) {
            String commentText = this.getTagDescriptionText((SourceDocHasDescription)tags[i]);
            if (commentText.length() > 0) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append(commentText.trim());
            }
            ++i;
        }
        if (b.length() > 0) {
            String tagName = tags[0].getName();
            String heading = tagName.substring(1) + ":";
            if ("@version".equals(tagName)) {
                heading = JavadocArb.getString(0);
            } else if ("@since".equals(tagName)) {
                heading = JavadocArb.getString(103);
            }
            this.startDefintionList(buffer, heading);
            this.addToDefinitionList(buffer, b.toString());
            this.endDefinitionList(buffer);
        }
    }

    private void addDeprecatedComments(StringBuffer buffer, SourceDocTag[] tags) {
        StringBuffer depr = new StringBuffer(this.b(JavadocArb.getString(109)));
        depr.append(SPACE).append(this.getTagDescriptionText((SourceDocHasDescription)tags[0]));
        this.p(buffer, depr.toString());
    }

    private String getLiteralDescription(SourceDocInlineTag inlineTag) {
        SourceDocDescription desc = inlineTag.getDescription();
        String text = desc.getDocText();
        if (text.length() > 0) {
            CharSequence inputStr = text.subSequence(0, text.length());
            String[][] stringArray = LITERAL_CONVERSION_MAP;
            int n = 0;
            while (n < stringArray.length) {
                String[] s = stringArray[n];
                String patternStr = s[0];
                String replacementStr = s[1];
                Pattern pattern = Pattern.compile(patternStr);
                Matcher matcher = pattern.matcher(inputStr);
                inputStr = matcher.replaceAll(replacementStr);
                ++n;
            }
            return inputStr.toString();
        }
        return EMPTY_STRING;
    }

    private String getInheritedComment(SourceDocElement sourceDocElement) {
        SourceMember member = sourceDocElement.getOwningMember();
        if (!(member instanceof SourceMethod)) {
            return EMPTY_STRING;
        }
        SourceMethod sourceMethod = (SourceMethod)member;
        for (JavaMethod javaMethod : sourceMethod.getOverriddenMethods()) {
            SourceDocBlockTag pTag;
            String pname;
            SourceDocComment superComment;
            SourceElement methodSourceElement = javaMethod.getSourceElement();
            if (methodSourceElement == null || (superComment = ((SourceMethod)methodSourceElement).getDocComment()) == null) continue;
            if (sourceDocElement instanceof SourceDocComment) {
                return this.getTagDescriptionText((SourceDocHasDescription)superComment);
            }
            if (!(sourceDocElement instanceof SourceDocTag)) continue;
            SourceDocTag superTag = (SourceDocTag)sourceDocElement;
            if ("@return".equals(superTag.getName())) {
                Collection foundTags = superComment.findTags("@return");
                if (foundTags.size() <= 0) continue;
                SourceDocTag[] tags = foundTags.toArray(new SourceDocTag[foundTags.size()]);
                return this.getTagDescriptionText((SourceDocHasDescription)tags[0]);
            }
            if (superTag.isException()) {
                SourceDocBlockTag exTag;
                String exname;
                SourceDocReference ref = superTag.getReference();
                String string = exname = ref != null ? ref.getClassName() : superTag.getReferenceText();
                if (exname == null) {
                    exname = superTag.getReferenceText();
                }
                if ((exTag = superComment.findExceptionTag(exname)) == null) continue;
                return this.getTagDescriptionText((SourceDocHasDescription)exTag);
            }
            if (!superTag.isParameter()) continue;
            SourceDocReference ref = superTag.getReference();
            String string = pname = ref != null ? ref.getParameterName() : superTag.getReferenceText();
            if (pname == null) {
                pname = superTag.getReferenceText();
            }
            if ((pTag = superComment.findParameterTag(pname)) == null) continue;
            return this.getTagDescriptionText((SourceDocHasDescription)pTag);
        }
        return EMPTY_STRING;
    }

    private String unwrapValueReference(SourceDocTag referenceTag) {
        SourceExpression initializer;
        JavaHasType refObject;
        SourceDocReference ref = referenceTag.getReference();
        if (ref != null && (refObject = ref.getResolvedObject()) instanceof SourceFieldVariable && (initializer = ((SourceFieldVariable)refObject).getInitializer()) != null) {
            return initializer.getText();
        }
        return null;
    }

    private String unwrapReference(SourceDocTag referenceTag) {
        String link;
        StringBuffer data = new StringBuffer(100);
        SourceDocReference reference = referenceTag.getReference();
        if (reference != null) {
            String target = this.determineLinkTarget(referenceTag);
            if (target == null) {
                link = this.error(referenceTag.getText());
            } else {
                SourceDocDescription desc;
                String tagDescription = referenceTag.isException() ? referenceTag.getReferenceText() : ((desc = referenceTag.getDescription()) != null ? desc.getDocText() : referenceTag.getArgumentText());
                String display = tagDescription.startsWith(POUND) ? tagDescription.substring(1) : tagDescription.replace('#', '.');
                link = this.createJotLink(target, display);
            }
        } else {
            String descriptionText = this.getTagDescriptionText((SourceDocHasDescription)referenceTag);
            if (descriptionText.length() == 0) {
                descriptionText = referenceTag.getArgumentText();
            }
            link = descriptionText;
        }
        data.append(link);
        return data.toString();
    }

    private String determineLinkTarget(SourceDocTag referenceTag) {
        String className = null;
        String memberName = null;
        SourceDocReference ref = referenceTag.getReference();
        if (ref != null) {
            memberName = ref.getMemberName();
            JavaHasType refObject = ref.getResolvedObject();
            if (refObject instanceof JavaMember) {
                JavaMember member = (JavaMember)refObject;
                if (3 == refObject.getElementKind()) {
                    className = member.getResolvedType().getQualifiedName();
                } else {
                    SourceElement se = member.getSourceElement();
                    if (se != null) {
                        className = ((JavaMember)se).getOwningClass().getQualifiedName();
                    }
                }
            }
        }
        if (className != null) {
            if (memberName == null) {
                return className;
            }
            Collection paramList = ref.getMethodParameterTypeNames();
            int size = paramList.size();
            if (size > 0) {
                int counter = 1;
                StringBuffer buffer = new StringBuffer(50);
                buffer.append(OPEN_PAREN);
                for (String pname : paramList) {
                    buffer.append(pname.endsWith(ARRAY) ? pname.substring(0, pname.length() - 2) : pname);
                    if (counter++ >= size) continue;
                    buffer.append(", ");
                }
                buffer.append(CLOSE_PAREN);
                memberName = memberName + buffer.toString();
            } else if (referenceTag.getDocText().indexOf(40) != -1) {
                memberName = memberName + PARENS;
            }
            return className + POUND + memberName;
        }
        return null;
    }

    private String createSeeLink(SourceDocTag seeTag) {
        String target;
        SourceDocReference ref = seeTag.getReference();
        if (ref != null && (target = this.determineLinkTarget(seeTag)) != null) {
            String argText;
            int pound = target.indexOf(35);
            if (pound == -1) {
                String className = this.getShortName(target);
                String link = this.createJotLink(target, className);
                return this.code(link);
            }
            String description = EMPTY_STRING;
            SourceDocDescription seeTagDescription = seeTag.getDescription();
            if (seeTagDescription != null) {
                description = seeTag.getDescription().getText().trim();
            }
            String display = description.length() > 0 ? description : ((argText = seeTag.getArgumentText()).startsWith(POUND) ? argText.substring(1) : argText.replaceAll(POUND, "."));
            String link = this.createJotLink(target, display);
            return this.code(link);
        }
        return seeTag.getArgumentText();
    }

    private String createJotLink(String linkTarget, String displayText) {
        String toDisplay = displayText.trim().replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        return "<a href=\"jot_href://" + linkTarget + SPLIT_HREF + toDisplay + END_HREF;
    }

    private Map<String, List<SourceDocTag>> groupTagsByType(List<SourceDocBlockTag> allTags) {
        HashMap<String, List<SourceDocTag>> map = new HashMap<String, List<SourceDocTag>>();
        for (SourceDocBlockTag current : allTags) {
            List<SourceDocBlockTag> tagList;
            String key;
            String tagName = current.getName();
            String string = key = "@exception".equals(tagName) ? "@throws" : tagName;
            if (map.containsKey(key)) {
                tagList = (List)map.get(key);
            } else {
                tagList = new ArrayList();
                map.put(key, tagList);
            }
            tagList.add(current);
        }
        return map;
    }

    private String createTypeLink(JavaType linkType, BindingContext bindingContext) {
        JavaType boundType = bindingContext.bind(linkType);
        String textForType = this.getTextForType(boundType);
        StringBuffer b = new StringBuffer(textForType);
        if (linkType.hasTypeParameters()) {
            Collection typeParams = linkType.getActualTypeArguments();
            String delim = "&lt;";
            for (JavaType t : typeParams) {
                b.append(delim);
                String typeLink = this.createTypeLink(t, bindingContext);
                b.append(typeLink);
                delim = ", ";
            }
            b.append("&gt;");
        }
        return b.toString();
    }

    private String getTextForType(JavaType javaType) {
        JavaType type = javaType.isArray() ? javaType.getComponentType() : javaType;
        if (type.isPrimitive()) {
            return javaType.getName();
        }
        String displayName = javaType.getName();
        JavaClass erasure = type.getTypeErasure();
        String qualifiedClassName = erasure.getQualifiedName();
        return this.createJotLink(qualifiedClassName, displayName);
    }

    private SourceClass getOwningClass(SourceMember member) {
        SourceMember element = member;
        while (element != null) {
            if (element instanceof SourceClass) {
                return (SourceClass)element;
            }
            element = element.getParent();
        }
        return null;
    }

    private String filler(int columnStart) {
        StringBuffer fill = new StringBuffer(columnStart);
        int i = 0;
        while (i < columnStart) {
            fill.append(NB_SPACE);
            ++i;
        }
        return fill.toString();
    }

    private String getShortName(String name) {
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return name;
        }
        return name.substring(++idx);
    }

    private void startDefintionList(StringBuffer buff, String title) {
        buff.append(this.dl());
        this.dt(buff, this.b(title));
    }

    private void addToDefinitionList(StringBuffer buff, String item) {
        buff.append(this.dd());
        buff.append(item);
    }

    private void endDefinitionList(StringBuffer buff) {
        buff.append(this.dlClose());
    }

    private void h3(StringBuffer buffer, String heading) {
        buffer.append(this.h3());
        buffer.append(heading);
        buffer.append(this.h3Close());
    }

    private void p(StringBuffer buffer, String text) {
        buffer.append(this.p());
        buffer.append(text);
        buffer.append(this.pClose());
    }

    private void pre(StringBuffer buffer, String formattedText) {
        buffer.append(this.pre());
        buffer.append(formattedText);
        buffer.append(this.preClose());
    }

    private void dt(StringBuffer buffer, String text) {
        buffer.append(this.dt());
        buffer.append(text);
        buffer.append(this.dtClose());
    }

    private String br() {
        return "<br>";
    }

    private String code() {
        return "<code>";
    }

    private String codeClose() {
        return "</code>";
    }

    private String code(String codeText) {
        return this.code() + codeText + this.codeClose();
    }

    private String error() {
        return "<font color = \"red\">";
    }

    private String errorClose() {
        return "</font>";
    }

    private String error(String errorText) {
        return this.error() + errorText + this.errorClose();
    }

    private String b() {
        return "<b>";
    }

    private String bClose() {
        return "</b>";
    }

    private String b(String boldText) {
        return this.b() + boldText + this.bClose();
    }

    private String pre() {
        return "<pre>";
    }

    private String preClose() {
        return "</pre>";
    }

    private String p() {
        return "<p>";
    }

    private String pClose() {
        return "</p>";
    }

    private String h3() {
        return "<h3>";
    }

    private String h3Close() {
        return "</h3>";
    }

    private String dl() {
        return "<dl>";
    }

    private String dlClose() {
        return "</dl>";
    }

    private String dd() {
        return "<dd>";
    }

    private String dt() {
        return "<dt>";
    }

    private String dtClose() {
        return "</dt>";
    }
}

