/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc.popup;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.htmlpopup.ContentProvider;
import oracle.ide.ceditor.htmlpopup.HtmlPopupView;
import oracle.ide.ceditor.htmlpopup.StaticContentProvider;
import oracle.ide.model.Project;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.help.JavadocUtil;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.javadoc.JavadocArb;
import oracle.jdevimpl.javadoc.popup.JavadocFormater;

public final class SourceMemberProvider
implements ContentProvider {
    private JavaManager _javaManager;
    private SourceMember _sourceMember;
    private Context _context;

    public SourceMemberProvider(Context context, SourceMember sourceMember) {
        this._context = context;
        Project project = this._context.getProject();
        this._javaManager = JavaManager.getJavaManager((Project)project);
        this._sourceMember = sourceMember;
    }

    public String getHTML() {
        JavadocFormater javadocFormater = JavadocFormater.getInstance();
        String javadoc = javadocFormater.getJavadoc(this._sourceMember);
        return javadoc;
    }

    public void navigate(HtmlPopupView popupView, String reference) {
        if (reference.startsWith("jot_href://")) {
            String jotRef = reference.substring("jot_href://".length());
            SourceMember handle = this.resolveJotReference(jotRef);
            if (handle != null) {
                this.activateJavadocLink(popupView, handle);
            } else {
                String text = JavadocArb.format(97, jotRef);
                popupView.push((ContentProvider)new StaticContentProvider(text));
            }
        } else {
            this.activateExternalLink(reference);
        }
    }

    public boolean isError() {
        return false;
    }

    private SourceMember resolveJotReference(String target) {
        String membername;
        String classname;
        int pound = target.indexOf(35);
        if (pound >= 0) {
            String[] reference = target.split("#");
            classname = reference[0];
            membername = reference[1];
        } else {
            classname = target;
            membername = null;
        }
        SourceClass cls = this._javaManager.getSourceClass(classname);
        if (cls != null) {
            String mName;
            if (membername == null) {
                return cls;
            }
            int paren = membername.indexOf("(");
            boolean hasParens = paren != -1;
            String string = mName = hasParens ? membername.substring(0, paren) : membername;
            if (classname.endsWith("." + mName)) {
                String params = paren != -1 ? membername.substring(paren + 1) : "";
                String[] paramTypes = this.getParameterTypes(params);
                List list = cls.getSourceConstructors();
                SourceMethod[] constructors = list.toArray(new SourceMethod[list.size()]);
                SourceMethod constr = this.getMatchingMethod(constructors, paramTypes);
                if (constr != null) {
                    return constr;
                }
            }
            String params = paren != -1 ? membername.substring(paren + 1) : "";
            String[] paramTypes = this.getParameterTypes(params);
            Collection coll = cls.getSourceMethods(mName);
            SourceMethod[] methods = coll.toArray(new SourceMethod[coll.size()]);
            SourceMethod method = this.getMatchingMethod(methods, paramTypes);
            if (method != null) {
                return method;
            }
            SourceFieldVariable field = cls.getSourceFieldVariable(membername);
            if (field != null) {
                return field;
            }
        }
        return null;
    }

    private void activateExternalLink(String href) {
        try {
            if (href.toLowerCase().startsWith("http:")) {
                BrowserRunner.getBrowserRunner().runBrowserOnURL(new URL(href), null, null);
            } else if (href.startsWith("#")) {
                String itemName = this._sourceMember.getEnclosingClass().getQualifiedName();
                URL url = JavadocUtil.resolveJavadocURL(this._context, itemName);
                if (url != null && url.getRef() != null) {
                    String newUrl = url.toString();
                    int idx = newUrl.lastIndexOf("#");
                    if (idx >= 0) {
                        newUrl = newUrl.substring(idx + 1) + href;
                    }
                    BrowserRunner.getBrowserRunner().runBrowserOnURL(new URL(newUrl), null, null);
                }
            } else {
                URL url = new URL(href);
                BrowserRunner.getBrowserRunner().runBrowserOnURL(url, null, null);
            }
        }
        catch (MalformedURLException e) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)JavadocArb.format(38, href), (String)JavadocArb.getString(81), null);
        }
    }

    private void activateJavadocLink(HtmlPopupView popupView, SourceMember member) {
        SourceMemberProvider sourceMemberProvider = new SourceMemberProvider(this._context, member);
        popupView.push((ContentProvider)sourceMemberProvider);
    }

    private SourceMethod getMatchingMethod(SourceMethod[] methods, String[] typeNames) {
        int i = 0;
        while (i < methods.length) {
            SourceVariable[] types;
            SourceMethod method = methods[i];
            List parameters = method.getSourceParameters();
            if (typeNames.length == parameters.size() && this.matches(types = parameters.toArray(new SourceVariable[parameters.size()]), typeNames)) {
                return method;
            }
            ++i;
        }
        if (typeNames.length == 0) {
            return methods.length > 0 ? methods[0] : null;
        }
        return null;
    }

    private boolean matches(SourceVariable[] types, String[] typeNames) {
        int x = 0;
        while (x < types.length) {
            String tname = typeNames[x];
            JavaType paramType = types[x].getSourceType().getResolvedType();
            if (paramType == null) {
                return false;
            }
            String qualifiedVarTypeName = paramType.getTypeErasure().getQualifiedName();
            if (!qualifiedVarTypeName.equals(tname) && !qualifiedVarTypeName.endsWith("." + tname)) {
                return false;
            }
            ++x;
        }
        return true;
    }

    private String[] getParameterTypes(String methodName) {
        StringTokenizer tokenizer = new StringTokenizer(methodName, "(,)", false);
        ArrayList<String> l = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String elem = tokenizer.nextElement().toString().trim();
            if (elem.length() <= 0) continue;
            l.add(elem);
        }
        String[] params = new String[l.size()];
        l.toArray(params);
        return params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceMemberProvider that = (SourceMemberProvider)o;
        return this._sourceMember.equals(that._sourceMember);
    }

    public int hashCode() {
        return this._sourceMember.hashCode();
    }
}

