/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.jvmti.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class Transport {
    private Socket socket;
    private DataInputStream dataInputStream;
    private DataOutputStream dataOutputStream;
    private int negotiatedVersion;

    public boolean makeSocketConnection(int port, String handshake, int version) {
        try {
            ServerSocket serverSocket = new ServerSocket(port);
            this.socket = serverSocket.accept();
            serverSocket.close();
            this.dataInputStream = new DataInputStream(this.socket.getInputStream());
            this.dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
            int handshakeLength = handshake.length();
            int i = 0;
            while (i < handshakeLength) {
                char ch = handshake.charAt(i);
                this.dataOutputStream.writeByte((byte)ch);
                char chRead = (char)this.dataInputStream.readByte();
                if (chRead != ch) {
                    boolean bl = false;
                    return bl;
                }
                ++i;
            }
            this.sendInt(version);
            this.negotiatedVersion = this.receiveInt();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void closeSocketConnection() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    public void sendByte(byte b) throws IOException {
        this.dataOutputStream.writeByte(b);
    }

    public void sendBoolean(boolean b) throws IOException {
        this.dataOutputStream.writeBoolean(b);
    }

    public void sendShort(short s) throws IOException {
        this.dataOutputStream.writeShort(s);
    }

    public void sendChar(char c) throws IOException {
        this.dataOutputStream.writeChar(c);
    }

    public void sendInt(int n) throws IOException {
        this.dataOutputStream.writeInt(n);
    }

    public void sendLong(long n) throws IOException {
        this.dataOutputStream.writeLong(n);
    }

    public void sendFloat(float f) throws IOException {
        this.dataOutputStream.writeFloat(f);
    }

    public void sendDouble(double d) throws IOException {
        this.dataOutputStream.writeDouble(d);
    }

    public byte receiveByte() throws IOException {
        return this.dataInputStream.readByte();
    }

    public boolean receiveBoolean() throws IOException {
        return this.dataInputStream.readBoolean();
    }

    public short receiveShort() throws IOException {
        return this.dataInputStream.readShort();
    }

    public char receiveChar() throws IOException {
        return this.dataInputStream.readChar();
    }

    public int receiveInt() throws IOException {
        return this.dataInputStream.readInt();
    }

    public long receiveLong() throws IOException {
        return this.dataInputStream.readLong();
    }

    public float receiveFloat() throws IOException {
        return this.dataInputStream.readFloat();
    }

    public double receiveDouble() throws IOException {
        return this.dataInputStream.readDouble();
    }

    public void sendString(String s) throws IOException {
        byte[] bytes = s.getBytes("UTF-8");
        this.dataOutputStream.writeInt(bytes.length);
        this.dataOutputStream.write(bytes);
    }

    public String receiveString() throws IOException {
        int length = this.dataInputStream.readInt();
        byte[] bytes = new byte[length];
        this.dataInputStream.read(bytes);
        return new String(bytes, "UTF-8");
    }
}

