/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.model;

import java.awt.Font;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.xml.bind.ElementListEvent;
import oracle.javatools.xml.bind.ElementListListener;
import oracle.jdevimpl.deploy.res.CommonArb;
import oracle.jdevimpl.deploy.res.WarArb;
import oracle.jdevimpl.model.WorkingSetsEditor;
import oracle.jdevimpl.xml.ArrayElementList;
import oracle.jdevimpl.xml.DetailPanel;
import oracle.jdevimpl.xml.MasterPanel;

public class PatternFiltersPanel
extends MasterPanel {
    private transient ArrayElementList _filterList;

    public PatternFiltersPanel() {
        super(CommonArb.getString(5), "f1_depfgpkgpatternfilter_html", true);
        this.setListFont(new Font("Monospaced", 0, 12));
    }

    protected void onEntryImpl(TraversableContext tc) {
        PatternFilters patternFilters = WorkingSetsEditor.getPatternFilters((Namespace)tc);
        boolean nonNullFilters = patternFilters != null;
        Object[] filters = nonNullFilters ? patternFilters.getFilters() : null;
        this._filterList = new ArrayElementList(PatternFilter.class, filters);
        this._filterList.addElementListListener(new 1(this, patternFilters));
        this.setElementList(this._filterList);
        this.setAddButtonEnabled(nonNullFilters);
    }

    protected void onExitImpl(TraversableContext tc) throws TraversalException {
        PatternFilters patternFilters = WorkingSetsEditor.getPatternFilters((Namespace)tc);
        boolean nonNullFilters = patternFilters != null;
        PatternFilter[] filters = nonNullFilters ? patternFilters.getFilters() : null;
        PatternFilter[] activeFilters = (PatternFilter[])this._filterList.getData();
        if (filters != null && activeFilters != null && filters.length == activeFilters.length) {
            int i = 0;
            while (i < filters.length) {
                if (!filters[i].equals((Object)activeFilters[i])) {
                    this.updateFilters(patternFilters);
                    return;
                }
                ++i;
            }
            return;
        }
        this.updateFilters(patternFilters);
    }

    private void updateFilters(PatternFilters patternFilters) {
        if (patternFilters != null) {
            patternFilters.setFilters((PatternFilter[])this._filterList.getData());
        }
    }

    protected String getElementListItemKey() {
        return "pattern-filter";
    }

    protected DetailPanel newCreatePanel() {
        return new Details(true);
    }

    protected boolean prependNewItems() {
        return true;
    }

    protected Traversable newDetailPanel() {
        return new Details(false);
    }

    protected String getDisplayName(Object data) {
        return data != null ? data.toString() : CommonArb.getString(102);
    }

    protected boolean showUpDownButtons() {
        return true;
    }

    static void mav$updateFilters(PatternFiltersPanel patternFiltersPanel, PatternFilters patternFilters) {
        patternFiltersPanel.updateFilters(patternFilters);
    }

    final class 1
    implements ElementListListener {
        private final /* synthetic */ PatternFilters v$patternFilters;
        final /* synthetic */ PatternFiltersPanel this$0;

        public void elementsAdded(ElementListEvent e) {
            PatternFiltersPanel.mav$updateFilters(this.this$0, this.v$patternFilters);
        }

        public void elementsRemoved(ElementListEvent e) {
            PatternFiltersPanel.mav$updateFilters(this.this$0, this.v$patternFilters);
        }

        public void elementsChanged(ElementListEvent e) {
            PatternFiltersPanel.mav$updateFilters(this.this$0, this.v$patternFilters);
        }

        public 1(PatternFiltersPanel patternFiltersPanel, PatternFilters patternFilters) {
            this.v$patternFilters = patternFilters;
            this.this$0 = patternFiltersPanel;
        }
    }

    private class Details
    extends DetailPanel {
        private final JRadioButton rbInclude;
        private final JRadioButton rbExclude;
        private final ButtonGroup group;
        private final JTextField tfPattern;
        private transient PatternFilter _curFilter;

        private void $init$() {
            this.rbInclude = new JRadioButton();
            this.rbExclude = new JRadioButton();
            this.group = new ButtonGroup();
        }

        Details(boolean isForDialog) {
            super(isForDialog, "f1_depfgdlgselpat_html");
            this.$init$();
            ResourceUtils.resButton((AbstractButton)this.rbInclude, (String)CommonArb.getString(94));
            ResourceUtils.resButton((AbstractButton)this.rbExclude, (String)CommonArb.getString(17));
            this.group.add(this.rbInclude);
            this.group.add(this.rbExclude);
            if (isForDialog) {
                this.rbExclude.setSelected(true);
            }
            this.addLabeledPanel(CommonArb.getString(6), new JRadioButton[]{this.rbInclude, this.rbExclude});
            this.tfPattern = this.addWatchedTextField(WarArb.getString(135));
            this.tfPattern.setFont(new Font("Monospaced", 0, 12));
        }

        protected void onEntryImpl(TraversableContext tc, Object data) {
            this._curFilter = data instanceof PatternFilter ? (PatternFilter)data : PatternFilter.newExclude((String)"");
            if (this._curFilter.isExclude()) {
                this.rbExclude.setSelected(true);
            } else {
                this.rbInclude.setSelected(true);
            }
            this.tfPattern.setText(this._curFilter.getPattern());
            this.tieTextComponentToMasterList(this.tfPattern, tc);
            this.tieItemSelectableToMasterList(this.rbInclude, tc);
            this.tieItemSelectableToMasterList(this.rbExclude, tc);
        }

        protected void onExitImpl(TraversableContext tc, Object data) throws TraversalException {
            this.untieItemSelectableFromMasterList(this.rbInclude);
            this.untieItemSelectableFromMasterList(this.rbExclude);
            this.untieTextComponentFromMasterList(this.tfPattern);
            String pattern = this.tfPattern.getText();
            PatternFilter patternFilter = this.rbInclude.isSelected() ? PatternFilter.newInclude((String)pattern) : PatternFilter.newExclude((String)pattern);
            tc.put(PatternFiltersPanel.this.getElementListItemKey(), (Object)patternFilter);
        }

        protected String getDialogTitle() {
            return WarArb.getString(63);
        }

        protected void flushPrimaryTextComponent() {
            this._curFilter.setInclude(this.rbInclude.isSelected());
            this._curFilter.setPattern(this.tfPattern.getText());
        }
    }
}

