/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.model;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.model.ContentLevel;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.common.FileGroupPackager;
import oracle.jdeveloper.resource.ModelArb;
import oracle.jdevimpl.model.DirectoriesPatternFilterPanel;
import oracle.jdevimpl.model.FilesPatternFilterPanel;
import oracle.jdevimpl.model.WorkingSetsEditor;

public class PatternFiltersTreePanel
extends DefaultTraversablePanel
implements ActionListener,
GridBagConstants,
TreeWillExpandListener,
TreeCellCheckedListener {
    private final JScrollPane _spFiles;
    private final JMutableTreeNode _root;
    private final DefaultTreeModel _treeModel;
    private final FileURLComparator _urlComparator;
    protected final JButton _btnFilterFiles;
    protected final JButton _btnFilterDirectories;
    protected JPanel _buttonPanel;
    protected CustomJTree _dirTree;
    private KeyNavigationManager keyMgr;
    private PatternFilters _filters;
    private Project _lastProject;
    protected ContentLevelNode _rootNode;
    private transient ContentLevel _contentLevel;
    private static final String CONTENT_LEVEL = "content-level-data";
    protected String _rootNodeLabel;

    private void $init$() {
        this._spFiles = new JScrollPane();
        this._root = new JMutableTreeNode();
        this._treeModel = new DefaultTreeModel((TreeNode)this._root, true);
        this._urlComparator = new FileURLComparator(null);
        this._btnFilterFiles = new JButton();
        this._btnFilterDirectories = new JButton();
        this._rootNodeLabel = ModelArb.getString((int)17);
    }

    public PatternFiltersTreePanel() {
        this.$init$();
        this.createTree();
        this._btnFilterFiles.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._btnFilterFiles, (String)ModelArb.getString((int)124));
        this._btnFilterDirectories.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._btnFilterDirectories, (String)ModelArb.getString((int)142));
        this._spFiles.getViewport().add((Component)this._dirTree, null);
        this._dirTree.setRootVisible(false);
        this._dirTree.setShowsRootHandles(false);
        this._dirTree.addTreeCellCheckedListener((TreeCellCheckedListener)this);
        this._dirTree.addTreeWillExpandListener((TreeWillExpandListener)this);
        this._dirTree.enableToolTips(true);
        this._dirTree.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setLayout(new GridBagLayout());
        Insets in5555 = new Insets(5, 5, 0, 5);
        Insets in0088 = new Insets(8, 3, 5, 5);
        this.add(this._spFiles, this.gbc(0, 0, 1, 1, 1.0, 1.0, 18, 1, in5555));
        this._buttonPanel = new JPanel(new GridLayout(1, 2, 8, 0));
        this.add(this._buttonPanel, this.gbc(0, 1, 1, 1, 0.0, 0.0, 14, 0, in0088));
        this._buttonPanel.add(this._btnFilterFiles);
        this._buttonPanel.add(this._btnFilterDirectories);
        this.setHelpID("f1_depfgpkgfilefilter_html");
    }

    public void onEntry(TraversableContext tc) {
        Project project = (Project)tc.find("Project");
        this._filters = WorkingSetsEditor.getPatternFilters((Namespace)tc);
        if (this._filters == null) {
            this._rootNode = null;
        } else {
            if (this._rootNode != null && this._rootNode.isLoaded() && project == this._lastProject) {
                this.updateCheckedStates(this._rootNode);
                return;
            }
            this._lastProject = project;
            this._rootNode = new ContentLevelNode(project);
            PatternFilters includeAllFilters = PatternFilters.getInstance((HashStructure)HashStructure.newInstance());
            includeAllFilters.addInclude("**");
            ContentSet projectContent = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
            this._contentLevel = ContentLevel.newInstanceForHideDirs((ContentSet)projectContent, (PatternFilters)includeAllFilters, (boolean)false);
            ContentLevel contentLevel = (ContentLevel)tc.find(CONTENT_LEVEL);
            if (this._contentLevel != null && ModelUtil.areEqual((Object)this._contentLevel, (Object)contentLevel)) {
                this.updateCheckedStates(this._rootNode);
                return;
            }
            tc.put(CONTENT_LEVEL, (Object)this._contentLevel);
            this._root.removeAllChildren();
            this._root.add((MutableTreeNode)((Object)this._rootNode));
            this._treeModel.nodeStructureChanged((TreeNode)this._root);
            this._dirTree.setVisible(true);
            this._dirTree.setEnabled(this._filters != null);
            String[] selection = (String[])tc.find("initial-selection");
            this.initializeTreeSelection(selection);
            this.updateCheckedStates(this._rootNode);
        }
        boolean enable = false;
        if (this._filters != null && this._rootNode != null) {
            enable = true;
        }
        this._dirTree.setVisible(enable);
        this._btnFilterDirectories.setEnabled(enable);
        this._btnFilterFiles.setEnabled(enable);
    }

    public void onExit(TraversableContext tc) {
    }

    public void treeWillExpand(TreeExpansionEvent e) {
        TreePath tp = e.getPath();
        ContentLevelNode node = (ContentLevelNode)((Object)tp.getLastPathComponent());
        node.maybeLoad();
    }

    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    public void cellChecked(TreeCellCheckedEvent e) {
        this.handleCheck(e, true);
    }

    public void cellUnchecked(TreeCellCheckedEvent e) {
        this.handleCheck(e, false);
    }

    private void handleCheck(TreeCellCheckedEvent e, boolean isInclude) {
        ContentLevelNode node = (ContentLevelNode)((Object)e.getSource());
        String name = ContentLevelNode.mav$isRootPath(node) ? "**" : node.getRelPath();
        if (name != null) {
            if (isInclude) {
                this._filters.addInclude(name, true);
            } else {
                this._filters.addExclude(name, true);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        DirectoriesPatternFilterPanel filterPanel;
        JMutableTreeNode dirNode = this.getNearestDirectory();
        String path = dirNode.isRoot() ? "" : ((ContentLevelNode)dirNode).getRelPath();
        Object source = e.getSource();
        if (source == this._btnFilterFiles) {
            FilesPatternFilterPanel filterPanel2 = new FilesPatternFilterPanel();
            if (filterPanel2.showDialog((Component)((Object)this), this._filters, path)) {
                this.updateCheckedStates(this._rootNode);
                this._dirTree.repaint();
            }
        } else if (source == this._btnFilterDirectories && (filterPanel = new DirectoriesPatternFilterPanel()).showDialog((Component)((Object)this), this._filters, path)) {
            this.updateCheckedStates(this._rootNode);
            this._dirTree.repaint();
        }
    }

    private void initializeTreeSelection(String[] selection) {
        TreePath treePath;
        if (selection != null && selection.length > 0 && (treePath = this.convertPath(selection)) != null) {
            this._dirTree.expandPath(treePath);
            this._dirTree.setSelectionPath(treePath);
            this._dirTree.scrollPathToVisible(treePath);
            return;
        }
        IdeUtil.expandTreeToDepth((JTree)this._dirTree, (int)2);
    }

    private TreePath convertPath(String[] path) {
        if (path != null && path.length > 0) {
            TreePath rootPath = new TreePath(this._root);
            TreePath root2Path = rootPath.pathByAddingChild(this._root.getChildAt(0));
            return this.findPath(root2Path, path, 0);
        }
        return null;
    }

    private TreePath findPath(TreePath treePath, String[] path, int index) {
        ContentLevelNode parent = (ContentLevelNode)((Object)treePath.getLastPathComponent());
        parent.maybeLoad();
        int count = parent.getChildCount();
        int i = 0;
        while (i < count) {
            ContentLevelNode child = (ContentLevelNode)((Object)parent.getChildAt(i));
            if (ContentLevelNode.ra$_label(child).equals(path[index])) {
                TreePath curPath = treePath.pathByAddingChild((Object)child);
                if (++index < path.length) {
                    return this.findPath(curPath, path, index);
                }
                return curPath;
            }
            ++i;
        }
        return null;
    }

    private void createTree() {
        this._dirTree = new 1(this._treeModel);
        this.keyMgr = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)new KeyNavigationManager.TreeKeyAdapter((JTree)this._dirTree));
        this._dirTree.setExpandsSelectedPaths(true);
        this._dirTree.setScrollsOnExpand(true);
    }

    private void updateCheckedStates(ContentLevelNode node) {
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            node.getModel().setCheckBoxState(this.isSelected(node.getRelPath()));
            return;
        }
        if (node.isLoaded()) {
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                ContentLevelNode childNode = (ContentLevelNode)((Object)children.nextElement());
                if (childNode == null) continue;
                this.updateCheckedStates(childNode);
            }
            node.updateNodes();
        } else {
            TriStateBoolean checkBoxState = TriStateBoolean.FALSE;
            if (this._filters != null) {
                checkBoxState = this._filters.inferFromFilters(node.getRelPath());
            }
            node.getModel().setCheckBoxState(checkBoxState);
        }
    }

    private boolean isSelected(String relPath) {
        return this._filters != null ? this._filters.isIncluded(relPath) : false;
    }

    private TriStateBoolean isInitiallySelected(String relPath) {
        return this._filters != null ? this._filters.inferFromFilters(relPath) : TriStateBoolean.FALSE;
    }

    private static String getLabel(String path) {
        if (path != null) {
            if (path.endsWith("/")) {
                int dirSlash = path.lastIndexOf(47);
                if (dirSlash > 0) {
                    int lastSlash = path.lastIndexOf(47, dirSlash - 1);
                    return path.substring(lastSlash >= 0 ? lastSlash + 1 : 0, dirSlash);
                }
            } else {
                int lastSlash = path.lastIndexOf("/");
                if (lastSlash >= 0) {
                    return path.substring(lastSlash + 1);
                }
            }
        }
        return path;
    }

    private static JTreeCellData newJTreeCellData(ContentLevel contentLevel, String label) {
        String urlStr;
        JTreeCellData cellData = new JTreeCellData(label);
        if (contentLevel != null && ModelUtil.hasLength((String)(urlStr = URLFileSystem.getPlatformPathName((URL)contentLevel.getDirectoryURL())))) {
            cellData.setToolTipText(urlStr);
        }
        return cellData;
    }

    private JMutableTreeNode getNearestDirectory() {
        JMutableTreeNode curNode = (JMutableTreeNode)this._dirTree.getLastSelectedPathComponent();
        if (curNode.isLeaf()) {
            return (JMutableTreeNode)curNode.getParent();
        }
        return curNode;
    }

    static JTreeCellData maS$newJTreeCellData(ContentLevel contentLevel, String string) {
        return PatternFiltersTreePanel.newJTreeCellData(contentLevel, string);
    }

    static TriStateBoolean mav$isInitiallySelected(PatternFiltersTreePanel patternFiltersTreePanel, String string) {
        return patternFiltersTreePanel.isInitiallySelected(string);
    }

    static String maS$getLabel(String string) {
        return PatternFiltersTreePanel.getLabel(string);
    }

    static KeyNavigationManager ra$keyMgr(PatternFiltersTreePanel patternFiltersTreePanel) {
        return patternFiltersTreePanel.keyMgr;
    }

    static DefaultTreeModel ra$_treeModel(PatternFiltersTreePanel patternFiltersTreePanel) {
        return patternFiltersTreePanel._treeModel;
    }

    static ContentLevel ra$_contentLevel(PatternFiltersTreePanel patternFiltersTreePanel) {
        return patternFiltersTreePanel._contentLevel;
    }

    static FileURLComparator ra$_urlComparator(PatternFiltersTreePanel patternFiltersTreePanel) {
        return patternFiltersTreePanel._urlComparator;
    }

    final class 1
    extends CustomJTree {
        protected void processKeyEvent(KeyEvent e) {
            if (PatternFiltersTreePanel.ra$keyMgr(PatternFiltersTreePanel.this) != null) {
                PatternFiltersTreePanel.ra$keyMgr(PatternFiltersTreePanel.this).preProcessKeyEvent(e);
            }
            super.processKeyEvent(e);
            if (PatternFiltersTreePanel.ra$keyMgr(PatternFiltersTreePanel.this) != null) {
                PatternFiltersTreePanel.ra$keyMgr(PatternFiltersTreePanel.this).postProcessKeyEvent(e);
            }
        }

        public 1(TreeModel treeModel) {
            super(treeModel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContentLevelNode
    extends JMutableTreeNode {
        private final ContentLevel _level;
        private final boolean _isLeaf;
        private final String _label;
        private final String _path;
        private boolean _isLoaded;

        ContentLevelNode(Project project) {
            this(null, String.format("%s (%s)", patternFiltersTreePanel._rootNodeLabel, project.getShortLabel()), "");
        }

        ContentLevelNode(ContentLevel level) {
            this(level, PatternFiltersTreePanel.maS$getLabel(level.getRelPath()), level.getRelPath());
        }

        ContentLevelNode(String relPath) {
            this(null, PatternFiltersTreePanel.maS$getLabel(relPath), relPath);
        }

        private ContentLevelNode(ContentLevel level, String label, String relPath) {
            super(PatternFiltersTreePanel.maS$newJTreeCellData(level, label));
            this._level = level;
            this._label = label;
            this._path = relPath;
            this._isLeaf = this._level == null && !this.isRootPath();
            this._treeCellData.setIcon(this._isLeaf ? UIManager.getIcon("FileView.fileIcon") : UIManager.getIcon("FileView.directoryIcon"));
            this._treeCellData.setCheckBoxState(PatternFiltersTreePanel.mav$isInitiallySelected(PatternFiltersTreePanel.this, this.getRelPath()));
            this._treeCellData.setHasCheckBox(true);
        }

        private boolean isRootPath() {
            return "".equals(this._path);
        }

        public String getRelPath() {
            return this._path;
        }

        public boolean getAllowsChildren() {
            return this._isLeaf ^ true;
        }

        public boolean isLeaf() {
            return this._isLeaf;
        }

        boolean isLoaded() {
            return this._isLoaded;
        }

        void maybeLoad() {
            if (this._isLoaded || this._level == null && !this.isRootPath()) {
                return;
            }
            WaitCursor waitCursor = new WaitCursor((Component)((Object)PatternFiltersTreePanel.this));
            1 worker = new 1(this, waitCursor);
            waitCursor.show(400);
            this._isLoaded = true;
            worker.construct();
            worker.finished();
        }

        public String toString() {
            return this._label;
        }

        static String ra$_label(ContentLevelNode contentLevelNode) {
            return contentLevelNode._label;
        }

        static boolean mav$isRootPath(ContentLevelNode contentLevelNode) {
            return contentLevelNode.isRootPath();
        }

        static ContentLevel ra$_level(ContentLevelNode contentLevelNode) {
            return contentLevelNode._level;
        }

        final class 1
        extends SwingWorker {
            private URL[] _files;
            private String[] _folders;
            private ContentLevel contentLevel;
            private final /* synthetic */ WaitCursor v$waitCursor;
            final /* synthetic */ ContentLevelNode this$0;

            public Object construct() {
                URLPath regularFiles;
                if (ContentLevelNode.mav$isRootPath(this.this$0)) {
                    regularFiles = FileGroupPackager.stripRegularFiles(PatternFiltersTreePanel.ra$_contentLevel(this.this$0.PatternFiltersTreePanel.this).getDirectoryURLPath());
                    this.contentLevel = PatternFiltersTreePanel.ra$_contentLevel(this.this$0.PatternFiltersTreePanel.this);
                } else {
                    regularFiles = null;
                    this.contentLevel = ContentLevelNode.ra$_level(this.this$0);
                }
                if (this.contentLevel != null) {
                    List children = this.contentLevel.getFiles();
                    if (regularFiles != null && regularFiles.size() > 0) {
                        List<URL> regularFilesList = Arrays.asList(regularFiles.getEntries());
                        children.addAll(regularFilesList);
                    }
                    Collections.sort(children, PatternFiltersTreePanel.ra$_urlComparator(this.this$0.PatternFiltersTreePanel.this));
                    this._files = children.toArray(new URL[children.size()]);
                    List folders = this.contentLevel.getDirectories();
                    Collections.sort(folders);
                    this._folders = folders.toArray(new String[folders.size()]);
                } else {
                    this._files = new URL[0];
                    this._folders = new String[0];
                }
                return null;
            }

            public void finished() {
                if (this._folders.length > 0) {
                    ArrayList<String> seenPaths = new ArrayList<String>();
                    int n = this._folders.length;
                    int i = 0;
                    while (i < n) {
                        String folderPath = this._folders[i];
                        if (!seenPaths.contains(folderPath)) {
                            seenPaths.add(folderPath);
                            ContentLevel newLevel = this.contentLevel.getContentLevel(folderPath);
                            if (newLevel != null) {
                                ContentLevelNode child = new ContentLevelNode(newLevel);
                                this.this$0.add((MutableTreeNode)((Object)child));
                            }
                        }
                        ++i;
                    }
                    PatternFiltersTreePanel.ra$_treeModel(this.this$0.PatternFiltersTreePanel.this).nodeStructureChanged((TreeNode)((Object)this.this$0));
                }
                if (this._files.length > 0) {
                    URLPath urlPath = this.contentLevel.getDirectoryURLPath();
                    int i = 0;
                    while (i < this._files.length) {
                        String relPath = urlPath.toShortestRelativePath(this._files[i]);
                        ContentLevelNode fileNode = new ContentLevelNode(relPath);
                        this.this$0.add((MutableTreeNode)((Object)fileNode));
                        ++i;
                    }
                }
                this.this$0.updateNodes();
                this.v$waitCursor.hide();
            }

            public 1(ContentLevelNode contentLevelNode, WaitCursor waitCursor) {
                this.v$waitCursor = waitCursor;
                this.this$0 = contentLevelNode;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileURLComparator
    implements Comparator {
        private final boolean _caseSensitive;

        private void $init$() {
            this._caseSensitive = URLFileSystem.isLocalFileSystemCaseSensitive();
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            URL url1 = (URL)o1;
            URL url2 = (URL)o2;
            String str1 = URLFileSystem.getFileName((URL)url1);
            String str2 = URLFileSystem.getFileName((URL)url2);
            if (this._caseSensitive) {
                return str1.compareTo(str2);
            }
            return str1.compareToIgnoreCase(str2);
        }

        private FileURLComparator() {
            this.$init$();
        }

        FileURLComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

