/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.model;

import java.net.URI;
import java.util.ArrayList;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.ExtensionHook;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Assert;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.model.JDevTechnologyInfo;
import oracle.jdeveloper.model.JDevTechnologyRegistry;

public class TechnologyHookHandler
extends ExtensionHook {
    static final String nsURI = "http://xmlns.oracle.com/ide/extension";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "technology-hook");
    private ArrayList<TechnologyHookData> hookDataList_;
    private boolean ranOnce_;
    private TechnologyHandler techHandler;
    private static final String HOOK_DATA = "hook-data";
    private static final String HOOK_DATA_LIST = "hook-data-list";

    private void $init$() {
        this.hookDataList_ = new ArrayList();
        this.ranOnce_ = false;
        this.techHandler = new TechnologyHandler();
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(TechnologyHandler.ELEMENT_NAME, (ElementVisitor)this.techHandler);
        context.getScopeData().put(HOOK_DATA_LIST, this.hookDataList_);
    }

    public synchronized void registerTechnologies() {
        if (this.ranOnce_) {
            return;
        }
        this.ranOnce_ = true;
        TechnologyRegistry reg = TechnologyRegistry.getInstance();
        for (TechnologyHookData thd : this.hookDataList_) {
            TechId techId = reg.getTechId(thd.key_);
            Assert.check((techId != null ? 1 : 0) != 0);
            if (thd.dependencies_ != null) {
                for (String depKey : thd.dependencies_) {
                    TechId depTechId = reg.getTechId(depKey);
                    if (depTechId == null) {
                        String msg = "Dependency " + depKey + " not found. Coming from hook " + thd.extURI_;
                        Assert.fail((String)msg);
                        TechnologyHookHandler.logSevere(msg);
                        continue;
                    }
                    techId.addDependency(depTechId);
                }
            }
            JDevTechnologyInfo tInfo = new JDevTechnologyInfo(techId, null, null, null);
            if (thd.traversables_ != null) {
                int size = thd.traversables_.size();
                tInfo.setWizardPanels(thd.traversables_.toArray(new MetaClass[size]));
            }
            if (thd.libraries_ != null) {
                tInfo.setLibraryIDs(thd.libraries_.toArray());
            }
            if (thd.generatedFiles_ != null) {
                tInfo.setGeneratedFiles(thd.generatedFiles_.toArray(new JDevTechnologyInfo.GeneratedFileInfo[thd.generatedFiles_.size()]));
            }
            JDevTechnologyRegistry.getInstance().registerTechnologyInfo(tInfo);
        }
    }

    static void logSevere(String msg) {
        ExtensionRegistry.getExtensionRegistry().getLogger().severe(msg);
    }

    public TechnologyHookHandler() {
        this.$init$();
    }

    static class TechnologyHookData {
        String key_;
        String name_;
        String desc_;
        ArrayList<String> dependencies_;
        ArrayList<MetaClass<Traversable>> traversables_;
        ArrayList<String> libraries_;
        ArrayList<JDevTechnologyInfo.GeneratedFileInfo> generatedFiles_;
        URI extURI_;

        TechnologyHookData() {
        }
    }

    static class TestFactory
    implements ElementVisitorFactory {
        public ElementVisitor getVisitor(ElementName elementName) {
            System.out.println("ELEMENT VISITOR FACTORY  " + elementName);
            return null;
        }

        TestFactory() {
        }
    }

    static class TechnologyHandler
    extends ElementVisitor {
        static ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "technology");
        private KeyHandler keyHandler_;
        private NameHandler nameHandler_;
        private DescHandler descHandler_;
        private TechDepHandler techDepHandler_;
        private LibDepHandler libDepHandler_;
        private WizPageHandler wizPageHandler_;
        private GeneratedFilesHandler genFileHandler_;

        private void $init$() {
            this.keyHandler_ = new KeyHandler();
            this.nameHandler_ = new NameHandler();
            this.descHandler_ = new DescHandler();
            this.techDepHandler_ = new TechDepHandler();
            this.libDepHandler_ = new LibDepHandler();
            this.wizPageHandler_ = new WizPageHandler();
            this.genFileHandler_ = new GeneratedFilesHandler();
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(KeyHandler.ELEMENT_NAME, (ElementVisitor)this.keyHandler_);
            context.registerChildVisitor(NameHandler.ELEMENT_NAME, (ElementVisitor)this.nameHandler_);
            context.registerChildVisitor(DescHandler.ELEMENT_NAME, (ElementVisitor)this.descHandler_);
            context.registerChildVisitor(TechDepHandler.ELEMENT_NAME, (ElementVisitor)this.techDepHandler_);
            context.registerChildVisitor(LibDepHandler.ELEMENT_NAME, (ElementVisitor)this.libDepHandler_);
            context.registerChildVisitor(WizPageHandler.ELEMENT_NAME, (ElementVisitor)this.wizPageHandler_);
            context.registerChildVisitor(GeneratedFilesHandler.ELEMENT_NAME, (ElementVisitor)this.genFileHandler_);
            TechnologyHookData thd = new TechnologyHookData();
            thd.extURI_ = context.getExtensionSourceURI();
            context.getScopeData().put(TechnologyHookHandler.HOOK_DATA, thd);
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            ArrayList hookDataList = (ArrayList)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA_LIST);
            Assert.check((hookData.key_ != null ? 1 : 0) != 0, (String)("Missing key in technology-hook: " + context.getExtensionSourceURI()));
            if (hookData.key_ != null) {
                TechnologyRegistry.getInstance().registerTechnology(hookData.key_, hookData.name_, hookData.desc_);
                hookDataList.add(hookData);
            } else {
                String msg = "Key not specified in technology hook in " + context.getExtensionSourceURI();
                TechnologyHookHandler.logSevere(msg);
            }
        }

        TechnologyHandler() {
            this.$init$();
        }
    }

    static class KeyHandler
    extends ElementVisitor {
        static ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "key");

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            hookData.key_ = context.getText();
        }

        KeyHandler() {
        }
    }

    static class NameHandler
    extends ElementVisitor {
        static ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "name");

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            hookData.name_ = context.getText();
        }

        NameHandler() {
        }
    }

    static class DescHandler
    extends ElementVisitor {
        static ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "description");

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            hookData.desc_ = context.getText();
        }

        DescHandler() {
        }
    }

    static class TechDepHandler
    extends ElementVisitor {
        static ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "technology-dependencies");
        private TechKeyHandler depKeyHandler;

        private void $init$() {
            this.depKeyHandler = new TechKeyHandler();
        }

        public void start(ElementStartContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            hookData.dependencies_ = new ArrayList();
            context.registerChildVisitor(TechKeyHandler.ELEMENT_NAME, (ElementVisitor)this.depKeyHandler);
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            if (hookData.dependencies_.size() == 0) {
                hookData.dependencies_ = null;
            }
        }

        TechDepHandler() {
            this.$init$();
        }
    }

    static class LibDepHandler
    extends ElementVisitor {
        static ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "library-dependencies");
        LibKeyHandler libKeyHandler;

        private void $init$() {
            this.libKeyHandler = new LibKeyHandler();
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(LibKeyHandler.ELEMENT_NAME, (ElementVisitor)this.libKeyHandler);
            TechnologyHookData thd = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            thd.libraries_ = new ArrayList();
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            if (hookData.libraries_.size() == 0) {
                hookData.libraries_ = null;
            }
        }

        LibDepHandler() {
            this.$init$();
        }
    }

    static class LibKeyHandler
    extends ElementVisitor {
        static ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "library");

        public void end(ElementEndContext context) {
            String library = context.getText();
            if (ModelUtil.hasLength((String)library)) {
                TechnologyHookData thd = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
                thd.libraries_.add(library);
            }
        }

        LibKeyHandler() {
        }
    }

    static class WizPageHandler
    extends ElementVisitor {
        static ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "wizard-pages");
        private PageHandler pageHandler;

        private void $init$() {
            this.pageHandler = new PageHandler();
        }

        public void start(ElementStartContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            hookData.traversables_ = new ArrayList();
            context.registerChildVisitor(PageHandler.ELEMENT_NAME, (ElementVisitor)this.pageHandler);
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            if (hookData.traversables_.size() == 0) {
                hookData.traversables_ = null;
            }
        }

        WizPageHandler() {
            this.$init$();
        }
    }

    static class PageHandler
    extends ElementVisitor {
        static ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "page");
        private TraversableClassHandler tcHandler;

        private void $init$() {
            this.tcHandler = new TraversableClassHandler();
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(TraversableClassHandler.ELEMENT_NAME, (ElementVisitor)this.tcHandler);
        }

        PageHandler() {
            this.$init$();
        }
    }

    static class TechKeyHandler
    extends ElementVisitor {
        static ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "key");

        public void end(ElementEndContext context) {
            String techKey = context.getText();
            if (ModelUtil.hasLength((String)techKey)) {
                TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
                hookData.dependencies_.add(techKey);
            }
        }

        TechKeyHandler() {
        }
    }

    static class TraversableClassHandler
    extends ElementVisitor {
        static ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "traversable-class");

        public void end(ElementEndContext context) {
            String clazz = context.getText();
            if (ModelUtil.hasLength((String)clazz)) {
                TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
                MetaClass mct = new MetaClass(Thread.currentThread().getContextClassLoader(), clazz);
                hookData.traversables_.add((MetaClass<Traversable>)mct);
            }
        }

        TraversableClassHandler() {
        }
    }

    static class GeneratedFilesHandler
    extends ElementVisitor {
        static ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "generated-files");
        private FileHandler fileHandler;

        private void $init$() {
            this.fileHandler = new FileHandler();
        }

        public void start(ElementStartContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            hookData.generatedFiles_ = new ArrayList();
            context.registerChildVisitor(FileHandler.ELEMENT_NAME, (ElementVisitor)this.fileHandler);
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            if (hookData.generatedFiles_.size() == 0) {
                hookData.generatedFiles_ = null;
            }
        }

        GeneratedFilesHandler() {
            this.$init$();
        }
    }

    static class FileHandler
    extends ElementVisitor {
        static ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "file");
        static String GENERATED_FILE = "FileHandler.GENERATED_FILE";
        static FileVisitorFactory fileVisitorFactory = new FileVisitorFactory();

        public void start(ElementStartContext context) {
            JDevTechnologyInfo.GeneratedFileInfo genFile = new JDevTechnologyInfo.GeneratedFileInfo();
            context.getScopeData().put(GENERATED_FILE, genFile);
            context.registerVisitorFactory((ElementVisitorFactory)fileVisitorFactory);
        }

        public void end(ElementEndContext context) {
            TechnologyHookData hookData = (TechnologyHookData)context.getScopeData().get(TechnologyHookHandler.HOOK_DATA);
            JDevTechnologyInfo.GeneratedFileInfo genFile = (JDevTechnologyInfo.GeneratedFileInfo)context.getScopeData().get(GENERATED_FILE);
            hookData.generatedFiles_.add(genFile);
        }

        FileHandler() {
        }
    }

    static class FileVisitorFactory
    extends ElementVisitor
    implements ElementVisitorFactory {
        static ElementName NAME_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "name");
        static ElementName PATH_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "path");
        static ElementName TYPE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "type");
        static ElementName DESC_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "description");

        public ElementVisitor getVisitor(ElementName name) {
            return this;
        }

        public void start(ElementStartContext context) {
            JDevTechnologyInfo.GeneratedFileInfo genFile = (JDevTechnologyInfo.GeneratedFileInfo)context.getScopeData().get(FileHandler.GENERATED_FILE);
            Assert.check((genFile != null ? 1 : 0) != 0);
            ElementName element = context.getElementName();
            if (element.equals((Object)NAME_ELEMENT)) {
                boolean value = Boolean.parseBoolean(context.getAttributeValue("prompt"));
                genFile.setPromptForName(value);
            } else if (element.equals((Object)PATH_ELEMENT)) {
                boolean value = Boolean.parseBoolean(context.getAttributeValue("prompt"));
                genFile.setPromptForName(value);
            } else if (!element.equals((Object)TYPE_ELEMENT) && !element.equals((Object)DESC_ELEMENT)) {
                TechnologyHookHandler.logSevere("Unrecognized element in technology-hook: " + element);
            }
        }

        public void end(ElementEndContext context) {
            JDevTechnologyInfo.GeneratedFileInfo genFile = (JDevTechnologyInfo.GeneratedFileInfo)context.getScopeData().get(FileHandler.GENERATED_FILE);
            Assert.check((genFile != null ? 1 : 0) != 0);
            ElementName element = context.getElementName();
            if (element.equals((Object)NAME_ELEMENT)) {
                genFile.setName(context.getText());
            } else if (element.equals((Object)PATH_ELEMENT)) {
                genFile.setPath(context.getText());
            } else if (element.equals((Object)TYPE_ELEMENT)) {
                genFile.setFileType(context.getText());
            } else if (element.equals((Object)DESC_ELEMENT)) {
                genFile.setDescription(context.getText());
            } else {
                TechnologyHookHandler.logSevere("Unrecognized element in technology-hook: " + element);
            }
        }

        FileVisitorFactory() {
        }
    }
}

