/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.explorer.ChildFilterHelper;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.jdevimpl.navigator.FileNameComparator;

final class ApplicationFilter
extends ChildFilterHelper {
    private static final FileNameComparator _comparator = new FileNameComparator();

    public void initChildren(Context context, List children) {
        WorkingSet currentWorkingSet;
        Workspace workspace = context.getWorkspace();
        if (workspace != null && (currentWorkingSet = WorkingSets.getInstance((Workspace)workspace).getCurrentWorkingSet()) != null) {
            ArrayList<Project> projects = new ArrayList<Project>();
            Iterator iter = workspace.getChildren();
            while (iter.hasNext()) {
                Project project;
                Object next = iter.next();
                if (!(next instanceof Project) || !currentWorkingSet.isIncluded(project = (Project)next)) continue;
                projects.add(project);
            }
            Collections.sort(projects, _comparator);
            children.addAll(projects);
        }
    }

    public boolean handleChildrenAdded(Context context, List children, TNode parent, TreeExplorer tree) {
        Enumeration echildren = parent.children();
        while (echildren.hasMoreElements()) {
            TNode child = (TNode)echildren.nextElement();
            Element element = child.getData();
            if (!children.contains(element)) continue;
            children.remove(element);
        }
        TNode child = null;
        for (Element element : children) {
            child = tree.addChild(element, parent, tree.getTreeModel());
        }
        if (child != null) {
            TNode selected = child;
            this.activateNavigator(tree);
            SwingUtilities.invokeLater(new 1(this, tree, selected));
        }
        return true;
    }

    private void activateNavigator(TreeExplorer tree) {
        JTree jtree = tree.getJTree();
        if (jtree != null) {
            jtree.requestFocus();
        }
    }

    ApplicationFilter() {
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ TreeExplorer v$tree;
        private final /* synthetic */ TNode v$selected;
        final /* synthetic */ ApplicationFilter this$0;

        public void run() {
            this.v$tree.setSelected(this.v$selected);
            this.v$tree.nodeChanged(this.v$selected);
        }

        public 1(ApplicationFilter applicationFilter, TreeExplorer treeExplorer, TNode tNode) {
            this.v$selected = tNode;
            this.v$tree = treeExplorer;
            this.this$0 = applicationFilter;
        }
    }
}

