/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.explorer.ChildFilterHelper;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.jdevimpl.navigator.FileNameComparator;

final class ApplicationsFilter
extends ChildFilterHelper {
    private static final FileNameComparator _comparator = new FileNameComparator();

    public void initChildren(Context context, List children) {
        Workspaces workspacesObj = Ide.getWorkspaces();
        if (workspacesObj != null) {
            ArrayList workspaces = new ArrayList();
            Iterator iter = workspacesObj.getChildren();
            while (iter.hasNext()) {
                workspaces.add(iter.next());
            }
            Collections.sort(workspaces, _comparator);
            children.addAll(workspaces);
        }
    }

    public boolean handleChildrenAdded(Context context, List children, TNode parent, TreeExplorer tree) {
        int numAdded = 0;
        if (parent instanceof MutableTreeNode) {
            MutableTreeNode parentMTN = (MutableTreeNode)parent;
            for (Object next : children) {
                if (!(next instanceof Workspace)) continue;
                Workspace addedWorkspace = (Workspace)next;
                int i = 0;
                int n = parent.getChildCount();
                while (i < n) {
                    int cmp;
                    TNode childTNode;
                    Element childData;
                    TreeNode childObj = parent.getChildAt(i);
                    if (childObj instanceof TNode && (childData = (childTNode = (TNode)childObj).getData()) instanceof Workspace && (cmp = _comparator.compare(addedWorkspace, childData)) < 0) break;
                    ++i;
                }
                parentMTN.insert((MutableTreeNode)tree.createTNode((Element)addedWorkspace), i);
                ++numAdded;
            }
        }
        return numAdded > 0;
    }

    public boolean handleChildrenRemoved(Context context, List children, TNode parent, TreeExplorer tree) {
        int numRemoved = 0;
        if (parent instanceof MutableTreeNode) {
            MutableTreeNode parentMTN = (MutableTreeNode)parent;
            int i = parent.getChildCount() - 1;
            while (i >= 0) {
                TreeNode childObj = parent.getChildAt(i);
                if (childObj instanceof TNode) {
                    TNode childTNode = (TNode)childObj;
                    Element childDataObj = childTNode.getData();
                    Iterator iter = children.iterator();
                    while (iter.hasNext()) {
                        if (childDataObj != iter.next()) continue;
                        parentMTN.remove(i);
                        ++numRemoved;
                        break;
                    }
                }
                --i;
            }
        }
        return numRemoved > 0;
    }

    ApplicationsFilter() {
    }
}

