/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.navigator.ContentSetSupport;
import oracle.ide.navigator.NavigatorInit;
import oracle.ide.navigator.NavigatorInitFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.jdevimpl.navigator.Res;

final class CompositeNodeSupport
extends NavigatorInit
implements Controller {
    private static final String TOGGLE_COMPOSITE_NODES_CMD = "CompositeNodeSupport.toggleCompositeNodes";
    private static final int TOGGLE_COMPOSITE_NODES_CMD_ID = Ide.findOrCreateCmdID((String)"CompositeNodeSupport.toggleCompositeNodes");
    private static IdeAction _toggleCompositeNodesAction;
    private boolean _showCompositeNodes;
    static final String SHOW_COMPOSITE_NODES = "show-composite-nodes";
    private static final boolean DEFAULT_SHOW_COMPOSITE_NODES = true;
    private Controller _controller;

    private void $init$() {
        this._showCompositeNodes = true;
    }

    static void init(ProjectNavigatorManager nav) {
        CompositeNodeSupport.maybeInitToggleCompositeNodesAction();
        nav.addNavigatorInit(new NavigatorInitFactory(CompositeNodeSupport.class));
    }

    CompositeNodeSupport(NavigatorWindow navWin, Context context) {
        super(navWin, context);
        this.$init$();
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new 1();
        }
        return this._controller;
    }

    public void loadPreferences(PropertyAccess prefs) {
        this._showCompositeNodes = CompositeNodeSupport.str2Boolean((PropertyAccess)prefs, (String)SHOW_COMPOSITE_NODES, (boolean)true);
    }

    public void savePreferences(PropertyAccess prefs) {
        CompositeNodeSupport.boolean2Str((PropertyAccess)prefs, (String)SHOW_COMPOSITE_NODES, (boolean)this._showCompositeNodes);
    }

    public void copyPreferencesTo(Context context) {
        context.setBoolean("enable-content-level-filters", this._showCompositeNodes);
    }

    public void initToolbar(Toolbar toolbar) {
        MenuToolButton menuToolButton = ContentSetSupport.findDisplayOptionsMenu((Toolbar)toolbar);
        if (toolbar != null) {
            IdeAction localAction = _toggleCompositeNodesAction.newLocalAction((View)this.getNavigatorWindow());
            localAction.addController((Controller)this);
            menuToolButton.addPopupItem((ToggleAction)localAction);
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == TOGGLE_COMPOSITE_NODES_CMD_ID) {
            this._showCompositeNodes ^= true;
            action.setState(this._showCompositeNodes);
            ProjectNavigatorManager.refreshAllProjectsInNavigator((Context)context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == TOGGLE_COMPOSITE_NODES_CMD_ID) {
            action.setEnabled(true);
            action.setState(this._showCompositeNodes);
            return true;
        }
        return false;
    }

    private static void maybeInitToggleCompositeNodesAction() {
        if (_toggleCompositeNodesAction == null) {
            IdeAction action = IdeAction.get((int)TOGGLE_COMPOSITE_NODES_CMD_ID, (String)TOGGLE_COMPOSITE_NODES_CMD, (String)Res.getString(33));
            action.setEnabled(true);
            action.putValue("Check", (Object)Boolean.TRUE);
            _toggleCompositeNodesAction = action;
        }
    }

    final class 1
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            return false;
        }
    }
}

