/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.ContentLevel;
import oracle.ide.model.ContentSet;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLPath;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.Library;
import oracle.jdevimpl.navigator.SubjectFolder;

class LibraryFolder
extends SubjectFolder {
    private final Context _context;
    private final String _displayName;
    private final Library _library;

    LibraryFolder(Context context, JLibrary lib) {
        if (lib == null) {
            throw new IllegalArgumentException();
        }
        LibraryFolder.initContext(context);
        this._context = context;
        this._displayName = lib.getName();
        this._library = lib;
    }

    LibraryFolder(Context context, JDK jdk) {
        if (jdk == null) {
            throw new IllegalArgumentException();
        }
        LibraryFolder.initContext(context);
        this._context = context;
        this._displayName = jdk.getShortLabel();
        this._library = jdk;
    }

    private static void initContext(Context context) {
        context.setBoolean("flat-level-enabled", true);
    }

    public Object getData() {
        return this._library;
    }

    public String getShortLabel() {
        return this._displayName;
    }

    public Icon getIcon() {
        return this._library.getIcon();
    }

    ArrayList getChildrenList() {
        ArrayList children = new ArrayList();
        PatternFilters workingSetFilters = this.getWorkingSet();
        if (this._context.getBoolean("show-root-dirs")) {
            IntersectedFilters filters = new IntersectedFilters(workingSetFilters);
            this.addURLPath(children, this._library.getSourcePath(), filters);
            this.addURLPath(children, this._library.getClassPath(), filters);
        } else {
            ContentSet libContents = new ContentSet(HashStructure.newInstance());
            URLPath libURLPath = libContents.getURLPath();
            libURLPath.add(this._library.getSourcePath());
            libURLPath.add(this._library.getClassPath());
            ContentLevel contentLevel = ContentLevel.newInstanceForHideDirs((ContentSet)libContents, (PatternFilters)workingSetFilters, (boolean)true);
            contentLevel.addFlatDirs(this._context, children);
        }
        return children;
    }

    private PatternFilters getWorkingSet() {
        Workspace workspace;
        if (this._context.getBoolean("enable-working-sets") && (workspace = this._context.getWorkspace()) != null) {
            WorkingSet curr = WorkingSets.getInstance((Workspace)workspace).getCurrentWorkingSet();
            return curr.getPatternFilters(this._context.getProject());
        }
        return null;
    }

    private void addURLPath(ArrayList jars, URLPath urlPath, IntersectedFilters filters) {
        if (urlPath != null) {
            for (URL url : urlPath) {
                ContentLevel contentLevel = ContentLevel.newInstanceForShowDirs((URL)url, (IntersectedFilters)filters, (boolean)true);
                jars.add(contentLevel.newFolder(this._context));
            }
        }
    }
}

